/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.block.tile;

import java.util.Arrays;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import vazkii.arl.block.tile.TileMod;
import vazkii.psi.client.core.helper.PsiRenderHelper;
import vazkii.psi.common.Psi;
import vazkii.psi.common.block.BlockConjured;
import vazkii.psi.common.block.base.ModBlocks;

public class TileConjured
extends TileMod {
    private static final String TAG_TIME_LEGACY = "time";
    private static final String TAG_COLORIZER = "colorizer";
    private int time = -1;
    public ItemStack colorizer = ItemStack.field_190927_a;

    public void doParticles() {
        int color = 1295871;
        if (!this.colorizer.func_190926_b()) {
            color = Psi.proxy.getColorForColorizer(this.colorizer);
        }
        float r = (float)PsiRenderHelper.r(color) / 255.0f;
        float g = (float)PsiRenderHelper.g(color) / 255.0f;
        float b = (float)PsiRenderHelper.b(color) / 255.0f;
        IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        if ((state = state.func_185899_b((IBlockAccess)this.func_145831_w(), this.func_174877_v())).func_177230_c() == ModBlocks.conjured && ((Boolean)state.func_177229_b((IProperty)BlockConjured.SOLID)).booleanValue()) {
            boolean[] edges = new boolean[12];
            Arrays.fill(edges, true);
            if (((Boolean)state.func_177229_b((IProperty)BlockConjured.BLOCK_DOWN)).booleanValue()) {
                this.removeEdges(edges, 0, 1, 2, 3);
            }
            if (((Boolean)state.func_177229_b((IProperty)BlockConjured.BLOCK_UP)).booleanValue()) {
                this.removeEdges(edges, 4, 5, 6, 7);
            }
            if (((Boolean)state.func_177229_b((IProperty)BlockConjured.BLOCK_NORTH)).booleanValue()) {
                this.removeEdges(edges, 3, 7, 8, 11);
            }
            if (((Boolean)state.func_177229_b((IProperty)BlockConjured.BLOCK_SOUTH)).booleanValue()) {
                this.removeEdges(edges, 1, 5, 9, 10);
            }
            if (((Boolean)state.func_177229_b((IProperty)BlockConjured.BLOCK_EAST)).booleanValue()) {
                this.removeEdges(edges, 2, 6, 10, 11);
            }
            if (((Boolean)state.func_177229_b((IProperty)BlockConjured.BLOCK_WEST)).booleanValue()) {
                this.removeEdges(edges, 0, 4, 8, 9);
            }
            double x = this.func_174877_v().func_177958_n();
            double y = this.func_174877_v().func_177956_o();
            double z = this.func_174877_v().func_177952_p();
            this.makeParticle(edges[0], r, g, b, x + 0.0, y + 0.0, z + 0.0, 0.0, 0.0, 1.0);
            this.makeParticle(edges[1], r, g, b, x + 0.0, y + 0.0, z + 1.0, 1.0, 0.0, 0.0);
            this.makeParticle(edges[2], r, g, b, x + 1.0, y + 0.0, z + 0.0, 0.0, 0.0, 1.0);
            this.makeParticle(edges[3], r, g, b, x + 0.0, y + 0.0, z + 0.0, 1.0, 0.0, 0.0);
            this.makeParticle(edges[4], r, g, b, x + 0.0, y + 1.0, z + 0.0, 0.0, 0.0, 1.0);
            this.makeParticle(edges[5], r, g, b, x + 0.0, y + 1.0, z + 1.0, 1.0, 0.0, 0.0);
            this.makeParticle(edges[6], r, g, b, x + 1.0, y + 1.0, z + 0.0, 0.0, 0.0, 1.0);
            this.makeParticle(edges[7], r, g, b, x + 0.0, y + 1.0, z + 0.0, 1.0, 0.0, 0.0);
            this.makeParticle(edges[8], r, g, b, x + 0.0, y + 0.0, z + 0.0, 0.0, 1.0, 0.0);
            this.makeParticle(edges[9], r, g, b, x + 0.0, y + 0.0, z + 1.0, 0.0, 1.0, 0.0);
            this.makeParticle(edges[10], r, g, b, x + 1.0, y + 0.0, z + 1.0, 0.0, 1.0, 0.0);
            this.makeParticle(edges[11], r, g, b, x + 1.0, y + 0.0, z + 0.0, 0.0, 1.0, 0.0);
        } else if (Math.random() < 0.5) {
            float w = 0.15f;
            float h = 0.05f;
            double x = (double)this.func_174877_v().func_177958_n() + 0.5 + (Math.random() - 0.5) * (double)w;
            double y = (double)this.func_174877_v().func_177956_o() + 0.25 + (Math.random() - 0.5) * (double)h;
            double z = (double)this.func_174877_v().func_177952_p() + 0.5 + (Math.random() - 0.5) * (double)w;
            float s = 0.2f + (float)Math.random() * 0.1f;
            float m = 0.01f + (float)Math.random() * 0.015f;
            Psi.proxy.wispFX(x, y, z, r, g, b, s, -m);
        }
    }

    public void makeParticle(boolean doit, float r, float g, float b, double xp, double yp, double zp, double xv, double yv, double zv) {
        if (doit && Math.random() < 0.3) {
            float m = 0.1f;
            Psi.proxy.sparkleFX(xp, yp, zp, r, g, b, (float)(xv *= (double)m), (float)(yv *= (double)m), (float)(zv *= (double)m), 1.25f, 20);
        }
    }

    public void removeEdges(boolean[] edges, int ... posArray) {
        for (int i : posArray) {
            edges[i] = false;
        }
    }

    public void onLoad() {
        if (this.time > 0) {
            this.field_145850_b.func_175684_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c(), this.time);
            this.time = -1;
        }
    }

    public void writeSharedNBT(NBTTagCompound cmp) {
        NBTTagCompound stackCmp = new NBTTagCompound();
        if (!this.colorizer.func_190926_b()) {
            this.colorizer.func_77955_b(stackCmp);
        }
        cmp.func_74782_a(TAG_COLORIZER, (NBTBase)stackCmp);
    }

    public void readSharedNBT(NBTTagCompound cmp) {
        if (cmp.func_150297_b(TAG_TIME_LEGACY, 99)) {
            this.time = cmp.func_74762_e(TAG_TIME_LEGACY);
        }
        NBTTagCompound stackCmp = cmp.func_74775_l(TAG_COLORIZER);
        this.colorizer = new ItemStack(stackCmp);
    }
}

