/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.world;

import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.DEFeatures;
import com.brandon3055.draconicevolution.blocks.DraconiumOre;
import com.brandon3055.draconicevolution.world.ChaosWorldGenHandler;
import com.brandon3055.draconicevolution.world.WorldGenEnderComet;
import com.brandon3055.draconicevolution.world.WorldTickHandler;
import com.google.common.base.Predicate;
import java.util.ArrayDeque;
import java.util.LinkedList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class DEWorldGenHandler
implements IWorldGenerator {
    public static DEWorldGenHandler instance = new DEWorldGenHandler();
    private static String DATA_TAG = "DEWorldGen";
    private static LinkedList<ChunkReference> retroGenerating = new LinkedList();

    public static void initialize() {
        if (DEConfig.worldGenEnabled) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)instance, (int)0);
            MinecraftForge.EVENT_BUS.register((Object)instance);
            if (DEConfig.enableRetroGen) {
                MinecraftForge.EVENT_BUS.register((Object)new WorldTickHandler());
            }
        }
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        this.addOreGen(random, chunkX, chunkZ, world);
    }

    public void addOreGen(Random random, int chunkX, int chunkZ, World world) {
        switch (world.field_73011_w.getDimension()) {
            case 0: {
                if (DEConfig.disableOreSpawnOverworld) break;
                this.addOreSpawn(DEFeatures.draconiumOre.func_176223_P().func_177226_a(DraconiumOre.ORE_TYPE, (Comparable)((Object)DraconiumOre.EnumType.NORMAL)), Blocks.field_150348_b.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 6, 10, 2, 2, 8);
                break;
            }
            case 1: {
                int actualX = chunkX * 16;
                int actualZ = chunkZ * 16;
                int x1 = actualX + random.nextInt(16);
                int y = 20 + random.nextInt(170);
                int z1 = actualZ + random.nextInt(16);
                if (DEConfig.generateEnderComets && Math.sqrt(actualX * actualX + actualZ * actualZ) > 200.0 && random.nextInt(Math.max(1, DEConfig.cometRarity)) == 0) {
                    new WorldGenEnderComet().func_180709_b(world, random, new BlockPos(actualX + 8, y, actualZ + 8));
                }
                if (DEConfig.generateChaosIslands) {
                    ChaosWorldGenHandler.generateChunk(world, chunkX, chunkZ, null, random);
                }
                if (DEConfig.disableOreSpawnEnd) break;
                this.addOreSpawn(DEFeatures.draconiumOre.func_176223_P().func_177226_a(DraconiumOre.ORE_TYPE, (Comparable)((Object)DraconiumOre.EnumType.END)), Blocks.field_150377_bs.func_176223_P(), world, random, actualX, actualZ, 4, 5, 10, 1, 70);
                break;
            }
            case -1: {
                if (DEConfig.disableOreSpawnNether) break;
                this.addOreSpawn(DEFeatures.draconiumOre.func_176223_P().func_177226_a(DraconiumOre.ORE_TYPE, (Comparable)((Object)DraconiumOre.EnumType.NETHER)), Blocks.field_150424_aL.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 5, 7, 5, 1, 125);
                break;
            }
            default: {
                int[] nArray = DEConfig.oreGenDimentionBlacklist;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    Integer i2 = nArray[i];
                    if (i2.intValue() != world.field_73011_w.getDimension()) continue;
                    return;
                }
                this.addOreSpawn(DEFeatures.draconiumOre.func_176223_P().func_177226_a(DraconiumOre.ORE_TYPE, (Comparable)((Object)DraconiumOre.EnumType.NORMAL)), Blocks.field_150348_b.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 3, 4, 2, 2, 8);
            }
        }
    }

    public void addOreSpawn(IBlockState block, IBlockState baseBlock, World world, Random random, int chunkXPos, int chunkZPos, int minVainSize, int maxVainSize, int chancesToSpawn, int minY, int maxY) {
        for (int i = 0; i < chancesToSpawn; ++i) {
            int posX = chunkXPos + random.nextInt(16);
            int posY = minY + random.nextInt(maxY - minY);
            int posZ = chunkZPos + random.nextInt(16);
            new WorldGenMinable(block, minVainSize + random.nextInt(maxVainSize - minVainSize), (Predicate)BlockMatcher.func_177642_a((Block)baseBlock.func_177230_c())).func_180709_b(world, random, new BlockPos(posX, posY, posZ));
        }
    }

    @SubscribeEvent
    public void chunkLoadEvent(ChunkDataEvent.Load event) {
        int dim = event.getWorld().field_73011_w.getDimension();
        NBTTagCompound tag = event.getData().func_74775_l(DATA_TAG);
        if (tag.func_74767_n("Generated") || tag.func_74767_n("Loaded")) {
            return;
        }
        tag.func_74757_a("Loaded", true);
        event.getData().func_74782_a(DATA_TAG, (NBTBase)tag);
        if (event.getChunk().func_76606_c(0, 128) && dim != 1) {
            return;
        }
        if (DEConfig.enableRetroGen) {
            ArrayDeque chunks = (ArrayDeque)WorldTickHandler.chunksToGen.get(dim);
            if (chunks == null) {
                WorldTickHandler.chunksToGen.put(dim, new ArrayDeque(128));
                chunks = (ArrayDeque)WorldTickHandler.chunksToGen.get(dim);
            }
            if (chunks != null) {
                chunks.addLast(new ChunkPos(event.getChunk().field_76635_g, event.getChunk().field_76647_h));
                retroGenerating.add(new ChunkReference(dim, event.getChunk().field_76635_g, event.getChunk().field_76647_h));
                WorldTickHandler.chunksToGen.put(dim, (Object)chunks);
            }
        }
    }

    public void retroGenComplete(int dim, int chunkX, int chunkZ) {
        retroGenerating.remove(new ChunkReference(dim, chunkX, chunkZ));
    }

    @SubscribeEvent
    public void chunkSaveEvent(ChunkDataEvent.Save event) {
        NBTTagCompound genTag = event.getData().func_74775_l(DATA_TAG);
        if (!retroGenerating.contains(new ChunkReference(event.getWorld().field_73011_w.getDimension(), event.getChunk().field_76635_g, event.getChunk().field_76647_h))) {
            genTag.func_74757_a("Generated", true);
        }
        genTag.func_82580_o("Loaded");
        event.getData().func_74782_a(DATA_TAG, (NBTBase)genTag);
    }

    private static class ChunkReference {
        public final int dimension;
        public final int xPos;
        public final int zPos;

        public ChunkReference(int dim, int x, int z) {
            this.dimension = dim;
            this.xPos = x;
            this.zPos = z;
        }

        public int hashCode() {
            return this.xPos * 43 + this.zPos * 3 + this.dimension;
        }

        public boolean equals(Object o) {
            if (o == null || o.getClass() != this.getClass()) {
                if (o instanceof Chunk) {
                    Chunk other = (Chunk)o;
                    return this.xPos == other.field_76635_g && this.zPos == other.field_76647_h && this.dimension == other.func_177412_p().field_73011_w.getDimension();
                }
                return false;
            }
            ChunkReference other = (ChunkReference)o;
            return other.dimension == this.dimension && other.xPos == this.xPos && other.zPos == this.zPos;
        }
    }
}

