/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.villager;

import com.lothrazar.cyclicmagic.config.IHasConfig;
import com.lothrazar.cyclicmagic.registry.VillagerProfRegistry;
import com.lothrazar.cyclicmagic.registry.module.BaseEventModule;
import com.lothrazar.cyclicmagic.villager.druid.VillagerDruid;
import com.lothrazar.cyclicmagic.villager.sage.VillagerSage;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.registry.VillagerRegistry;

public class VillagerCreateModule
extends BaseEventModule
implements IHasConfig {
    private boolean sageEnabled;
    private boolean druidEnabled;
    public static int sageCount;
    public static int druidCount;

    private VillagerRegistry.VillagerProfession addVillager(String name, EntityVillager.ITradeList[][] trades) {
        VillagerRegistry.VillagerProfession prof = new VillagerRegistry.VillagerProfession("cyclicmagic:" + name, "cyclicmagic:textures/entity/villager/" + name + ".png", "minecraft:textures/entity/zombie_villager/zombie_villager.png");
        VillagerProfRegistry.register(prof);
        VillagerRegistry.VillagerCareer villager = new VillagerRegistry.VillagerCareer(prof, name);
        for (int i = 0; i < trades.length; ++i) {
            villager.addTrade(i + 1, trades[i]);
        }
        return prof;
    }

    @Override
    public void onPreInit() {
        super.onPreInit();
        if (this.sageEnabled) {
            VillagerProfRegistry.SAGE = this.addVillager("sage", VillagerSage.buildTrades());
        }
        if (this.druidEnabled) {
            VillagerProfRegistry.DRUID = this.addVillager("druid", VillagerDruid.buildTrades());
        }
    }

    @Override
    public void syncConfig(Configuration c) {
        String category = "cyclicmagic.villagers";
        c.addCustomCategoryComment(category, "Two new villagers with more trades");
        this.sageEnabled = c.getBoolean("SageVillagers", category, true, "Adds new villager type Sage.  Spawns naturally and from mob eggs. ");
        this.druidEnabled = c.getBoolean("DruidVillagers", category, true, "Adds new villager type Druid.  Spawns naturally and from mob eggs. ");
        String desc = "Number of villager entities that will attempt to spawn when a new village generates in the world terrain (no buildings)";
        sageCount = c.getInt("SageCount", category, 2, 0, 9, desc);
        druidCount = c.getInt("DruidCount", category, 2, 0, 9, desc);
    }
}

