/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item.dynamite;

import com.lothrazar.cyclicmagic.entity.EntityThrowableDispensable;
import com.lothrazar.cyclicmagic.item.core.BaseItemProjectile;
import com.lothrazar.cyclicmagic.item.dynamite.EntityDynamite;
import com.lothrazar.cyclicmagic.item.dynamite.EntityDynamiteBlockSafe;
import com.lothrazar.cyclicmagic.item.dynamite.EntityDynamiteMining;
import com.lothrazar.cyclicmagic.util.UtilPlayer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class ItemProjectileTNT
extends BaseItemProjectile {
    private ExplosionType type;
    private int strength;

    public ItemProjectileTNT(int str, ExplosionType t) {
        this.strength = str;
        this.type = t;
    }

    @Override
    public EntityThrowableDispensable getThrownEntity(World world, ItemStack held, double x, double y, double z) {
        switch (this.type) {
            case NORMAL: {
                return new EntityDynamite(world, this.strength, x, y, z);
            }
            case MINING: {
                return new EntityDynamiteMining(world, this.strength, x, y, z);
            }
            case BLOCKSAFE: {
                return new EntityDynamiteBlockSafe(world, this.strength, x, y, z);
            }
        }
        return null;
    }

    @Override
    public void onItemThrow(ItemStack held, World world, EntityPlayer player, EnumHand hand) {
        EntityThrowableDispensable d = null;
        switch (this.type) {
            case NORMAL: {
                d = new EntityDynamite(world, (EntityLivingBase)player, this.strength);
                break;
            }
            case MINING: {
                d = new EntityDynamiteMining(world, (EntityLivingBase)player, this.strength);
                break;
            }
            case BLOCKSAFE: {
                d = new EntityDynamiteBlockSafe(world, (EntityLivingBase)player, this.strength);
                break;
            }
        }
        this.doThrow(world, player, hand, d);
        UtilPlayer.decrStackSize(player, hand);
    }

    @Override
    public SoundEvent getSound() {
        return SoundEvents.field_187511_aA;
    }

    public static enum ExplosionType {
        NORMAL,
        BLOCKSAFE,
        MINING;

    }
}

