/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item;

import com.lothrazar.cyclicmagic.IContent;
import com.lothrazar.cyclicmagic.data.IHasRecipe;
import com.lothrazar.cyclicmagic.item.core.BaseTool;
import com.lothrazar.cyclicmagic.registry.ItemRegistry;
import com.lothrazar.cyclicmagic.registry.RecipeRegistry;
import com.lothrazar.cyclicmagic.util.UtilParticle;
import com.lothrazar.cyclicmagic.util.UtilSound;
import com.lothrazar.cyclicmagic.util.UtilWorld;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;

public class ItemIceWand
extends BaseTool
implements IHasRecipe,
IContent {
    private static final int DURABILITY = 256;
    private static final int RADIUS = 2;
    private boolean enabled;

    public ItemIceWand() {
        super(256);
    }

    @Override
    public void register() {
        ItemRegistry.register(this, "water_freezer");
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public void syncConfig(Configuration config) {
        this.enabled = config.getBoolean("WaterFroster", "cyclicmagic.content", true, "Set false to delete - requires restart");
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (pos == null) {
            return super.func_180614_a(player, world, pos, hand, side, hitX, hitY, hitZ);
        }
        if (side != null) {
            pos = pos.func_177972_a(side);
        }
        if (this.spreadWaterFromCenter(world, pos.func_177972_a(side))) {
            super.onUse(stack, player, world, hand);
        }
        return super.func_180614_a(player, world, pos, hand, side, hitX, hitY, hitZ);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (this.spreadWaterFromCenter(world, player.func_180425_c().func_177972_a(player.func_174811_aO()))) {
            super.onUse(stack, player, world, hand);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    private boolean spreadWaterFromCenter(World world, BlockPos posCenter) {
        boolean success;
        int count = 0;
        ArrayList<BlockPos> water = UtilWorld.findBlocks(world, posCenter, (Block)Blocks.field_150355_j, 2);
        water.addAll(UtilWorld.findBlocks(world, posCenter, (Block)Blocks.field_150358_i, 2));
        for (BlockPos pos : water) {
            world.func_180501_a(pos, Blocks.field_150432_aD.func_176223_P(), 3);
            UtilParticle.spawnParticle(world, EnumParticleTypes.WATER_SPLASH, pos);
            UtilParticle.spawnParticle(world, EnumParticleTypes.WATER_SPLASH, pos.func_177984_a());
            ++count;
        }
        boolean bl = success = count > 0;
        if (success) {
            UtilSound.playSound(world, posCenter, SoundEvents.field_187806_ee, SoundCategory.BLOCKS);
        }
        return success;
    }

    @Override
    public IRecipe addRecipe() {
        return RecipeRegistry.addShapedRecipe(new ItemStack((Item)this), "wdw", "idi", " o ", Character.valueOf('w'), new ItemStack(Items.field_151131_as), Character.valueOf('d'), "ingotBrickNether", Character.valueOf('o'), "ingotGold", Character.valueOf('i'), new ItemStack(Blocks.field_150432_aD));
    }
}

