/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.capability;

import net.minecraftforge.energy.EnergyStorage;

public class EnergyStore
extends EnergyStorage {
    public static final int DEFAULT_CAPACITY = 64000;
    public static final int MAX_TRANSFER = 6400;

    public EnergyStore(int cap) {
        this(cap, true);
    }

    public EnergyStore(int cap, boolean canImportPower) {
        super(cap);
        this.maxReceive = canImportPower ? 6400 : 0;
        this.maxExtract = 6400;
    }

    public EnergyStore(int cap, int maxRec, int maxExt) {
        super(cap);
        this.maxReceive = maxRec;
        this.maxExtract = maxExt;
    }

    public void setEnergyStored(int en) {
        if (en < 0) {
            en = 0;
        }
        this.energy = Math.min(en, this.capacity);
    }

    public int emptyCapacity() {
        return this.capacity - this.energy;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (!this.canReceive() || this.getMaxEnergyStored() <= this.getEnergyStored()) {
            return 0;
        }
        int energyReceived = Math.min(this.getMaxEnergyStored() - this.getEnergyStored(), Math.min(this.maxReceive, maxReceive));
        if (!simulate) {
            int newEnergy = energyReceived + this.getEnergyStored();
            this.setEnergyStored(Math.min(this.getMaxEnergyStored(), newEnergy));
        }
        return energyReceived;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (!this.canExtract()) {
            return 0;
        }
        int energyExtracted = Math.min(this.getEnergyStored(), Math.min(this.maxExtract, maxExtract));
        if (!simulate) {
            this.setEnergyStored(this.getEnergyStored() - energyExtracted);
        }
        return energyExtracted;
    }
}

