/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.uncrafter;

import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.block.core.TileEntityBaseMachineInvo;
import com.lothrazar.cyclicmagic.block.uncrafter.BlockUncrafting;
import com.lothrazar.cyclicmagic.gui.ITileRedstoneToggle;
import com.lothrazar.cyclicmagic.util.UtilInventoryTransfer;
import com.lothrazar.cyclicmagic.util.UtilItemStack;
import com.lothrazar.cyclicmagic.util.UtilUncraft;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;

public class TileEntityUncrafter
extends TileEntityBaseMachineInvo
implements ITileRedstoneToggle,
ITickable {
    public static final int SLOT_UNCRAFTME = 0;
    public static final int SLOT_ROWS = 4;
    public static final int SLOT_COLS = 5;
    public static int TIMER_FULL = 200;

    public TileEntityUncrafter() {
        super(21);
        this.timer = TIMER_FULL;
        this.initEnergy(BlockUncrafting.FUEL_COST);
        this.setSlotsForInsert(0);
        this.setSlotsForExtract(1, this.func_70302_i_() - 1);
    }

    @Override
    public int[] getFieldOrdinals() {
        return super.getFieldArray(Fields.values().length);
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.needsRedstone = tagCompound.func_74762_e("redstone");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        tagCompound.func_74768_a("redstone", this.needsRedstone);
        return super.func_189515_b(tagCompound);
    }

    public void func_73660_a() {
        if (!this.isRunning()) {
            return;
        }
        ItemStack stack = this.func_70301_a(0);
        if (stack.func_190926_b()) {
            return;
        }
        if (!this.updateEnergyIsBurning()) {
            return;
        }
        if (this.updateTimerIsZero()) {
            this.timer = TIMER_FULL;
            UtilUncraft.Uncrafter uncrafter = new UtilUncraft.Uncrafter();
            try {
                if (uncrafter.process(stack) == UtilUncraft.UncraftResultType.SUCCESS) {
                    if (!this.func_145831_w().field_72995_K) {
                        ArrayList<ItemStack> uncrafterOutput = uncrafter.getDrops();
                        this.setOutputItems(uncrafterOutput);
                        this.func_70298_a(0, uncrafter.getOutsize());
                    }
                } else {
                    ArrayList<ItemStack> toDrop = new ArrayList<ItemStack>();
                    toDrop.add(stack.func_77946_l());
                    this.setOutputItems(toDrop);
                    if (!this.func_145831_w().field_72995_K) {
                        this.func_70298_a(0, stack.func_190916_E());
                    }
                }
                this.func_145831_w().func_175704_b(this.func_174877_v(), this.func_174877_v().func_177984_a());
                this.func_70296_d();
            }
            catch (Exception e) {
                ModCyclic.logger.error("Unhandled exception in uncrafting ", e);
                e.printStackTrace();
            }
        }
    }

    private void setOutputItems(List<ItemStack> output) {
        ArrayList<ItemStack> toDrop = UtilInventoryTransfer.dumpToIInventory(output, this, 1);
        if (!toDrop.isEmpty()) {
            for (ItemStack s : toDrop) {
                UtilItemStack.dropItemStackInWorld(this.func_145831_w(), this.func_174877_v().func_177984_a(), s);
            }
        }
    }

    @Override
    public int func_174887_a_(int id) {
        switch (Fields.values()[id]) {
            case TIMER: {
                return this.timer;
            }
            case REDSTONE: {
                if (this.needsRedstone != 1 && this.needsRedstone != 0) {
                    this.needsRedstone = 0;
                }
                return this.needsRedstone;
            }
        }
        return -7;
    }

    @Override
    public void func_174885_b(int id, int value) {
        switch (Fields.values()[id]) {
            case TIMER: {
                this.timer = value;
                break;
            }
            case REDSTONE: {
                if (value != 1 && value != 0) {
                    value = 0;
                }
                this.needsRedstone = value;
            }
        }
    }

    @Override
    public int func_174890_g() {
        return Fields.values().length;
    }

    @Override
    public void toggleNeedsRedstone() {
        int val = (this.needsRedstone + 1) % 2;
        this.func_174885_b(Fields.REDSTONE.ordinal(), val);
    }

    @Override
    public boolean onlyRunIfPowered() {
        return this.needsRedstone == 1;
    }

    public static enum Fields {
        TIMER,
        REDSTONE;

    }
}

