/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.fluidplacer;

import com.lothrazar.cyclicmagic.IContent;
import com.lothrazar.cyclicmagic.block.core.BlockBaseFacingOmni;
import com.lothrazar.cyclicmagic.block.core.TileEntityBaseMachineFluid;
import com.lothrazar.cyclicmagic.block.fluidplacer.TileEntityFluidPlacer;
import com.lothrazar.cyclicmagic.data.IHasRecipe;
import com.lothrazar.cyclicmagic.registry.BlockRegistry;
import com.lothrazar.cyclicmagic.registry.RecipeRegistry;
import com.lothrazar.cyclicmagic.util.UtilChat;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class BlockFluidPlacer
extends BlockBaseFacingOmni
implements ITileEntityProvider,
IHasRecipe,
IContent {
    private boolean enabled;

    public BlockFluidPlacer() {
        super(Material.field_151575_d);
        this.func_149711_c(3.0f);
        this.func_149752_b(3.0f);
        this.setHarvestLevel("pickaxe", 1);
        this.setTranslucent();
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityFluidPlacer();
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack tool) {
        super.func_180657_a(world, player, pos, state, te, tool);
        world.func_175698_g(pos);
    }

    @Override
    public void register() {
        BlockRegistry.registerBlock((Block)this, "fluid_placer", null);
        GameRegistry.registerTileEntity(TileEntityFluidPlacer.class, (String)"fluid_placer_te");
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public void syncConfig(Configuration config) {
        String category = "cyclicmagic.content";
        this.enabled = config.getBoolean("fluid_placer", category, true, "Set false to delete - requires restart");
    }

    @Override
    public IRecipe addRecipe() {
        return RecipeRegistry.addShapedRecipe(new ItemStack((Block)this), "i i", "frd", "i i", Character.valueOf('r'), "dustRedstone", Character.valueOf('i'), "ingotIron", Character.valueOf('f'), Blocks.field_150460_al, Character.valueOf('d'), Items.field_151133_ar);
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntityBaseMachineFluid te = (TileEntityBaseMachineFluid)world.func_175625_s(pos);
        boolean success = FluidUtil.interactWithFluidHandler((EntityPlayer)player, (EnumHand)hand, (World)world, (BlockPos)pos, (EnumFacing)side);
        if (te != null && !world.field_72995_K) {
            String message = null;
            FluidStack fs = te.getCurrentFluidStack();
            if (fs != null) {
                String amtStr = fs.amount + " / " + te.getCapacity() + " ";
                message = UtilChat.lang("cyclic.fluid.amount") + amtStr + fs.getLocalizedName();
            } else {
                message = UtilChat.lang("cyclic.fluid.empty");
            }
            String powered = world.func_175640_z(pos) ? "cyclic.redstone.on" : "cyclic.redstone.off";
            UtilChat.sendStatusMessage(player, message + "; " + UtilChat.lang(powered));
        }
        return success || super.func_180639_a(world, pos, state, player, hand, side, hitX, hitY, hitZ);
    }
}

