/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.enchantlibrary.shelf;

import com.lothrazar.cyclicmagic.block.core.BaseTESR;
import com.lothrazar.cyclicmagic.block.enchantlibrary.shelf.TileEntityLibrary;
import com.lothrazar.cyclicmagic.data.EnchantStack;
import com.lothrazar.cyclicmagic.data.QuadrantEnum;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;

public class LibraryTESR<T extends TileEntityLibrary>
extends BaseTESR<T> {
    private static final int TEXTCOLOR = 0;
    boolean doNameplate = false;
    final float horizDistFromCenter = 0.46f;
    final float leftColumn = 1.6f;
    final float rightColumn = 2.08f;
    final float topRow = -0.9f;
    final float bottomRow = -1.4125f;
    final float vOffset = -0.11f;

    public LibraryTESR(Block block) {
        super(block);
    }

    public void render(TileEntityLibrary te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        EnumFacing face = te.getCurrentFacing();
        this.renderEnchantStack(te, te.getEnchantStack(QuadrantEnum.TL), QuadrantEnum.TL, face, x, y, z, destroyStage, 1.6f, -0.9f, 0.46f);
        this.renderEnchantStack(te, te.getEnchantStack(QuadrantEnum.TR), QuadrantEnum.TR, face, x, y, z, destroyStage, 2.08f, -0.9f, 0.46f);
        this.renderEnchantStack(te, te.getEnchantStack(QuadrantEnum.BL), QuadrantEnum.BL, face, x, y, z, destroyStage, 1.6f, -1.4125f, 0.46f);
        this.renderEnchantStack(te, te.getEnchantStack(QuadrantEnum.BR), QuadrantEnum.BR, face, x, y, z, destroyStage, 2.08f, -1.4125f, 0.46f);
    }

    private void renderStack(TileEntityLibrary te, EnchantStack stack, EnumFacing face, QuadrantEnum quad, double x, double y, double z) {
        float scaleFactor = 0.045f;
        int angle = this.angleOfFace(face);
        ItemStack s = stack.getRenderIcon();
        GlStateManager.func_179123_a();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179101_C();
        float startX = 0.0f;
        float startY = 0.0f;
        switch (quad) {
            case TL: {
                startX = 0.089f;
                startY = 0.956f;
                break;
            }
            case TR: {
                startX = 0.6f;
                startY = 0.956f;
                break;
            }
            case BL: {
                startX = 0.089f;
                startY = 0.45f;
                break;
            }
            case BR: {
                startX = 0.6f;
                startY = 0.45f;
            }
        }
        float bookY = startY;
        float bookX = startX;
        int max = (int)Math.ceil((float)stack.getCount() / 8.0f);
        for (int i = 0; i < max; ++i) {
            bookX += scaleFactor;
            if (i % 8 == 0) {
                bookX = startX;
                bookY -= scaleFactor;
            }
            this.renderItem(te, s, bookX, bookY, 1.0f, angle, false, scaleFactor);
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179099_b();
    }

    private void renderEnchantStack(TileEntityLibrary te, EnchantStack stack, QuadrantEnum quad, EnumFacing face, double x, double y, double z, int destroyStage, float xt, float yt, float zt) {
        if (stack.isEmpty()) {
            return;
        }
        float fontSize = 0.0069444445f;
        GlStateManager.func_179094_E();
        int angle = this.angleOfFace(face);
        this.renderTextAt(stack.shortName(), x, y, z, destroyStage, xt - 1.517f, yt + 0.77f, zt - 0.44f, angle, 0, fontSize);
        if (!stack.isEmpty()) {
            this.renderTextAt(stack.levelName(), x, y, z, destroyStage, xt - 1.5f, yt + 0.8f + -0.11f, zt - 0.44f, angle, 0, fontSize);
            this.renderTextAt(stack.countName(), x, y, z, destroyStage, xt - 1.5f, yt + 0.8f + -0.22f, zt - 0.44f, angle, 0, fontSize);
        }
        this.renderStack(te, stack, face, quad, x, y, z);
        GlStateManager.func_179121_F();
    }
}

