/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.dropper;

import com.lothrazar.cyclicmagic.block.core.TileEntityBaseMachineInvo;
import com.lothrazar.cyclicmagic.block.dropper.BlockDropperExact;
import com.lothrazar.cyclicmagic.gui.ITileRedstoneToggle;
import com.lothrazar.cyclicmagic.util.UtilItemStack;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;

public class TileEntityDropperExact
extends TileEntityBaseMachineInvo
implements ITileRedstoneToggle,
ITickable {
    private int slotCurrent = 0;
    private int dropCount = 1;
    private int delay = 10;
    private int hOffset = 0;

    public TileEntityDropperExact() {
        super(9);
        this.initEnergy(BlockDropperExact.FUEL_COST);
        this.setSlotsForExtract(0, 8);
        this.setSlotsForInsert(0, 8);
        this.timer = this.delay;
    }

    public void func_73660_a() {
        if (!this.isRunning()) {
            return;
        }
        if (!this.updateEnergyIsBurning()) {
            return;
        }
        if (this.updateTimerIsZero()) {
            this.updateCurrentSlot();
            if (this.slotCurrent > -1 && !this.func_70301_a(this.slotCurrent).func_190926_b()) {
                ItemStack dropMe = this.func_70301_a(this.slotCurrent).func_77946_l();
                this.timer = this.delay;
                BlockPos target = this.getCurrentFacingPos().func_177967_a(this.getCurrentFacing(), this.hOffset);
                int amtDrop = Math.min(this.dropCount, dropMe.func_190916_E());
                dropMe.func_190920_e(amtDrop);
                UtilItemStack.dropItemStackMotionless(this.field_145850_b, target, dropMe);
                this.func_70298_a(this.slotCurrent, amtDrop);
            }
        }
    }

    private void updateCurrentSlot() {
        int j = 1;
        for (int k = 0; k < this.inv.size(); ++k) {
            if (((ItemStack)this.inv.get(k)).func_190926_b() || this.field_145850_b.field_73012_v.nextInt(j++) != 0) continue;
            this.slotCurrent = k;
            return;
        }
        this.slotCurrent = -1;
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.needsRedstone = tagCompound.func_74762_e("redstone");
        this.timer = tagCompound.func_74762_e("Timer");
        this.delay = tagCompound.func_74762_e("delay");
        this.dropCount = tagCompound.func_74762_e("dropCount");
        this.hOffset = tagCompound.func_74762_e("hOffset");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        tagCompound.func_74768_a("Timer", this.timer);
        tagCompound.func_74768_a("redstone", this.needsRedstone);
        tagCompound.func_74768_a("delay", this.delay);
        tagCompound.func_74768_a("dropCount", this.dropCount);
        tagCompound.func_74768_a("hOffset", this.hOffset);
        return super.func_189515_b(tagCompound);
    }

    @Override
    public void toggleNeedsRedstone() {
        int val = (this.needsRedstone + 1) % 2;
        this.func_174885_b(Fields.REDSTONE.ordinal(), val);
    }

    @Override
    public boolean onlyRunIfPowered() {
        return this.needsRedstone == 1;
    }

    @Override
    public int func_174887_a_(int id) {
        switch (Fields.values()[id]) {
            case TIMER: {
                return this.timer;
            }
            case REDSTONE: {
                return this.needsRedstone;
            }
            case DELAY: {
                return this.delay;
            }
            case DROPCOUNT: {
                return this.dropCount;
            }
            case OFFSET: {
                return this.hOffset;
            }
        }
        return -1;
    }

    @Override
    public void func_174885_b(int id, int value) {
        switch (Fields.values()[id]) {
            case TIMER: {
                this.timer = value;
                break;
            }
            case REDSTONE: {
                this.needsRedstone = value;
                break;
            }
            case DELAY: {
                this.delay = Math.max(0, value);
                break;
            }
            case DROPCOUNT: {
                this.dropCount = Math.max(1, value);
                break;
            }
            case OFFSET: {
                this.hOffset = Math.max(0, value);
            }
        }
    }

    @Override
    public int[] getFieldOrdinals() {
        return super.getFieldArray(this.func_174890_g());
    }

    @Override
    public int func_174890_g() {
        return Fields.values().length;
    }

    public static enum Fields {
        TIMER,
        REDSTONE,
        DROPCOUNT,
        DELAY,
        OFFSET;

    }
}

