/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.dehydrator;

import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RecipeDeHydrate
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    public static ArrayList<RecipeDeHydrate> recipes = new ArrayList();
    private ItemStack recipeInput = ItemStack.field_190927_a;
    private ItemStack resultItem = ItemStack.field_190927_a;
    private int time;
    private int fluid;

    public RecipeDeHydrate(ItemStack in, ItemStack out, int time, int fluid) {
        this.recipeInput = in;
        this.resultItem = out;
        this.setFluid(fluid);
        this.time = time;
        this.setRegistryName(new ResourceLocation("cyclicmagic", "dehydrate" + UUID.randomUUID().toString() + out.func_77977_a()));
    }

    public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
        return RecipeDeHydrate.recipeSlotMatches(inv.func_70301_a(0), this.recipeInput);
    }

    public static boolean recipeSlotMatches(ItemStack sInvo, ItemStack sRecipe) {
        if (sInvo.func_190926_b() != sRecipe.func_190926_b()) {
            return false;
        }
        return sInvo.func_190916_E() >= sRecipe.func_190916_E() && (sInvo.func_77969_a(sRecipe) || OreDictionary.itemMatches((ItemStack)sInvo, (ItemStack)sRecipe, (boolean)false));
    }

    public boolean tryPayCost(IInventory invoSource) {
        if (invoSource.func_70301_a(0).func_190916_E() < this.recipeInput.func_190916_E()) {
            return false;
        }
        invoSource.func_70298_a(0, this.recipeInput.func_190916_E());
        return true;
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        return this.resultItem.func_77946_l();
    }

    public boolean func_194133_a(int width, int height) {
        return width <= 1 && height <= 1;
    }

    public ItemStack func_77571_b() {
        return this.resultItem.func_77946_l();
    }

    public ItemStack getRecipeInput() {
        return this.recipeInput;
    }

    public int getTime() {
        return this.time;
    }

    public void setTime(int time) {
        this.time = time;
    }

    public static void initAllRecipes() {
        int defaultTime = 10;
        int defaultFluid = 100;
        RecipeDeHydrate.addRecipe(new RecipeDeHydrate(new ItemStack(Blocks.field_150435_aG), new ItemStack(Blocks.field_150405_ch), defaultTime, defaultFluid));
        RecipeDeHydrate.addRecipe(new RecipeDeHydrate(new ItemStack(Blocks.field_150346_d), new ItemStack(Blocks.field_150351_n), defaultTime, defaultFluid));
        RecipeDeHydrate.addRecipe(new RecipeDeHydrate(new ItemStack((Block)Blocks.field_150329_H, 1, 2), new ItemStack((Block)Blocks.field_150330_I), defaultTime, defaultFluid));
        RecipeDeHydrate.addRecipe(new RecipeDeHydrate(new ItemStack((Block)Blocks.field_150349_c), new ItemStack(Blocks.field_185774_da), defaultTime, defaultFluid));
        RecipeDeHydrate.addRecipe(new RecipeDeHydrate(new ItemStack(Blocks.field_150346_d, 1, 1), new ItemStack(Blocks.field_150346_d, 1, 2), defaultTime, defaultFluid));
        RecipeDeHydrate.addRecipe(new RecipeDeHydrate(new ItemStack(Items.field_151078_bh, 12), new ItemStack(Items.field_151116_aA), defaultTime, defaultFluid));
        RecipeDeHydrate.addRecipe(new RecipeDeHydrate(new ItemStack(Blocks.field_150345_g, 1, Short.MAX_VALUE), new ItemStack(Items.field_151055_y), defaultTime, defaultFluid));
        for (int i = 0; i < 6; ++i) {
            RecipeDeHydrate.addRecipe(new RecipeDeHydrate(new ItemStack(Blocks.field_150345_g, 1, i), new ItemStack(Items.field_151055_y), defaultTime, defaultFluid));
        }
        for (EnumDyeColor col : EnumDyeColor.values()) {
            RecipeDeHydrate.addRecipe(new RecipeDeHydrate(new ItemStack(Blocks.field_192443_dR, 1, col.func_176765_a()), new ItemStack(Blocks.field_192444_dS, 1, col.func_176765_a()), defaultTime, defaultFluid));
        }
    }

    public static void addRecipe(RecipeDeHydrate rec) {
        if (rec.recipeInput.func_77960_j() == Short.MAX_VALUE) {
            ItemStack snew = new ItemStack(rec.recipeInput.func_77973_b(), rec.recipeInput.func_190916_E(), 0);
            snew.func_77982_d(rec.recipeInput.func_77978_p());
            rec.recipeInput = snew;
        }
        recipes.add(rec);
    }

    public int getFluid() {
        return this.fluid;
    }

    public void setFluid(int fluid) {
        this.fluid = fluid;
    }
}

