/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.cablewireless.energy;

import com.lothrazar.cyclicmagic.block.core.TileEntityBaseMachineFluid;
import com.lothrazar.cyclicmagic.capability.EnergyStore;
import com.lothrazar.cyclicmagic.data.BlockPosDim;
import com.lothrazar.cyclicmagic.gui.ITileRedstoneToggle;
import com.lothrazar.cyclicmagic.item.location.ItemLocation;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class TileCableEnergyWireless
extends TileEntityBaseMachineFluid
implements ITickable,
ITileRedstoneToggle {
    public static final int ENERGY_FULL = 64000;
    public static final int MAX_TRANSFER = 1000;
    public static final int SLOT_COUNT = 9;
    List<Integer> slotList = IntStream.rangeClosed(0, 9).boxed().collect(Collectors.toList());
    private int transferRate = 500;

    public TileCableEnergyWireless() {
        super(9);
        this.initEnergy(new EnergyStore(64000, 64000, 64000));
    }

    @Override
    public int[] getFieldOrdinals() {
        return super.getFieldArray(Fields.values().length);
    }

    @Override
    public int func_174887_a_(int id) {
        switch (Fields.values()[id]) {
            case REDSTONE: {
                return this.needsRedstone;
            }
            case TRANSFER_RATE: {
                return this.transferRate;
            }
        }
        return 0;
    }

    @Override
    public void func_174885_b(int id, int value) {
        switch (Fields.values()[id]) {
            case REDSTONE: {
                this.needsRedstone = value % 2;
                break;
            }
            case TRANSFER_RATE: {
                this.transferRate = value;
            }
        }
    }

    @Override
    public boolean func_94041_b(int index, ItemStack stack) {
        return stack.func_77973_b() instanceof ItemLocation;
    }

    private BlockPosDim getTarget(int slot) {
        return ItemLocation.getPosition(this.func_70301_a(slot));
    }

    public void func_73660_a() {
        if (!this.isRunning()) {
            return;
        }
        Collections.shuffle(this.slotList);
        for (int slot : this.slotList) {
            this.outputEnergy(slot);
        }
    }

    @Override
    public void toggleNeedsRedstone() {
        int val = this.needsRedstone == 1 ? 0 : 1;
        this.func_174885_b(Fields.REDSTONE.ordinal(), val);
    }

    @Override
    public boolean onlyRunIfPowered() {
        return this.needsRedstone == 1;
    }

    private boolean isTargetValid(BlockPosDim target) {
        return target != null && target.getDimension() == this.getDimension() && this.field_145850_b.func_175707_a(target.toBlockPos(), target.toBlockPos().func_177984_a());
    }

    private void outputEnergy(int slot) {
        BlockPosDim dim = this.getTarget(slot);
        if (!this.isTargetValid(dim)) {
            return;
        }
        BlockPos target = dim.toBlockPos();
        TileEntity tileTarget = this.field_145850_b.func_175625_s(target);
        if (tileTarget != null && tileTarget.hasCapability(CapabilityEnergy.ENERGY, null)) {
            IEnergyStorage handlerHere = (IEnergyStorage)this.getCapability(CapabilityEnergy.ENERGY, null);
            IEnergyStorage handlerOutput = (IEnergyStorage)tileTarget.getCapability(CapabilityEnergy.ENERGY, null);
            int drain = handlerHere.extractEnergy(this.transferRate, true);
            if (drain > 0) {
                int filled = handlerOutput.receiveEnergy(drain, false);
                handlerHere.extractEnergy(filled, false);
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.transferRate = compound.func_74762_e("transferRate");
        this.needsRedstone = compound.func_74762_e("redstone");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("transferRate", this.transferRate);
        compound.func_74768_a("redstone", this.needsRedstone);
        return super.func_189515_b(compound);
    }

    public static enum Fields {
        REDSTONE,
        TRANSFER_RATE;

    }
}

