/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.network.packets;

import io.netty.buffer.ByteBuf;
import mcmultipart.api.multipart.IMultipartTile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import sonar.core.SonarCore;
import sonar.core.network.PacketMultipart;
import sonar.core.network.PacketMultipartHandler;
import sonar.logistics.api.core.tiles.connections.data.network.ILogisticsNetwork;
import sonar.logistics.core.tiles.readers.items.TileInventoryReader;
import sonar.logistics.core.tiles.readers.items.handling.ItemHelper;

public class PacketInventoryReader
extends PacketMultipart {
    public ItemStack selected;
    public int button;

    public PacketInventoryReader() {
    }

    public PacketInventoryReader(int slotID, BlockPos pos, ItemStack selected, int button) {
        super(slotID, pos);
        this.selected = selected;
        this.button = button;
    }

    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        if (buf.readBoolean()) {
            this.selected = ByteBufUtils.readItemStack((ByteBuf)buf);
        }
        this.button = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        if (this.selected != null) {
            buf.writeBoolean(true);
            ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.selected);
        } else {
            buf.writeBoolean(false);
        }
        buf.writeInt(this.button);
    }

    public static class Handler
    extends PacketMultipartHandler<PacketInventoryReader> {
        public IMessage processMessage(PacketInventoryReader message, EntityPlayer player, World world, IMultipartTile part, MessageContext ctx) {
            if (ctx.side == Side.SERVER) {
                SonarCore.proxy.getThreadListener(ctx.side).func_152344_a(() -> {
                    if (!(part instanceof TileInventoryReader)) {
                        return;
                    }
                    TileInventoryReader reader = (TileInventoryReader)part;
                    ILogisticsNetwork network = reader.getNetwork();
                    if (network.isValid()) {
                        ItemHelper.onNetworkItemInteraction(reader, network, reader.getMonitoredList(), player, message.selected, message.button);
                    }
                });
            }
            return null;
        }
    }
}

