/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.wireless.receivers;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import sonar.core.network.sync.SyncEnum;
import sonar.core.network.sync.SyncTagType;
import sonar.logistics.PL2;
import sonar.logistics.api.core.tiles.connections.EnumCableConnection;
import sonar.logistics.api.core.tiles.connections.EnumCableConnectionType;
import sonar.logistics.api.core.tiles.connections.redstone.IRedstoneConnectable;
import sonar.logistics.api.core.tiles.connections.redstone.network.IRedstoneNetwork;
import sonar.logistics.api.core.tiles.misc.signaller.SignallerModes;
import sonar.logistics.api.core.tiles.wireless.IWirelessManager;
import sonar.logistics.api.core.tiles.wireless.emitters.IRedstoneEmitter;
import sonar.logistics.api.core.tiles.wireless.receivers.IRedstoneReceiver;
import sonar.logistics.core.tiles.connections.redstone.handling.RedstoneConnectionHandler;
import sonar.logistics.core.tiles.connections.redstone.handling.RedstoneConnectionHelper;
import sonar.logistics.core.tiles.connections.redstone.network.EmptyRedstoneNetwork;
import sonar.logistics.core.tiles.connections.redstone.network.RedstoneNetwork;
import sonar.logistics.core.tiles.connections.redstone.tiles.TileRedstoneCable;
import sonar.logistics.core.tiles.wireless.handling.WirelessRedstoneManager;
import sonar.logistics.core.tiles.wireless.receivers.GuiRedstoneReceiver;
import sonar.logistics.core.tiles.wireless.receivers.TileAbstractReceiver;

public class TileRedstoneReceiver
extends TileAbstractReceiver<IRedstoneEmitter, IRedstoneReceiver>
implements IRedstoneReceiver,
IRedstoneConnectable {
    public IRedstoneNetwork rNetwork = EmptyRedstoneNetwork.INSTANCE;
    public static final Function<IRedstoneEmitter, Boolean> EMITTER_FUNC = e -> e.getRedstoneNetwork().getActualPower() > 0;
    public SyncTagType.INT currentPower = new SyncTagType.INT(0);
    public SyncEnum<SignallerModes> mode = new SyncEnum((Enum[])SignallerModes.values(), 1);

    @Override
    public IWirelessManager getWirelessHandler() {
        return WirelessRedstoneManager.instance();
    }

    @Override
    public void updatePower() {
        if (this.isServer()) {
            int toSet;
            boolean power = ((SignallerModes)this.mode.getObject()).checkList(this.getAllNetworks(), n -> n.getLocalPower() > 0);
            int n2 = toSet = power ? 15 : 0;
            if ((Integer)this.currentPower.getObject() != toSet) {
                this.currentPower.setObject((Object)toSet);
                TileRedstoneCable cable = RedstoneConnectionHelper.getCable((IBlockAccess)this.field_145850_b, this.field_174879_c);
                if (cable != null) {
                    RedstoneConnectionHandler.instance().markPowerForUpdate(cable.getRegistryID());
                }
            }
        }
    }

    public List<IRedstoneNetwork> getAllNetworks() {
        ArrayList<IRedstoneNetwork> networks = new ArrayList<IRedstoneNetwork>();
        List<Integer> connected = this.getConnectedNetworks();
        connected.forEach(id -> RedstoneNetwork.addSubNetworks(networks, RedstoneConnectionHandler.instance().getNetwork((int)id), 0));
        networks.remove(this.rNetwork);
        return networks;
    }

    @Override
    public void onEmitterDisconnected(IRedstoneEmitter emitter) {
        WirelessRedstoneManager.instance().disconnectNetworks(this.getRedstoneNetwork(), emitter.getRedstoneNetwork());
        RedstoneConnectionHandler.instance().markPowerForUpdate(this.rNetwork.getNetworkID());
    }

    @Override
    public void onEmitterConnected(IRedstoneEmitter emitter) {
        WirelessRedstoneManager.instance().connectNetworks(this.getRedstoneNetwork(), emitter.getRedstoneNetwork());
        RedstoneConnectionHandler.instance().markPowerForUpdate(this.rNetwork.getNetworkID());
    }

    @Override
    public void onNetworkConnect(IRedstoneNetwork network) {
        if (!this.rNetwork.isValid() || ((Integer)this.networkID.getObject()).intValue() != network.getNetworkID()) {
            this.rNetwork = network;
            this.networkID.setObject((Object)network.getNetworkID());
        }
    }

    @Override
    public void onNetworkDisconnect(IRedstoneNetwork network) {
        if (((Integer)this.networkID.getObject()).intValue() == network.getNetworkID()) {
            this.rNetwork = EmptyRedstoneNetwork.INSTANCE;
            this.networkID.setObject((Object)-1);
        } else if ((Integer)this.networkID.getObject() != -1) {
            PL2.logger.info("%s : attempted to disconnect from the wrong handling with ID: %s expected %s", (Object)this, (Object)network.getNetworkID(), this.networkID.getObject());
        }
    }

    @Override
    public int getRedstonePower() {
        return (Integer)this.currentPower.getObject();
    }

    @Override
    public EnumCableConnection canConnect(int registryID, EnumCableConnectionType type, EnumFacing dir, boolean internal) {
        if (!type.isRedstone()) {
            return EnumCableConnection.NONE;
        }
        EnumFacing toCheck = internal ? dir : dir.func_176734_d();
        return toCheck == this.getCableFace() ? EnumCableConnection.NETWORK : EnumCableConnection.NONE;
    }

    public Object getClientElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        return id == 0 ? new GuiRedstoneReceiver(this) : null;
    }

    @Override
    public void writePacket(ByteBuf buf, int id) {
        super.writePacket(buf, id);
        switch (id) {
            case 1: {
                this.mode.writeToBuf(buf);
            }
        }
    }

    @Override
    public void readPacket(ByteBuf buf, int id) {
        super.readPacket(buf, id);
        switch (id) {
            case 1: {
                this.mode.readFromBuf(buf);
                this.updatePower();
            }
        }
    }

    public int getCurrentPower() {
        return (Integer)this.currentPower.getObject();
    }

    @Override
    public void refreshConnectedNetworks() {
    }

    @Override
    public List<Integer> getConnectedNetworks() {
        ArrayList<Integer> networks = new ArrayList<Integer>();
        List emitters = this.getEmitters();
        for (IRedstoneEmitter emitter : emitters) {
            IRedstoneNetwork rNetwork = emitter.getRedstoneNetwork();
            if (rNetwork.getNetworkID() == -1 || !rNetwork.isValid()) continue;
            networks.add(rNetwork.getNetworkID());
        }
        return networks;
    }

    @Override
    public IRedstoneNetwork getRedstoneNetwork() {
        return this.rNetwork;
    }
}

