/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.readers.info;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.world.World;
import sonar.core.client.gui.GuiHelpOverlay;
import sonar.core.client.gui.GuiSonar;
import sonar.core.client.gui.GuiSonarTile;
import sonar.core.helpers.FontHelper;
import sonar.core.network.FlexibleGuiHandler;
import sonar.core.utils.CustomColour;
import sonar.logistics.PL2Translate;
import sonar.logistics.api.core.tiles.displays.info.IProvidableInfo;
import sonar.logistics.base.gui.GuiSelectionList;
import sonar.logistics.base.gui.PL2Colours;
import sonar.logistics.base.gui.buttons.LogisticsButton;
import sonar.logistics.base.gui.overlays.HelpOverlays;
import sonar.logistics.core.tiles.displays.info.InfoRenderHelper;
import sonar.logistics.core.tiles.readers.base.TileAbstractLogicReader;
import sonar.logistics.core.tiles.readers.info.ContainerInfoReader;
import sonar.logistics.core.tiles.readers.network.TileNetworkReader;

public class GuiInfoReader
extends GuiSelectionList<IProvidableInfo> {
    public TileAbstractLogicReader<IProvidableInfo> part;
    public EntityPlayer player;
    public GuiHelpOverlay<GuiInfoReader> overlay = HelpOverlays.infoReader;

    public GuiInfoReader(EntityPlayer player, TileAbstractLogicReader<IProvidableInfo> tile) {
        super((Container)new ContainerInfoReader(player, tile), tile);
        this.player = player;
        this.part = tile;
        this.field_146999_f = 248;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.overlay.initGui((GuiSonarTile)this);
        this.field_146292_n.add(new LogisticsButton.CHANNELS((GuiSonar)this, 1, this.field_147003_i + 9, this.field_147009_r + 7));
        this.field_146292_n.add(new LogisticsButton.HELP((GuiSonar)this, 2, this.field_147003_i + this.field_146999_f - 9 - 16, this.field_147009_r + 7));
    }

    @Override
    public void func_146284_a(GuiButton button) {
        super.func_146284_a(button);
        if (button != null) {
            if (button.field_146127_k == 1) {
                FlexibleGuiHandler.changeGui(this.part, (int)1, (int)0, (World)this.player.func_130014_f_(), (EntityPlayer)this.player);
            }
            if (button.field_146127_k == 2) {
                GuiHelpOverlay.enableHelp = !GuiHelpOverlay.enableHelp;
                this.reset();
            }
        }
    }

    @Override
    public void func_73864_a(int x, int y, int button) throws IOException {
        super.func_73864_a(x, y, button);
        this.overlay.mouseClicked((GuiSonarTile)this, x, y, button);
    }

    @Override
    public void func_146979_b(int x, int y) {
        super.func_146979_b(x, y);
        if (this.part instanceof TileNetworkReader) {
            FontHelper.textCentre((String)PL2Translate.NETWORK_READER.t(), (int)this.field_146999_f, (int)6, (CustomColour)PL2Colours.white_text);
        } else {
            FontHelper.textCentre((String)PL2Translate.INFO_READER.t(), (int)this.field_146999_f, (int)6, (CustomColour)PL2Colours.white_text);
        }
        FontHelper.textCentre((String)PL2Translate.INFO_READER_HELP.t(), (int)this.field_146999_f, (int)18, (CustomColour)PL2Colours.grey_text);
        this.overlay.drawOverlay((GuiSonarTile)this, x, y);
    }

    @Override
    public void setInfo() {
        this.infoList = !this.part.getChannels().hasChannels() ? new ArrayList() : this.part.getMonitoredList().createSaveableList(this.part.getSorter());
    }

    @Override
    public void selectionPressed(GuiButton button, int infoPos, int buttonID, IProvidableInfo info) {
        if (info.isValid() && !info.isHeader()) {
            this.part.selectedInfo.setInfo(info);
            this.part.sendByteBufPacket(buttonID == 0 ? -9 : -10);
        }
    }

    @Override
    public boolean isCategoryHeader(IProvidableInfo info) {
        return info.isHeader();
    }

    @Override
    public boolean isSelectedInfo(IProvidableInfo info) {
        if (!info.isValid() || info.isHeader()) {
            return false;
        }
        List<IProvidableInfo> selectedInfo = this.part.getSelectedInfo();
        for (IProvidableInfo selected : selectedInfo) {
            if (selected == null || selected.isHeader() || !info.isMatchingType(selected) || !info.isMatchingInfo(selected)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isPairedInfo(IProvidableInfo info) {
        if (!info.isValid() || info.isHeader()) {
            return false;
        }
        List<IProvidableInfo> pairedInfo = this.part.getPairedInfo();
        for (IProvidableInfo selected : pairedInfo) {
            if (selected == null || selected.isHeader() || !info.isMatchingType(selected) || !info.isMatchingInfo(selected)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void renderInfo(IProvidableInfo info, int yPos) {
        InfoRenderHelper.renderMonitorInfoInGUI(info, yPos + 1, PL2Colours.white_text.getRGB());
    }

    @Override
    public int getColour(int i, int type) {
        IProvidableInfo info = (IProvidableInfo)this.infoList.get(i + this.start);
        if (info == null || info.isHeader()) {
            return PL2Colours.layers[1].getRGB();
        }
        List<IProvidableInfo> selectedInfo = type == 0 ? this.part.getSelectedInfo() : this.part.getPairedInfo();
        int pos = 0;
        for (IProvidableInfo selected : selectedInfo) {
            if (selected != null && !selected.isHeader() && info.isMatchingType(selected) && info.isMatchingInfo(selected)) {
                return PL2Colours.infoColours[pos].getRGB();
            }
            ++pos;
        }
        return PL2Colours.layers[1].getRGB();
    }

    public void func_73869_a(char c, int i) throws IOException {
        super.func_73869_a(c, i);
        this.overlay.onTileChanged((GuiSonarTile)this);
    }
}

