/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.displays.info.types.text;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import sonar.core.helpers.ListHelper;
import sonar.core.helpers.NBTHelper;
import sonar.core.helpers.RenderHelper;
import sonar.logistics.api.core.tiles.displays.info.IInfo;
import sonar.logistics.api.core.tiles.displays.info.InfoUUID;
import sonar.logistics.core.tiles.displays.gsi.interaction.DisplayScreenClick;
import sonar.logistics.core.tiles.displays.gsi.interaction.actions.IDisplayAction;
import sonar.logistics.core.tiles.displays.info.elements.AbstractDisplayElement;
import sonar.logistics.core.tiles.displays.info.elements.DisplayElementHelper;
import sonar.logistics.core.tiles.displays.info.elements.base.ElementFillType;
import sonar.logistics.core.tiles.displays.info.elements.base.IClickableElement;
import sonar.logistics.core.tiles.displays.info.elements.base.IInfoReferenceElement;
import sonar.logistics.core.tiles.displays.info.types.text.styling.StyledStringLine;

public abstract class StyledTextElement
extends AbstractDisplayElement
implements IClickableElement,
Iterable<StyledStringLine>,
IInfoReferenceElement {
    private Map<Integer, IDisplayAction> actions = Maps.newHashMap();
    private List<StyledStringLine> textLines = new ArrayList<StyledStringLine>();
    private List<InfoUUID> uuids;
    public int spacing = 0;
    public int action_id_count = 0;
    public boolean updateTextScaling = true;
    public boolean updateTextContents = true;
    public double textScale = 1.0;
    public static final int INVALID = -1;
    public static final int AFTER = -2;
    public static final int BEFORE = -3;

    public StyledTextElement() {
    }

    public StyledTextElement(String string) {
        this(Lists.newArrayList((Object[])new String[]{string}));
    }

    public StyledTextElement(List<String> strings) {
        strings.forEach(this::addLine);
    }

    @Override
    public void updateRender() {
        super.updateRender();
        if (this.updateTextContents || this.updateTextScaling) {
            this.uuids = null;
            this.unscaledWidthHeight = null;
            this.maxScaling = null;
            this.actualScaling = null;
            this.updateTextContents = false;
            this.getHolder().getContainer().updateActualScaling();
            this.getGSI().updateInfoReferences();
        }
    }

    @Override
    public void onElementChanged() {
        this.markTextContentsChanged();
    }

    public int addAction(IDisplayAction action) {
        int id = this.action_id_count + 1;
        this.actions.put(id, action);
        return id;
    }

    @Nullable
    public IDisplayAction getAction(int action_id) {
        return this.actions.get(action_id);
    }

    public List<StyledStringLine> getLines() {
        return this.textLines;
    }

    public List<StyledStringLine> setLines(List<StyledStringLine> textLines) {
        textLines.forEach(ss -> ss.setText(this));
        this.markTextContentsChanged();
        this.textLines = textLines;
        return this.textLines;
    }

    public void addLine(String line) {
        this.addLine(new StyledStringLine(this, line));
    }

    public void addLine(StyledStringLine line) {
        line.setText(this);
        this.textLines.add(line);
        this.markTextContentsChanged();
    }

    public void setLine(int i, StyledStringLine line) {
        line.setText(this);
        this.textLines.set(i, line);
        this.markTextContentsChanged();
    }

    public void preRender(StyledStringLine c) {
    }

    public void deleteLine(int lineY) {
        this.textLines.remove(lineY);
        this.markTextContentsChanged();
    }

    public void addNewLine(int lineY, StyledStringLine line) {
        line.setText(this);
        if (lineY >= this.textLines.size()) {
            this.textLines.add(line);
        } else {
            this.textLines.add(lineY, line);
        }
        this.markTextContentsChanged();
    }

    public void postRender(StyledStringLine c) {
    }

    @Override
    public List<InfoUUID> getInfoReferences() {
        if (this.uuids == null) {
            ArrayList<InfoUUID> references = new ArrayList<InfoUUID>();
            this.forEach(line -> line.forEach(s -> ListHelper.addWithCheck((Collection)references, s.getInfoReferences())));
            this.uuids = references;
        }
        return this.uuids;
    }

    @Override
    public void onInfoReferenceChanged(InfoUUID uuid, IInfo info) {
        this.forEach(line -> line.forEach(s -> {
            if (s.getInfoReferences().contains(uuid)) {
                s.updateTextContents();
            }
        }));
    }

    public void markTextContentsChanged() {
        this.updateTextContents = true;
    }

    public void markTextScalingChanged() {
        this.updateTextScaling = true;
    }

    @Override
    public String getRepresentiveString() {
        return "Styled Text";
    }

    @Override
    public int onGSIClicked(DisplayScreenClick click, EntityPlayer player, double subClickX, double subClickY) {
        return -1;
    }

    public static boolean isValidReturn(int i_return) {
        return i_return != -1 && i_return != -2 && i_return != -3;
    }

    @Override
    @Nonnull
    public Iterator<StyledStringLine> iterator() {
        return this.textLines.iterator();
    }

    @Override
    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        ArrayList<StyledStringLine> newLines = new ArrayList<StyledStringLine>();
        NBTTagList tagList = nbt.func_150295_c("ssc", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound ssTag = tagList.func_150305_b(i);
            StyledStringLine ss = new StyledStringLine(this);
            ss.readData(ssTag, type);
            newLines.add(ss);
        }
        this.textLines = newLines;
        NBTTagList actionList = nbt.func_150295_c("actions", 10);
        for (int i = 0; i < actionList.func_74745_c(); ++i) {
            NBTTagCompound actionTag = actionList.func_150305_b(i);
            int saved_id = actionTag.func_74762_e("saved_id");
            IDisplayAction action = DisplayElementHelper.loadDisplayAction(actionTag);
            this.actions.put(saved_id, action);
        }
        this.action_id_count = nbt.func_74762_e("action_id");
        this.markTextScalingChanged();
    }

    @Override
    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.writeData(nbt, type);
        ArrayList actions_to_save = new ArrayList();
        NBTTagList tagList = new NBTTagList();
        for (StyledStringLine ss : this.textLines) {
            tagList.func_74742_a((NBTBase)ss.writeData(new NBTTagCompound(), type));
            ListHelper.addWithCheck(actions_to_save, ss.getContainedActions());
        }
        if (!tagList.func_82582_d()) {
            nbt.func_74782_a("ssc", (NBTBase)tagList);
        }
        NBTTagList actionList = new NBTTagList();
        for (Integer i : actions_to_save) {
            IDisplayAction action;
            if (i == -1 || (action = this.actions.get(i)) == null) continue;
            NBTTagCompound actionTag = new NBTTagCompound();
            DisplayElementHelper.saveDisplayAction(actionTag, action, type);
            actionTag.func_74768_a("saved_id", i.intValue());
            actionList.func_74742_a((NBTBase)actionTag);
        }
        if (!actionList.func_82582_d()) {
            nbt.func_74782_a("actions", (NBTBase)actionList);
        }
        nbt.func_74768_a("action_id", this.action_id_count);
        return nbt;
    }

    @Override
    public int[] createUnscaledWidthHeight() {
        return new int[]{1, 1};
    }

    @Override
    public ElementFillType getFillType() {
        return ElementFillType.FILL_SCALED_CONTAINER;
    }

    public int getLineCount() {
        return this.getLines().size();
    }

    public int getLineIndex(StyledStringLine toFind) {
        int i = 0;
        for (StyledStringLine line : this) {
            if (line == toFind) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getLineLength(int line) {
        if (line >= this.getLineCount() || line < 0) {
            return 0;
        }
        return this.getUnformattedLine(line).length();
    }

    public int getLineWidth(int line) {
        return RenderHelper.fontRenderer.func_78256_a(this.getFormattedLine(line));
    }

    public String getUnformattedLine(int line) {
        StyledStringLine ss = this.getLine(line);
        return ss == null ? "" : ss.getCachedUnformattedString();
    }

    public String getFormattedLine(int line) {
        StyledStringLine ss = this.getLine(line);
        return ss == null ? "" : ss.getCachedFormattedString();
    }

    public StyledStringLine getLine(int line) {
        if (line == -1 || line >= this.getLineCount()) {
            return null;
        }
        return this.getLines().get(line);
    }
}

