/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.displays.info.types.items;

import javax.annotation.Nullable;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import sonar.core.client.gui.IGuiOrigin;
import sonar.core.helpers.RenderHelper;
import sonar.logistics.api.asm.ASMDisplayElement;
import sonar.logistics.api.core.tiles.displays.info.InfoUUID;
import sonar.logistics.api.core.tiles.displays.info.lists.AbstractChangeableList;
import sonar.logistics.core.tiles.displays.gsi.interaction.DisplayScreenClick;
import sonar.logistics.core.tiles.displays.gsi.packets.GSIClickPacketHelper;
import sonar.logistics.core.tiles.displays.info.elements.NetworkGridElement;
import sonar.logistics.core.tiles.displays.info.types.LogicInfoList;
import sonar.logistics.core.tiles.displays.info.types.items.GuiEditNetworkItemlist;
import sonar.logistics.core.tiles.displays.info.types.items.MonitoredItemStack;
import sonar.logistics.core.tiles.displays.tiles.TileAbstractDisplay;

@ASMDisplayElement(id="n_item_l", modid="practicallogistics2")
public class NetworkItemGridElement
extends NetworkGridElement<MonitoredItemStack> {
    public static final String REGISTRY_NAME = "n_item_l";

    public NetworkItemGridElement() {
    }

    public NetworkItemGridElement(InfoUUID uuid) {
        super(uuid);
    }

    @Override
    public double getRenderWidth() {
        return (double)Math.round(Math.min(this.element_size, Math.min(this.getActualScaling()[0], this.getActualScaling()[1])) * 10000.0) / 10000.0;
    }

    @Override
    public double getRenderHeight() {
        return (double)Math.round(Math.min(this.element_size, Math.min(this.getActualScaling()[0], this.getActualScaling()[1])) * 10000.0) / 10000.0;
    }

    @Override
    public void renderGridElement(MonitoredItemStack stack, int index) {
        GlStateManager.func_179139_a((double)(this.width / 16.0 * this.grid_fill_percentage), (double)(this.height / 16.0 * this.grid_fill_percentage), (double)0.02);
        GlStateManager.func_179140_f();
        RenderHelper.renderItemIntoGUI((ItemStack)stack.getItemStack(), (int)0, (int)0);
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)0.8);
        GlStateManager.func_179132_a((boolean)false);
        RenderHelper.renderStoredItemStackOverlay((ItemStack)stack.getItemStack(), (long)0L, (int)0, (int)0, (int)this.text_colour, (String)("" + stack.getStored()), (boolean)false);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179132_a((boolean)true);
    }

    @Override
    public void onChangeableListChanged(InfoUUID uuid, AbstractChangeableList list) {
        if (this.info instanceof LogicInfoList) {
            ((LogicInfoList)this.info).listChanged = true;
        }
    }

    @Override
    public void onGridElementClicked(DisplayScreenClick click, LogicInfoList list, @Nullable MonitoredItemStack stack) {
        int networkID = stack == null || stack.getNetworkSource() == -1 ? ((Integer)list.networkID.getObject()).intValue() : stack.getNetworkSource();
        GSIClickPacketHelper.sendGSIClickPacket(GSIClickPacketHelper.createItemClickPacket(stack == null ? null : stack.getStoredStack(), networkID), this.getHolder().getContainer(), click);
    }

    @Override
    public Object getClientEditGui(TileAbstractDisplay obj, Object origin, World world, EntityPlayer player) {
        return IGuiOrigin.withOrigin((IGuiOrigin)new GuiEditNetworkItemlist(this, obj), (Object)origin);
    }

    @Override
    public String getRegisteredName() {
        return REGISTRY_NAME;
    }
}

