/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.displays.info.types.fluids;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;
import sonar.core.api.fluids.StoredFluidStack;
import sonar.core.client.gui.IGuiOrigin;
import sonar.core.helpers.NBTHelper;
import sonar.logistics.api.asm.ASMDisplayElement;
import sonar.logistics.api.core.tiles.displays.info.IInfo;
import sonar.logistics.api.core.tiles.displays.info.InfoUUID;
import sonar.logistics.core.tiles.displays.gsi.interaction.DisplayScreenClick;
import sonar.logistics.core.tiles.displays.gsi.packets.GSIClickPacketHelper;
import sonar.logistics.core.tiles.displays.info.InfoRenderHelper;
import sonar.logistics.core.tiles.displays.info.elements.AbstractInfoElement;
import sonar.logistics.core.tiles.displays.info.elements.base.ElementFillType;
import sonar.logistics.core.tiles.displays.info.elements.base.IClickableElement;
import sonar.logistics.core.tiles.displays.info.types.fluids.GuiEditNetworkFluid;
import sonar.logistics.core.tiles.displays.info.types.fluids.InfoNetworkFluid;
import sonar.logistics.core.tiles.displays.tiles.TileAbstractDisplay;

@ASMDisplayElement(id="n_fluid", modid="practicallogistics2")
public class ElementNetworkFluid
extends AbstractInfoElement<InfoNetworkFluid>
implements IClickableElement {
    public int text_colour = 0xFFFFFF;
    public static final String REGISTRY_NAME = "n_fluid";

    public ElementNetworkFluid() {
    }

    public ElementNetworkFluid(InfoUUID uuid) {
        super(uuid);
    }

    @Override
    public void render(InfoNetworkFluid info) {
        GL11.glPushMatrix();
        GlStateManager.func_179140_f();
        GL11.glTranslated((double)0.0, (double)0.0, (double)0.001);
        TextureAtlasSprite sprite = Minecraft.func_71410_x().func_147117_R().getTextureExtry(info.getFluidStack().getFluid().getStill().toString());
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        InfoRenderHelper.renderProgressBarWithSprite(sprite, this.getActualScaling()[0], this.getActualScaling()[1], ((StoredFluidStack)info.fluidStack.getObject()).stored, ((StoredFluidStack)info.fluidStack.getObject()).capacity);
        GlStateManager.func_179145_e();
        GL11.glPopMatrix();
    }

    @Override
    public int onGSIClicked(DisplayScreenClick click, EntityPlayer player, double subClickX, double subClickY) {
        this.info = this.getGSI().getCachedInfo(this.uuid);
        if (this.info != null && this.isType(this.info)) {
            InfoNetworkFluid stack = (InfoNetworkFluid)this.info;
            int networkID = stack.getNetworkSource();
            GSIClickPacketHelper.sendGSIClickPacket(GSIClickPacketHelper.createFluidClickPacket(stack.getStoredStack(), networkID), this.getHolder().getContainer(), click);
        }
        return -1;
    }

    @Override
    public Object getClientEditGui(TileAbstractDisplay obj, Object origin, World world, EntityPlayer player) {
        return IGuiOrigin.withOrigin((IGuiOrigin)new GuiEditNetworkFluid(this, obj), (Object)origin);
    }

    @Override
    public boolean isType(IInfo info) {
        return info instanceof InfoNetworkFluid;
    }

    @Override
    public ElementFillType getFillType() {
        return ElementFillType.FILL_CONTAINER;
    }

    @Override
    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        this.text_colour = nbt.func_74762_e("colour");
    }

    @Override
    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.writeData(nbt, type);
        nbt.func_74768_a("colour", this.text_colour);
        return nbt;
    }

    @Override
    public String getRegisteredName() {
        return REGISTRY_NAME;
    }
}

