/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.displays.info.elements.buttons;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import sonar.core.api.IFlexibleGui;
import sonar.core.client.gui.IGuiOrigin;
import sonar.core.handlers.inventories.containers.ContainerMultipartSync;
import sonar.core.integration.multipart.TileSonarMultipart;
import sonar.logistics.api.asm.ASMDisplayElement;
import sonar.logistics.api.core.tiles.displays.info.InfoUUID;
import sonar.logistics.base.requests.info.GuiInfoSource;
import sonar.logistics.base.requests.info.IInfoRequirement;
import sonar.logistics.core.tiles.displays.gsi.DisplayGSI;
import sonar.logistics.core.tiles.displays.gsi.interaction.DisplayScreenClick;
import sonar.logistics.core.tiles.displays.gsi.packets.GSIElementPacketHelper;
import sonar.logistics.core.tiles.displays.info.InfoPacketHelper;
import sonar.logistics.core.tiles.displays.info.elements.UnconfiguredInfoElement;
import sonar.logistics.core.tiles.displays.info.elements.buttons.ButtonElement;
import sonar.logistics.core.tiles.displays.tiles.TileAbstractDisplay;

@ASMDisplayElement(id="empty_info", modid="practicallogistics2")
public class ButtonEmptyInfo
extends ButtonElement
implements IFlexibleGui<TileAbstractDisplay>,
IInfoRequirement {
    public static final String REGISTRY_NAME = "empty_info";

    public ButtonEmptyInfo() {
        super(0, 2, 15, "SELECT SOURCE");
    }

    @Override
    public int onGSIClicked(DisplayScreenClick click, EntityPlayer player, double subClickX, double subClickY) {
        return 0;
    }

    public void onGuiOpened(TileAbstractDisplay obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        InfoPacketHelper.sendLocalProvidersFromScreen(obj, (IBlockAccess)world, obj.func_174877_v(), player);
    }

    public Object getServerElement(TileAbstractDisplay obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        return new ContainerMultipartSync((TileSonarMultipart)obj);
    }

    public Object getClientElement(TileAbstractDisplay obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        return new GuiInfoSource(this, this.getGSI(), (Container)new ContainerMultipartSync((TileSonarMultipart)obj));
    }

    @Override
    public Object getClientEditGui(TileAbstractDisplay obj, Object origin, World world, EntityPlayer player) {
        return IGuiOrigin.withOrigin((IGuiOrigin)new GuiInfoSource(this, this.getGSI(), (Container)new ContainerMultipartSync((TileSonarMultipart)obj)), (Object)origin);
    }

    @Override
    public int getRequired() {
        return 1;
    }

    @Override
    public List<InfoUUID> getSelectedInfo() {
        return new ArrayList<InfoUUID>();
    }

    @Override
    public void onGuiClosed(List<InfoUUID> selected) {
        GSIElementPacketHelper.sendGSIPacket(GSIElementPacketHelper.createInfoRequirementPacket(selected), this.getElementIdentity(), this.getGSI());
    }

    @Override
    public void doInfoRequirementPacket(DisplayGSI gsi, EntityPlayer player, List<InfoUUID> require) {
        InfoUUID infoUUID = require.get(0);
        if (InfoUUID.valid(infoUUID)) {
            this.getHolder().getElements().addElement(new UnconfiguredInfoElement(infoUUID));
            this.getHolder().getElements().removeElement(this);
        }
    }

    @Override
    public String getRegisteredName() {
        return REGISTRY_NAME;
    }
}

