/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.connections.redstone.handling;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import sonar.core.helpers.ListHelper;
import sonar.core.utils.Pair;
import sonar.logistics.PL2;
import sonar.logistics.api.core.tiles.connections.EnumCableConnectionType;
import sonar.logistics.api.core.tiles.connections.redstone.IRedstoneCable;
import sonar.logistics.api.core.tiles.connections.redstone.IRedstoneConnectable;
import sonar.logistics.api.core.tiles.connections.redstone.network.IRedstoneNetwork;
import sonar.logistics.core.tiles.connections.data.handling.AbstractConnectionHandler;
import sonar.logistics.core.tiles.connections.data.handling.CableConnectionHelper;
import sonar.logistics.core.tiles.connections.redstone.handling.RedstoneConnectionHelper;
import sonar.logistics.core.tiles.connections.redstone.network.EmptyRedstoneNetwork;
import sonar.logistics.core.tiles.connections.redstone.network.RedstoneNetwork;

public class RedstoneConnectionHandler
extends AbstractConnectionHandler<IRedstoneCable> {
    public final List<Integer> forUpdate = new ArrayList<Integer>();
    public final Map<Integer, Integer> powerCache = new HashMap<Integer, Integer>();
    public final Map<Integer, IRedstoneNetwork> networks = new HashMap<Integer, IRedstoneNetwork>();
    private int REDSTONE_NETWORK_COUNT;

    public static RedstoneConnectionHandler instance() {
        return PL2.proxy.redstoneManager;
    }

    @Override
    public void removeAll() {
        super.removeAll();
        this.REDSTONE_NETWORK_COUNT = 0;
        this.forUpdate.clear();
        this.powerCache.clear();
        this.networks.clear();
    }

    @Override
    public int getNextAvailableID() {
        return this.REDSTONE_NETWORK_COUNT++;
    }

    public int getCurrentIdentity() {
        return this.REDSTONE_NETWORK_COUNT;
    }

    public int setIdentityCount(int count) {
        this.REDSTONE_NETWORK_COUNT = count;
        return this.REDSTONE_NETWORK_COUNT;
    }

    public void tick() {
        this.networks.forEach((I, N) -> N.tick());
        if (!this.forUpdate.isEmpty()) {
            this.networks.values().forEach(IRedstoneNetwork::updateLocalPower);
            this.networks.values().forEach(IRedstoneNetwork::updateGlobalPower);
            this.networks.values().forEach(IRedstoneNetwork::updateActualPower);
            this.forUpdate.clear();
        }
    }

    public void markPowerForUpdate(int registryID) {
        ListHelper.addWithCheck(this.forUpdate, (Object)registryID);
    }

    public int updatePower(int registryID) {
        List<IRedstoneCable> cables = this.getConnections(registryID);
        if (!cables.isEmpty()) {
            IRedstoneNetwork network = this.getNetwork(registryID);
            int lastPower = network.getActualPower();
            int power = this.getNetwork(registryID).updateActualPower();
            if (power != lastPower) {
                this.powerCache.put(registryID, power);
            }
            cables.forEach(cable -> cable.setNetworkPower(power));
        }
        return 0;
    }

    public IRedstoneNetwork getOrCreateNetwork(int registryID) {
        return this.networks.computeIfAbsent(registryID, i -> new RedstoneNetwork(registryID));
    }

    public IRedstoneNetwork getNetwork(int registryID) {
        IRedstoneNetwork network = this.networks.get(registryID);
        return network == null ? EmptyRedstoneNetwork.INSTANCE : network;
    }

    public int getCachedPower(int registryID) {
        return this.powerCache.getOrDefault(registryID, 0);
    }

    public void onNeighbourBlockStateChanged(IRedstoneCable cable, BlockPos pos, BlockPos neighbor) {
        this.markPowerForUpdate(cable.getRegistryID());
        cable.updateCableRenders();
    }

    public void onNeighbourTileEntityChanged(IRedstoneCable cable, BlockPos pos, BlockPos neighbor) {
        cable.updateCableRenders();
    }

    public void onNeighbourMultipartAdded(IRedstoneCable cable, IRedstoneConnectable connect) {
        this.getNetwork(cable.getRegistryID()).markCablesChanged();
        cable.updateCableRenders();
    }

    public void onNeighbourMultipartRemoved(IRedstoneCable cable, IRedstoneConnectable connect) {
        this.getNetwork(cable.getRegistryID()).markCablesChanged();
        cable.updateCableRenders();
    }

    public void addAllConnectionsToNetwork(IRedstoneCable cable, IRedstoneNetwork network) {
        RedstoneConnectionHelper.getConnectables(cable).forEach(network::addConnection);
    }

    public void removeAllConnectionsFromNetwork(IRedstoneCable cable, IRedstoneNetwork network) {
        RedstoneConnectionHelper.getConnectables(cable).forEach(network::removeConnection);
    }

    @Override
    public Pair<EnumCableConnectionType, Integer> getConnectionType(IRedstoneCable source, World world, BlockPos pos, EnumFacing dir, EnumCableConnectionType cableType) {
        return CableConnectionHelper.getCableConnection(source, world, pos, dir, EnumCableConnectionType.REDSTONE);
    }

    @Override
    public void onNetworksConnected(int newID, int oldID) {
        this.getNetwork(newID).markCablesChanged();
        this.getNetwork(oldID).markCablesChanged();
    }

    @Override
    public void onConnectionAdded(int registryID, IRedstoneCable added) {
        this.getOrCreateNetwork(registryID).markCablesChanged();
        this.markPowerForUpdate(registryID);
    }

    @Override
    public void onConnectionRemoved(int registryID, IRedstoneCable added) {
        this.getNetwork(registryID).markCablesChanged();
        this.markPowerForUpdate(registryID);
    }

    @Override
    public void onNetworksDisconnected(List<Integer> newNetworks) {
        for (int i : newNetworks) {
            IRedstoneNetwork network = this.getNetwork(i);
            network.markCablesChanged();
        }
    }

    @Override
    public void addConnectionToNetwork(IRedstoneCable add) {
        this.addConnection(add);
    }

    @Override
    public void removeConnectionFromNetwork(IRedstoneCable remove) {
        this.removeConnection(remove);
    }
}

