/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.connections.data.network;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import sonar.logistics.PL2;
import sonar.logistics.api.core.tiles.connections.data.network.ILogisticsNetwork;
import sonar.logistics.base.events.LogisticsEventHandler;
import sonar.logistics.base.events.NetworkChanges;
import sonar.logistics.base.tiles.INetworkTile;
import sonar.logistics.base.utils.CacheType;
import sonar.logistics.core.tiles.connections.data.network.CacheHandler;
import sonar.logistics.core.tiles.connections.data.network.EmptyLogisticsNetwork;
import sonar.logistics.core.tiles.connections.data.network.LogisticsNetwork;

public class LogisticsNetworkHandler {
    public Map<Integer, ILogisticsNetwork> cache = new ConcurrentHashMap<Integer, ILogisticsNetwork>();
    private int ID_COUNT;

    public static LogisticsNetworkHandler instance() {
        return PL2.proxy.networkManager;
    }

    public void removeAll() {
        this.ID_COUNT = 0;
        this.cache.clear();
    }

    public void tick() {
        if (this.cache.isEmpty()) {
            return;
        }
        Set<Map.Entry<Integer, ILogisticsNetwork>> entrySet = this.cache.entrySet();
        Iterator<Map.Entry<Integer, ILogisticsNetwork>> iterator = entrySet.iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, ILogisticsNetwork> entry = iterator.next();
            ILogisticsNetwork network = entry.getValue();
            if (!network.isValid()) {
                iterator.remove();
                continue;
            }
            network.onNetworkTick();
        }
    }

    public int getNextIdentity() {
        return this.ID_COUNT++;
    }

    public int getCurrentIdentity() {
        return this.ID_COUNT;
    }

    public int setIdentityCount(int count) {
        this.ID_COUNT = count;
        return this.ID_COUNT;
    }

    @Nonnull
    public ILogisticsNetwork getNetwork(int networkID) {
        ILogisticsNetwork networkCache = this.cache.get(networkID);
        return networkCache != null ? networkCache : EmptyLogisticsNetwork.INSTANCE;
    }

    public ILogisticsNetwork getOrCreateNetwork(int networkID) {
        if (networkID == -1) {
            return EmptyLogisticsNetwork.INSTANCE;
        }
        ILogisticsNetwork networkCache = this.cache.get(networkID);
        if (networkCache == null || !networkCache.isValid()) {
            LogisticsNetwork network = new LogisticsNetwork(networkID);
            network.onNetworkCreated();
            this.cache.put(networkID, network);
            networkCache = this.cache.get(networkID);
        }
        return networkCache;
    }

    public void connectNetworks(int oldID, int newID) {
        if (oldID != newID) {
            ILogisticsNetwork oldNet = this.cache.get(oldID);
            if (oldNet == null) {
                return;
            }
            ILogisticsNetwork newNet = this.getOrCreateNetwork(newID);
            List<INetworkTile> tiles = oldNet.getCachedTiles(CacheHandler.TILE, CacheType.LOCAL);
            oldNet.onNetworkRemoved();
            this.cache.remove(oldID);
            LogisticsEventHandler.instance().queueNetworkChange(newNet, NetworkChanges.LOCAL_CHANNELS, NetworkChanges.LOCAL_PROVIDERS);
        }
    }

    public Map<Integer, ILogisticsNetwork> getNetworkCache() {
        return this.cache;
    }
}

