/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.items.transceiver;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import sonar.core.api.utils.BlockCoords;
import sonar.core.common.item.SonarItem;
import sonar.core.helpers.FontHelper;
import sonar.logistics.api.core.tiles.wireless.transceivers.ITileTransceiver;

public class ItemWirelessItemTransceiver
extends SonarItem
implements ITileTransceiver {
    @Override
    public BlockCoords getCoords(ItemStack stack) {
        if (stack.func_77942_o()) {
            return BlockCoords.readFromNBT((NBTTagCompound)stack.func_77978_p().func_74775_l("coord"));
        }
        return null;
    }

    @Override
    public EnumFacing getDirection(ItemStack stack) {
        if (stack.func_77942_o()) {
            return EnumFacing.values()[stack.func_77978_p().func_74762_e("dir")];
        }
        return null;
    }

    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IBlockState state = world.func_180495_p(pos);
        Block target = state.func_177230_c();
        if (!world.field_72995_K) {
            ItemStack stack = player.func_184586_b(hand);
            NBTTagCompound tag = stack.func_77978_p();
            if (tag == null) {
                tag = new NBTTagCompound();
            }
            tag.func_74782_a("coord", (NBTBase)BlockCoords.writeToNBT((NBTTagCompound)new NBTTagCompound(), (BlockCoords)new BlockCoords(pos, world.field_73011_w.getDimension())));
            tag.func_74768_a("dir", facing.ordinal());
            tag.func_74778_a("targetName", target.func_149739_a());
            FontHelper.sendMessage((String)(stack.func_77942_o() ? "Overwritten Position" : "Saved Position"), (World)world, (EntityPlayer)player);
            stack.func_77982_d(tag);
        }
        return EnumActionResult.SUCCESS;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> list, ITooltipFlag par4) {
        super.func_77624_a(stack, world, list, par4);
        if (stack.func_77942_o()) {
            list.add("Block: " + TextFormatting.ITALIC + FontHelper.translate((String)(stack.func_77978_p().func_74779_i("targetName") + ".name")));
            list.add("Coords: " + TextFormatting.ITALIC + this.getCoords(stack).toString());
            list.add("Side: " + TextFormatting.ITALIC + this.getDirection(stack).name());
        }
    }
}

