/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.base.listeners;

import java.util.List;
import sonar.core.helpers.NBTHelper;
import sonar.core.helpers.SonarHelper;
import sonar.logistics.base.utils.Result;

public enum ListenerType {
    NEW_GUI_LISTENER(UpdateType.GUI, NBTHelper.SyncType.SAVE, 10),
    TEMPORARY_LISTENER(UpdateType.GUI, NBTHelper.SyncType.SAVE, 1),
    OLD_GUI_LISTENER(UpdateType.GUI, NBTHelper.SyncType.DEFAULT_SYNC, 0),
    NEW_DISPLAY_LISTENER(UpdateType.DISPLAY, NBTHelper.SyncType.SAVE, 10),
    OLD_DISPLAY_LISTENER(UpdateType.DISPLAY, NBTHelper.SyncType.DEFAULT_SYNC, 0),
    NEW_CHANNEL_LISTENER(UpdateType.CHANNEL, NBTHelper.SyncType.SAVE, 10),
    OLD_CHANNEL_LISTENER(UpdateType.CHANNEL, NBTHelper.SyncType.DEFAULT_SYNC, 0),
    NONE(UpdateType.NONE, NBTHelper.SyncType.NONE, 0);

    public static final List<ListenerType> ALL;
    private UpdateType updateType;
    private NBTHelper.SyncType syncType;
    public int order;

    private ListenerType(UpdateType updateType, NBTHelper.SyncType syncType, int order) {
        this.updateType = updateType;
        this.syncType = syncType;
    }

    public static Result canReplace(ListenerType toReplace, ListenerType type) {
        if (toReplace.getUpdateType() != type.getUpdateType()) {
            return Result.PASS;
        }
        return toReplace.order < type.order ? Result.SUCCESS : Result.FAIL;
    }

    public boolean shouldForceUpdate() {
        return this.getSyncType() == NBTHelper.SyncType.SAVE;
    }

    public boolean shouldSyncUpdate() {
        return this.getSyncType().isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.SAVE, NBTHelper.SyncType.DEFAULT_SYNC});
    }

    public boolean shouldForceUpdate(UpdateType type) {
        return this.canUpdateType(type) && this.shouldForceUpdate();
    }

    public boolean shouldSyncUpdate(UpdateType type) {
        return this.canUpdateType(type) && this.shouldSyncUpdate();
    }

    public boolean canUpdateType(UpdateType type) {
        return this.updateType == type;
    }

    public UpdateType getUpdateType() {
        return this.updateType;
    }

    public NBTHelper.SyncType getSyncType() {
        return this.syncType;
    }

    public boolean isType(ListenerType ... types) {
        for (ListenerType type : types) {
            if (type != this) continue;
            return true;
        }
        return false;
    }

    static {
        ALL = SonarHelper.convertArray((Object[])ListenerType.values());
    }

    public static enum UpdateType {
        GUI,
        DISPLAY,
        CHANNEL,
        NONE;

    }
}

