/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.base.filters.types;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.oredict.OreDictionary;
import sonar.core.client.gui.GuiSonar;
import sonar.core.helpers.FontHelper;
import sonar.core.helpers.NBTHelper;
import sonar.core.network.sync.SyncTagTypeList;
import sonar.logistics.api.asm.ASMFilter;
import sonar.logistics.api.core.tiles.nodes.TransferType;
import sonar.logistics.base.filters.IItemFilter;
import sonar.logistics.base.filters.types.BaseFilter;

@ASMFilter(id="oredict", modid="practicallogistics2")
public class OreDictFilter
extends BaseFilter
implements IItemFilter {
    public static final String id = "oredict";
    public SyncTagTypeList<String> oreDict = new SyncTagTypeList(8, 1);
    public ArrayList<Integer> ints;

    public OreDictFilter() {
        this.syncList.addPart(this.oreDict);
    }

    @Override
    public String getNodeID() {
        return id;
    }

    public List<String> getOreIDs() {
        return this.oreDict.objs;
    }

    public void addOreDict(String oreName) {
        for (String string : this.oreDict.getObjects()) {
            if (!string.equals(oreName)) continue;
            return;
        }
        this.oreDict.addObject((Object)oreName);
        this.ints = null;
    }

    public void removeOreDict(String oreName) {
        ArrayList<String> toRemove = new ArrayList<String>();
        for (String string : this.oreDict.getObjects()) {
            if (!string.equals(oreName)) continue;
            toRemove.add(string);
        }
        toRemove.forEach(remove -> this.oreDict.removeObject(remove));
        this.ints = null;
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        this.ints = null;
    }

    @Override
    public boolean canTransferItem(ItemStack stack) {
        if (this.oreDict != null && !this.oreDict.getObjects().isEmpty() && stack != null) {
            ArrayList<Integer> oreIDs = this.getOres();
            int[] names = OreDictionary.getOreIDs((ItemStack)stack);
            if (names.length != 0 && !oreIDs.isEmpty()) {
                int[] nArray = names;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    Integer id = nArray[i];
                    for (Integer oreName : oreIDs) {
                        if (!id.equals(oreName)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public ArrayList<Integer> getOres() {
        if (this.ints == null) {
            ArrayList<Integer> ores = new ArrayList<Integer>();
            for (String string : this.oreDict.objs) {
                int id = OreDictionary.getOreID((String)string);
                if (ores.contains(id)) continue;
                ores.add(id);
            }
            this.ints = ores;
        }
        return this.ints;
    }

    @Override
    public TransferType[] getTypes() {
        return new TransferType[]{TransferType.ITEMS};
    }

    @Override
    public void renderInfoInList(GuiSonar screen, int yPos) {
        GlStateManager.func_179139_a((double)0.75, (double)0.75, (double)0.75);
        FontHelper.text((String)"Ore Filter", (int)16, (int)((int)((double)(yPos + 2) * 1.3333333333333333)), (int)Color.white.getRGB());
        FontHelper.text((String)("Type: " + this.getTransferMode().name()), (int)88, (int)((int)((double)(yPos + 2) * 1.3333333333333333)), (int)Color.white.getRGB());
        FontHelper.text((String)("List Type: " + this.getListType().name()), (int)200, (int)((int)((double)(yPos + 2) * 1.3333333333333333)), (int)Color.white.getRGB());
        FontHelper.text((String)("Keys: " + FontHelper.getStringListToText((List)this.oreDict.objs)), (int)16, (int)((int)((double)(yPos + 14) * 1.3333333333333333)), (int)Color.white.getRGB());
        GlStateManager.func_179139_a((double)1.3333333333333333, (double)1.3333333333333333, (double)1.3333333333333333);
    }

    @Override
    public boolean isValidFilter() {
        return !this.oreDict.getObjects().isEmpty();
    }
}

