/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.base;

import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import sonar.logistics.api.base.IInfoManager;
import sonar.logistics.api.core.tiles.displays.info.IInfo;
import sonar.logistics.api.core.tiles.displays.info.InfoUUID;
import sonar.logistics.api.core.tiles.displays.info.lists.AbstractChangeableList;
import sonar.logistics.base.events.types.InfoEvent;
import sonar.logistics.base.listeners.ILogicListenable;
import sonar.logistics.base.utils.PL2AdditionType;
import sonar.logistics.base.utils.PL2RemovalType;
import sonar.logistics.core.tiles.displays.gsi.DisplayGSI;
import sonar.logistics.core.tiles.displays.tiles.connected.ConnectedDisplay;

public abstract class CommonInfoHandler
implements IInfoManager {
    public final Map<InfoUUID, IInfo> infoMap = new HashMap<InfoUUID, IInfo>();
    public final Map<Integer, DisplayGSI> gsiMap = new HashMap<Integer, DisplayGSI>();
    public final Map<Integer, ILogicListenable> identityTiles = new HashMap<Integer, ILogicListenable>();
    public final Map<Integer, ConnectedDisplay> connectedDisplays = new HashMap<Integer, ConnectedDisplay>();
    public final Map<InfoUUID, AbstractChangeableList> changeableLists = new HashMap<InfoUUID, AbstractChangeableList>();
    public final Side side;

    public CommonInfoHandler(Side side) {
        this.side = side;
    }

    public boolean isRemote() {
        return this.side.isClient();
    }

    @Override
    public void removeAll() {
        this.infoMap.clear();
        this.gsiMap.clear();
        this.identityTiles.clear();
        this.connectedDisplays.clear();
        this.changeableLists.clear();
    }

    @Override
    public void setInfo(InfoUUID uuid, IInfo newInfo) {
        this.infoMap.put(uuid, newInfo);
        MinecraftForge.EVENT_BUS.post((Event)new InfoEvent.InfoChanged(newInfo, uuid, this.isRemote()));
    }

    @Override
    public void addIdentityTile(ILogicListenable infoProvider, PL2AdditionType type) {
        this.identityTiles.put(infoProvider.getIdentity(), infoProvider);
    }

    @Override
    public void removeIdentityTile(ILogicListenable monitor, PL2RemovalType type) {
        ILogicListenable loaded = this.identityTiles.get(monitor.getIdentity());
        if (monitor == loaded) {
            this.identityTiles.remove(monitor.getIdentity());
        }
    }

    @Override
    public final Map<InfoUUID, IInfo> getInfoMap() {
        return this.infoMap;
    }

    @Override
    public final Map<Integer, DisplayGSI> getGSIMap() {
        return this.gsiMap;
    }

    @Override
    public final Map<Integer, ILogicListenable> getNetworkTileMap() {
        return this.identityTiles;
    }

    @Override
    public final Map<Integer, ConnectedDisplay> getConnectedDisplays() {
        return this.connectedDisplays;
    }

    @Override
    public final Map<InfoUUID, AbstractChangeableList> getChangeableListMap() {
        return this.changeableLists;
    }
}

