/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.api.core.tiles.displays.info.lists;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import sonar.logistics.api.core.tiles.displays.info.lists.IMonitoredValue;
import sonar.logistics.api.core.tiles.readers.ILogicListSorter;
import sonar.logistics.base.data.api.IData;

public abstract class AbstractChangeableList<T>
implements IData {
    public List<IMonitoredValue<T>> values = new ArrayList<IMonitoredValue<T>>();
    public boolean wasLastListNull = false;

    public List<IMonitoredValue<T>> getList() {
        return this.values;
    }

    public int getValueCount() {
        return this.values.size();
    }

    public T getActualValue(int i) {
        if (i < this.getValueCount()) {
            return this.values.get(i).getSaveableInfo();
        }
        return null;
    }

    public void add(T obj) {
        IMonitoredValue<T> found = this.find(obj);
        if (found == null) {
            this.values.add(this.createMonitoredValue(obj));
        } else {
            this.doCombine(found, obj);
        }
    }

    @Nullable
    public IMonitoredValue<T> find(T obj) {
        for (IMonitoredValue<T> value : this.values) {
            if (!value.canCombine(obj)) continue;
            return value;
        }
        return null;
    }

    public void saveStates() {
        ArrayList toDelete = new ArrayList();
        this.values.forEach(value -> {
            if (value.getChange().shouldDelete()) {
                toDelete.add(value);
            } else {
                value.resetChange();
            }
        });
        toDelete.forEach(value -> this.values.remove(value));
        this.wasLastListNull = this.values.isEmpty();
    }

    public void doCombine(IMonitoredValue<T> value, T obj) {
        value.combine(obj);
    }

    public List<T> createSaveableList() {
        ArrayList saveable = new ArrayList();
        this.values.forEach(value -> saveable.add(value.getSaveableInfo()));
        return saveable;
    }

    public List<T> createSaveableList(@Nullable ILogicListSorter sorter) {
        if (sorter != null && !this.values.isEmpty() && sorter.canSort(this.values.get(0))) {
            sorter.sortSaveableList(this);
        }
        return this.createSaveableList();
    }

    public abstract IMonitoredValue<T> createMonitoredValue(T var1);
}

