/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.client;

import com.feed_the_beast.ftblib.lib.icon.Color4I;
import com.feed_the_beast.ftblib.lib.icon.MutableColor4I;
import com.feed_the_beast.ftblib.lib.math.MathUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;

public class CachedVertexData {
    private final int mode;
    private final VertexFormat format;
    private final List<CachedVertex> list;
    private final boolean hasTex;
    private final boolean hasColor;
    private final boolean hasNormal;
    public final MutableColor4I color;
    public double minU = 0.0;
    public double minV = 0.0;
    public double maxU = 1.0;
    public double maxV = 1.0;

    private CachedVertexData(int m, VertexFormat f, Collection<CachedVertex> oldList) {
        this.mode = m;
        this.format = f;
        this.list = new ArrayList<CachedVertex>(oldList);
        this.hasTex = f.func_177347_a(0);
        this.hasColor = f.func_177346_d();
        this.hasNormal = f.func_177350_b();
        this.color = Color4I.WHITE.mutable();
    }

    public CachedVertexData(int m, VertexFormat f) {
        this(m, f, Collections.emptyList());
    }

    public void reset() {
        this.list.clear();
    }

    public CachedVertexData copy() {
        return new CachedVertexData(this.mode, this.format, this.list);
    }

    public CachedVertex pos(double x, double y, double z) {
        CachedVertex v = new CachedVertex(x, y, z);
        this.list.add(v);
        return v;
    }

    public CachedVertex pos(double x, double y) {
        return this.pos(x, y, 0.0);
    }

    public void draw(Tessellator tessellator, BufferBuilder buffer) {
        if (this.list.isEmpty()) {
            return;
        }
        buffer.func_181668_a(this.mode, this.format);
        for (CachedVertex v : this.list) {
            v.appendTo(buffer);
        }
        tessellator.func_78381_a();
    }

    public void rect(int x, int y, int w, int h) {
        this.pos(x, y + h, 0.0).tex(this.minU, this.maxV);
        this.pos(x + w, y + h, 0.0).tex(this.maxU, this.maxV);
        this.pos(x + w, y, 0.0).tex(this.maxU, this.minV);
        this.pos(x, y, 0.0).tex(this.minU, this.minV);
    }

    public void cubeFace(EnumFacing facing, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        float normalX = MathUtils.NORMALS_X[facing.func_176745_a()];
        float normalY = MathUtils.NORMALS_Y[facing.func_176745_a()];
        float normalZ = MathUtils.NORMALS_Z[facing.func_176745_a()];
        switch (facing) {
            case DOWN: {
                this.pos(minX, minY, minZ).tex(this.minU, this.minV).normal(normalX, normalY, normalZ);
                this.pos(maxX, minY, minZ).tex(this.maxU, this.minV).normal(normalX, normalY, normalZ);
                this.pos(maxX, minY, maxZ).tex(this.maxU, this.maxV).normal(normalX, normalY, normalZ);
                this.pos(minX, minY, maxZ).tex(this.minU, this.maxV).normal(normalX, normalY, normalZ);
                break;
            }
            case UP: {
                this.pos(minX, maxY, minZ).tex(this.minU, this.minV).normal(normalX, normalY, normalZ);
                this.pos(minX, maxY, maxZ).tex(this.minU, this.maxV).normal(normalX, normalY, normalZ);
                this.pos(maxX, maxY, maxZ).tex(this.maxU, this.maxV).normal(normalX, normalY, normalZ);
                this.pos(maxX, maxY, minZ).tex(this.maxU, this.minV).normal(normalX, normalY, normalZ);
                break;
            }
            case NORTH: {
                this.pos(minX, minY, minZ).tex(this.maxU, this.maxV).normal(normalX, normalY, normalZ);
                this.pos(minX, maxY, minZ).tex(this.maxU, this.minV).normal(normalX, normalY, normalZ);
                this.pos(maxX, maxY, minZ).tex(this.minU, this.minV).normal(normalX, normalY, normalZ);
                this.pos(maxX, minY, minZ).tex(this.minU, this.maxV).normal(normalX, normalY, normalZ);
                break;
            }
            case SOUTH: {
                this.pos(minX, minY, maxZ).tex(this.minU, this.maxV).normal(normalX, normalY, normalZ);
                this.pos(maxX, minY, maxZ).tex(this.maxU, this.maxV).normal(normalX, normalY, normalZ);
                this.pos(maxX, maxY, maxZ).tex(this.maxU, this.minV).normal(normalX, normalY, normalZ);
                this.pos(minX, maxY, maxZ).tex(this.minU, this.minV).normal(normalX, normalY, normalZ);
                break;
            }
            case WEST: {
                this.pos(minX, minY, minZ).tex(this.minU, this.maxV).normal(normalX, normalY, normalZ);
                this.pos(minX, minY, maxZ).tex(this.maxU, this.maxV).normal(normalX, normalY, normalZ);
                this.pos(minX, maxY, maxZ).tex(this.maxU, this.minV).normal(normalX, normalY, normalZ);
                this.pos(minX, maxY, minZ).tex(this.minU, this.minV).normal(normalX, normalY, normalZ);
                break;
            }
            case EAST: {
                this.pos(maxX, minY, minZ).tex(this.maxU, this.maxV).normal(normalX, normalY, normalZ);
                this.pos(maxX, maxY, minZ).tex(this.maxU, this.minV).normal(normalX, normalY, normalZ);
                this.pos(maxX, maxY, maxZ).tex(this.minU, this.minV).normal(normalX, normalY, normalZ);
                this.pos(maxX, minY, maxZ).tex(this.minU, this.maxV).normal(normalX, normalY, normalZ);
            }
        }
    }

    public void cube(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            this.cubeFace(facing, minX, minY, minZ, maxX, maxY, maxZ);
        }
    }

    public void cubeSides(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            if (facing.func_176740_k() == EnumFacing.Axis.Y) continue;
            this.cubeFace(facing, minX, minY, minZ, maxX, maxY, maxZ);
        }
    }

    public void centeredCube(double x, double y, double z, double rx, double ry, double rz) {
        this.cube(x - rx, y - ry, z - rz, x + rx, y + ry, z + rz);
    }

    public void centeredCube(double x, double y, double z, double r) {
        this.centeredCube(x, y, z, r, r, r);
    }

    public void cube(AxisAlignedBB aabb) {
        this.cube(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c, aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f);
    }

    public class CachedVertex {
        private final double x;
        private final double y;
        private final double z;
        private double u;
        private double v;
        private int r;
        private int g;
        private int b;
        private int a;
        private float nx;
        private float ny;
        private float nz;

        private CachedVertex(double _x, double _y, double _z) {
            this.r = CachedVertexData.this.color.redi();
            this.g = CachedVertexData.this.color.greeni();
            this.b = CachedVertexData.this.color.bluei();
            this.a = CachedVertexData.this.color.alphai();
            this.x = _x;
            this.y = _y;
            this.z = _z;
        }

        public CachedVertex tex(double _u, double _v) {
            this.u = _u;
            this.v = _v;
            return this;
        }

        public CachedVertex color(int _r, int _g, int _b, int _a) {
            this.r = _r;
            this.g = _g;
            this.b = _b;
            this.a = _a;
            return this;
        }

        public CachedVertex normal(float x, float y, float z) {
            this.nx = x;
            this.ny = y;
            this.nz = z;
            return this;
        }

        private void appendTo(BufferBuilder buffer) {
            buffer.func_181662_b(this.x, this.y, this.z);
            if (CachedVertexData.this.hasTex) {
                buffer.func_187315_a(this.u, this.v);
            }
            if (CachedVertexData.this.hasColor) {
                buffer.func_181669_b(this.r, this.g, this.b, this.a);
            }
            if (CachedVertexData.this.hasNormal) {
                buffer.func_181663_c(this.nx, this.ny, this.nz);
            }
            buffer.func_181675_d();
        }
    }
}

