/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.sprite;

import com.teamwizardry.librarianlib.features.sprite.ISprite;
import com.teamwizardry.librarianlib.features.sprite.Texture;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

@SideOnly(value=Side.CLIENT)
@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b!\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0005\b\u0017\u0018\u00002\u00020\u0001BG\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\u0005\u0012\u0006\u0010\f\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\rB\u000f\b\u0017\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\b\u00100\u001a\u000201H\u0016J&\u00102\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005JE\u00103\u001a\u0002012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b4J\u0010\u00105\u001a\u0002062\u0006\u00107\u001a\u00020\u0005H\u0016J\u0010\u00108\u001a\u0002062\u0006\u00107\u001a\u00020\u0005H\u0016J\u0010\u00109\u001a\u0002062\u0006\u00107\u001a\u00020\u0005H\u0016J\u0010\u0010:\u001a\u0002062\u0006\u00107\u001a\u00020\u0005H\u0016R\u0014\u0010\u0011\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\t\u001a\u00020\nX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\b\u001a\u00020\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0013\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u000b\u001a\u00020\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0013\"\u0004\b\u001c\u0010\u001aR\u001a\u0010\f\u001a\u00020\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0013\"\u0004\b\u001e\u0010\u001aR$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0003@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u0005@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u0013\"\u0004\b%\u0010\u001aR$\u0010&\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u0005@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\u0013\"\u0004\b(\u0010\u001aR$\u0010)\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u0005@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010\u0013\"\u0004\b+\u0010\u001aR$\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u0005@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\u0013\"\u0004\b-\u0010\u001aR\u001a\u0010\u0007\u001a\u00020\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010\u0013\"\u0004\b/\u0010\u001a\u00a8\u0006;"}, d2={"Lcom/teamwizardry/librarianlib/features/sprite/Sprite;", "Lcom/teamwizardry/librarianlib/features/sprite/ISprite;", "tex", "Lcom/teamwizardry/librarianlib/features/sprite/Texture;", "u", "", "v", "width", "height", "frames", "", "offsetU", "offsetV", "(Lcom/teamwizardry/librarianlib/features/sprite/Texture;IIII[III)V", "loc", "Lnet/minecraft/util/ResourceLocation;", "(Lnet/minecraft/util/ResourceLocation;)V", "frameCount", "getFrameCount", "()I", "getFrames", "()[I", "setFrames", "([I)V", "getHeight", "setHeight", "(I)V", "getOffsetU", "setOffsetU", "getOffsetV", "setOffsetV", "<set-?>", "getTex", "()Lcom/teamwizardry/librarianlib/features/sprite/Texture;", "setTex", "(Lcom/teamwizardry/librarianlib/features/sprite/Texture;)V", "getU", "setU", "uvHeight", "getUvHeight", "setUvHeight", "uvWidth", "getUvWidth", "setUvWidth", "getV", "setV", "getWidth", "setWidth", "bind", "", "getSubSprite", "init", "init$librarianlib_1_12_2", "maxU", "", "animFrames", "maxV", "minU", "minV", "librarianlib-1.12.2"})
public class Sprite
implements ISprite {
    @NotNull
    private Texture tex;
    private int u;
    private int v;
    private int uvWidth;
    private int uvHeight;
    @NotNull
    private int[] frames;
    private int offsetU;
    private int offsetV;
    private int width;
    private int height;

    @NotNull
    public final Texture getTex() {
        return this.tex;
    }

    protected final void setTex(@NotNull Texture texture) {
        Intrinsics.checkParameterIsNotNull((Object)texture, (String)"<set-?>");
        this.tex = texture;
    }

    public final int getU() {
        return this.u;
    }

    protected final void setU(int n) {
        this.u = n;
    }

    public final int getV() {
        return this.v;
    }

    protected final void setV(int n) {
        this.v = n;
    }

    public final int getUvWidth() {
        return this.uvWidth;
    }

    protected final void setUvWidth(int n) {
        this.uvWidth = n;
    }

    public final int getUvHeight() {
        return this.uvHeight;
    }

    protected final void setUvHeight(int n) {
        this.uvHeight = n;
    }

    @NotNull
    protected final int[] getFrames() {
        return this.frames;
    }

    protected final void setFrames(@NotNull int[] nArray) {
        Intrinsics.checkParameterIsNotNull((Object)nArray, (String)"<set-?>");
        this.frames = nArray;
    }

    protected final int getOffsetU() {
        return this.offsetU;
    }

    protected final void setOffsetU(int n) {
        this.offsetU = n;
    }

    protected final int getOffsetV() {
        return this.offsetV;
    }

    protected final void setOffsetV(int n) {
        this.offsetV = n;
    }

    @Override
    public int getFrameCount() {
        return this.frames.length;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public final void init$librarianlib_1_12_2(int u, int v, int width, int height, @NotNull int[] frames, int offsetU, int offsetV) {
        Intrinsics.checkParameterIsNotNull((Object)frames, (String)"frames");
        this.u = u;
        this.v = v;
        this.uvWidth = width;
        this.uvHeight = height;
        this.offsetU = offsetU;
        this.offsetV = offsetV;
        this.frames = frames;
    }

    @Override
    public float minU(int animFrames) {
        int[] nArray = this.frames;
        int n = this.offsetU;
        int n2 = this.u;
        boolean bl = nArray.length == 0;
        return (float)(n2 + n * (bl ? 0 : this.frames[animFrames % this.frames.length])) / (float)this.tex.getWidth();
    }

    @Override
    public float minV(int animFrames) {
        int[] nArray = this.frames;
        int n = this.offsetV;
        int n2 = this.v;
        boolean bl = nArray.length == 0;
        return (float)(n2 + n * (bl ? 0 : this.frames[animFrames % this.frames.length])) / (float)this.tex.getHeight();
    }

    @Override
    public float maxU(int animFrames) {
        int[] nArray = this.frames;
        int n = this.offsetU;
        int n2 = this.u + this.uvWidth;
        boolean bl = nArray.length == 0;
        return (float)(n2 + n * (bl ? 0 : this.frames[animFrames % this.frames.length])) / (float)this.tex.getWidth();
    }

    @Override
    public float maxV(int animFrames) {
        int[] nArray = this.frames;
        int n = this.offsetV;
        int n2 = this.v + this.uvHeight;
        boolean bl = nArray.length == 0;
        return (float)(n2 + n * (bl ? 0 : this.frames[animFrames % this.frames.length])) / (float)this.tex.getHeight();
    }

    @NotNull
    public final Sprite getSubSprite(int u, int v, int width, int height) {
        float uScale = (float)this.uvWidth / (float)this.getWidth();
        float vScale = (float)this.uvHeight / (float)this.getHeight();
        Sprite s = new Sprite(this.tex, this.u + (int)((float)u * uScale), this.v + (int)((float)v * vScale), (int)((float)width * uScale), (int)((float)height * vScale), this.frames, this.offsetU, this.offsetV);
        s.setWidth(width);
        s.setHeight(height);
        return s;
    }

    @Override
    public void bind() {
        this.tex.bind();
    }

    public Sprite(@NotNull Texture tex, int u, int v, int width, int height, @NotNull int[] frames, int offsetU, int offsetV) {
        Intrinsics.checkParameterIsNotNull((Object)tex, (String)"tex");
        Intrinsics.checkParameterIsNotNull((Object)frames, (String)"frames");
        this.frames = new int[0];
        this.width = 1;
        this.height = 1;
        this.tex = tex;
        this.init$librarianlib_1_12_2(u, v, width, height, frames, offsetU, offsetV);
    }

    public Sprite(@NotNull ResourceLocation loc) {
        Intrinsics.checkParameterIsNotNull((Object)loc, (String)"loc");
        this.frames = new int[0];
        this.width = 1;
        this.height = 1;
        this.tex = new Texture(loc);
        this.u = 0;
        this.v = 0;
        this.uvWidth = 16;
        this.uvHeight = 16;
        this.setWidth(16);
        this.setHeight(16);
        this.frames = new int[0];
    }

    @Override
    public float minU() {
        return ISprite.DefaultImpls.minU(this);
    }

    @Override
    public float minV() {
        return ISprite.DefaultImpls.minV(this);
    }

    @Override
    public float maxU() {
        return ISprite.DefaultImpls.maxU(this);
    }

    @Override
    public float maxV() {
        return ISprite.DefaultImpls.maxV(this);
    }

    @Override
    public void draw(int animTicks, float x, float y) {
        ISprite.DefaultImpls.draw(this, animTicks, x, y);
    }

    @Override
    public void draw(int animTicks, float x, float y, float width, float height) {
        ISprite.DefaultImpls.draw(this, animTicks, x, y, width, height);
    }

    @Override
    public void drawClipped(int animTicks, float x, float y, int width, int height, boolean reverseX, boolean reverseY) {
        ISprite.DefaultImpls.drawClipped(this, animTicks, x, y, width, height, reverseX, reverseY);
    }

    @Override
    public void drawClipped(int animTicks, float x, float y, int width, int height) {
        ISprite.DefaultImpls.drawClipped(this, animTicks, x, y, width, height);
    }

    @Override
    public int getInWidth() {
        return ISprite.DefaultImpls.getInWidth(this);
    }

    @Override
    public int getInHeight() {
        return ISprite.DefaultImpls.getInHeight(this);
    }
}

