/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.animator.animations;

import com.teamwizardry.librarianlib.features.animator.AnimatableProperty;
import com.teamwizardry.librarianlib.features.animator.Animation;
import com.teamwizardry.librarianlib.features.animator.Easing;
import com.teamwizardry.librarianlib.features.animator.Lerper;
import com.teamwizardry.librarianlib.features.animator.LerperHandler;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0017\b\u0016\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u001b\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0002X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u00020\u0002X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0012\"\u0004\b\u0019\u0010\u0014\u00a8\u0006\u001e"}, d2={"Lcom/teamwizardry/librarianlib/features/animator/animations/BasicAnimation;", "T", "", "Lcom/teamwizardry/librarianlib/features/animator/Animation;", "target", "property", "", "(Ljava/lang/Object;Ljava/lang/String;)V", "Lcom/teamwizardry/librarianlib/features/animator/AnimatableProperty;", "(Ljava/lang/Object;Lcom/teamwizardry/librarianlib/features/animator/AnimatableProperty;)V", "easing", "Lcom/teamwizardry/librarianlib/features/animator/Easing;", "getEasing", "()Lcom/teamwizardry/librarianlib/features/animator/Easing;", "setEasing", "(Lcom/teamwizardry/librarianlib/features/animator/Easing;)V", "from", "getFrom", "()Ljava/lang/Object;", "setFrom", "(Ljava/lang/Object;)V", "lerper", "Lcom/teamwizardry/librarianlib/features/animator/Lerper;", "to", "getTo", "setTo", "update", "", "time", "", "librarianlib-1.12.2"})
public final class BasicAnimation<T>
extends Animation<T> {
    @NotNull
    private Object from;
    @NotNull
    private Object to;
    @NotNull
    private Easing easing;
    private Lerper<Object> lerper;

    @NotNull
    public final Object getFrom() {
        return this.from;
    }

    public final void setFrom(@NotNull Object object) {
        Intrinsics.checkParameterIsNotNull((Object)object, (String)"<set-?>");
        this.from = object;
    }

    @NotNull
    public final Object getTo() {
        return this.to;
    }

    public final void setTo(@NotNull Object object) {
        Intrinsics.checkParameterIsNotNull((Object)object, (String)"<set-?>");
        this.to = object;
    }

    @NotNull
    public final Easing getEasing() {
        return this.easing;
    }

    public final void setEasing(@NotNull Easing easing) {
        Intrinsics.checkParameterIsNotNull((Object)easing, (String)"<set-?>");
        this.easing = easing;
    }

    @Override
    public void update(float time) {
        float progress2 = this.easing.invoke(this.timeFraction(time));
        Object object = this.lerper.lerp(this.from, this.to, progress2);
        this.getProperty().set(this.getTarget(), object);
    }

    public BasicAnimation(@NotNull T target, @NotNull AnimatableProperty<T> property) {
        Intrinsics.checkParameterIsNotNull(target, (String)"target");
        Intrinsics.checkParameterIsNotNull(property, (String)"property");
        super(target, property);
        this.from = property.get(target);
        this.to = property.get(target);
        this.easing = Easing.linear;
        this.lerper = LerperHandler.INSTANCE.getLerperOrError(property.getType());
    }

    public BasicAnimation(@NotNull T target, @NotNull String property) {
        Intrinsics.checkParameterIsNotNull(target, (String)"target");
        Intrinsics.checkParameterIsNotNull((Object)property, (String)"property");
        this(target, AnimatableProperty.Companion.get(target.getClass(), property));
    }
}

