/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.integration.jei.ritual;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.shinoow.abyssalcraft.api.APIUtils;
import com.shinoow.abyssalcraft.api.item.ACItems;
import com.shinoow.abyssalcraft.api.ritual.NecronomiconCreationRitual;
import com.shinoow.abyssalcraft.api.ritual.NecronomiconRitual;
import com.shinoow.abyssalcraft.api.ritual.RitualRegistry;
import com.shinoow.abyssalcraft.lib.NecronomiconText;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class RitualRecipeWrapper
implements IRecipeWrapper {
    private final Object[] offerings;
    private final Object sacrifice;
    private final ItemStack output;
    private final int bookType;
    private final NecronomiconRitual ritual;
    private Map<Integer, String> dimToString = Maps.newHashMap();

    public RitualRecipeWrapper(@Nonnull NecronomiconCreationRitual ritual) {
        if (ritual.getOfferings().length < 8) {
            this.offerings = new Object[8];
            for (int i = 0; i < ritual.getOfferings().length; ++i) {
                this.offerings[i] = ritual.getOfferings()[i];
            }
        } else {
            this.offerings = ritual.getOfferings();
        }
        this.sacrifice = ritual.getSacrifice();
        this.output = ritual.getItem();
        this.bookType = ritual.getBookType();
        this.ritual = ritual;
    }

    public Object[] getOfferings() {
        return this.offerings;
    }

    public Object getSacrifice() {
        return this.sacrifice;
    }

    public int getBookType() {
        return this.bookType;
    }

    public List<ItemStack> getOutputs() {
        return Collections.singletonList(this.output);
    }

    public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        this.dimToString.put(-1, I18n.func_135052_a((String)NecronomiconText.LABEL_ANYWHERE, (Object[])new Object[0]));
        this.dimToString.putAll(RitualRegistry.instance().getDimensionNameMappings());
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        boolean unicode = fr.func_82883_a();
        fr.func_78264_a(true);
        if (this.ritual.requiresSacrifice()) {
            fr.func_78276_b(I18n.func_135052_a((String)NecronomiconText.LABEL_SACRIFICE, (Object[])new Object[0]), 93, 124, 0xC40000);
        }
        fr.func_78279_b(I18n.func_135052_a((String)NecronomiconText.LABEL_LOCATION, (Object[])new Object[0]) + ": " + this.getDimension(this.ritual.getDimension()), 93, 85, 70, 0);
        fr.func_78279_b(I18n.func_135052_a((String)NecronomiconText.LABEL_REQUIRED_ENERGY, (Object[])new Object[0]) + ": " + this.ritual.getReqEnergy() + " PE", 93, 108, 70, 0);
        fr.func_78264_a(unicode);
    }

    private String getDimension(int dim) {
        if (!this.dimToString.containsKey(dim)) {
            this.dimToString.put(dim, "DIM" + dim);
        }
        return this.dimToString.get(dim);
    }

    private ItemStack getItem(int par1) {
        switch (par1) {
            case 0: {
                return new ItemStack(ACItems.necronomicon);
            }
            case 1: {
                return new ItemStack(ACItems.abyssal_wasteland_necronomicon);
            }
            case 2: {
                return new ItemStack(ACItems.dreadlands_necronomicon);
            }
            case 3: {
                return new ItemStack(ACItems.omothol_necronomicon);
            }
            case 4: {
                return new ItemStack(ACItems.abyssalnomicon);
            }
        }
        return new ItemStack(ACItems.necronomicon);
    }

    private boolean list(Object obj) {
        return obj == null ? false : obj instanceof ItemStack[] || obj instanceof String || obj instanceof List;
    }

    private List<ItemStack> getList(Object obj) {
        if (obj instanceof ItemStack[]) {
            return Lists.newArrayList((Object[])((ItemStack[])obj));
        }
        if (obj instanceof String) {
            return OreDictionary.getOres((String)((String)obj));
        }
        if (obj instanceof List) {
            return (List)obj;
        }
        return Collections.emptyList();
    }

    public void getIngredients(IIngredients ingredients) {
        ArrayList input = Lists.newArrayList();
        for (Object obj : this.offerings) {
            input.add(this.list(obj) ? this.getList(obj) : Collections.singletonList(APIUtils.convertToStack(obj)));
        }
        input.add(Collections.singletonList(APIUtils.convertToStack(this.sacrifice)));
        input.add(Collections.singletonList(this.getItem(this.bookType)));
        ingredients.setInputLists(ItemStack.class, (List)input);
        ingredients.setOutput(ItemStack.class, (Object)this.output);
    }
}

