/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.init;

import com.google.common.base.Predicate;
import com.google.gson.JsonObject;
import com.shinoow.abyssalcraft.api.AbyssalCraftAPI;
import com.shinoow.abyssalcraft.api.block.ACBlocks;
import com.shinoow.abyssalcraft.api.energy.structure.StructureHandler;
import com.shinoow.abyssalcraft.api.item.ACItems;
import com.shinoow.abyssalcraft.api.necronomicon.NecroData;
import com.shinoow.abyssalcraft.api.necronomicon.condition.ConditionProcessorRegistry;
import com.shinoow.abyssalcraft.api.necronomicon.condition.caps.INecroDataCapability;
import com.shinoow.abyssalcraft.api.necronomicon.condition.caps.NecroDataCapability;
import com.shinoow.abyssalcraft.api.necronomicon.condition.caps.NecroDataCapabilityStorage;
import com.shinoow.abyssalcraft.common.AbyssalCrafting;
import com.shinoow.abyssalcraft.common.caps.INecromancyCapability;
import com.shinoow.abyssalcraft.common.caps.NecromancyCapability;
import com.shinoow.abyssalcraft.common.caps.NecromancyCapabilityStorage;
import com.shinoow.abyssalcraft.common.enchantments.EnchantmentIronWall;
import com.shinoow.abyssalcraft.common.enchantments.EnchantmentLightPierce;
import com.shinoow.abyssalcraft.common.enchantments.EnchantmentWeaponInfusion;
import com.shinoow.abyssalcraft.common.handlers.CrystalFuelHandler;
import com.shinoow.abyssalcraft.common.handlers.FurnaceFuelHandler;
import com.shinoow.abyssalcraft.common.network.PacketDispatcher;
import com.shinoow.abyssalcraft.common.potion.PotionAntimatter;
import com.shinoow.abyssalcraft.common.potion.PotionCplague;
import com.shinoow.abyssalcraft.common.potion.PotionDplague;
import com.shinoow.abyssalcraft.common.structures.pe.BasicStructure;
import com.shinoow.abyssalcraft.common.util.ACLogger;
import com.shinoow.abyssalcraft.common.util.ShapedNBTRecipe;
import com.shinoow.abyssalcraft.init.BlockHandler;
import com.shinoow.abyssalcraft.init.ILifeCycleHandler;
import com.shinoow.abyssalcraft.init.InitHandler;
import com.shinoow.abyssalcraft.lib.ACConfig;
import com.shinoow.abyssalcraft.lib.ACLib;
import com.shinoow.abyssalcraft.lib.ACSounds;
import com.shinoow.abyssalcraft.lib.util.NecroDataJsonUtil;
import java.io.File;
import java.util.Stack;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityList;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionHelper;
import net.minecraft.potion.PotionType;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IFixType;
import net.minecraft.util.datafix.IFixableData;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.SetCount;
import net.minecraft.world.storage.loot.functions.SetMetadata;
import net.minecraftforge.common.DungeonHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.IFuelHandler;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;

public class MiscHandler
implements ILifeCycleHandler {
    public static PotionType Cplague_normal;
    public static PotionType Cplague_long;
    public static PotionType Dplague_normal;
    public static PotionType Dplague_long;
    public static PotionType Dplague_strong;
    public static PotionType antiMatter_normal;
    public static PotionType antiMatter_long;

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        AbyssalCraftAPI.coralium_plague = new PotionCplague(true, 65535).func_76399_b(1, 0).func_76390_b("potion.Cplague");
        AbyssalCraftAPI.dread_plague = new PotionDplague(true, 11342611).func_76399_b(1, 0).func_76390_b("potion.Dplague");
        AbyssalCraftAPI.antimatter_potion = new PotionAntimatter(true, 0xFFFFFF).func_76399_b(1, 0).func_76390_b("potion.Antimatter");
        MiscHandler.registerPotion(new ResourceLocation("abyssalcraft", "cplague"), AbyssalCraftAPI.coralium_plague);
        MiscHandler.registerPotion(new ResourceLocation("abyssalcraft", "dplague"), AbyssalCraftAPI.dread_plague);
        MiscHandler.registerPotion(new ResourceLocation("abyssalcraft", "antimatter"), AbyssalCraftAPI.antimatter_potion);
        Cplague_normal = new PotionType("Cplague", new PotionEffect[]{new PotionEffect(AbyssalCraftAPI.coralium_plague, 3600)});
        Cplague_long = new PotionType("Cplague", new PotionEffect[]{new PotionEffect(AbyssalCraftAPI.coralium_plague, 9600)});
        Dplague_normal = new PotionType("Dplague", new PotionEffect[]{new PotionEffect(AbyssalCraftAPI.dread_plague, 3600)});
        Dplague_long = new PotionType("Dplague", new PotionEffect[]{new PotionEffect(AbyssalCraftAPI.dread_plague, 9600)});
        Dplague_strong = new PotionType("Dplague", new PotionEffect[]{new PotionEffect(AbyssalCraftAPI.dread_plague, 432, 1)});
        antiMatter_normal = new PotionType("Antimatter", new PotionEffect[]{new PotionEffect(AbyssalCraftAPI.antimatter_potion, 3600)});
        antiMatter_long = new PotionType("Antimatter", new PotionEffect[]{new PotionEffect(AbyssalCraftAPI.antimatter_potion, 9600)});
        MiscHandler.registerPotionType(new ResourceLocation("abyssalcraft", "cplague"), Cplague_normal);
        MiscHandler.registerPotionType(new ResourceLocation("abyssalcraft", "cplague_long"), Cplague_long);
        MiscHandler.registerPotionType(new ResourceLocation("abyssalcraft", "dplague"), Dplague_normal);
        MiscHandler.registerPotionType(new ResourceLocation("abyssalcraft", "dplague_long"), Dplague_long);
        MiscHandler.registerPotionType(new ResourceLocation("abyssalcraft", "dplague_strong"), Dplague_strong);
        MiscHandler.registerPotionType(new ResourceLocation("abyssalcraft", "antimatter"), antiMatter_normal);
        MiscHandler.registerPotionType(new ResourceLocation("abyssalcraft", "antimatter_long"), antiMatter_long);
        this.addBrewing(PotionTypes.field_185233_e, ACItems.coralium_plagued_flesh, Cplague_normal);
        this.addBrewing(PotionTypes.field_185233_e, ACItems.coralium_plagued_flesh_on_a_bone, Cplague_normal);
        this.addBrewing(Cplague_normal, Items.field_151137_ax, Cplague_long);
        this.addBrewing(PotionTypes.field_185233_e, ACItems.dread_fragment, Dplague_normal);
        this.addBrewing(Dplague_normal, Items.field_151137_ax, Dplague_long);
        this.addBrewing(Dplague_normal, Items.field_151114_aO, Dplague_strong);
        this.addBrewing(PotionTypes.field_185233_e, ACItems.rotten_anti_flesh, antiMatter_normal);
        this.addBrewing(PotionTypes.field_185233_e, ACItems.anti_plagued_flesh, antiMatter_normal);
        this.addBrewing(PotionTypes.field_185233_e, ACItems.anti_plagued_flesh_on_a_bone, antiMatter_normal);
        this.addBrewing(antiMatter_normal, Items.field_151137_ax, antiMatter_long);
        AbyssalCraftAPI.coralium_enchantment = new EnchantmentWeaponInfusion("coralium");
        AbyssalCraftAPI.dread_enchantment = new EnchantmentWeaponInfusion("dread");
        AbyssalCraftAPI.light_pierce = new EnchantmentLightPierce();
        AbyssalCraftAPI.iron_wall = new EnchantmentIronWall();
        MiscHandler.registerEnchantment(new ResourceLocation("abyssalcraft", "coralium"), AbyssalCraftAPI.coralium_enchantment);
        MiscHandler.registerEnchantment(new ResourceLocation("abyssalcraft", "dread"), AbyssalCraftAPI.dread_enchantment);
        MiscHandler.registerEnchantment(new ResourceLocation("abyssalcraft", "light_pierce"), AbyssalCraftAPI.light_pierce);
        MiscHandler.registerEnchantment(new ResourceLocation("abyssalcraft", "iron_wall"), AbyssalCraftAPI.iron_wall);
        InitHandler.LIQUID_CORALIUM.setBlock(ACBlocks.liquid_coralium);
        InitHandler.LIQUID_ANTIMATTER.setBlock(ACBlocks.liquid_antimatter);
        if (AbyssalCraftAPI.liquid_coralium_fluid.getBlock() == null) {
            AbyssalCraftAPI.liquid_coralium_fluid.setBlock(ACBlocks.liquid_coralium);
        }
        if (AbyssalCraftAPI.liquid_antimatter_fluid.getBlock() == null) {
            AbyssalCraftAPI.liquid_antimatter_fluid.setBlock(ACBlocks.liquid_antimatter);
        }
        ACSounds.dreadguard_ambient = MiscHandler.registerSoundEvent("dreadguard.idle");
        ACSounds.dreadguard_hurt = MiscHandler.registerSoundEvent("dreadguard.hit");
        ACSounds.dreadguard_death = MiscHandler.registerSoundEvent("dreadguard.death");
        ACSounds.ghoul_normal_ambient = MiscHandler.registerSoundEvent("ghoul.normal.idle");
        ACSounds.ghoul_hurt = MiscHandler.registerSoundEvent("ghoul.hit");
        ACSounds.ghoul_death = MiscHandler.registerSoundEvent("ghoul.death");
        ACSounds.ghoul_pete_ambient = MiscHandler.registerSoundEvent("ghoul.pete.idle");
        ACSounds.ghoul_wilson_ambient = MiscHandler.registerSoundEvent("ghoul.wilson.idle");
        ACSounds.ghoul_orange_ambient = MiscHandler.registerSoundEvent("ghoul.orange.idle");
        ACSounds.golem_death = MiscHandler.registerSoundEvent("golem.death");
        ACSounds.golem_hurt = MiscHandler.registerSoundEvent("golem.hit");
        ACSounds.golem_ambient = MiscHandler.registerSoundEvent("golem.idle");
        ACSounds.sacthoth_death = MiscHandler.registerSoundEvent("sacthoth.death");
        ACSounds.shadow_death = MiscHandler.registerSoundEvent("shadow.death");
        ACSounds.shadow_hurt = MiscHandler.registerSoundEvent("shadow.hit");
        ACSounds.remnant_scream = MiscHandler.registerSoundEvent("remnant.scream");
        ACSounds.remnant_yes = MiscHandler.registerSoundEvent("remnant.yes");
        ACSounds.remnant_no = MiscHandler.registerSoundEvent("remnant.no");
        ACSounds.remnant_priest_chant = MiscHandler.registerSoundEvent("remnant.priest.chant");
        ACSounds.shoggoth_ambient = MiscHandler.registerSoundEvent("shoggoth.idle");
        ACSounds.shoggoth_hurt = MiscHandler.registerSoundEvent("shoggoth.hit");
        ACSounds.shoggoth_death = MiscHandler.registerSoundEvent("shoggoth.death");
        ACSounds.jzahar_charge = MiscHandler.registerSoundEvent("jzahar.charge");
        ACSounds.cthulhu_chant = MiscHandler.registerSoundEvent("chant.cthulhu");
        ACSounds.yog_sothoth_chant_1 = MiscHandler.registerSoundEvent("chant.yog_sothoth_1");
        ACSounds.yog_sothoth_chant_2 = MiscHandler.registerSoundEvent("chant.yog_sothoth_2");
        ACSounds.hastur_chant_1 = MiscHandler.registerSoundEvent("chant.hastur_1");
        ACSounds.hastur_chant_2 = MiscHandler.registerSoundEvent("chant.hastur_2");
        ACSounds.sleeping_chant = MiscHandler.registerSoundEvent("chant.sleeping");
        ACSounds.cthugha_chant = MiscHandler.registerSoundEvent("chant.cthugha");
        ACSounds.dread_spawn_ambient = MiscHandler.registerSoundEvent("dreadspawn.idle");
        ACSounds.dread_spawn_hurt = MiscHandler.registerSoundEvent("dreadspawn.hit");
        ACSounds.dread_spawn_death = MiscHandler.registerSoundEvent("dreadspawn.death");
        ACSounds.abyssal_zombie_ambient = MiscHandler.registerSoundEvent("abyssalzombie.idle");
        ACSounds.abyssal_zombie_hurt = MiscHandler.registerSoundEvent("abyssalzombie.hit");
        ACSounds.abyssal_zombie_death = MiscHandler.registerSoundEvent("abyssalzombie.death");
        ACSounds.antiplayer_hurt = MiscHandler.registerSoundEvent("antiplayer.hurt");
        ACSounds.dreadguard_barf = MiscHandler.registerSoundEvent("dreadguard.barf");
        ACSounds.jzahar_blast = MiscHandler.registerSoundEvent("jzahar.blast");
        ACSounds.jzahar_shout = MiscHandler.registerSoundEvent("jzahar.shout");
        ACSounds.jzahar_earthquake = MiscHandler.registerSoundEvent("jzahar.earthquake");
        ACSounds.jzahar_implosion = MiscHandler.registerSoundEvent("jzahar.implosion");
        ACSounds.jzahar_black_hole = MiscHandler.registerSoundEvent("jzahar.black_hole");
        CapabilityManager.INSTANCE.register(INecroDataCapability.class, NecroDataCapabilityStorage.instance, NecroDataCapability::new);
        CapabilityManager.INSTANCE.register(INecromancyCapability.class, NecromancyCapabilityStorage.instance, NecromancyCapability::new);
        ConditionProcessorRegistry.instance().registerProcessor(0, (condition, cap, player) -> cap.getBiomeTriggers().contains(condition.getConditionObject()));
        ConditionProcessorRegistry.instance().registerProcessor(1, (condition, cap, player) -> cap.getEntityTriggers().contains(condition.getConditionObject()));
        ConditionProcessorRegistry.instance().registerProcessor(2, (condition, cap, player) -> cap.getDimensionTriggers().contains(condition.getConditionObject()));
        ConditionProcessorRegistry.instance().registerProcessor(3, (condition, cap, player) -> {
            for (String name : (String[])condition.getConditionObject()) {
                if (!cap.getBiomeTriggers().contains(name)) continue;
                return true;
            }
            return false;
        });
        ConditionProcessorRegistry.instance().registerProcessor(4, (condition, cap, player) -> {
            for (String name : (String[])condition.getConditionObject()) {
                if (!cap.getEntityTriggers().contains(name)) continue;
                return true;
            }
            return false;
        });
        ConditionProcessorRegistry.instance().registerProcessor(5, (condition, cap, player) -> {
            for (String name : cap.getBiomeTriggers()) {
                if (!((Predicate)condition.getConditionObject()).apply((Object)ForgeRegistries.BIOMES.getValue(new ResourceLocation(name)))) continue;
                return true;
            }
            return false;
        });
        ConditionProcessorRegistry.instance().registerProcessor(6, (condition, cap, player) -> {
            for (String name : cap.getEntityTriggers()) {
                if (!((Predicate)condition.getConditionObject()).apply((Object)EntityList.getClass((ResourceLocation)new ResourceLocation(name)))) continue;
                return true;
            }
            return false;
        });
        ConditionProcessorRegistry.instance().registerProcessor(7, (condition, cap, player) -> cap.getArtifactTriggers().contains(condition.getConditionObject()));
        ConditionProcessorRegistry.instance().registerProcessor(8, (condition, cap, player) -> cap.getPageTriggers().contains(condition.getConditionObject()));
        ConditionProcessorRegistry.instance().registerProcessor(9, (condition, cap, player) -> cap.getWhisperTriggers().contains(condition.getConditionObject()));
        ConditionProcessorRegistry.instance().registerProcessor(10, (condition, cap, player) -> cap.getMiscTriggers().contains(condition.getConditionObject()));
        this.addDungeonHooks();
        this.sendIMC();
        PacketDispatcher.registerPackets();
    }

    @Override
    public void init(FMLInitializationEvent event) {
        GameRegistry.registerFuelHandler((IFuelHandler)new FurnaceFuelHandler());
        AbyssalCraftAPI.registerFuelHandler(new CrystalFuelHandler(), AbyssalCraftAPI.FuelType.CRYSTALLIZER);
        AbyssalCraftAPI.registerFuelHandler(new CrystalFuelHandler(), AbyssalCraftAPI.FuelType.TRANSMUTATOR);
        AbyssalCrafting.addRecipes();
        AbyssalCraftAPI.addGhoulArmorTextures((Item)Items.field_151024_Q, (Item)Items.field_151027_R, (Item)Items.field_151026_S, (Item)Items.field_151021_T, "abyssalcraft:textures/armor/ghoul/leather_1.png", "abyssalcraft:textures/armor/ghoul/leather_2.png");
        AbyssalCraftAPI.addGhoulArmorTextures((Item)Items.field_151020_U, (Item)Items.field_151023_V, (Item)Items.field_151022_W, (Item)Items.field_151029_X, "abyssalcraft:textures/armor/ghoul/chainmail_1.png", "abyssalcraft:textures/armor/ghoul/chainmail_2.png");
        AbyssalCraftAPI.addGhoulArmorTextures((Item)Items.field_151028_Y, (Item)Items.field_151030_Z, (Item)Items.field_151165_aa, (Item)Items.field_151167_ab, "abyssalcraft:textures/armor/ghoul/iron_1.png", "abyssalcraft:textures/armor/ghoul/iron_2.png");
        AbyssalCraftAPI.addGhoulArmorTextures((Item)Items.field_151169_ag, (Item)Items.field_151171_ah, (Item)Items.field_151149_ai, (Item)Items.field_151151_aj, "abyssalcraft:textures/armor/ghoul/gold_1.png", "abyssalcraft:textures/armor/ghoul/gold_2.png");
        AbyssalCraftAPI.addGhoulArmorTextures((Item)Items.field_151161_ac, (Item)Items.field_151163_ad, (Item)Items.field_151173_ae, (Item)Items.field_151175_af, "abyssalcraft:textures/armor/ghoul/diamond_1.png", "abyssalcraft:textures/armor/ghoul/diamond_2.png");
        AbyssalCraftAPI.addGhoulArmorTextures(ACItems.abyssalnite_helmet, ACItems.abyssalnite_chestplate, ACItems.abyssalnite_leggings, ACItems.abyssalnite_boots, "abyssalcraft:textures/armor/ghoul/abyssalnite_1.png", "abyssalcraft:textures/armor/ghoul/abyssalnite_2.png");
        AbyssalCraftAPI.addGhoulArmorTextures(ACItems.refined_coralium_helmet, ACItems.refined_coralium_chestplate, ACItems.refined_coralium_leggings, ACItems.refined_coralium_boots, "abyssalcraft:textures/armor/ghoul/coralium_1.png", "abyssalcraft:textures/armor/ghoul/coralium_2.png");
        AbyssalCraftAPI.addGhoulArmorTextures(ACItems.dreadium_helmet, ACItems.dreadium_chestplate, ACItems.dreadium_leggings, ACItems.dreadium_boots, "abyssalcraft:textures/armor/ghoul/dreadium_1.png", "abyssalcraft:textures/armor/ghoul/dreadium_2.png");
        AbyssalCraftAPI.addGhoulArmorTextures(ACItems.ethaxium_helmet, ACItems.ethaxium_chestplate, ACItems.ethaxium_leggings, ACItems.ethaxium_boots, "abyssalcraft:textures/armor/ghoul/ethaxium_1.png", "abyssalcraft:textures/armor/ghoul/ethaxium_2.png");
        AbyssalCraftAPI.addGhoulArmorTextures(ACItems.dreaded_abyssalnite_helmet, ACItems.dreaded_abyssalnite_chestplate, ACItems.dreaded_abyssalnite_leggings, ACItems.dreaded_abyssalnite_boots, "abyssalcraft:textures/armor/ghoul/dread_1.png", "abyssalcraft:textures/armor/ghoul/dread_2.png");
        AbyssalCraftAPI.addGhoulArmorTextures(ACItems.depths_helmet, ACItems.depths_chestplate, ACItems.depths_leggings, ACItems.depths_boots, "abyssalcraft:textures/armor/ghoul/depths_1.png", "abyssalcraft:textures/armor/ghoul/depths_2.png");
        AbyssalCraftAPI.addGhoulArmorTextures(ACItems.plated_coralium_helmet, ACItems.plated_coralium_chestplate, ACItems.plated_coralium_leggings, ACItems.plated_coralium_boots, "abyssalcraft:textures/armor/ghoul/coraliump_1.png", "abyssalcraft:textures/armor/ghoul/coraliump_2.png");
        AbyssalCraftAPI.addGhoulArmorTextures(ACItems.dreadium_samurai_helmet, ACItems.dreadium_samurai_chestplate, ACItems.dreadium_samurai_leggings, ACItems.dreadium_samurai_boots, "abyssalcraft:textures/armor/ghoul/dreadiums_1.png", "abyssalcraft:textures/armor/ghoul/dreadiums_2.png");
        AbyssalCraftAPI.getInternalNDHandler().registerInternalPages();
        StructureHandler.instance().registerStructure(new BasicStructure());
        FMLCommonHandler.instance().getDataFixer().init("abyssalcraft", 1).registerFix((IFixType)FixTypes.BLOCK_ENTITY, new IFixableData(){

            public int func_188216_a() {
                return 1;
            }

            public NBTTagCompound func_188217_a(NBTTagCompound compound) {
                String id;
                switch (id = compound.func_74779_i("id")) {
                    case "minecraft:tileentitycrate": 
                    case "minecraft:tileentitydghead": 
                    case "minecraft:tileentityphead": 
                    case "minecraft:tileentitywhead": 
                    case "minecraft:tileentityohead": 
                    case "minecraft:tileentitycrystallizer": 
                    case "minecraft:tileentitytransmutator": 
                    case "minecraft:tileentitydradguardspawner": 
                    case "minecraft:tileentitychagarothspawner": 
                    case "minecraft:tileentityengraver": 
                    case "minecraft:tileentitymaterializer": 
                    case "minecraft:tileentityritualaltar": 
                    case "minecraft:tileentityritualpedestal": 
                    case "minecraft:tileentitystatue": 
                    case "minecraft:tileentitydecorativestatue": 
                    case "minecraft:tileentityshoggothbiomass": 
                    case "minecraft:tileentityenergypedestal": 
                    case "minecraft:tileentitysacrificialaltar": 
                    case "minecraft:tileentitytieredenergypedestal": 
                    case "minecraft:tileentitytieredsacrificialaltar": 
                    case "minecraft:tileentityjzaharspawner": 
                    case "minecraft:tileentitygatekeeperminionspawner": 
                    case "minecraft:tileentityenergycollector": 
                    case "minecraft:tileentityenergyrelay": 
                    case "minecraft:tileentityenergycontainer": 
                    case "minecraft:tileentitytieredenergycollector": 
                    case "minecraft:tileentitytieredenergyrelay": 
                    case "minecraft:tileentitytieredenergycontainer": 
                    case "minecraft:tileentityrendingpedestal": 
                    case "minecraft:tileentitystatetransformer": 
                    case "minecraft:tileentityenergydepositioner": {
                        compound.func_74778_a("id", id.replace("minecraft", "abyssalcraft"));
                    }
                }
                return compound;
            }
        });
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        File folder = new File("config/abyssalcraft/");
        folder.mkdirs();
        Stack<File> folders = new Stack<File>();
        folders.add(folder);
        while (!folders.isEmpty()) {
            File dir = (File)folders.pop();
            File[] listOfFiles = dir.listFiles();
            for (File file : listOfFiles != null ? listOfFiles : new File[]{}) {
                JsonObject json;
                if (!file.isFile() || (json = NecroDataJsonUtil.readNecroDataJsonFromFile(file)) == null) continue;
                NecroData nd = NecroDataJsonUtil.deserializeNecroData(json);
                int book = NecroDataJsonUtil.getInteger(json, "booktype");
                if (nd == null) continue;
                ACLogger.info("Successfully deserialized JSON file for NecroData %s", nd.getIdentifier());
                AbyssalCraftAPI.registerNecronomiconData(nd, book);
            }
        }
    }

    @Override
    public void loadComplete(FMLLoadCompleteEvent event) {
    }

    static void addOreDictionaryStuff() {
        OreDictionary.registerOre((String)"ingotAbyssalnite", (Item)ACItems.abyssalnite_ingot);
        OreDictionary.registerOre((String)"ingotLiquifiedCoralium", (Item)ACItems.refined_coralium_ingot);
        OreDictionary.registerOre((String)"gemCoralium", (Item)ACItems.coralium_gem);
        OreDictionary.registerOre((String)"oreAbyssalnite", (Block)ACBlocks.abyssalnite_ore);
        OreDictionary.registerOre((String)"oreCoralium", (Block)ACBlocks.coralium_ore);
        OreDictionary.registerOre((String)"oreCoralium", (Block)ACBlocks.abyssal_coralium_ore);
        OreDictionary.registerOre((String)"oreDreadedAbyssalnite", (Block)ACBlocks.dreaded_abyssalnite_ore);
        OreDictionary.registerOre((String)"oreAbyssalnite", (Block)ACBlocks.dreadlands_abyssalnite_ore);
        OreDictionary.registerOre((String)"oreCoraliumStone", (Block)ACBlocks.coralium_infused_stone);
        OreDictionary.registerOre((String)"gemShadow", (Item)ACItems.shadow_gem);
        OreDictionary.registerOre((String)"liquidCoralium", (Block)ACBlocks.liquid_coralium);
        OreDictionary.registerOre((String)"materialCoraliumPearl", (Item)ACItems.coralium_pearl);
        OreDictionary.registerOre((String)"liquidAntimatter", (Block)ACBlocks.liquid_antimatter);
        OreDictionary.registerOre((String)"logWood", (Block)ACBlocks.darklands_oak_wood);
        OreDictionary.registerOre((String)"logWood", (Block)ACBlocks.dreadlands_log);
        OreDictionary.registerOre((String)"plankWood", (Block)ACBlocks.darklands_oak_planks);
        OreDictionary.registerOre((String)"plankWood", (Block)ACBlocks.dreadlands_planks);
        if (ACConfig.darklands_oak_slab) {
            OreDictionary.registerOre((String)"slabWood", (Block)ACBlocks.darklands_oak_slab);
        }
        OreDictionary.registerOre((String)"fenceWood", (Block)ACBlocks.darklands_oak_fence);
        OreDictionary.registerOre((String)"fenceWood", (Block)ACBlocks.dreadlands_wood_fence);
        if (ACConfig.darklands_oak_stairs) {
            OreDictionary.registerOre((String)"stairWood", (Block)ACBlocks.darklands_oak_stairs);
        }
        OreDictionary.registerOre((String)"doorWood", (Item)ACItems.darklands_oak_door);
        OreDictionary.registerOre((String)"doorWood", (Item)ACItems.dreadlands_door);
        OreDictionary.registerOre((String)"treeSapling", (Block)ACBlocks.darklands_oak_sapling);
        OreDictionary.registerOre((String)"treeSapling", (Block)ACBlocks.dreadlands_sapling);
        OreDictionary.registerOre((String)"treeLeaves", (Block)ACBlocks.darklands_oak_leaves);
        OreDictionary.registerOre((String)"treeLeaves", (Block)ACBlocks.dreadlands_leaves);
        OreDictionary.registerOre((String)"blockAbyssalnite", (ItemStack)new ItemStack(ACBlocks.ingot_block, 1, 0));
        OreDictionary.registerOre((String)"blockLiquifiedCoralium", (ItemStack)new ItemStack(ACBlocks.ingot_block, 1, 1));
        OreDictionary.registerOre((String)"blockDreadium", (ItemStack)new ItemStack(ACBlocks.ingot_block, 1, 2));
        OreDictionary.registerOre((String)"ingotCoraliumBrick", (Item)ACItems.coralium_brick);
        OreDictionary.registerOre((String)"ingotDreadium", (Item)ACItems.dreadium_ingot);
        OreDictionary.registerOre((String)"dustSulfur", (Item)ACItems.sulfur);
        OreDictionary.registerOre((String)"dustSaltpeter", (Item)ACItems.nitre);
        OreDictionary.registerOre((String)"materialMethane", (Item)ACItems.methane);
        OreDictionary.registerOre((String)"oreSaltpeter", (Block)ACBlocks.nitre_ore);
        OreDictionary.registerOre((String)"crystalIron", (ItemStack)new ItemStack(ACItems.crystal, 1, 0));
        OreDictionary.registerOre((String)"crystalGold", (ItemStack)new ItemStack(ACItems.crystal, 1, 1));
        OreDictionary.registerOre((String)"crystalSulfur", (ItemStack)new ItemStack(ACItems.crystal, 1, 2));
        OreDictionary.registerOre((String)"crystalCarbon", (ItemStack)new ItemStack(ACItems.crystal, 1, 3));
        OreDictionary.registerOre((String)"crystalOxygen", (ItemStack)new ItemStack(ACItems.crystal, 1, 4));
        OreDictionary.registerOre((String)"crystalHydrogen", (ItemStack)new ItemStack(ACItems.crystal, 1, 5));
        OreDictionary.registerOre((String)"crystalNitrogen", (ItemStack)new ItemStack(ACItems.crystal, 1, 6));
        OreDictionary.registerOre((String)"crystalPhosphorus", (ItemStack)new ItemStack(ACItems.crystal, 1, 7));
        OreDictionary.registerOre((String)"crystalPotassium", (ItemStack)new ItemStack(ACItems.crystal, 1, 8));
        OreDictionary.registerOre((String)"crystalNitrate", (ItemStack)new ItemStack(ACItems.crystal, 1, 9));
        OreDictionary.registerOre((String)"crystalMethane", (ItemStack)new ItemStack(ACItems.crystal, 1, 10));
        OreDictionary.registerOre((String)"crystalRedstone", (ItemStack)new ItemStack(ACItems.crystal, 1, 11));
        OreDictionary.registerOre((String)"crystalAbyssalnite", (ItemStack)new ItemStack(ACItems.crystal, 1, 12));
        OreDictionary.registerOre((String)"crystalCoralium", (ItemStack)new ItemStack(ACItems.crystal, 1, 13));
        OreDictionary.registerOre((String)"crystalDreadium", (ItemStack)new ItemStack(ACItems.crystal, 1, 14));
        OreDictionary.registerOre((String)"crystalBlaze", (ItemStack)new ItemStack(ACItems.crystal, 1, 15));
        OreDictionary.registerOre((String)"crystalTin", (ItemStack)new ItemStack(ACItems.crystal, 1, 16));
        OreDictionary.registerOre((String)"crystalCopper", (ItemStack)new ItemStack(ACItems.crystal, 1, 17));
        OreDictionary.registerOre((String)"crystalSilicon", (ItemStack)new ItemStack(ACItems.crystal, 1, 18));
        OreDictionary.registerOre((String)"crystalMagnesium", (ItemStack)new ItemStack(ACItems.crystal, 1, 19));
        OreDictionary.registerOre((String)"crystalAluminium", (ItemStack)new ItemStack(ACItems.crystal, 1, 20));
        OreDictionary.registerOre((String)"crystalSilica", (ItemStack)new ItemStack(ACItems.crystal, 1, 21));
        OreDictionary.registerOre((String)"crystalAlumina", (ItemStack)new ItemStack(ACItems.crystal, 1, 22));
        OreDictionary.registerOre((String)"crystalMagnesia", (ItemStack)new ItemStack(ACItems.crystal, 1, 23));
        OreDictionary.registerOre((String)"crystalZinc", (ItemStack)new ItemStack(ACItems.crystal, 1, 24));
        OreDictionary.registerOre((String)"foodFriedEgg", (Item)ACItems.fried_egg);
        OreDictionary.registerOre((String)"oreIron", (Block)ACBlocks.abyssal_iron_ore);
        OreDictionary.registerOre((String)"oreGold", (Block)ACBlocks.abyssal_gold_ore);
        OreDictionary.registerOre((String)"oreDiamond", (Block)ACBlocks.abyssal_diamond_ore);
        OreDictionary.registerOre((String)"oreSaltpeter", (Block)ACBlocks.abyssal_nitre_ore);
        OreDictionary.registerOre((String)"oreTin", (Block)ACBlocks.abyssal_tin_ore);
        OreDictionary.registerOre((String)"oreCopper", (Block)ACBlocks.abyssal_copper_ore);
        OreDictionary.registerOre((String)"ingotTin", (Item)ACItems.tin_ingot);
        OreDictionary.registerOre((String)"ingotCopper", (Item)ACItems.copper_ingot);
        OreDictionary.registerOre((String)"orePearlescentCoralium", (Block)ACBlocks.pearlescent_coralium_ore);
        OreDictionary.registerOre((String)"oreLiquifiedCoralium", (Block)ACBlocks.liquified_coralium_ore);
        OreDictionary.registerOre((String)"ingotEthaxiumBrick", (Item)ACItems.ethaxium_brick);
        OreDictionary.registerOre((String)"ingotEthaxium", (Item)ACItems.ethaxium_ingot);
        OreDictionary.registerOre((String)"blockEthaxium", (ItemStack)new ItemStack(ACBlocks.ingot_block, 1, 3));
        OreDictionary.registerOre((String)"nuggetAbyssalnite", (ItemStack)new ItemStack(ACItems.ingot_nugget, 1, 0));
        OreDictionary.registerOre((String)"nuggetLiquifiedCoralium", (ItemStack)new ItemStack(ACItems.ingot_nugget, 1, 1));
        OreDictionary.registerOre((String)"nuggetDreadium", (ItemStack)new ItemStack(ACItems.ingot_nugget, 1, 2));
        OreDictionary.registerOre((String)"nuggetEthaxium", (ItemStack)new ItemStack(ACItems.ingot_nugget, 1, 3));
        OreDictionary.registerOre((String)"crystalShardIron", (ItemStack)new ItemStack(ACItems.crystal_shard, 1, 0));
        OreDictionary.registerOre((String)"crystalShardGold", (ItemStack)new ItemStack(ACItems.crystal_shard, 1, 1));
        OreDictionary.registerOre((String)"crystalShardSulfur", (ItemStack)new ItemStack(ACItems.crystal_shard, 1, 2));
        OreDictionary.registerOre((String)"crystalShardCarbon", (ItemStack)new ItemStack(ACItems.crystal_shard, 1, 3));
        OreDictionary.registerOre((String)"crystalShardOxygen", (ItemStack)new ItemStack(ACItems.crystal_shard, 1, 4));
        OreDictionary.registerOre((String)"crystalShardHydrogen", (ItemStack)new ItemStack(ACItems.crystal_shard, 1, 5));
        OreDictionary.registerOre((String)"crystalShardNitrogen", (ItemStack)new ItemStack(ACItems.crystal_shard, 1, 6));
        OreDictionary.registerOre((String)"crystalShardPhosphorus", (ItemStack)new ItemStack(ACItems.crystal_shard, 1, 7));
        OreDictionary.registerOre((String)"crystalShardPotassium", (ItemStack)new ItemStack(ACItems.crystal_shard, 1, 8));
        OreDictionary.registerOre((String)"crystalShardNitrate", (ItemStack)new ItemStack(ACItems.crystal_shard, 1, 9));
        OreDictionary.registerOre((String)"crystalShardMethane", (ItemStack)new ItemStack(ACItems.crystal_shard, 1, 10));
        OreDictionary.registerOre((String)"crystalShardRedstone", (ItemStack)new ItemStack(ACItems.crystal_shard, 1, 11));
        OreDictionary.registerOre((String)"crystalShardAbyssalnite", (ItemStack)new ItemStack(ACItems.crystal_shard, 1, 12));
        OreDictionary.registerOre((String)"crystalShardCoralium", (ItemStack)new ItemStack(ACItems.crystal_shard, 1, 13));
        OreDictionary.registerOre((String)"crystalShardDreadium", (ItemStack)new ItemStack(ACItems.crystal_shard, 1, 14));
        OreDictionary.registerOre((String)"crystalShardBlaze", (ItemStack)new ItemStack(ACItems.crystal_shard, 1, 15));
        OreDictionary.registerOre((String)"crystalShardTin", (ItemStack)new ItemStack(ACItems.crystal_shard, 1, 16));
        OreDictionary.registerOre((String)"crystalShardCopper", (ItemStack)new ItemStack(ACItems.crystal_shard, 1, 17));
        OreDictionary.registerOre((String)"crystalShardSilicon", (ItemStack)new ItemStack(ACItems.crystal_shard, 1, 18));
        OreDictionary.registerOre((String)"crystalShardMagnesium", (ItemStack)new ItemStack(ACItems.crystal_shard, 1, 19));
        OreDictionary.registerOre((String)"crystalShardAluminium", (ItemStack)new ItemStack(ACItems.crystal_shard, 1, 20));
        OreDictionary.registerOre((String)"crystalShardSilica", (ItemStack)new ItemStack(ACItems.crystal_shard, 1, 21));
        OreDictionary.registerOre((String)"crystalShardAlumina", (ItemStack)new ItemStack(ACItems.crystal_shard, 1, 22));
        OreDictionary.registerOre((String)"crystalShardMagnesia", (ItemStack)new ItemStack(ACItems.crystal_shard, 1, 23));
        OreDictionary.registerOre((String)"crystalShardZinc", (ItemStack)new ItemStack(ACItems.crystal_shard, 1, 24));
        OreDictionary.registerOre((String)"blockGlass", (Block)ACBlocks.abyssal_sand_glass);
        OreDictionary.registerOre((String)"crystalFragmentIron", (ItemStack)new ItemStack(ACItems.crystal_fragment, 1, 0));
        OreDictionary.registerOre((String)"crystalFragmentGold", (ItemStack)new ItemStack(ACItems.crystal_fragment, 1, 1));
        OreDictionary.registerOre((String)"crystalFragmentSulfur", (ItemStack)new ItemStack(ACItems.crystal_fragment, 1, 2));
        OreDictionary.registerOre((String)"crystalFragmentCarbon", (ItemStack)new ItemStack(ACItems.crystal_fragment, 1, 3));
        OreDictionary.registerOre((String)"crystalFragmentOxygen", (ItemStack)new ItemStack(ACItems.crystal_fragment, 1, 4));
        OreDictionary.registerOre((String)"crystalFragmentHydrogen", (ItemStack)new ItemStack(ACItems.crystal_fragment, 1, 5));
        OreDictionary.registerOre((String)"crystalFragmentNitrogen", (ItemStack)new ItemStack(ACItems.crystal_fragment, 1, 6));
        OreDictionary.registerOre((String)"crystalFragmentPhosphorus", (ItemStack)new ItemStack(ACItems.crystal_fragment, 1, 7));
        OreDictionary.registerOre((String)"crystalFragmentPotassium", (ItemStack)new ItemStack(ACItems.crystal_fragment, 1, 8));
        OreDictionary.registerOre((String)"crystalFragmentNitrate", (ItemStack)new ItemStack(ACItems.crystal_fragment, 1, 9));
        OreDictionary.registerOre((String)"crystalFragmentMethane", (ItemStack)new ItemStack(ACItems.crystal_fragment, 1, 10));
        OreDictionary.registerOre((String)"crystalFragmentRedstone", (ItemStack)new ItemStack(ACItems.crystal_fragment, 1, 11));
        OreDictionary.registerOre((String)"crystalFragmentAbyssalnite", (ItemStack)new ItemStack(ACItems.crystal_fragment, 1, 12));
        OreDictionary.registerOre((String)"crystalFragmentCoralium", (ItemStack)new ItemStack(ACItems.crystal_fragment, 1, 13));
        OreDictionary.registerOre((String)"crystalFragmentDreadium", (ItemStack)new ItemStack(ACItems.crystal_fragment, 1, 14));
        OreDictionary.registerOre((String)"crystalFragmentBlaze", (ItemStack)new ItemStack(ACItems.crystal_fragment, 1, 15));
        OreDictionary.registerOre((String)"crystalFragmentTin", (ItemStack)new ItemStack(ACItems.crystal_fragment, 1, 16));
        OreDictionary.registerOre((String)"crystalFragmentCopper", (ItemStack)new ItemStack(ACItems.crystal_fragment, 1, 17));
        OreDictionary.registerOre((String)"crystalFragmentSilicon", (ItemStack)new ItemStack(ACItems.crystal_fragment, 1, 18));
        OreDictionary.registerOre((String)"crystalFragmentMagnesium", (ItemStack)new ItemStack(ACItems.crystal_fragment, 1, 19));
        OreDictionary.registerOre((String)"crystalFragmentAluminium", (ItemStack)new ItemStack(ACItems.crystal_fragment, 1, 20));
        OreDictionary.registerOre((String)"crystalFragmentSilica", (ItemStack)new ItemStack(ACItems.crystal_fragment, 1, 21));
        OreDictionary.registerOre((String)"crystalFragmentAlumina", (ItemStack)new ItemStack(ACItems.crystal_fragment, 1, 22));
        OreDictionary.registerOre((String)"crystalFragmentMagnesia", (ItemStack)new ItemStack(ACItems.crystal_fragment, 1, 23));
        OreDictionary.registerOre((String)"crystalFragmentZinc", (ItemStack)new ItemStack(ACItems.crystal_fragment, 1, 24));
    }

    @SubscribeEvent
    public void lootLoad(LootTableLoadEvent event) {
        LootPool main;
        if (event.getName().equals((Object)LootTableList.field_186420_b) && (main = event.getTable().getPool("main")) != null) {
            main.addEntry((LootEntry)new LootEntryItem(ACItems.darkstone_axe, 3, 0, new LootFunction[0], new LootCondition[0], "abyssalcraft:darkstone_axe"));
            main.addEntry((LootEntry)new LootEntryItem(ACItems.darkstone_pickaxe, 3, 0, new LootFunction[0], new LootCondition[0], "abyssalcraft:darkstone_pickaxe"));
            main.addEntry((LootEntry)new LootEntryItem(ACItems.darkstone_shovel, 2, 0, new LootFunction[0], new LootCondition[0], "abyssalcraft:darkstone_shovel"));
            main.addEntry((LootEntry)new LootEntryItem(ACItems.darkstone_sword, 2, 0, new LootFunction[0], new LootCondition[0], "abyssalcraft:darkstone_sword"));
            main.addEntry((LootEntry)new LootEntryItem(Item.func_150898_a((Block)ACBlocks.darklands_oak_wood), 10, 0, new LootFunction[]{new SetCount(new LootCondition[0], new RandomValueRange(1.0f, 3.0f))}, new LootCondition[0], "abyssalcraft:darklands_oak_wood"));
            main.addEntry((LootEntry)new LootEntryItem(ACItems.cobblestone_upgrade_kit, 2, 0, new LootFunction[]{new SetCount(new LootCondition[0], new RandomValueRange(1.0f, 2.0f))}, new LootCondition[0], "abyssalcraft:cobblestone_upgrade_kit"));
        }
        if (event.getName().equals((Object)LootTableList.field_186423_e) && (main = event.getTable().getPool("main")) != null) {
            main.addEntry((LootEntry)new LootEntryItem(ACItems.abyssalnite_ingot, 3, 0, new LootFunction[]{new SetCount(new LootCondition[0], new RandomValueRange(1.0f, 3.0f))}, new LootCondition[0], "abyssalcraft:abyssalnite_ingot"));
            main.addEntry((LootEntry)new LootEntryItem(ACItems.copper_ingot, 7, 0, new LootFunction[]{new SetCount(new LootCondition[0], new RandomValueRange(1.0f, 5.0f))}, new LootCondition[0], "abyssalcraft:copper_ingot"));
            main.addEntry((LootEntry)new LootEntryItem(ACItems.tin_ingot, 7, 0, new LootFunction[]{new SetCount(new LootCondition[0], new RandomValueRange(1.0f, 5.0f))}, new LootCondition[0], "abyssalcraft:tin_ingot"));
            main.addEntry((LootEntry)new LootEntryItem(ACItems.crystal, 8, 0, new LootFunction[]{new SetCount(new LootCondition[0], new RandomValueRange(1.0f, 5.0f)), new SetMetadata(new LootCondition[0], new RandomValueRange(24.0f))}, new LootCondition[0], "abyssalcraft:crystallized_zinc"));
            main.addEntry((LootEntry)new LootEntryItem(ACItems.abyssalnite_pickaxe, 2, 0, new LootFunction[0], new LootCondition[0], "abyssalcraft:abyssalnite_pickaxe"));
            main.addEntry((LootEntry)new LootEntryItem(ACItems.abyssalnite_helmet, 2, 0, new LootFunction[0], new LootCondition[0], "abyssalcraft:abyssalnite_helmet"));
            main.addEntry((LootEntry)new LootEntryItem(ACItems.abyssalnite_chestplate, 2, 0, new LootFunction[0], new LootCondition[0], "abyssalcraft:abyssalnite_chestplate"));
            main.addEntry((LootEntry)new LootEntryItem(ACItems.abyssalnite_leggings, 2, 0, new LootFunction[0], new LootCondition[0], "abyssalcraft:abyssalnite_leggings"));
            main.addEntry((LootEntry)new LootEntryItem(ACItems.abyssalnite_boots, 2, 0, new LootFunction[0], new LootCondition[0], "abyssalcraft:abyssalnite_boots"));
            main.addEntry((LootEntry)new LootEntryItem(ACItems.cobblestone_upgrade_kit, 10, 0, new LootFunction[]{new SetCount(new LootCondition[0], new RandomValueRange(1.0f, 2.0f))}, new LootCondition[0], "abyssalcraft:cobblestone_upgrade_kit"));
            main.addEntry((LootEntry)new LootEntryItem(ACItems.iron_upgrade_kit, 7, 0, new LootFunction[]{new SetCount(new LootCondition[0], new RandomValueRange(1.0f, 2.0f))}, new LootCondition[0], "abyssalcraft:iron_upgrade_kit"));
            main.addEntry((LootEntry)new LootEntryItem(ACItems.gold_upgrade_kit, 4, 0, new LootFunction[]{new SetCount(new LootCondition[0], new RandomValueRange(1.0f, 2.0f))}, new LootCondition[0], "abyssalcraft:gold_upgrade_kit"));
            main.addEntry((LootEntry)new LootEntryItem(ACItems.diamond_upgrade_kit, 1, 0, new LootFunction[]{new SetCount(new LootCondition[0], new RandomValueRange(1.0f, 2.0f))}, new LootCondition[0], "abyssalcraft:diamond_upgrade_kit"));
        }
        if (event.getName().equals((Object)LootTableList.field_186422_d) && (main = event.getTable().getPool("main")) != null) {
            main.addEntry((LootEntry)new LootEntryItem(ACItems.abyssalnite_ingot, 3, 0, new LootFunction[]{new SetCount(new LootCondition[0], new RandomValueRange(1.0f, 3.0f))}, new LootCondition[0], "abyssalcraft:abyssalnite_ingot"));
            main.addEntry((LootEntry)new LootEntryItem(ACItems.copper_ingot, 7, 0, new LootFunction[]{new SetCount(new LootCondition[0], new RandomValueRange(1.0f, 5.0f))}, new LootCondition[0], "abyssalcraft:copper_ingot"));
            main.addEntry((LootEntry)new LootEntryItem(ACItems.tin_ingot, 7, 0, new LootFunction[]{new SetCount(new LootCondition[0], new RandomValueRange(1.0f, 5.0f))}, new LootCondition[0], "abyssalcraft:tin_ingot"));
            main.addEntry((LootEntry)new LootEntryItem(ACItems.crystal, 8, 0, new LootFunction[]{new SetCount(new LootCondition[0], new RandomValueRange(1.0f, 5.0f)), new SetMetadata(new LootCondition[0], new RandomValueRange(24.0f))}, new LootCondition[0], "abyssalcraft:crystallized_zinc"));
            main.addEntry((LootEntry)new LootEntryItem(ACItems.mre, 5, 0, new LootFunction[0], new LootCondition[0], "abyssalcraft:mre"));
            main.addEntry((LootEntry)new LootEntryItem(ACItems.coralium_gem, 8, 0, new LootFunction[]{new SetCount(new LootCondition[0], new RandomValueRange(1.0f, 5.0f))}, new LootCondition[0], "abyssalcraft:coralium_gem"));
            main.addEntry((LootEntry)new LootEntryItem(ACItems.shadow_fragment, 8, 0, new LootFunction[]{new SetCount(new LootCondition[0], new RandomValueRange(1.0f, 10.0f))}, new LootCondition[0], "abyssalcraft:shadow_fragment"));
            main.addEntry((LootEntry)new LootEntryItem(ACItems.shadow_shard, 5, 0, new LootFunction[]{new SetCount(new LootCondition[0], new RandomValueRange(1.0f, 6.0f))}, new LootCondition[0], "abyssalcraft:shadow_gem_shard"));
            main.addEntry((LootEntry)new LootEntryItem(ACItems.shadow_gem, 3, 0, new LootFunction[]{new SetCount(new LootCondition[0], new RandomValueRange(1.0f, 3.0f))}, new LootCondition[0], "abyssalcraft:shadow_gem"));
        }
        if (event.getName().equals((Object)LootTableList.field_186424_f) && (main = event.getTable().getPool("main")) != null) {
            main.addEntry((LootEntry)new LootEntryItem(ACItems.abyssalnite_ingot, 3, 0, new LootFunction[]{new SetCount(new LootCondition[0], new RandomValueRange(1.0f, 3.0f))}, new LootCondition[0], "abyssalcraft:abyssalnite_ingot"));
            main.addEntry((LootEntry)new LootEntryItem(ACItems.copper_ingot, 7, 0, new LootFunction[]{new SetCount(new LootCondition[0], new RandomValueRange(1.0f, 5.0f))}, new LootCondition[0], "abyssalcraft:copper_ingot"));
            main.addEntry((LootEntry)new LootEntryItem(ACItems.tin_ingot, 7, 0, new LootFunction[]{new SetCount(new LootCondition[0], new RandomValueRange(1.0f, 5.0f))}, new LootCondition[0], "abyssalcraft:tin_ingot"));
            main.addEntry((LootEntry)new LootEntryItem(ACItems.crystal, 8, 0, new LootFunction[]{new SetCount(new LootCondition[0], new RandomValueRange(1.0f, 5.0f)), new SetMetadata(new LootCondition[0], new RandomValueRange(24.0f))}, new LootCondition[0], "abyssalcraft:crystallized_zinc"));
            main.addEntry((LootEntry)new LootEntryItem(ACItems.shadow_fragment, 8, 0, new LootFunction[]{new SetCount(new LootCondition[0], new RandomValueRange(1.0f, 10.0f))}, new LootCondition[0], "abyssalcraft:shadow_fragment"));
            main.addEntry((LootEntry)new LootEntryItem(ACItems.shadow_shard, 5, 0, new LootFunction[]{new SetCount(new LootCondition[0], new RandomValueRange(1.0f, 6.0f))}, new LootCondition[0], "abyssalcraft:shadow_gem_shard"));
            main.addEntry((LootEntry)new LootEntryItem(ACItems.shadow_gem, 3, 0, new LootFunction[]{new SetCount(new LootCondition[0], new RandomValueRange(1.0f, 3.0f))}, new LootCondition[0], "abyssalcraft:shadow_gem"));
        }
        if (event.getName().equals((Object)LootTableList.field_186429_k) && (main = event.getTable().getPool("main")) != null) {
            main.addEntry((LootEntry)new LootEntryItem(ACItems.abyssalnite_ingot, 3, 0, new LootFunction[]{new SetCount(new LootCondition[0], new RandomValueRange(1.0f, 3.0f))}, new LootCondition[0], "abyssalcraft:abyssalnite_ingot"));
            main.addEntry((LootEntry)new LootEntryItem(ACItems.copper_ingot, 7, 0, new LootFunction[]{new SetCount(new LootCondition[0], new RandomValueRange(1.0f, 5.0f))}, new LootCondition[0], "abyssalcraft:copper_ingot"));
            main.addEntry((LootEntry)new LootEntryItem(ACItems.tin_ingot, 7, 0, new LootFunction[]{new SetCount(new LootCondition[0], new RandomValueRange(1.0f, 5.0f))}, new LootCondition[0], "abyssalcraft:tin_ingot"));
            main.addEntry((LootEntry)new LootEntryItem(ACItems.crystal, 8, 0, new LootFunction[]{new SetCount(new LootCondition[0], new RandomValueRange(1.0f, 5.0f)), new SetMetadata(new LootCondition[0], new RandomValueRange(24.0f))}, new LootCondition[0], "abyssalcraft:crystallized_zinc"));
            main.addEntry((LootEntry)new LootEntryItem(ACItems.shadow_fragment, 8, 0, new LootFunction[]{new SetCount(new LootCondition[0], new RandomValueRange(1.0f, 10.0f))}, new LootCondition[0], "abyssalcraft:shadow_fragment"));
            main.addEntry((LootEntry)new LootEntryItem(ACItems.shadow_shard, 5, 0, new LootFunction[]{new SetCount(new LootCondition[0], new RandomValueRange(1.0f, 6.0f))}, new LootCondition[0], "abyssalcraft:shadow_gem_shard"));
            main.addEntry((LootEntry)new LootEntryItem(ACItems.shadow_gem, 3, 0, new LootFunction[]{new SetCount(new LootCondition[0], new RandomValueRange(1.0f, 3.0f))}, new LootCondition[0], "abyssalcraft:shadow_gem"));
        }
        if (event.getName().equals((Object)LootTableList.field_186428_j) && (main = event.getTable().getPool("main")) != null) {
            main.addEntry((LootEntry)new LootEntryItem(ACItems.abyssalnite_ingot, 3, 0, new LootFunction[]{new SetCount(new LootCondition[0], new RandomValueRange(1.0f, 3.0f))}, new LootCondition[0], "abyssalcraft:abyssalnite_ingot"));
            main.addEntry((LootEntry)new LootEntryItem(ACItems.copper_ingot, 7, 0, new LootFunction[]{new SetCount(new LootCondition[0], new RandomValueRange(1.0f, 5.0f))}, new LootCondition[0], "abyssalcraft:copper_ingot"));
            main.addEntry((LootEntry)new LootEntryItem(ACItems.tin_ingot, 7, 0, new LootFunction[]{new SetCount(new LootCondition[0], new RandomValueRange(1.0f, 5.0f))}, new LootCondition[0], "abyssalcraft:tin_ingot"));
            main.addEntry((LootEntry)new LootEntryItem(ACItems.crystal, 8, 0, new LootFunction[]{new SetCount(new LootCondition[0], new RandomValueRange(1.0f, 5.0f)), new SetMetadata(new LootCondition[0], new RandomValueRange(24.0f))}, new LootCondition[0], "abyssalcraft:crystallized_zinc"));
            main.addEntry((LootEntry)new LootEntryItem(ACItems.shadow_fragment, 8, 0, new LootFunction[]{new SetCount(new LootCondition[0], new RandomValueRange(1.0f, 10.0f))}, new LootCondition[0], "abyssalcraft:shadow_fragment"));
            main.addEntry((LootEntry)new LootEntryItem(ACItems.shadow_shard, 5, 0, new LootFunction[]{new SetCount(new LootCondition[0], new RandomValueRange(1.0f, 6.0f))}, new LootCondition[0], "abyssalcraft:shadow_gem_shard"));
            main.addEntry((LootEntry)new LootEntryItem(ACItems.shadow_gem, 3, 0, new LootFunction[]{new SetCount(new LootCondition[0], new RandomValueRange(1.0f, 3.0f))}, new LootCondition[0], "abyssalcraft:shadow_gem"));
        }
    }

    @SubscribeEvent
    public void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        IForgeRegistry reg = event.getRegistry();
        this.addShapedNBTRecipe((IForgeRegistry<IRecipe>)reg, this.rl("oblivion_deathbomb_0"), null, new ItemStack(ACBlocks.oblivion_deathbomb), "#%%", "&$%", "\u00a3%%", Character.valueOf('#'), ACItems.liquid_antimatter_bucket_stack, Character.valueOf('\u00a3'), ACItems.liquid_coralium_bucket_stack, Character.valueOf('%'), Blocks.field_150343_Z, Character.valueOf('&'), ACItems.oblivion_catalyst, Character.valueOf('$'), ACBlocks.odb_core);
        this.addShapedNBTRecipe((IForgeRegistry<IRecipe>)reg, this.rl("oblivion_deathbomb_1"), null, new ItemStack(ACBlocks.oblivion_deathbomb), "#%%", "&$%", "\u00a3%%", Character.valueOf('#'), ACItems.liquid_coralium_bucket_stack, Character.valueOf('\u00a3'), ACItems.liquid_antimatter_bucket_stack, Character.valueOf('%'), Blocks.field_150343_Z, Character.valueOf('&'), ACItems.oblivion_catalyst, Character.valueOf('$'), ACBlocks.odb_core);
        this.addShapedNBTRecipe((IForgeRegistry<IRecipe>)reg, this.rl("transmutator"), null, new ItemStack(ACBlocks.transmutator_idle, 1), "###", "#%#", "&$&", Character.valueOf('#'), ACItems.coralium_brick, Character.valueOf('%'), new ItemStack(ACItems.transmutation_gem, 1, Short.MAX_VALUE), Character.valueOf('&'), new ItemStack(ACBlocks.ingot_block, 1, 1), Character.valueOf('$'), ACItems.liquid_coralium_bucket_stack);
        this.addShapedNBTRecipe((IForgeRegistry<IRecipe>)reg, this.rl("materializer"), null, new ItemStack(ACBlocks.materializer), "###", "#%#", "&$&", Character.valueOf('#'), ACItems.ethaxium_brick, Character.valueOf('%'), Blocks.field_150343_Z, Character.valueOf('&'), new ItemStack(ACBlocks.ingot_block, 1, 3), Character.valueOf('$'), ACItems.liquid_antimatter_bucket_stack);
    }

    private ResourceLocation rl(String name) {
        return new ResourceLocation("abyssalcraft", name);
    }

    private void addShapedNBTRecipe(IForgeRegistry<IRecipe> reg, ResourceLocation name, ResourceLocation group, @Nonnull ItemStack output, Object ... params) {
        CraftingHelper.ShapedPrimer primer = CraftingHelper.parseShaped((Object[])params);
        reg.register(new ShapedNBTRecipe(group == null ? "" : group.toString(), primer.width, primer.height, (NonNullList<Ingredient>)primer.input, output).setRegistryName(name));
    }

    private void addDungeonHooks() {
        DungeonHooks.addDungeonMob((ResourceLocation)new ResourceLocation("abyssalcraft", "abyssalzombie"), (int)150);
        DungeonHooks.addDungeonMob((ResourceLocation)new ResourceLocation("abyssalcraft", "depthsghoul"), (int)100);
        DungeonHooks.addDungeonMob((ResourceLocation)new ResourceLocation("abyssalcraft", "shadowcreature"), (int)120);
        DungeonHooks.addDungeonMob((ResourceLocation)new ResourceLocation("abyssalcraft", "shadowmonster"), (int)100);
        DungeonHooks.addDungeonMob((ResourceLocation)new ResourceLocation("abyssalcraft", "shadowbeast"), (int)30);
        DungeonHooks.addDungeonMob((ResourceLocation)new ResourceLocation("abyssalcraft", "antiabyssalzombie"), (int)50);
        DungeonHooks.addDungeonMob((ResourceLocation)new ResourceLocation("abyssalcraft", "antighoul"), (int)50);
        DungeonHooks.addDungeonMob((ResourceLocation)new ResourceLocation("abyssalcraft", "antiskeleton"), (int)50);
        DungeonHooks.addDungeonMob((ResourceLocation)new ResourceLocation("abyssalcraft", "antispider"), (int)50);
        DungeonHooks.addDungeonMob((ResourceLocation)new ResourceLocation("abyssalcraft", "antizombie"), (int)50);
    }

    private void sendIMC() {
        FMLInterModComms.sendMessage((String)"arsmagica2", (String)"dbs", (String)("am2.entities.EntityDryad|" + String.valueOf(ACLib.abyssal_wasteland_id)));
        FMLInterModComms.sendMessage((String)"arsmagica2", (String)"dbs", (String)("am2.entities.EntityDryad|" + String.valueOf(ACLib.dreadlands_id)));
        FMLInterModComms.sendMessage((String)"arsmagica2", (String)"dbs", (String)("am2.entities.EntityDryad|" + String.valueOf(ACLib.omothol_id)));
        FMLInterModComms.sendMessage((String)"arsmagica2", (String)"dbs", (String)("am2.entities.EntityDryad|" + String.valueOf(ACLib.dark_realm_id)));
        FMLInterModComms.sendMessage((String)"arsmagica2", (String)"dbs", (String)("am2.entities.EntityManaElemental|" + String.valueOf(ACLib.abyssal_wasteland_id)));
        FMLInterModComms.sendMessage((String)"arsmagica2", (String)"dbs", (String)("am2.entities.EntityManaElemental|" + String.valueOf(ACLib.dreadlands_id)));
        FMLInterModComms.sendMessage((String)"arsmagica2", (String)"dbs", (String)("am2.entities.EntityManaElemental|" + String.valueOf(ACLib.omothol_id)));
        FMLInterModComms.sendMessage((String)"arsmagica2", (String)"dbs", (String)("am2.entities.EntityManaElemental|" + String.valueOf(ACLib.dark_realm_id)));
        if (ACConfig.abyssal_stone_brick_slab) {
            FMLInterModComms.sendMessage((String)"BuildCraft|Core", (String)"blacklist-facade", (ItemStack)new ItemStack(ACBlocks.abyssal_stone_brick_slab));
            FMLInterModComms.sendMessage((String)"BuildCraft|Core", (String)"blacklist-facade", (ItemStack)new ItemStack(BlockHandler.abyslab2));
        }
        if (ACConfig.darkstone_slab) {
            FMLInterModComms.sendMessage((String)"BuildCraft|Core", (String)"blacklist-facade", (ItemStack)new ItemStack(ACBlocks.darkstone_slab));
            FMLInterModComms.sendMessage((String)"BuildCraft|Core", (String)"blacklist-facade", (ItemStack)new ItemStack(BlockHandler.Darkstoneslab2));
        }
        if (ACConfig.darkstone_cobblestone_slab) {
            FMLInterModComms.sendMessage((String)"BuildCraft|Core", (String)"blacklist-facade", (ItemStack)new ItemStack(ACBlocks.darkstone_cobblestone_slab));
            FMLInterModComms.sendMessage((String)"BuildCraft|Core", (String)"blacklist-facade", (ItemStack)new ItemStack(BlockHandler.Darkcobbleslab2));
        }
        if (ACConfig.darkstone_brick_slab) {
            FMLInterModComms.sendMessage((String)"BuildCraft|Core", (String)"blacklist-facade", (ItemStack)new ItemStack(ACBlocks.darkstone_brick_slab));
            FMLInterModComms.sendMessage((String)"BuildCraft|Core", (String)"blacklist-facade", (ItemStack)new ItemStack(BlockHandler.Darkbrickslab2));
        }
        if (ACConfig.darklands_oak_slab) {
            FMLInterModComms.sendMessage((String)"BuildCraft|Core", (String)"blacklist-facade", (ItemStack)new ItemStack(ACBlocks.darklands_oak_slab));
            FMLInterModComms.sendMessage((String)"BuildCraft|Core", (String)"blacklist-facade", (ItemStack)new ItemStack(BlockHandler.DLTslab2));
        }
        if (ACConfig.abyssalnite_stone_brick_slab) {
            FMLInterModComms.sendMessage((String)"BuildCraft|Core", (String)"blacklist-facade", (ItemStack)new ItemStack(ACBlocks.abyssalnite_stone_brick_slab));
            FMLInterModComms.sendMessage((String)"BuildCraft|Core", (String)"blacklist-facade", (ItemStack)new ItemStack(BlockHandler.abydreadbrickslab2));
        }
        if (ACConfig.dreadstone_brick_slab) {
            FMLInterModComms.sendMessage((String)"BuildCraft|Core", (String)"blacklist-facade", (ItemStack)new ItemStack(ACBlocks.dreadstone_brick_slab));
            FMLInterModComms.sendMessage((String)"BuildCraft|Core", (String)"blacklist-facade", (ItemStack)new ItemStack(BlockHandler.dreadbrickslab2));
        }
        if (ACConfig.coralium_stone_brick_slab) {
            FMLInterModComms.sendMessage((String)"BuildCraft|Core", (String)"blacklist-facade", (ItemStack)new ItemStack(ACBlocks.coralium_stone_brick_slab));
            FMLInterModComms.sendMessage((String)"BuildCraft|Core", (String)"blacklist-facade", (ItemStack)new ItemStack(BlockHandler.cstonebrickslab2));
        }
        if (ACConfig.ethaxium_brick_slab) {
            FMLInterModComms.sendMessage((String)"BuildCraft|Core", (String)"blacklist-facade", (ItemStack)new ItemStack(ACBlocks.ethaxium_brick_slab));
            FMLInterModComms.sendMessage((String)"BuildCraft|Core", (String)"blacklist-facade", (ItemStack)new ItemStack(BlockHandler.ethaxiumslab2));
        }
        FMLInterModComms.sendMessage((String)"BuildCraft|Core", (String)"blacklist-facade", (ItemStack)new ItemStack(ACBlocks.abyssal_gateway));
        FMLInterModComms.sendMessage((String)"BuildCraft|Core", (String)"blacklist-facade", (ItemStack)new ItemStack(ACBlocks.dreaded_gateway));
        FMLInterModComms.sendMessage((String)"BuildCraft|Core", (String)"blacklist-facade", (ItemStack)new ItemStack(ACBlocks.omothol_gateway));
        FMLInterModComms.sendMessage((String)"BuildCraft|Core", (String)"blacklist-facade", (ItemStack)new ItemStack(ACBlocks.coralium_fire));
        FMLInterModComms.sendMessage((String)"BuildCraft|Core", (String)"blacklist-facade", (ItemStack)new ItemStack(ACBlocks.dreaded_fire));
        FMLInterModComms.sendMessage((String)"BuildCraft|Core", (String)"blacklist-facade", (ItemStack)new ItemStack(ACBlocks.omothol_fire));
        FMLInterModComms.sendMessage((String)"BuildCraft|Core", (String)"blacklist-facade", (ItemStack)new ItemStack(ACBlocks.transmutator_active));
        FMLInterModComms.sendMessage((String)"BuildCraft|Core", (String)"blacklist-facade", (ItemStack)new ItemStack(ACBlocks.crystallizer_active));
        FMLInterModComms.sendMessage((String)"BuildCraft|Core", (String)"blacklist-facade", (ItemStack)new ItemStack(ACBlocks.engraver));
        FMLInterModComms.sendMessage((String)"BuildCraft|Core", (String)"blacklist-facade", (ItemStack)new ItemStack(ACBlocks.oblivion_deathbomb));
        FMLInterModComms.sendMessage((String)"BuildCraft|Core", (String)"blacklist-facade", (ItemStack)new ItemStack(ACBlocks.odb_core));
        FMLInterModComms.sendMessage((String)"BuildCraft|Core", (String)"blacklist-facade", (ItemStack)new ItemStack(ACBlocks.darkstone_brick_fence));
        if (ACConfig.darkstone_cobblestone_wall) {
            FMLInterModComms.sendMessage((String)"BuildCraft|Core", (String)"blacklist-facade", (ItemStack)new ItemStack(ACBlocks.darkstone_cobblestone_wall));
        }
        FMLInterModComms.sendMessage((String)"BuildCraft|Core", (String)"blacklist-facade", (ItemStack)new ItemStack(ACBlocks.abyssal_stone_brick_fence));
        FMLInterModComms.sendMessage((String)"BuildCraft|Core", (String)"blacklist-facade", (ItemStack)new ItemStack(ACBlocks.darklands_oak_fence));
        FMLInterModComms.sendMessage((String)"BuildCraft|Core", (String)"blacklist-facade", (ItemStack)new ItemStack(ACBlocks.abyssalnite_stone_brick_fence));
        FMLInterModComms.sendMessage((String)"BuildCraft|Core", (String)"blacklist-facade", (ItemStack)new ItemStack(ACBlocks.dreadstone_brick_fence));
        FMLInterModComms.sendMessage((String)"BuildCraft|Core", (String)"blacklist-facade", (ItemStack)new ItemStack(ACBlocks.coralium_stone_brick_fence));
        FMLInterModComms.sendMessage((String)"BuildCraft|Core", (String)"blacklist-facade", (ItemStack)new ItemStack(ACBlocks.ethaxium_brick_fence));
        FMLInterModComms.sendMessage((String)"BuildCraft|Core", (String)"blacklist-facade", (ItemStack)new ItemStack(ACBlocks.dreadlands_wood_fence));
        if (ACConfig.abyssal_stone_brick_stairs) {
            FMLInterModComms.sendMessage((String)"BuildCraft|Core", (String)"blacklist-facade", (ItemStack)new ItemStack(ACBlocks.abyssal_stone_brick_stairs));
        }
        if (ACConfig.darkstone_brick_stairs) {
            FMLInterModComms.sendMessage((String)"BuildCraft|Core", (String)"blacklist-facade", (ItemStack)new ItemStack(ACBlocks.darkstone_brick_stairs));
        }
        if (ACConfig.darkstone_cobblestone_stairs) {
            FMLInterModComms.sendMessage((String)"BuildCraft|Core", (String)"blacklist-facade", (ItemStack)new ItemStack(ACBlocks.darkstone_cobblestone_stairs));
        }
        if (ACConfig.darklands_oak_stairs) {
            FMLInterModComms.sendMessage((String)"BuildCraft|Core", (String)"blacklist-facade", (ItemStack)new ItemStack(ACBlocks.darklands_oak_stairs));
        }
        if (ACConfig.abyssalnite_stone_brick_stairs) {
            FMLInterModComms.sendMessage((String)"BuildCraft|Core", (String)"blacklist-facade", (ItemStack)new ItemStack(ACBlocks.abyssalnite_stone_brick_stairs));
        }
        if (ACConfig.dreadstone_brick_stairs) {
            FMLInterModComms.sendMessage((String)"BuildCraft|Core", (String)"blacklist-facade", (ItemStack)new ItemStack(ACBlocks.dreadstone_brick_stairs));
        }
        if (ACConfig.coralium_stone_brick_stairs) {
            FMLInterModComms.sendMessage((String)"BuildCraft|Core", (String)"blacklist-facade", (ItemStack)new ItemStack(ACBlocks.coralium_stone_brick_stairs));
        }
        if (ACConfig.ethaxium_brick_stairs) {
            FMLInterModComms.sendMessage((String)"BuildCraft|Core", (String)"blacklist-facade", (ItemStack)new ItemStack(ACBlocks.ethaxium_brick_stairs));
        }
        FMLInterModComms.sendMessage((String)"BuildCraft|Core", (String)"blacklist-facade", (ItemStack)new ItemStack(ACBlocks.abyssal_stone_button));
        FMLInterModComms.sendMessage((String)"BuildCraft|Core", (String)"blacklist-facade", (ItemStack)new ItemStack(ACBlocks.darkstone_button));
        FMLInterModComms.sendMessage((String)"BuildCraft|Core", (String)"blacklist-facade", (ItemStack)new ItemStack(ACBlocks.darklands_oak_button));
        FMLInterModComms.sendMessage((String)"BuildCraft|Core", (String)"blacklist-facade", (ItemStack)new ItemStack(ACBlocks.coralium_stone_button));
        FMLInterModComms.sendMessage((String)"BuildCraft|Core", (String)"blacklist-facade", (ItemStack)new ItemStack(ACBlocks.abyssal_stone_pressure_plate));
        FMLInterModComms.sendMessage((String)"BuildCraft|Core", (String)"blacklist-facade", (ItemStack)new ItemStack(ACBlocks.darkstone_pressure_plate));
        FMLInterModComms.sendMessage((String)"BuildCraft|Core", (String)"blacklist-facade", (ItemStack)new ItemStack(ACBlocks.darklands_oak_pressure_plate));
        FMLInterModComms.sendMessage((String)"BuildCraft|Core", (String)"blacklist-facade", (ItemStack)new ItemStack(ACBlocks.coralium_stone_pressure_plate));
        FMLInterModComms.sendMessage((String)"BuildCraft|Core", (String)"blacklist-facade", (ItemStack)new ItemStack(BlockHandler.Altar));
        FMLInterModComms.sendMessage((String)"BuildCraft|Core", (String)"blacklist-facade", (ItemStack)new ItemStack(ACBlocks.chagaroth_altar_top));
        FMLInterModComms.sendMessage((String)"BuildCraft|Core", (String)"blacklist-facade", (ItemStack)new ItemStack(ACBlocks.chagaroth_altar_bottom));
        FMLInterModComms.sendMessage((String)"BuildCraft|Core", (String)"blacklist-facade", (ItemStack)new ItemStack(ACBlocks.dreadlands_infused_powerstone));
        FMLInterModComms.sendMessage((String)"BuildCraft|Core", (String)"blacklist-facade", (ItemStack)new ItemStack(ACBlocks.depths_ghoul_head));
        FMLInterModComms.sendMessage((String)"BuildCraft|Core", (String)"blacklist-facade", (ItemStack)new ItemStack(ACBlocks.pete_head));
        FMLInterModComms.sendMessage((String)"BuildCraft|Core", (String)"blacklist-facade", (ItemStack)new ItemStack(ACBlocks.mr_wilson_head));
        FMLInterModComms.sendMessage((String)"BuildCraft|Core", (String)"blacklist-facade", (ItemStack)new ItemStack(ACBlocks.dr_orange_head));
        FMLInterModComms.sendMessage((String)"BuildCraft|Core", (String)"blacklist-facade", (ItemStack)new ItemStack(ACBlocks.darklands_oak_sapling));
        FMLInterModComms.sendMessage((String)"BuildCraft|Core", (String)"blacklist-facade", (ItemStack)new ItemStack(ACBlocks.dreadlands_sapling));
        FMLInterModComms.sendMessage((String)"BuildCraft|Core", (String)"blacklist-facade", (ItemStack)new ItemStack(BlockHandler.house));
        FMLInterModComms.sendMessage((String)"BuildCraft|Core", (String)"blacklist-facade", (ItemStack)new ItemStack(ACBlocks.dark_ethaxium_brick_stairs));
        FMLInterModComms.sendMessage((String)"BuildCraft|Core", (String)"blacklist-facade", (ItemStack)new ItemStack(ACBlocks.dark_ethaxium_brick_slab));
        FMLInterModComms.sendMessage((String)"BuildCraft|Core", (String)"blacklist-facade", (ItemStack)new ItemStack(BlockHandler.darkethaxiumslab2));
        FMLInterModComms.sendMessage((String)"BuildCraft|Core", (String)"blacklist-facade", (ItemStack)new ItemStack(ACBlocks.dark_ethaxium_brick_fence));
        FMLInterModComms.sendMessage((String)"BuildCraft|Core", (String)"blacklist-facade", (ItemStack)new ItemStack(ACBlocks.ritual_altar));
        FMLInterModComms.sendMessage((String)"BuildCraft|Core", (String)"blacklist-facade", (ItemStack)new ItemStack(ACBlocks.ritual_pedestal));
        FMLInterModComms.sendMessage((String)"BuildCraft|Core", (String)"blacklist-facade", (ItemStack)new ItemStack(ACBlocks.statue, 1, Short.MAX_VALUE));
        FMLInterModComms.sendMessage((String)"BuildCraft|Core", (String)"blacklist-facade", (ItemStack)new ItemStack(ACBlocks.energy_pedestal));
        FMLInterModComms.sendMessage((String)"chiselsandbits", (String)"ignoreblocklogic", (ResourceLocation)ACBlocks.stone.getRegistryName());
        FMLInterModComms.sendMessage((String)"chiselsandbits", (String)"ignoreblocklogic", (ResourceLocation)ACBlocks.abyssal_sand.getRegistryName());
        FMLInterModComms.sendMessage((String)"chiselsandbits", (String)"ignoreblocklogic", (ResourceLocation)ACBlocks.abyssal_sand_glass.getRegistryName());
    }

    private static void registerPotion(ResourceLocation res, Potion pot) {
        InitHandler.INSTANCE.POTIONS.add((Potion)pot.setRegistryName(res));
    }

    private static void registerEnchantment(ResourceLocation res, Enchantment ench) {
        InitHandler.INSTANCE.ENCHANTMENTS.add((Enchantment)ench.setRegistryName(res));
    }

    private static void registerPotionType(ResourceLocation res, PotionType pot) {
        InitHandler.INSTANCE.POTION_TYPES.add((PotionType)pot.setRegistryName(res));
    }

    private static SoundEvent registerSoundEvent(String name) {
        ResourceLocation res = new ResourceLocation("abyssalcraft", name);
        SoundEvent evt = (SoundEvent)new SoundEvent(res).setRegistryName(res);
        InitHandler.INSTANCE.SOUND_EVENTS.add(evt);
        return evt;
    }

    private void addBrewing(PotionType input, Item ingredient, PotionType output) {
        PotionHelper.func_193357_a((PotionType)input, (Item)ingredient, (PotionType)output);
    }
}

