/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.common.world;

import com.google.common.collect.Lists;
import com.shinoow.abyssalcraft.common.structures.overworld.AChouse1;
import com.shinoow.abyssalcraft.common.structures.overworld.AChouse2;
import com.shinoow.abyssalcraft.common.structures.overworld.ACscion1;
import com.shinoow.abyssalcraft.common.structures.overworld.ACscion2;
import com.shinoow.abyssalcraft.common.structures.overworld.StructureCircularShrine;
import com.shinoow.abyssalcraft.common.structures.overworld.StructureCircularShrineColumns;
import com.shinoow.abyssalcraft.common.structures.overworld.StructureElevatedShrine;
import com.shinoow.abyssalcraft.common.structures.overworld.StructureElevatedShrineLarge;
import com.shinoow.abyssalcraft.common.structures.overworld.StructureRitualGrounds;
import com.shinoow.abyssalcraft.common.structures.overworld.StructureRitualGroundsColumns;
import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class DarklandsStructureGenerator {
    static List<WorldGenerator> structures = Lists.newArrayList((Object[])new WorldGenerator[]{new AChouse1(), new AChouse2(), new ACscion1(), new ACscion2(), new StructureRitualGrounds(), new StructureCircularShrine(), new StructureCircularShrineColumns(), new StructureRitualGroundsColumns(), new StructureElevatedShrine(), new StructureElevatedShrineLarge()});
    static List<WorldGenerator> shrines = Lists.newArrayList((Object[])new WorldGenerator[]{new StructureCircularShrine(), new StructureCircularShrineColumns(), new StructureElevatedShrine(), new StructureElevatedShrineLarge()});
    static List<WorldGenerator> ritual_grounds = Lists.newArrayList((Object[])new WorldGenerator[]{new StructureRitualGrounds(), new StructureRitualGroundsColumns()});
    static List<WorldGenerator> houses = Lists.newArrayList((Object[])new WorldGenerator[]{new AChouse1(), new AChouse2()});
    static List<WorldGenerator> misc = Lists.newArrayList((Object[])new WorldGenerator[]{new ACscion1(), new ACscion2()});

    public static void generate(int type, World world, Random random, BlockPos pos) {
        DarklandsStructureGenerator.generate(type, world, random, pos, Blocks.field_150349_c.func_176223_P(), null);
    }

    public static void generate(int type, World world, Random random, BlockPos pos, IBlockState spawnBlock, IBlockState ... extra) {
        switch (type) {
            case 0: {
                DarklandsStructureGenerator.generateRandomStructure(structures, world, random, pos, 3, spawnBlock, extra);
                break;
            }
            case 1: {
                DarklandsStructureGenerator.generateRandomStructure(shrines, world, random, pos, 3, spawnBlock, extra);
                break;
            }
            case 2: {
                DarklandsStructureGenerator.generateRandomStructure(ritual_grounds, world, random, pos, 3, spawnBlock, extra);
                break;
            }
            case 3: {
                DarklandsStructureGenerator.generateRandomStructure(houses, world, random, pos, 5, spawnBlock, extra);
                break;
            }
            case 4: {
                DarklandsStructureGenerator.generateRandomStructure(misc, world, random, pos, 3, spawnBlock, extra);
                break;
            }
            default: {
                DarklandsStructureGenerator.generateRandomStructure(structures, world, random, pos, 3, spawnBlock, extra);
            }
        }
    }

    private static void generateRandomStructure(List<WorldGenerator> structures, World world, Random random, BlockPos pos, int bounds, IBlockState spawnBlock, IBlockState ... extra) {
        WorldGenerator structure = structures.get(random.nextInt(structures.size()));
        while (world.func_175623_d(pos) && pos.func_177956_o() > 2) {
            pos = pos.func_177977_b();
        }
        if (!DarklandsStructureGenerator.checkBlocks(world, pos, bounds, spawnBlock, extra)) {
            return;
        }
        if (random.nextFloat() < 0.03f) {
            structure.func_180709_b(world, random, pos);
        }
    }

    private static boolean checkBlocks(World world, BlockPos pos, int bounds, IBlockState spawnBlock, IBlockState ... extra) {
        if (spawnBlock == null) {
            return true;
        }
        if (extra != null) {
            for (IBlockState state : extra) {
                if (!DarklandsStructureGenerator.checkBlocks(world, pos, bounds, state)) continue;
                return true;
            }
        }
        return DarklandsStructureGenerator.checkBlocks(world, pos, bounds, spawnBlock);
    }

    private static boolean checkBlocks(World world, BlockPos pos, int bounds, IBlockState state) {
        boolean b = world.func_180495_p(pos) != state;
        boolean b1 = world.func_180495_p(pos.func_177964_d(bounds)) != state;
        boolean b2 = world.func_180495_p(pos.func_177970_e(bounds)) != state;
        boolean b3 = world.func_180495_p(pos.func_177985_f(bounds)) != state;
        boolean b4 = world.func_180495_p(pos.func_177965_g(bounds)) != state;
        return !b && !b1 && !b2 && !b3 && !b4;
    }
}

