/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.common.world;

import com.shinoow.abyssalcraft.api.block.ACBlocks;
import com.shinoow.abyssalcraft.common.structures.StructureShoggothPit;
import com.shinoow.abyssalcraft.common.structures.abyss.Abyruin;
import com.shinoow.abyssalcraft.common.structures.abyss.Chains;
import com.shinoow.abyssalcraft.common.structures.abyss.stronghold.MapGenAbyStronghold;
import com.shinoow.abyssalcraft.common.world.gen.MapGenCavesAC;
import com.shinoow.abyssalcraft.common.world.gen.MapGenRavineAC;
import com.shinoow.abyssalcraft.common.world.gen.WorldGenAbyLake;
import com.shinoow.abyssalcraft.lib.ACConfig;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;

public class ChunkProviderAbyss
implements IChunkGenerator {
    private Random rand;
    private NoiseGeneratorOctaves noiseGen1;
    private NoiseGeneratorOctaves noiseGen2;
    private NoiseGeneratorOctaves noiseGen3;
    private NoiseGeneratorPerlin noiseGen4;
    public NoiseGeneratorOctaves noiseGen5;
    public NoiseGeneratorOctaves noiseGen6;
    public NoiseGeneratorOctaves mobSpawnerNoise;
    private World worldObj;
    private final boolean mapFeaturesEnabled;
    private WorldType worldType;
    private final double[] field_147434_q;
    private final float[] parabolicField;
    private double[] stoneNoise = new double[256];
    private MapGenBase caveGenerator = new MapGenCavesAC();
    private MapGenAbyStronghold strongholdGenerator = new MapGenAbyStronghold();
    private MapGenBase ravineGenerator = new MapGenRavineAC();
    private Biome[] biomesForGeneration;
    double[] doubleArray1;
    double[] doubleArray2;
    double[] doubleArray3;
    double[] doubleArray4;
    int[][] field_73219_j = new int[32][32];

    public ChunkProviderAbyss(World par1World, long par2, boolean par4) {
        this.caveGenerator = TerrainGen.getModdedMapGen((MapGenBase)this.caveGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.CAVE);
        this.ravineGenerator = TerrainGen.getModdedMapGen((MapGenBase)this.ravineGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.RAVINE);
        this.worldObj = par1World;
        this.mapFeaturesEnabled = par4;
        this.worldType = par1World.func_72912_H().func_76067_t();
        this.rand = new Random(par2);
        this.noiseGen1 = new NoiseGeneratorOctaves(this.rand, 16);
        this.noiseGen2 = new NoiseGeneratorOctaves(this.rand, 16);
        this.noiseGen3 = new NoiseGeneratorOctaves(this.rand, 8);
        this.noiseGen4 = new NoiseGeneratorPerlin(this.rand, 4);
        this.noiseGen5 = new NoiseGeneratorOctaves(this.rand, 10);
        this.noiseGen6 = new NoiseGeneratorOctaves(this.rand, 16);
        this.mobSpawnerNoise = new NoiseGeneratorOctaves(this.rand, 8);
        this.field_147434_q = new double[825];
        this.parabolicField = new float[25];
        for (int j = -2; j <= 2; ++j) {
            for (int k = -2; k <= 2; ++k) {
                float f;
                this.parabolicField[j + 2 + (k + 2) * 5] = f = 10.0f / MathHelper.func_76129_c((float)((float)(j * j + k * k) + 0.2f));
            }
        }
    }

    public void setBlocksInChunk(int x, int z, ChunkPrimer primer) {
        int b0 = 63;
        this.biomesForGeneration = this.worldObj.func_72959_q().func_76937_a(this.biomesForGeneration, x * 4 - 2, z * 4 - 2, 10, 10);
        this.generateNoise(x * 4, 0, z * 4);
        for (int k = 0; k < 4; ++k) {
            int l = k * 5;
            int i1 = (k + 1) * 5;
            for (int j1 = 0; j1 < 4; ++j1) {
                int k1 = (l + j1) * 33;
                int l1 = (l + j1 + 1) * 33;
                int i2 = (i1 + j1) * 33;
                int j2 = (i1 + j1 + 1) * 33;
                for (int k2 = 0; k2 < 32; ++k2) {
                    double d0 = 0.125;
                    double d1 = this.field_147434_q[k1 + k2];
                    double d2 = this.field_147434_q[l1 + k2];
                    double d3 = this.field_147434_q[i2 + k2];
                    double d4 = this.field_147434_q[j2 + k2];
                    double d5 = (this.field_147434_q[k1 + k2 + 1] - d1) * d0;
                    double d6 = (this.field_147434_q[l1 + k2 + 1] - d2) * d0;
                    double d7 = (this.field_147434_q[i2 + k2 + 1] - d3) * d0;
                    double d8 = (this.field_147434_q[j2 + k2 + 1] - d4) * d0;
                    for (int l2 = 0; l2 < 8; ++l2) {
                        double d9 = 0.25;
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * d9;
                        double d13 = (d4 - d2) * d9;
                        for (int i3 = 0; i3 < 4; ++i3) {
                            double d14 = 0.25;
                            double d16 = (d11 - d10) * d14;
                            double d15 = d10 - d16;
                            for (int k3 = 0; k3 < 4; ++k3) {
                                double d;
                                d15 += d16;
                                if (d > 0.0) {
                                    primer.func_177855_a(k * 4 + i3, k2 * 8 + l2, j1 * 4 + k3, ACBlocks.stone.func_176203_a(1));
                                    continue;
                                }
                                if (k2 * 8 + l2 >= b0) continue;
                                primer.func_177855_a(k * 4 + i3, k2 * 8 + l2, j1 * 4 + k3, ACBlocks.liquid_coralium.func_176223_P());
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
    }

    public void replaceBlocksForBiome(int x, int z, ChunkPrimer primer, Biome[] par5BiomeArray) {
        if (!ForgeEventFactory.onReplaceBiomeBlocks((IChunkGenerator)this, (int)x, (int)z, (ChunkPrimer)primer, (World)this.worldObj)) {
            return;
        }
        double d0 = 0.03125;
        this.stoneNoise = this.noiseGen4.func_151599_a(this.stoneNoise, (double)(x * 16), (double)(z * 16), 16, 16, d0 * 2.0, d0 * 2.0, 1.0);
        for (int k = 0; k < 16; ++k) {
            for (int l = 0; l < 16; ++l) {
                Biome Biome2 = par5BiomeArray[l + k * 16];
                Biome2.func_180622_a(this.worldObj, this.rand, primer, x * 16 + k, z * 16 + l, this.stoneNoise[l + k * 16]);
            }
        }
    }

    public Chunk func_185932_a(int x, int z) {
        this.rand.setSeed((long)x * 341873128712L + (long)z * 132897987541L);
        ChunkPrimer primer = new ChunkPrimer();
        this.setBlocksInChunk(x, z, primer);
        this.biomesForGeneration = this.worldObj.func_72959_q().func_76933_b(this.biomesForGeneration, x * 16, z * 16, 16, 16);
        this.replaceBlocksForBiome(x, z, primer, this.biomesForGeneration);
        this.caveGenerator.func_186125_a(this.worldObj, x, z, primer);
        this.ravineGenerator.func_186125_a(this.worldObj, x, z, primer);
        if (this.mapFeaturesEnabled) {
            this.strongholdGenerator.func_186125_a(this.worldObj, x, z, primer);
        }
        Chunk chunk = new Chunk(this.worldObj, primer, x, z);
        byte[] abyte1 = chunk.func_76605_m();
        for (int k = 0; k < abyte1.length; ++k) {
            abyte1[k] = (byte)Biome.func_185362_a((Biome)this.biomesForGeneration[k]);
        }
        chunk.func_76603_b();
        return chunk;
    }

    private void generateNoise(int x, int y, int z) {
        this.doubleArray4 = this.noiseGen6.func_76305_a(this.doubleArray4, x, z, 5, 5, 200.0, 200.0, 0.5);
        this.doubleArray1 = this.noiseGen3.func_76304_a(this.doubleArray1, x, y, z, 5, 33, 5, 8.555150000000001, 4.277575000000001, 8.555150000000001);
        this.doubleArray2 = this.noiseGen1.func_76304_a(this.doubleArray2, x, y, z, 5, 33, 5, 684.412, 684.412, 684.412);
        this.doubleArray3 = this.noiseGen2.func_76304_a(this.doubleArray3, x, y, z, 5, 33, 5, 684.412, 684.412, 684.412);
        int l = 0;
        int i1 = 0;
        for (int j1 = 0; j1 < 5; ++j1) {
            for (int k1 = 0; k1 < 5; ++k1) {
                float f = 0.0f;
                float f1 = 0.0f;
                float f2 = 0.0f;
                int b0 = 2;
                Biome Biome2 = this.biomesForGeneration[j1 + 2 + (k1 + 2) * 10];
                for (int l1 = -b0; l1 <= b0; ++l1) {
                    for (int i2 = -b0; i2 <= b0; ++i2) {
                        Biome Biome1 = this.biomesForGeneration[j1 + l1 + 2 + (k1 + i2 + 2) * 10];
                        float f3 = Biome1.func_185355_j();
                        float f4 = Biome1.func_185360_m();
                        if (this.worldType == WorldType.field_151360_e && f3 > 0.0f) {
                            f3 = 1.0f + f3 * 2.0f;
                            f4 = 1.0f + f4 * 4.0f;
                        }
                        float f5 = this.parabolicField[l1 + 2 + (i2 + 2) * 5] / (f3 + 2.0f);
                        if (Biome1.func_185355_j() > Biome2.func_185355_j()) {
                            f5 /= 2.0f;
                        }
                        f += f4 * f5;
                        f1 += f3 * f5;
                        f2 += f5;
                    }
                }
                f /= f2;
                f1 /= f2;
                f = f * 0.9f + 0.1f;
                f1 = (f1 * 4.0f - 1.0f) / 8.0f;
                double d13 = this.doubleArray4[i1] / 8000.0;
                if (d13 < 0.0) {
                    d13 = -d13 * 0.3;
                }
                if ((d13 = d13 * 3.0 - 2.0) < 0.0) {
                    if ((d13 /= 2.0) < -1.0) {
                        d13 = -1.0;
                    }
                    d13 /= 1.4;
                    d13 /= 2.0;
                } else {
                    if (d13 > 1.0) {
                        d13 = 1.0;
                    }
                    d13 /= 8.0;
                }
                ++i1;
                double d12 = f1;
                double d14 = f;
                d12 += d13 * 0.2;
                d12 = d12 * 8.5 / 8.0;
                double d5 = 8.5 + d12 * 4.0;
                for (int j2 = 0; j2 < 33; ++j2) {
                    double d6 = ((double)j2 - d5) * 12.0 * 128.0 / 256.0 / d14;
                    if (d6 < 0.0) {
                        d6 *= 4.0;
                    }
                    double d7 = this.doubleArray2[l] / 512.0;
                    double d8 = this.doubleArray3[l] / 512.0;
                    double d9 = (this.doubleArray1[l] / 10.0 + 1.0) / 2.0;
                    double d10 = MathHelper.func_151238_b((double)d7, (double)d8, (double)d9) - d6;
                    if (j2 > 29) {
                        double d11 = (float)(j2 - 29) / 3.0f;
                        d10 = d10 * (1.0 - d11) + -10.0 * d11;
                    }
                    this.field_147434_q[l] = d10;
                    ++l;
                }
            }
        }
    }

    public void func_185931_b(int x, int z) {
        int Xcoord2;
        int i;
        int i2;
        int l1;
        int k1;
        BlockFalling.field_149832_M = true;
        int k = x * 16;
        int l = z * 16;
        BlockPos pos = new BlockPos(k, 0, l);
        Biome Biome2 = this.worldObj.func_180494_b(pos.func_177982_a(16, 0, 16));
        this.rand.setSeed(this.worldObj.func_72905_C());
        long i1 = this.rand.nextLong() / 2L * 2L + 1L;
        long j1 = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)x * i1 + (long)z * j1 ^ this.worldObj.func_72905_C());
        boolean flag = false;
        ForgeEventFactory.onChunkPopulate((boolean)true, (IChunkGenerator)this, (World)this.worldObj, (Random)this.rand, (int)x, (int)z, (boolean)flag);
        if (this.mapFeaturesEnabled) {
            this.strongholdGenerator.func_175794_a(this.worldObj, this.rand, new ChunkPos(x, z));
        }
        if (ACConfig.generateCoraliumLake && TerrainGen.populate((IChunkGenerator)this, (World)this.worldObj, (Random)this.rand, (int)x, (int)z, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAKE) && !flag && this.rand.nextInt(6) == 0) {
            k1 = this.rand.nextInt(16) + 8;
            l1 = this.rand.nextInt(128);
            i2 = this.rand.nextInt(16) + 8;
            new WorldGenAbyLake(ACBlocks.liquid_coralium).func_180709_b(this.worldObj, this.rand, pos.func_177982_a(k1, l1, i2));
        }
        if (this.rand.nextFloat() < 0.15f) {
            k1 = this.rand.nextInt(16) + 8;
            l1 = this.rand.nextInt(128);
            i2 = this.rand.nextInt(16) + 8;
            new WorldGenAbyLake(ACBlocks.stone.func_176203_a(1)).func_180709_b(this.worldObj, this.rand, pos.func_177982_a(k1, l1, i2));
        }
        if (ACConfig.generateAbyssalWastelandPillars) {
            for (i = 0; i < 1; ++i) {
                int Xcoord1 = this.rand.nextInt(16) + 8;
                int Zcoord1 = this.rand.nextInt(16) + 8;
                if (!(this.rand.nextFloat() < 0.01f)) continue;
                new Chains().func_180709_b(this.worldObj, this.rand, pos.func_177982_a(Xcoord1, 0, Zcoord1));
            }
        }
        if (ACConfig.generateAbyssalWastelandRuins) {
            for (i = 0; i < 5; ++i) {
                Xcoord2 = this.rand.nextInt(16) + 8;
                int Ycoord2 = this.rand.nextInt(70);
                int Zcoord2 = this.rand.nextInt(16) + 8;
                new Abyruin().func_180709_b(this.worldObj, this.rand, pos.func_177982_a(Xcoord2, Ycoord2, Zcoord2));
            }
        }
        if (ACConfig.generateShoggothLairs) {
            for (i = 0; i < 1; ++i) {
                int Zcoord2;
                Xcoord2 = this.rand.nextInt(16) + 8;
                BlockPos pos1 = this.worldObj.func_175645_m(pos.func_177982_a(Xcoord2, 0, Zcoord2 = this.rand.nextInt(2) + 28));
                if (this.worldObj.func_180495_p(pos1).func_185904_a() == Material.field_151585_k) {
                    pos1 = pos1.func_177977_b();
                }
                if (this.rand.nextInt(200) != 0 || this.worldObj.func_175623_d(pos1.func_177964_d(13)) || this.worldObj.func_175623_d(pos1.func_177964_d(20)) || this.worldObj.func_175623_d(pos1.func_177964_d(27))) continue;
                new StructureShoggothPit().func_180709_b(this.worldObj, this.rand, pos1);
            }
        }
        Biome2.func_180624_a(this.worldObj, this.rand, new BlockPos(k, 0, l));
        ForgeEventFactory.onChunkPopulate((boolean)false, (IChunkGenerator)this, (World)this.worldObj, (Random)this.rand, (int)x, (int)z, (boolean)flag);
        BlockFalling.field_149832_M = false;
    }

    public List func_177458_a(EnumCreatureType par1EnumCreatureType, BlockPos pos) {
        Biome biome = this.worldObj.func_180494_b(pos);
        return biome == null ? null : biome.func_76747_a(par1EnumCreatureType);
    }

    public BlockPos func_180513_a(World par1World, String par2String, BlockPos pos, boolean bool) {
        return "AbyStronghold".equals(par2String) && this.strongholdGenerator != null ? this.strongholdGenerator.func_180706_b(par1World, pos, bool) : null;
    }

    public void func_180514_a(Chunk chunk, int x, int z) {
        if (this.mapFeaturesEnabled) {
            this.strongholdGenerator.func_186125_a(this.worldObj, x, z, null);
        }
    }

    public boolean func_185933_a(Chunk chunkIn, int x, int z) {
        return false;
    }

    public boolean func_193414_a(World par1World, String par2String, BlockPos pos) {
        return "AbyStronghold".equals(par2String) && this.strongholdGenerator != null ? this.strongholdGenerator.func_175795_b(pos) : false;
    }

    public void markStructureExplored(World world, String string, BlockPos pos) {
        if ("AbyStronghold".equals(string)) {
            this.strongholdGenerator.markStructureExplored(world, pos);
        }
    }
}

