/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.common.structures.omothol;

import com.google.common.collect.Lists;
import com.shinoow.abyssalcraft.api.block.ACBlocks;
import com.shinoow.abyssalcraft.common.entity.EntityRemnant;
import com.shinoow.abyssalcraft.common.structures.omothol.MapGenOmothol;
import com.shinoow.abyssalcraft.common.structures.omothol.StructureJzaharTemple;
import com.shinoow.abyssalcraft.lib.ACConfig;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.template.TemplateManager;

public class StructureOmotholPieces {
    public static void registerOmotholPieces() {
        MapGenStructureIO.func_143031_a(House1.class, (String)"OmtBH");
        MapGenStructureIO.func_143031_a(Field1.class, (String)"OmtDF");
        MapGenStructureIO.func_143031_a(Field2.class, (String)"OmtF");
        MapGenStructureIO.func_143031_a(Torch.class, (String)"OmtL");
        MapGenStructureIO.func_143031_a(Hall.class, (String)"OmtPH");
        MapGenStructureIO.func_143031_a(House4Garden.class, (String)"OmtSH");
        MapGenStructureIO.func_143031_a(WoodHut.class, (String)"OmtSmH");
        MapGenStructureIO.func_143031_a(Church.class, (String)"OmtST");
        MapGenStructureIO.func_143031_a(House2.class, (String)"OmtS");
        MapGenStructureIO.func_143031_a(Start.class, (String)"OmtStart");
        MapGenStructureIO.func_143031_a(Path.class, (String)"OmtSR");
        MapGenStructureIO.func_143031_a(House3.class, (String)"OmtTRH");
        MapGenStructureIO.func_143031_a(HouseBanker.class, (String)"OmtBH");
        MapGenStructureIO.func_143031_a(Well.class, (String)"OmtW");
    }

    public static List<PieceWeight> getStructureVillageWeightedPieceList(Random random, int p_75084_1_) {
        ArrayList list = Lists.newArrayList();
        list.add(new PieceWeight(House4Garden.class, 4, MathHelper.func_76136_a((Random)random, (int)(2 + p_75084_1_), (int)(4 + p_75084_1_ * 2))));
        list.add(new PieceWeight(Church.class, 20, MathHelper.func_76136_a((Random)random, (int)(0 + p_75084_1_), (int)(1 + p_75084_1_))));
        list.add(new PieceWeight(House1.class, 20, MathHelper.func_76136_a((Random)random, (int)(0 + p_75084_1_), (int)(2 + p_75084_1_))));
        list.add(new PieceWeight(WoodHut.class, 3, MathHelper.func_76136_a((Random)random, (int)(2 + p_75084_1_), (int)(5 + p_75084_1_ * 3))));
        list.add(new PieceWeight(Hall.class, 15, MathHelper.func_76136_a((Random)random, (int)(0 + p_75084_1_), (int)(2 + p_75084_1_))));
        list.add(new PieceWeight(Field1.class, 3, MathHelper.func_76136_a((Random)random, (int)(1 + p_75084_1_), (int)(4 + p_75084_1_))));
        list.add(new PieceWeight(Field2.class, 3, MathHelper.func_76136_a((Random)random, (int)(2 + p_75084_1_), (int)(4 + p_75084_1_ * 2))));
        list.add(new PieceWeight(House2.class, 15, MathHelper.func_76136_a((Random)random, (int)0, (int)(1 + p_75084_1_))));
        list.add(new PieceWeight(House3.class, 8, MathHelper.func_76136_a((Random)random, (int)(0 + p_75084_1_), (int)(3 + p_75084_1_ * 2))));
        list.add(new PieceWeight(HouseBanker.class, 8, MathHelper.func_76136_a((Random)random, (int)(2 + p_75084_1_), (int)(4 + p_75084_1_ * 2))));
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            if (((PieceWeight)iterator.next()).villagePiecesLimit != 0) continue;
            iterator.remove();
        }
        return list;
    }

    private static int func_75079_a(List<PieceWeight> p_75079_0_) {
        boolean flag = false;
        int i = 0;
        for (PieceWeight structurevillagepieces$pieceweight : p_75079_0_) {
            if (structurevillagepieces$pieceweight.villagePiecesLimit > 0 && structurevillagepieces$pieceweight.villagePiecesSpawned < structurevillagepieces$pieceweight.villagePiecesLimit) {
                flag = true;
            }
            i += structurevillagepieces$pieceweight.villagePieceWeight;
        }
        return flag ? i : -1;
    }

    private static Omothol func_176065_a(Start start, PieceWeight weight, List<StructureComponent> p_176065_2_, Random rand, int p_176065_4_, int p_176065_5_, int p_176065_6_, EnumFacing facing, int p_176065_8_) {
        Class<? extends Omothol> oclass = weight.villagePieceClass;
        Omothol structurevillagepieces$village = null;
        if (oclass == House4Garden.class) {
            structurevillagepieces$village = House4Garden.func_175858_a(start, p_176065_2_, rand, p_176065_4_, p_176065_5_, p_176065_6_, facing, p_176065_8_);
        } else if (oclass == Church.class) {
            structurevillagepieces$village = Church.func_175854_a(start, p_176065_2_, rand, p_176065_4_, p_176065_5_, p_176065_6_, facing, p_176065_8_);
        } else if (oclass == House1.class) {
            structurevillagepieces$village = House1.func_175850_a(start, p_176065_2_, rand, p_176065_4_, p_176065_5_, p_176065_6_, facing, p_176065_8_);
        } else if (oclass == WoodHut.class) {
            structurevillagepieces$village = WoodHut.func_175853_a(start, p_176065_2_, rand, p_176065_4_, p_176065_5_, p_176065_6_, facing, p_176065_8_);
        } else if (oclass == Hall.class) {
            structurevillagepieces$village = Hall.func_175857_a(start, p_176065_2_, rand, p_176065_4_, p_176065_5_, p_176065_6_, facing, p_176065_8_);
        } else if (oclass == Field1.class) {
            structurevillagepieces$village = Field1.func_175851_a(start, p_176065_2_, rand, p_176065_4_, p_176065_5_, p_176065_6_, facing, p_176065_8_);
        } else if (oclass == Field2.class) {
            structurevillagepieces$village = Field2.func_175852_a(start, p_176065_2_, rand, p_176065_4_, p_176065_5_, p_176065_6_, facing, p_176065_8_);
        } else if (oclass == House2.class) {
            structurevillagepieces$village = House2.func_175855_a(start, p_176065_2_, rand, p_176065_4_, p_176065_5_, p_176065_6_, facing, p_176065_8_);
        } else if (oclass == House3.class) {
            structurevillagepieces$village = House3.func_175849_a(start, p_176065_2_, rand, p_176065_4_, p_176065_5_, p_176065_6_, facing, p_176065_8_);
        } else if (oclass == HouseBanker.class) {
            structurevillagepieces$village = HouseBanker.func_175858_a(start, p_176065_2_, rand, p_176065_4_, p_176065_5_, p_176065_6_, facing, p_176065_8_);
        }
        return structurevillagepieces$village;
    }

    private static Omothol func_176067_c(Start start, List<StructureComponent> p_176067_1_, Random rand, int p_176067_3_, int p_176067_4_, int p_176067_5_, EnumFacing facing, int p_176067_7_) {
        int i = StructureOmotholPieces.func_75079_a(start.structureVillageWeightedPieceList);
        if (i <= 0) {
            return null;
        }
        int j = 0;
        block0: while (j < 5) {
            ++j;
            int k = rand.nextInt(i);
            for (PieceWeight structurevillagepieces$pieceweight : start.structureVillageWeightedPieceList) {
                if ((k -= structurevillagepieces$pieceweight.villagePieceWeight) >= 0) continue;
                if (!structurevillagepieces$pieceweight.canSpawnMoreVillagePiecesOfType(p_176067_7_) || structurevillagepieces$pieceweight == start.structVillagePieceWeight && start.structureVillageWeightedPieceList.size() > 1) continue block0;
                Omothol structurevillagepieces$village = StructureOmotholPieces.func_176065_a(start, structurevillagepieces$pieceweight, p_176067_1_, rand, p_176067_3_, p_176067_4_, p_176067_5_, facing, p_176067_7_);
                if (structurevillagepieces$village == null) continue;
                ++structurevillagepieces$pieceweight.villagePiecesSpawned;
                start.structVillagePieceWeight = structurevillagepieces$pieceweight;
                if (!structurevillagepieces$pieceweight.canSpawnMoreVillagePieces()) {
                    start.structureVillageWeightedPieceList.remove(structurevillagepieces$pieceweight);
                }
                return structurevillagepieces$village;
            }
        }
        StructureBoundingBox structureboundingbox = Torch.func_175856_a(start, p_176067_1_, rand, p_176067_3_, p_176067_4_, p_176067_5_, facing);
        if (structureboundingbox != null) {
            return new Torch(start, p_176067_7_, rand, structureboundingbox, facing);
        }
        return null;
    }

    private static StructureComponent func_176066_d(Start start, List<StructureComponent> p_176066_1_, Random rand, int p_176066_3_, int p_176066_4_, int p_176066_5_, EnumFacing facing, int p_176066_7_) {
        if (p_176066_7_ > 250) {
            return null;
        }
        if (Math.abs(p_176066_3_ - start.func_74874_b().field_78897_a) <= 4000 && Math.abs(p_176066_5_ - start.func_74874_b().field_78896_c) <= 4000) {
            Omothol structurecomponent = StructureOmotholPieces.func_176067_c(start, p_176066_1_, rand, p_176066_3_, p_176066_4_, p_176066_5_, facing, p_176066_7_ + 1);
            if (structurecomponent != null) {
                int i1;
                int i = (structurecomponent.func_74874_b().field_78897_a + structurecomponent.func_74874_b().field_78893_d) / 2;
                int j = (structurecomponent.func_74874_b().field_78896_c + structurecomponent.func_74874_b().field_78892_f) / 2;
                int k = structurecomponent.func_74874_b().field_78893_d - structurecomponent.func_74874_b().field_78897_a;
                int l = structurecomponent.func_74874_b().field_78892_f - structurecomponent.func_74874_b().field_78896_c;
                int n = i1 = k > l ? k : l;
                if (start.getWorldChunkManager().func_76940_a(i, j, i1 / 2 + 4, MapGenOmothol.villageSpawnBiomes)) {
                    p_176066_1_.add(structurecomponent);
                    start.field_74932_i.add(structurecomponent);
                    return structurecomponent;
                }
            }
            return null;
        }
        return null;
    }

    private static StructureComponent func_176069_e(Start start, List<StructureComponent> p_176069_1_, Random rand, int p_176069_3_, int p_176069_4_, int p_176069_5_, EnumFacing facing, int p_176069_7_) {
        if (p_176069_7_ > 3 + start.terrainType) {
            return null;
        }
        if (Math.abs(p_176069_3_ - start.func_74874_b().field_78897_a) <= 4000 && Math.abs(p_176069_5_ - start.func_74874_b().field_78896_c) <= 4000) {
            StructureBoundingBox structureboundingbox = Path.func_175848_a(start, p_176069_1_, rand, p_176069_3_, p_176069_4_, p_176069_5_, facing);
            if (structureboundingbox != null && structureboundingbox.field_78895_b > 10) {
                int i1;
                Path structurecomponent = new Path(start, p_176069_7_, rand, structureboundingbox, facing);
                int i = (structurecomponent.func_74874_b().field_78897_a + structurecomponent.func_74874_b().field_78893_d) / 2;
                int j = (structurecomponent.func_74874_b().field_78896_c + structurecomponent.func_74874_b().field_78892_f) / 2;
                int k = structurecomponent.func_74874_b().field_78893_d - structurecomponent.func_74874_b().field_78897_a;
                int l = structurecomponent.func_74874_b().field_78892_f - structurecomponent.func_74874_b().field_78896_c;
                int n = i1 = k > l ? k : l;
                if (start.getWorldChunkManager().func_76940_a(i, j, i1 / 2 + 4, MapGenOmothol.villageSpawnBiomes)) {
                    p_176069_1_.add(structurecomponent);
                    start.field_74930_j.add(structurecomponent);
                    return structurecomponent;
                }
            }
            return null;
        }
        return null;
    }

    public static class WoodHut
    extends Omothol {
        private boolean isTallHouse;
        private int tablePosition;

        public WoodHut() {
        }

        public WoodHut(Start start, int p_i45565_2_, Random rand, StructureBoundingBox p_i45565_4_, EnumFacing facing) {
            super(start, p_i45565_2_);
            this.func_186164_a(facing);
            this.field_74887_e = p_i45565_4_;
            this.isTallHouse = rand.nextBoolean();
            this.tablePosition = rand.nextInt(3);
        }

        @Override
        protected void func_143012_a(NBTTagCompound tagCompound) {
            super.func_143012_a(tagCompound);
            tagCompound.func_74768_a("T", this.tablePosition);
            tagCompound.func_74757_a("C", this.isTallHouse);
        }

        @Override
        protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager p_143011_2_) {
            super.func_143011_b(tagCompound, p_143011_2_);
            this.tablePosition = tagCompound.func_74762_e("T");
            this.isTallHouse = tagCompound.func_74767_n("C");
        }

        public static WoodHut func_175853_a(Start start, List<StructureComponent> p_175853_1_, Random rand, int p_175853_3_, int p_175853_4_, int p_175853_5_, EnumFacing facing, int p_175853_7_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)p_175853_3_, (int)p_175853_4_, (int)p_175853_5_, (int)0, (int)0, (int)0, (int)4, (int)6, (int)5, (EnumFacing)facing);
            return WoodHut.canVillageGoDeeper(structureboundingbox) && StructureComponent.func_74883_a(p_175853_1_, (StructureBoundingBox)structureboundingbox) == null ? new WoodHut(start, p_175853_7_, rand, structureboundingbox, facing) : null;
        }

        public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            if (this.field_143015_k < 0) {
                this.field_143015_k = this.getAverageGroundLevel(worldIn, structureBoundingBoxIn);
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78894_e + 6 - 1, 0);
            }
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 1, 1, 3, 5, 4, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 0, 0, 3, 0, 4, ACBlocks.ethaxium_brick.func_176223_P(), ACBlocks.ethaxium_brick.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 0, 1, 2, 0, 3, Blocks.field_150346_d.func_176223_P(), Blocks.field_150346_d.func_176223_P(), false);
            if (this.isTallHouse) {
                this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 4, 1, 2, 4, 3, ACBlocks.ethaxium_pillar.func_176223_P(), ACBlocks.ethaxium_pillar.func_176223_P(), false);
            } else {
                this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 5, 1, 2, 5, 3, ACBlocks.ethaxium_pillar.func_176223_P(), ACBlocks.ethaxium_pillar.func_176223_P(), false);
            }
            this.func_175811_a(worldIn, ACBlocks.ethaxium_pillar.func_176223_P(), 1, 4, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_pillar.func_176223_P(), 2, 4, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_pillar.func_176223_P(), 1, 4, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_pillar.func_176223_P(), 2, 4, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_pillar.func_176223_P(), 0, 4, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_pillar.func_176223_P(), 0, 4, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_pillar.func_176223_P(), 0, 4, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_pillar.func_176223_P(), 3, 4, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_pillar.func_176223_P(), 3, 4, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_pillar.func_176223_P(), 3, 4, 3, structureBoundingBoxIn);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 1, 0, 0, 3, 0, ACBlocks.ethaxium_pillar.func_176223_P(), ACBlocks.ethaxium_pillar.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 3, 1, 0, 3, 3, 0, ACBlocks.ethaxium_pillar.func_176223_P(), ACBlocks.ethaxium_pillar.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 1, 4, 0, 3, 4, ACBlocks.ethaxium_pillar.func_176223_P(), ACBlocks.ethaxium_pillar.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 3, 1, 4, 3, 3, 4, ACBlocks.ethaxium_pillar.func_176223_P(), ACBlocks.ethaxium_pillar.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 1, 1, 0, 3, 3, ACBlocks.ethaxium_brick.func_176223_P(), ACBlocks.ethaxium_brick.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 3, 1, 1, 3, 3, 3, ACBlocks.ethaxium_brick.func_176223_P(), ACBlocks.ethaxium_brick.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 1, 0, 2, 3, 0, ACBlocks.ethaxium_brick.func_176223_P(), ACBlocks.ethaxium_brick.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 1, 4, 2, 3, 4, ACBlocks.ethaxium_brick.func_176223_P(), ACBlocks.ethaxium_brick.func_176223_P(), false);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 0, 2, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 3, 2, 2, structureBoundingBoxIn);
            if (this.tablePosition > 0) {
                this.func_175811_a(worldIn, Blocks.field_180407_aO.func_176223_P(), this.tablePosition, 1, 3, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150452_aw.func_176223_P(), this.tablePosition, 2, 3, structureBoundingBoxIn);
            }
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 1, 1, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 1, 2, 0, structureBoundingBoxIn);
            this.placeDoorCurrentPosition(worldIn, structureBoundingBoxIn, randomIn, 1, 1, 0, EnumFacing.NORTH);
            if (this.func_175807_a(worldIn, 1, 0, -1, structureBoundingBoxIn).func_185904_a() == Material.field_151579_a && this.func_175807_a(worldIn, 1, -1, -1, structureBoundingBoxIn).func_185904_a() != Material.field_151579_a && ACConfig.ethaxium_brick_stairs) {
                this.func_175811_a(worldIn, ACBlocks.ethaxium_brick_stairs.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH), 1, 0, -1, structureBoundingBoxIn);
            }
            for (int i = 0; i < 5; ++i) {
                for (int j = 0; j < 4; ++j) {
                    this.func_74871_b(worldIn, j, 6, i, structureBoundingBoxIn);
                    this.func_175808_b(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), j, -1, i, structureBoundingBoxIn);
                }
            }
            this.spawnRemnants(worldIn, structureBoundingBoxIn, 1, 1, 2, 1);
            return true;
        }
    }

    public static class Well
    extends Omothol {
        public Well() {
        }

        public Well(Start start, int p_i2109_2_, Random rand, int p_i2109_4_, int p_i2109_5_) {
            super(start, p_i2109_2_);
            this.func_186164_a(EnumFacing.Plane.HORIZONTAL.func_179518_a(rand));
            switch (this.func_186165_e()) {
                case NORTH: 
                case SOUTH: {
                    this.field_74887_e = new StructureBoundingBox(-36, 54, 7, 44, 81, 98);
                    break;
                }
                default: {
                    this.field_74887_e = new StructureBoundingBox(-36, 54, 7, 44, 81, 98);
                }
            }
        }

        public void func_74861_a(StructureComponent componentIn, List<StructureComponent> listIn, Random rand) {
            StructureOmotholPieces.func_176069_e((Start)componentIn, listIn, rand, this.field_74887_e.field_78897_a + 36, this.field_74887_e.field_78894_e - 4, this.field_74887_e.field_78896_c - 6, EnumFacing.WEST, this.func_74877_c());
            StructureOmotholPieces.func_176069_e((Start)componentIn, listIn, rand, this.field_74887_e.field_78893_d - 36, this.field_74887_e.field_78894_e - 4, this.field_74887_e.field_78896_c - 6, EnumFacing.EAST, this.func_74877_c());
            StructureOmotholPieces.func_176069_e((Start)componentIn, listIn, rand, this.field_74887_e.field_78897_a - 5, this.field_74887_e.field_78894_e - 4, this.field_74887_e.field_78896_c + 30, EnumFacing.WEST, this.func_74877_c());
            StructureOmotholPieces.func_176069_e((Start)componentIn, listIn, rand, this.field_74887_e.field_78893_d + 5, this.field_74887_e.field_78894_e - 4, this.field_74887_e.field_78896_c + 30, EnumFacing.EAST, this.func_74877_c());
            StructureOmotholPieces.func_176069_e((Start)componentIn, listIn, rand, this.field_74887_e.field_78897_a - 5, this.field_74887_e.field_78894_e - 4, this.field_74887_e.field_78892_f - 30, EnumFacing.WEST, this.func_74877_c());
            StructureOmotholPieces.func_176069_e((Start)componentIn, listIn, rand, this.field_74887_e.field_78893_d + 5, this.field_74887_e.field_78894_e - 4, this.field_74887_e.field_78892_f - 30, EnumFacing.EAST, this.func_74877_c());
            StructureOmotholPieces.func_176069_e((Start)componentIn, listIn, rand, this.field_74887_e.field_78897_a + 39, this.field_74887_e.field_78894_e - 4, this.field_74887_e.field_78896_c - 8, EnumFacing.NORTH, this.func_74877_c());
            StructureOmotholPieces.func_176069_e((Start)componentIn, listIn, rand, this.field_74887_e.field_78897_a + 39, this.field_74887_e.field_78894_e - 4, this.field_74887_e.field_78892_f + 5, EnumFacing.SOUTH, this.func_74877_c());
        }

        public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            StructureJzaharTemple temple = new StructureJzaharTemple();
            temple.func_180709_b(worldIn, randomIn, new BlockPos(4, this.func_74862_a(0), 7));
            return true;
        }
    }

    public static abstract class Omothol
    extends StructureComponent {
        protected int field_143015_k = -1;
        private int remnantsSpawned;
        private boolean isDesertVillage;

        public Omothol() {
        }

        protected Omothol(Start start, int type) {
            super(type);
            if (start != null) {
                this.isDesertVillage = start.inDesert;
            }
        }

        protected void func_143012_a(NBTTagCompound tagCompound) {
            tagCompound.func_74768_a("HPos", this.field_143015_k);
            tagCompound.func_74768_a("VCount", this.remnantsSpawned);
            tagCompound.func_74757_a("Desert", this.isDesertVillage);
        }

        protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager p_143011_2_) {
            this.field_143015_k = tagCompound.func_74762_e("HPos");
            this.remnantsSpawned = tagCompound.func_74762_e("VCount");
            this.isDesertVillage = tagCompound.func_74767_n("Desert");
        }

        protected StructureComponent getNextComponentNN(Start start, List<StructureComponent> p_74891_2_, Random rand, int p_74891_4_, int p_74891_5_) {
            if (this.func_186165_e() != null) {
                switch (this.func_186165_e()) {
                    case NORTH: {
                        return StructureOmotholPieces.func_176066_d(start, p_74891_2_, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + p_74891_4_, this.field_74887_e.field_78896_c + p_74891_5_, EnumFacing.WEST, this.func_74877_c());
                    }
                    case SOUTH: {
                        return StructureOmotholPieces.func_176066_d(start, p_74891_2_, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + p_74891_4_, this.field_74887_e.field_78896_c + p_74891_5_, EnumFacing.WEST, this.func_74877_c());
                    }
                    case WEST: {
                        return StructureOmotholPieces.func_176066_d(start, p_74891_2_, rand, this.field_74887_e.field_78897_a + p_74891_5_, this.field_74887_e.field_78895_b + p_74891_4_, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, this.func_74877_c());
                    }
                    case EAST: {
                        return StructureOmotholPieces.func_176066_d(start, p_74891_2_, rand, this.field_74887_e.field_78897_a + p_74891_5_, this.field_74887_e.field_78895_b + p_74891_4_, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, this.func_74877_c());
                    }
                }
            }
            return null;
        }

        protected StructureComponent getNextComponentPP(Start start, List<StructureComponent> p_74894_2_, Random rand, int p_74894_4_, int p_74894_5_) {
            if (this.func_186165_e() != null) {
                switch (this.func_186165_e()) {
                    case NORTH: {
                        return StructureOmotholPieces.func_176066_d(start, p_74894_2_, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + p_74894_4_, this.field_74887_e.field_78896_c + p_74894_5_, EnumFacing.EAST, this.func_74877_c());
                    }
                    case SOUTH: {
                        return StructureOmotholPieces.func_176066_d(start, p_74894_2_, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + p_74894_4_, this.field_74887_e.field_78896_c + p_74894_5_, EnumFacing.EAST, this.func_74877_c());
                    }
                    case WEST: {
                        return StructureOmotholPieces.func_176066_d(start, p_74894_2_, rand, this.field_74887_e.field_78897_a + p_74894_5_, this.field_74887_e.field_78895_b + p_74894_4_, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, this.func_74877_c());
                    }
                    case EAST: {
                        return StructureOmotholPieces.func_176066_d(start, p_74894_2_, rand, this.field_74887_e.field_78897_a + p_74894_5_, this.field_74887_e.field_78895_b + p_74894_4_, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, this.func_74877_c());
                    }
                }
            }
            return null;
        }

        protected int getAverageGroundLevel(World worldIn, StructureBoundingBox p_74889_2_) {
            int i = 0;
            int j = 0;
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            for (int k = this.field_74887_e.field_78896_c; k <= this.field_74887_e.field_78892_f; ++k) {
                for (int l = this.field_74887_e.field_78897_a; l <= this.field_74887_e.field_78893_d; ++l) {
                    blockpos$mutableblockpos.func_181079_c(l, 64, k);
                    if (!p_74889_2_.func_175898_b((Vec3i)blockpos$mutableblockpos)) continue;
                    i += Math.max(worldIn.func_175672_r((BlockPos)blockpos$mutableblockpos).func_177956_o(), worldIn.field_73011_w.func_76557_i());
                    ++j;
                }
            }
            if (j == 0) {
                return -1;
            }
            return i / j;
        }

        protected static boolean canVillageGoDeeper(StructureBoundingBox p_74895_0_) {
            return p_74895_0_ != null && p_74895_0_.field_78895_b > 10;
        }

        protected void spawnRemnants(World worldIn, StructureBoundingBox p_74893_2_, int p_74893_3_, int p_74893_4_, int p_74893_5_, int p_74893_6_) {
            if (this.remnantsSpawned < p_74893_6_) {
                int l;
                int k;
                int j;
                for (int i = this.remnantsSpawned; i < p_74893_6_ && p_74893_2_.func_175898_b((Vec3i)new BlockPos(j = this.func_74865_a(p_74893_3_ + i, p_74893_5_), k = this.func_74862_a(p_74893_4_), l = this.func_74873_b(p_74893_3_ + i, p_74893_5_))); ++i) {
                    ++this.remnantsSpawned;
                    EntityRemnant remnant = new EntityRemnant(worldIn);
                    remnant.func_70012_b((double)j + 0.5, k, (double)l + 0.5, 0.0f, 0.0f);
                    remnant.func_180482_a(worldIn.func_175649_E(new BlockPos((Entity)remnant)), null);
                    remnant.setProfession(this.func_180779_c(i, remnant.getProfession()));
                    worldIn.func_72838_d((Entity)remnant);
                }
            }
        }

        protected int func_180779_c(int p_180779_1_, int p_180779_2_) {
            return p_180779_2_;
        }

        protected void func_175811_a(World worldIn, IBlockState blockstateIn, int x, int y, int z, StructureBoundingBox boundingboxIn) {
            super.func_175811_a(worldIn, blockstateIn, x, y, z, boundingboxIn);
        }

        protected void placeDoorCurrentPosition(World p_189927_1_, StructureBoundingBox p_189927_2_, Random p_189927_3_, int p_189927_4_, int p_189927_5_, int p_189927_6_, EnumFacing p_189927_7_) {
            this.func_189915_a(p_189927_1_, p_189927_2_, p_189927_3_, p_189927_4_, p_189927_5_, p_189927_6_, EnumFacing.NORTH, (BlockDoor)(p_189927_3_.nextBoolean() ? ACBlocks.darklands_oak_door : ACBlocks.dreadlands_door));
        }

        protected void func_175804_a(World worldIn, StructureBoundingBox boundingboxIn, int xMin, int yMin, int zMin, int xMax, int yMax, int zMax, IBlockState boundaryBlockState, IBlockState insideBlockState, boolean existingOnly) {
            super.func_175804_a(worldIn, boundingboxIn, xMin, yMin, zMin, xMax, yMax, zMax, boundaryBlockState, insideBlockState, existingOnly);
        }

        protected void func_175808_b(World worldIn, IBlockState blockstateIn, int x, int y, int z, StructureBoundingBox boundingboxIn) {
            super.func_175808_b(worldIn, blockstateIn, x, y, z, boundingboxIn);
        }
    }

    public static class Torch
    extends Omothol {
        public Torch() {
        }

        public Torch(Start start, int p_i45568_2_, Random rand, StructureBoundingBox p_i45568_4_, EnumFacing facing) {
            super(start, p_i45568_2_);
            this.func_186164_a(facing);
            this.field_74887_e = p_i45568_4_;
        }

        public static StructureBoundingBox func_175856_a(Start start, List<StructureComponent> p_175856_1_, Random rand, int p_175856_3_, int p_175856_4_, int p_175856_5_, EnumFacing facing) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)p_175856_3_, (int)p_175856_4_, (int)p_175856_5_, (int)0, (int)0, (int)0, (int)3, (int)4, (int)2, (EnumFacing)facing);
            return StructureComponent.func_74883_a(p_175856_1_, (StructureBoundingBox)structureboundingbox) != null ? null : structureboundingbox;
        }

        public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            if (this.field_143015_k < 0) {
                this.field_143015_k = this.getAverageGroundLevel(worldIn, structureBoundingBoxIn);
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78894_e + 4 - 1, 0);
            }
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 0, 0, 2, 3, 1, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_brick_fence.func_176223_P(), 1, 0, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_brick_fence.func_176223_P(), 1, 1, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_brick_fence.func_176223_P(), 1, 2, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150325_L.func_176203_a(EnumDyeColor.WHITE.func_176767_b()), 1, 3, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150478_aa.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.EAST), 2, 3, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150478_aa.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.NORTH), 1, 3, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150478_aa.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.WEST), 0, 3, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150478_aa.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.SOUTH), 1, 3, -1, structureBoundingBoxIn);
            return true;
        }
    }

    public static class Start
    extends Well {
        public BiomeProvider worldChunkMngr;
        public boolean inDesert;
        public int terrainType;
        public PieceWeight structVillagePieceWeight;
        public List<PieceWeight> structureVillageWeightedPieceList;
        public List<StructureComponent> field_74932_i = Lists.newArrayList();
        public List<StructureComponent> field_74930_j = Lists.newArrayList();
        public Biome biome;

        public Start() {
        }

        public Start(BiomeProvider chunkManagerIn, int p_i2104_2_, Random rand, int p_i2104_4_, int p_i2104_5_, List<PieceWeight> p_i2104_6_, int p_i2104_7_) {
            super(null, 0, rand, p_i2104_4_, p_i2104_5_);
            Biome biomegenbase;
            this.worldChunkMngr = chunkManagerIn;
            this.structureVillageWeightedPieceList = p_i2104_6_;
            this.terrainType = p_i2104_7_;
            this.biome = biomegenbase = chunkManagerIn.func_180300_a(new BlockPos(p_i2104_4_, 0, p_i2104_5_), Biomes.field_76771_b);
        }

        public BiomeProvider getWorldChunkManager() {
            return this.worldChunkMngr;
        }
    }

    public static abstract class Road
    extends Omothol {
        public Road() {
        }

        protected Road(Start start, int type) {
            super(start, type);
        }
    }

    public static class PieceWeight {
        public Class<? extends Omothol> villagePieceClass;
        public final int villagePieceWeight;
        public int villagePiecesSpawned;
        public int villagePiecesLimit;

        public PieceWeight(Class<? extends Omothol> p_i2098_1_, int p_i2098_2_, int p_i2098_3_) {
            this.villagePieceClass = p_i2098_1_;
            this.villagePieceWeight = p_i2098_2_;
            this.villagePiecesLimit = p_i2098_3_;
        }

        public boolean canSpawnMoreVillagePiecesOfType(int p_75085_1_) {
            return this.villagePiecesLimit == 0 || this.villagePiecesSpawned < this.villagePiecesLimit;
        }

        public boolean canSpawnMoreVillagePieces() {
            return this.villagePiecesLimit == 0 || this.villagePiecesSpawned < this.villagePiecesLimit;
        }
    }

    public static class Path
    extends Road {
        private int length;

        public Path() {
        }

        public Path(Start start, int p_i45562_2_, Random rand, StructureBoundingBox p_i45562_4_, EnumFacing facing) {
            super(start, p_i45562_2_);
            this.func_186164_a(facing);
            this.field_74887_e = p_i45562_4_;
            this.length = Math.max(p_i45562_4_.func_78883_b(), p_i45562_4_.func_78880_d());
        }

        @Override
        protected void func_143012_a(NBTTagCompound tagCompound) {
            super.func_143012_a(tagCompound);
            tagCompound.func_74768_a("Length", this.length);
        }

        @Override
        protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager p_143011_2_) {
            super.func_143011_b(tagCompound, p_143011_2_);
            this.length = tagCompound.func_74762_e("Length");
        }

        public void func_74861_a(StructureComponent componentIn, List<StructureComponent> listIn, Random rand) {
            boolean flag = false;
            for (int i = rand.nextInt(5); i < this.length - 8; i += 2 + rand.nextInt(5)) {
                StructureComponent structurecomponent = this.getNextComponentNN((Start)componentIn, listIn, rand, 0, i);
                if (structurecomponent == null) continue;
                i += Math.max(structurecomponent.func_74874_b().func_78883_b(), structurecomponent.func_74874_b().func_78880_d());
                flag = true;
            }
            for (int j = rand.nextInt(5); j < this.length - 8; j += 2 + rand.nextInt(5)) {
                StructureComponent structurecomponent1 = this.getNextComponentPP((Start)componentIn, listIn, rand, 0, j);
                if (structurecomponent1 == null) continue;
                j += Math.max(structurecomponent1.func_74874_b().func_78883_b(), structurecomponent1.func_74874_b().func_78880_d());
                flag = true;
            }
            if (flag && rand.nextInt(3) > 0 && this.func_186165_e() != null) {
                switch (this.func_186165_e()) {
                    case NORTH: {
                        StructureOmotholPieces.func_176069_e((Start)componentIn, listIn, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, EnumFacing.WEST, this.func_74877_c());
                        break;
                    }
                    case SOUTH: {
                        StructureOmotholPieces.func_176069_e((Start)componentIn, listIn, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f - 2, EnumFacing.WEST, this.func_74877_c());
                        break;
                    }
                    case WEST: {
                        StructureOmotholPieces.func_176069_e((Start)componentIn, listIn, rand, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, this.func_74877_c());
                        break;
                    }
                    case EAST: {
                        StructureOmotholPieces.func_176069_e((Start)componentIn, listIn, rand, this.field_74887_e.field_78893_d - 2, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, this.func_74877_c());
                    }
                }
            }
            if (flag && rand.nextInt(3) > 0 && this.func_186165_e() != null) {
                switch (this.func_186165_e()) {
                    case NORTH: {
                        StructureOmotholPieces.func_176069_e((Start)componentIn, listIn, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, EnumFacing.EAST, this.func_74877_c());
                        break;
                    }
                    case SOUTH: {
                        StructureOmotholPieces.func_176069_e((Start)componentIn, listIn, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f - 2, EnumFacing.EAST, this.func_74877_c());
                        break;
                    }
                    case WEST: {
                        StructureOmotholPieces.func_176069_e((Start)componentIn, listIn, rand, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, this.func_74877_c());
                        break;
                    }
                    case EAST: {
                        StructureOmotholPieces.func_176069_e((Start)componentIn, listIn, rand, this.field_74887_e.field_78893_d - 2, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, this.func_74877_c());
                    }
                }
            }
        }

        public static StructureBoundingBox func_175848_a(Start start, List<StructureComponent> p_175848_1_, Random rand, int p_175848_3_, int p_175848_4_, int p_175848_5_, EnumFacing facing) {
            for (int i = 7 * MathHelper.func_76136_a((Random)rand, (int)3, (int)5); i >= 7; i -= 7) {
                StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)p_175848_3_, (int)p_175848_4_, (int)p_175848_5_, (int)0, (int)0, (int)0, (int)3, (int)3, (int)i, (EnumFacing)facing);
                if (StructureComponent.func_74883_a(p_175848_1_, (StructureBoundingBox)structureboundingbox) != null) continue;
                return structureboundingbox;
            }
            return null;
        }

        public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            for (int i = this.field_74887_e.field_78897_a; i <= this.field_74887_e.field_78893_d; ++i) {
                for (int j = this.field_74887_e.field_78896_c; j <= this.field_74887_e.field_78892_f; ++j) {
                    BlockPos blockpos = new BlockPos(i, 64, j);
                    if (!structureBoundingBoxIn.func_175898_b((Vec3i)blockpos)) continue;
                    BlockPos blockpos1 = blockpos;
                    switch (this.func_186165_e()) {
                        case NORTH: {
                            blockpos1 = blockpos.func_177968_d();
                            break;
                        }
                        case SOUTH: {
                            blockpos1 = blockpos.func_177978_c();
                            break;
                        }
                        case EAST: {
                            blockpos1 = blockpos.func_177976_e();
                            break;
                        }
                        case WEST: {
                            blockpos1 = blockpos.func_177974_f();
                        }
                    }
                    blockpos = worldIn.func_175672_r(blockpos).func_177977_b();
                    blockpos1 = worldIn.func_175672_r(blockpos1).func_177977_b();
                    if (blockpos1.func_177956_o() > blockpos.func_177956_o() && blockpos.func_177956_o() <= 40) {
                        blockpos = new BlockPos(blockpos.func_177958_n(), blockpos1.func_177956_o(), blockpos.func_177952_p());
                    }
                    if (worldIn.func_175672_r(blockpos).func_177977_b().func_177956_o() <= 40 && blockpos.func_177956_o() <= 49) {
                        blockpos = new BlockPos(blockpos.func_177958_n(), 49, blockpos.func_177952_p());
                    }
                    worldIn.func_180501_a(blockpos, ACBlocks.stone.func_176203_a(5), 2);
                }
            }
            return true;
        }
    }

    public static class HouseBanker
    extends Omothol {
        private boolean isRoofAccessible;

        public HouseBanker() {
        }

        public HouseBanker(Start start, int p_i45566_2_, Random rand, StructureBoundingBox p_i45566_4_, EnumFacing facing) {
            super(start, p_i45566_2_);
            this.func_186164_a(facing);
            this.field_74887_e = p_i45566_4_;
            this.isRoofAccessible = rand.nextBoolean();
        }

        @Override
        protected void func_143012_a(NBTTagCompound tagCompound) {
            super.func_143012_a(tagCompound);
            tagCompound.func_74757_a("Terrace", this.isRoofAccessible);
        }

        @Override
        protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager p_143011_2_) {
            super.func_143011_b(tagCompound, p_143011_2_);
            this.isRoofAccessible = tagCompound.func_74767_n("Terrace");
        }

        public static HouseBanker func_175858_a(Start start, List<StructureComponent> p_175858_1_, Random rand, int p_175858_3_, int p_175858_4_, int p_175858_5_, EnumFacing facing, int p_175858_7_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)p_175858_3_, (int)p_175858_4_, (int)p_175858_5_, (int)0, (int)0, (int)0, (int)5, (int)6, (int)5, (EnumFacing)facing);
            return StructureComponent.func_74883_a(p_175858_1_, (StructureBoundingBox)structureboundingbox) != null ? null : new HouseBanker(start, p_175858_7_, rand, structureboundingbox, facing);
        }

        public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            if (this.field_143015_k < 0) {
                this.field_143015_k = this.getAverageGroundLevel(worldIn, structureBoundingBoxIn);
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78894_e + 6 - 1, 0);
            }
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 0, 0, 4, 0, 4, ACBlocks.ethaxium_brick.func_176223_P(), ACBlocks.ethaxium_brick.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 4, 0, 4, 4, 4, ACBlocks.ethaxium_pillar.func_176223_P(), ACBlocks.ethaxium_pillar.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 4, 1, 3, 4, 3, ACBlocks.ethaxium_brick.func_176223_P(), ACBlocks.ethaxium_brick.func_176223_P(), false);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), 0, 1, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), 0, 2, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), 0, 3, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), 4, 1, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), 4, 2, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), 4, 3, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), 0, 1, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), 0, 2, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), 0, 3, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), 4, 1, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), 4, 2, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), 4, 3, 4, structureBoundingBoxIn);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 1, 1, 0, 3, 3, ACBlocks.ethaxium_brick.func_176223_P(), ACBlocks.ethaxium_brick.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 4, 1, 1, 4, 3, 3, ACBlocks.ethaxium_brick.func_176223_P(), ACBlocks.ethaxium_brick.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 1, 4, 3, 3, 4, ACBlocks.ethaxium_brick.func_176223_P(), ACBlocks.ethaxium_brick.func_176223_P(), false);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 0, 2, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 2, 2, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 4, 2, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), 1, 1, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), 1, 2, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), 1, 3, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), 2, 3, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), 3, 3, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), 3, 2, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), 3, 1, 0, structureBoundingBoxIn);
            if (this.func_175807_a(worldIn, 2, 0, -1, structureBoundingBoxIn).func_185904_a() == Material.field_151579_a && this.func_175807_a(worldIn, 2, -1, -1, structureBoundingBoxIn).func_185904_a() != Material.field_151579_a && ACConfig.ethaxium_brick_stairs) {
                this.func_175811_a(worldIn, ACBlocks.ethaxium_brick_stairs.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH), 2, 0, -1, structureBoundingBoxIn);
            }
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 1, 1, 3, 3, 3, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 5, 0, 4, 5, 4, ACBlocks.ethaxium_brick.func_176223_P(), ACBlocks.ethaxium_brick.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 9, 0, 4, 9, 4, ACBlocks.ethaxium_pillar.func_176223_P(), ACBlocks.ethaxium_pillar.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 9, 1, 3, 9, 3, ACBlocks.ethaxium_brick.func_176223_P(), ACBlocks.ethaxium_brick.func_176223_P(), false);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), 0, 6, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), 0, 7, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), 0, 8, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), 4, 6, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), 4, 7, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), 4, 8, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), 0, 6, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), 0, 7, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), 0, 8, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), 4, 6, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), 4, 7, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), 4, 8, 4, structureBoundingBoxIn);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 6, 1, 0, 8, 3, ACBlocks.ethaxium_brick.func_176223_P(), ACBlocks.ethaxium_brick.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 6, 0, 3, 8, 0, ACBlocks.ethaxium_brick.func_176223_P(), ACBlocks.ethaxium_brick.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 4, 6, 1, 4, 8, 3, ACBlocks.ethaxium_brick.func_176223_P(), ACBlocks.ethaxium_brick.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 6, 4, 3, 8, 4, ACBlocks.ethaxium_brick.func_176223_P(), ACBlocks.ethaxium_brick.func_176223_P(), false);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 0, 7, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 2, 7, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 4, 7, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 2, 7, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), 1, 6, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), 1, 7, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), 1, 8, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), 2, 8, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), 3, 8, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), 3, 7, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), 3, 6, 0, structureBoundingBoxIn);
            if (this.isRoofAccessible) {
                this.func_175811_a(worldIn, ACBlocks.ethaxium_brick_fence.func_176223_P(), 0, 10, 0, structureBoundingBoxIn);
                this.func_175811_a(worldIn, ACBlocks.ethaxium_brick_fence.func_176223_P(), 1, 10, 0, structureBoundingBoxIn);
                this.func_175811_a(worldIn, ACBlocks.ethaxium_brick_fence.func_176223_P(), 2, 10, 0, structureBoundingBoxIn);
                this.func_175811_a(worldIn, ACBlocks.ethaxium_brick_fence.func_176223_P(), 3, 10, 0, structureBoundingBoxIn);
                this.func_175811_a(worldIn, ACBlocks.ethaxium_brick_fence.func_176223_P(), 4, 10, 0, structureBoundingBoxIn);
                this.func_175811_a(worldIn, ACBlocks.ethaxium_brick_fence.func_176223_P(), 0, 10, 4, structureBoundingBoxIn);
                this.func_175811_a(worldIn, ACBlocks.ethaxium_brick_fence.func_176223_P(), 1, 10, 4, structureBoundingBoxIn);
                this.func_175811_a(worldIn, ACBlocks.ethaxium_brick_fence.func_176223_P(), 2, 10, 4, structureBoundingBoxIn);
                this.func_175811_a(worldIn, ACBlocks.ethaxium_brick_fence.func_176223_P(), 3, 10, 4, structureBoundingBoxIn);
                this.func_175811_a(worldIn, ACBlocks.ethaxium_brick_fence.func_176223_P(), 4, 10, 4, structureBoundingBoxIn);
                this.func_175811_a(worldIn, ACBlocks.ethaxium_brick_fence.func_176223_P(), 4, 10, 1, structureBoundingBoxIn);
                this.func_175811_a(worldIn, ACBlocks.ethaxium_brick_fence.func_176223_P(), 4, 10, 2, structureBoundingBoxIn);
                this.func_175811_a(worldIn, ACBlocks.ethaxium_brick_fence.func_176223_P(), 4, 10, 3, structureBoundingBoxIn);
                this.func_175811_a(worldIn, ACBlocks.ethaxium_brick_fence.func_176223_P(), 0, 10, 1, structureBoundingBoxIn);
                this.func_175811_a(worldIn, ACBlocks.ethaxium_brick_fence.func_176223_P(), 0, 10, 2, structureBoundingBoxIn);
                this.func_175811_a(worldIn, ACBlocks.ethaxium_brick_fence.func_176223_P(), 0, 10, 3, structureBoundingBoxIn);
            }
            IBlockState iblockstate = Blocks.field_150468_ap.func_176223_P().func_177226_a((IProperty)BlockLadder.field_176382_a, (Comparable)EnumFacing.SOUTH);
            this.func_175811_a(worldIn, iblockstate, 3, 1, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate, 3, 2, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate, 3, 3, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate, 3, 4, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate, 3, 5, 3, structureBoundingBoxIn);
            if (this.isRoofAccessible) {
                this.func_175811_a(worldIn, iblockstate, 3, 6, 3, structureBoundingBoxIn);
                this.func_175811_a(worldIn, iblockstate, 3, 7, 3, structureBoundingBoxIn);
                this.func_175811_a(worldIn, iblockstate, 3, 8, 3, structureBoundingBoxIn);
                this.func_175811_a(worldIn, iblockstate, 3, 9, 3, structureBoundingBoxIn);
            }
            this.func_175811_a(worldIn, Blocks.field_150478_aa.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)this.func_186165_e()), 2, 3, 1, structureBoundingBoxIn);
            for (int k = 0; k < 5; ++k) {
                for (int j = 0; j < 5; ++j) {
                    this.func_74871_b(worldIn, j, 11, k, structureBoundingBoxIn);
                    this.func_175808_b(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), j, -1, k, structureBoundingBoxIn);
                }
            }
            this.spawnRemnants(worldIn, structureBoundingBoxIn, 1, 1, 2, 1);
            return true;
        }

        @Override
        protected int func_180779_c(int p_180779_1_, int p_180779_2_) {
            return 5;
        }
    }

    public static class House4Garden
    extends Omothol {
        private boolean isRoofAccessible;

        public House4Garden() {
        }

        public House4Garden(Start start, int p_i45566_2_, Random rand, StructureBoundingBox p_i45566_4_, EnumFacing facing) {
            super(start, p_i45566_2_);
            this.func_186164_a(facing);
            this.field_74887_e = p_i45566_4_;
            this.isRoofAccessible = rand.nextBoolean();
        }

        @Override
        protected void func_143012_a(NBTTagCompound tagCompound) {
            super.func_143012_a(tagCompound);
            tagCompound.func_74757_a("Terrace", this.isRoofAccessible);
        }

        @Override
        protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager p_143011_2_) {
            super.func_143011_b(tagCompound, p_143011_2_);
            this.isRoofAccessible = tagCompound.func_74767_n("Terrace");
        }

        public static House4Garden func_175858_a(Start start, List<StructureComponent> p_175858_1_, Random rand, int p_175858_3_, int p_175858_4_, int p_175858_5_, EnumFacing facing, int p_175858_7_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)p_175858_3_, (int)p_175858_4_, (int)p_175858_5_, (int)0, (int)0, (int)0, (int)5, (int)6, (int)5, (EnumFacing)facing);
            return StructureComponent.func_74883_a(p_175858_1_, (StructureBoundingBox)structureboundingbox) != null ? null : new House4Garden(start, p_175858_7_, rand, structureboundingbox, facing);
        }

        public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            if (this.field_143015_k < 0) {
                this.field_143015_k = this.getAverageGroundLevel(worldIn, structureBoundingBoxIn);
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78894_e + 6 - 1, 0);
            }
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 0, 0, 4, 0, 4, ACBlocks.ethaxium_brick.func_176223_P(), ACBlocks.ethaxium_brick.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 4, 0, 4, 4, 4, ACBlocks.ethaxium_pillar.func_176223_P(), ACBlocks.ethaxium_pillar.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 4, 1, 3, 4, 3, ACBlocks.ethaxium_brick.func_176223_P(), ACBlocks.ethaxium_brick.func_176223_P(), false);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), 0, 1, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), 0, 2, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), 0, 3, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), 4, 1, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), 4, 2, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), 4, 3, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), 0, 1, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), 0, 2, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), 0, 3, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), 4, 1, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), 4, 2, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), 4, 3, 4, structureBoundingBoxIn);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 1, 1, 0, 3, 3, ACBlocks.ethaxium_brick.func_176223_P(), ACBlocks.ethaxium_brick.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 4, 1, 1, 4, 3, 3, ACBlocks.ethaxium_brick.func_176223_P(), ACBlocks.ethaxium_brick.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 1, 4, 3, 3, 4, ACBlocks.ethaxium_brick.func_176223_P(), ACBlocks.ethaxium_brick.func_176223_P(), false);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 0, 2, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 2, 2, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 4, 2, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), 1, 1, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), 1, 2, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), 1, 3, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), 2, 3, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), 3, 3, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), 3, 2, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), 3, 1, 0, structureBoundingBoxIn);
            if (this.func_175807_a(worldIn, 2, 0, -1, structureBoundingBoxIn).func_185904_a() == Material.field_151579_a && this.func_175807_a(worldIn, 2, -1, -1, structureBoundingBoxIn).func_185904_a() != Material.field_151579_a && ACConfig.ethaxium_brick_stairs) {
                this.func_175811_a(worldIn, ACBlocks.ethaxium_brick_stairs.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH), 2, 0, -1, structureBoundingBoxIn);
            }
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 1, 1, 3, 3, 3, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            if (this.isRoofAccessible) {
                this.func_175811_a(worldIn, ACBlocks.ethaxium_brick_fence.func_176223_P(), 0, 5, 0, structureBoundingBoxIn);
                this.func_175811_a(worldIn, ACBlocks.ethaxium_brick_fence.func_176223_P(), 1, 5, 0, structureBoundingBoxIn);
                this.func_175811_a(worldIn, ACBlocks.ethaxium_brick_fence.func_176223_P(), 2, 5, 0, structureBoundingBoxIn);
                this.func_175811_a(worldIn, ACBlocks.ethaxium_brick_fence.func_176223_P(), 3, 5, 0, structureBoundingBoxIn);
                this.func_175811_a(worldIn, ACBlocks.ethaxium_brick_fence.func_176223_P(), 4, 5, 0, structureBoundingBoxIn);
                this.func_175811_a(worldIn, ACBlocks.ethaxium_brick_fence.func_176223_P(), 0, 5, 4, structureBoundingBoxIn);
                this.func_175811_a(worldIn, ACBlocks.ethaxium_brick_fence.func_176223_P(), 1, 5, 4, structureBoundingBoxIn);
                this.func_175811_a(worldIn, ACBlocks.ethaxium_brick_fence.func_176223_P(), 2, 5, 4, structureBoundingBoxIn);
                this.func_175811_a(worldIn, ACBlocks.ethaxium_brick_fence.func_176223_P(), 3, 5, 4, structureBoundingBoxIn);
                this.func_175811_a(worldIn, ACBlocks.ethaxium_brick_fence.func_176223_P(), 4, 5, 4, structureBoundingBoxIn);
                this.func_175811_a(worldIn, ACBlocks.ethaxium_brick_fence.func_176223_P(), 4, 5, 1, structureBoundingBoxIn);
                this.func_175811_a(worldIn, ACBlocks.ethaxium_brick_fence.func_176223_P(), 4, 5, 2, structureBoundingBoxIn);
                this.func_175811_a(worldIn, ACBlocks.ethaxium_brick_fence.func_176223_P(), 4, 5, 3, structureBoundingBoxIn);
                this.func_175811_a(worldIn, ACBlocks.ethaxium_brick_fence.func_176223_P(), 0, 5, 1, structureBoundingBoxIn);
                this.func_175811_a(worldIn, ACBlocks.ethaxium_brick_fence.func_176223_P(), 0, 5, 2, structureBoundingBoxIn);
                this.func_175811_a(worldIn, ACBlocks.ethaxium_brick_fence.func_176223_P(), 0, 5, 3, structureBoundingBoxIn);
            }
            if (this.isRoofAccessible) {
                IBlockState iblockstate = Blocks.field_150468_ap.func_176223_P().func_177226_a((IProperty)BlockLadder.field_176382_a, (Comparable)EnumFacing.SOUTH);
                this.func_175811_a(worldIn, iblockstate, 3, 1, 3, structureBoundingBoxIn);
                this.func_175811_a(worldIn, iblockstate, 3, 2, 3, structureBoundingBoxIn);
                this.func_175811_a(worldIn, iblockstate, 3, 3, 3, structureBoundingBoxIn);
                this.func_175811_a(worldIn, iblockstate, 3, 4, 3, structureBoundingBoxIn);
            }
            this.func_175811_a(worldIn, Blocks.field_150478_aa.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)this.func_186165_e()), 2, 3, 1, structureBoundingBoxIn);
            for (int k = 0; k < 5; ++k) {
                for (int j = 0; j < 5; ++j) {
                    this.func_74871_b(worldIn, j, 6, k, structureBoundingBoxIn);
                    this.func_175808_b(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), j, -1, k, structureBoundingBoxIn);
                }
            }
            this.spawnRemnants(worldIn, structureBoundingBoxIn, 1, 1, 2, 1);
            return true;
        }
    }

    public static class House3
    extends Omothol {
        public House3() {
        }

        public House3(Start start, int p_i45561_2_, Random rand, StructureBoundingBox p_i45561_4_, EnumFacing facing) {
            super(start, p_i45561_2_);
            this.func_186164_a(facing);
            this.field_74887_e = p_i45561_4_;
        }

        public static House3 func_175849_a(Start start, List<StructureComponent> p_175849_1_, Random rand, int p_175849_3_, int p_175849_4_, int p_175849_5_, EnumFacing facing, int p_175849_7_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)p_175849_3_, (int)p_175849_4_, (int)p_175849_5_, (int)0, (int)0, (int)0, (int)9, (int)7, (int)12, (EnumFacing)facing);
            return House3.canVillageGoDeeper(structureboundingbox) && StructureComponent.func_74883_a(p_175849_1_, (StructureBoundingBox)structureboundingbox) == null ? new House3(start, p_175849_7_, rand, structureboundingbox, facing) : null;
        }

        public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            if (this.field_143015_k < 0) {
                this.field_143015_k = this.getAverageGroundLevel(worldIn, structureBoundingBoxIn);
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78894_e + 7 - 1, 0);
            }
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 1, 1, 7, 4, 4, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 2, 1, 6, 8, 4, 10, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 2, 0, 5, 8, 0, 10, ACBlocks.ethaxium_brick.func_176223_P(), ACBlocks.ethaxium_brick.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 0, 1, 7, 0, 4, ACBlocks.ethaxium_brick.func_176223_P(), ACBlocks.ethaxium_brick.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 0, 0, 0, 3, 5, ACBlocks.ethaxium_brick.func_176223_P(), ACBlocks.ethaxium_brick.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 8, 0, 0, 8, 3, 10, ACBlocks.ethaxium_brick.func_176223_P(), ACBlocks.ethaxium_brick.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 0, 0, 7, 2, 0, ACBlocks.ethaxium_brick.func_176223_P(), ACBlocks.ethaxium_brick.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 0, 5, 2, 1, 5, ACBlocks.ethaxium_brick.func_176223_P(), ACBlocks.ethaxium_brick.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 2, 0, 6, 2, 3, 10, ACBlocks.ethaxium_brick.func_176223_P(), ACBlocks.ethaxium_brick.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 3, 0, 10, 7, 3, 10, ACBlocks.ethaxium_brick.func_176223_P(), ACBlocks.ethaxium_brick.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 2, 0, 7, 3, 0, ACBlocks.ethaxium_brick.func_176223_P(), ACBlocks.ethaxium_brick.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 2, 5, 2, 3, 5, ACBlocks.ethaxium_brick.func_176223_P(), ACBlocks.ethaxium_brick.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 4, 1, 8, 4, 1, ACBlocks.ethaxium_brick.func_176223_P(), ACBlocks.ethaxium_brick.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 4, 4, 3, 4, 4, ACBlocks.ethaxium_brick.func_176223_P(), ACBlocks.ethaxium_brick.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 5, 2, 8, 5, 3, ACBlocks.ethaxium_brick.func_176223_P(), ACBlocks.ethaxium_brick.func_176223_P(), false);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), 0, 4, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), 0, 4, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), 8, 4, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), 8, 4, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), 8, 4, 4, structureBoundingBoxIn);
            if (ACConfig.ethaxium_brick_stairs) {
                IBlockState iblockstate = ACBlocks.ethaxium_brick_stairs.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH);
                IBlockState iblockstate1 = ACBlocks.ethaxium_brick_stairs.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.SOUTH);
                IBlockState iblockstate2 = ACBlocks.ethaxium_brick_stairs.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.WEST);
                IBlockState iblockstate3 = ACBlocks.ethaxium_brick_stairs.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.EAST);
                for (int k = -1; k <= 2; ++k) {
                    for (int l = 0; l <= 8; ++l) {
                        this.func_175811_a(worldIn, iblockstate, l, 4 + k, k, structureBoundingBoxIn);
                        if (k <= -1 && l > 1 || k <= 0 && l > 3 || k <= 1 && l > 4 && l < 6) continue;
                        this.func_175811_a(worldIn, iblockstate1, l, 4 + k, 5 - k, structureBoundingBoxIn);
                    }
                }
                for (int l1 = 4; l1 >= 1; --l1) {
                    this.func_175811_a(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), l1, 2 + l1, 7 - l1, structureBoundingBoxIn);
                    for (int i1 = 8 - l1; i1 <= 10; ++i1) {
                        this.func_175811_a(worldIn, iblockstate3, l1, 2 + l1, i1, structureBoundingBoxIn);
                    }
                }
                this.func_175811_a(worldIn, iblockstate2, 6, 6, 4, structureBoundingBoxIn);
                for (int j2 = 6; j2 <= 8; ++j2) {
                    for (int j1 = 5; j1 <= 10; ++j1) {
                        this.func_175811_a(worldIn, iblockstate2, j2, 12 - j2, j1, structureBoundingBoxIn);
                    }
                }
                if (this.func_175807_a(worldIn, 2, 0, -1, structureBoundingBoxIn).func_185904_a() == Material.field_151579_a && this.func_175807_a(worldIn, 2, -1, -1, structureBoundingBoxIn).func_185904_a() != Material.field_151579_a) {
                    this.func_175811_a(worldIn, iblockstate, 2, 0, -1, structureBoundingBoxIn);
                }
            }
            this.func_175804_a(worldIn, structureBoundingBoxIn, 3, 4, 5, 3, 4, 10, ACBlocks.ethaxium_brick.func_176223_P(), ACBlocks.ethaxium_brick.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 7, 4, 2, 7, 4, 10, ACBlocks.ethaxium_brick.func_176223_P(), ACBlocks.ethaxium_brick.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 4, 5, 4, 4, 5, 10, ACBlocks.ethaxium_brick.func_176223_P(), ACBlocks.ethaxium_brick.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 6, 5, 4, 6, 5, 10, ACBlocks.ethaxium_brick.func_176223_P(), ACBlocks.ethaxium_brick.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 5, 6, 3, 5, 6, 10, ACBlocks.ethaxium_brick.func_176223_P(), ACBlocks.ethaxium_brick.func_176223_P(), false);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), 6, 6, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), 7, 5, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_pillar.func_176223_P(), 0, 2, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_pillar.func_176223_P(), 0, 2, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 0, 2, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 0, 2, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_pillar.func_176223_P(), 4, 2, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 5, 2, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_pillar.func_176223_P(), 6, 2, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_pillar.func_176223_P(), 8, 2, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 8, 2, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 8, 2, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_pillar.func_176223_P(), 8, 2, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), 8, 2, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_pillar.func_176223_P(), 8, 2, 6, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 8, 2, 7, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 8, 2, 8, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_pillar.func_176223_P(), 8, 2, 9, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_pillar.func_176223_P(), 2, 2, 6, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 2, 2, 7, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 2, 2, 8, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_pillar.func_176223_P(), 2, 2, 9, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_pillar.func_176223_P(), 4, 4, 10, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 5, 4, 10, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_pillar.func_176223_P(), 6, 4, 10, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), 5, 5, 10, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 2, 1, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 2, 2, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150478_aa.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)this.func_186165_e()), 2, 3, 1, structureBoundingBoxIn);
            this.placeDoorCurrentPosition(worldIn, structureBoundingBoxIn, randomIn, 2, 1, 0, EnumFacing.NORTH);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 0, -1, 3, 2, -1, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            for (int k2 = 0; k2 < 5; ++k2) {
                for (int i3 = 0; i3 < 9; ++i3) {
                    this.func_74871_b(worldIn, i3, 7, k2, structureBoundingBoxIn);
                    this.func_175808_b(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), i3, -1, k2, structureBoundingBoxIn);
                }
            }
            for (int l2 = 5; l2 < 11; ++l2) {
                for (int j3 = 2; j3 < 9; ++j3) {
                    this.func_74871_b(worldIn, j3, 7, l2, structureBoundingBoxIn);
                    this.func_175808_b(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), j3, -1, l2, structureBoundingBoxIn);
                }
            }
            this.spawnRemnants(worldIn, structureBoundingBoxIn, 4, 1, 2, 2);
            return true;
        }
    }

    public static class House2
    extends Omothol {
        private boolean hasMadeChest;

        public House2() {
        }

        public House2(Start start, int p_i45563_2_, Random rand, StructureBoundingBox p_i45563_4_, EnumFacing facing) {
            super(start, p_i45563_2_);
            this.func_186164_a(facing);
            this.field_74887_e = p_i45563_4_;
        }

        public static House2 func_175855_a(Start start, List<StructureComponent> p_175855_1_, Random rand, int p_175855_3_, int p_175855_4_, int p_175855_5_, EnumFacing facing, int p_175855_7_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)p_175855_3_, (int)p_175855_4_, (int)p_175855_5_, (int)0, (int)0, (int)0, (int)10, (int)6, (int)7, (EnumFacing)facing);
            return House2.canVillageGoDeeper(structureboundingbox) && StructureComponent.func_74883_a(p_175855_1_, (StructureBoundingBox)structureboundingbox) == null ? new House2(start, p_175855_7_, rand, structureboundingbox, facing) : null;
        }

        @Override
        protected void func_143012_a(NBTTagCompound tagCompound) {
            super.func_143012_a(tagCompound);
            tagCompound.func_74757_a("Chest", this.hasMadeChest);
        }

        @Override
        protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager p_143011_2_) {
            super.func_143011_b(tagCompound, p_143011_2_);
            this.hasMadeChest = tagCompound.func_74767_n("Chest");
        }

        public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            if (this.field_143015_k < 0) {
                this.field_143015_k = this.getAverageGroundLevel(worldIn, structureBoundingBoxIn);
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78894_e + 6 - 1, 0);
            }
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 1, 0, 9, 4, 6, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 0, 0, 9, 0, 6, ACBlocks.ethaxium_brick.func_176223_P(), ACBlocks.ethaxium_brick.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 4, 0, 9, 4, 6, ACBlocks.ethaxium_brick.func_176223_P(), ACBlocks.ethaxium_brick.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 5, 0, 9, 5, 6, Blocks.field_150333_U.func_176223_P(), Blocks.field_150333_U.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 5, 1, 8, 5, 5, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 1, 0, 2, 3, 0, ACBlocks.ethaxium_brick.func_176223_P(), ACBlocks.ethaxium_brick.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 1, 0, 0, 4, 0, ACBlocks.ethaxium_pillar.func_176223_P(), ACBlocks.ethaxium_pillar.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 3, 1, 0, 3, 4, 0, ACBlocks.ethaxium_pillar.func_176223_P(), ACBlocks.ethaxium_pillar.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 1, 6, 0, 4, 6, ACBlocks.ethaxium_pillar.func_176223_P(), ACBlocks.ethaxium_pillar.func_176223_P(), false);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), 3, 3, 1, structureBoundingBoxIn);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 3, 1, 2, 3, 3, 2, ACBlocks.ethaxium_brick.func_176223_P(), ACBlocks.ethaxium_brick.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 4, 1, 3, 5, 3, 3, ACBlocks.ethaxium_brick.func_176223_P(), ACBlocks.ethaxium_brick.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 1, 1, 0, 3, 5, ACBlocks.ethaxium_brick.func_176223_P(), ACBlocks.ethaxium_brick.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 1, 6, 5, 3, 6, ACBlocks.ethaxium_brick.func_176223_P(), ACBlocks.ethaxium_brick.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 5, 1, 0, 5, 3, 0, ACBlocks.ethaxium_brick_fence.func_176223_P(), ACBlocks.ethaxium_brick_fence.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 9, 1, 0, 9, 3, 0, ACBlocks.ethaxium_brick_fence.func_176223_P(), ACBlocks.ethaxium_brick_fence.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 6, 1, 4, 9, 4, 6, ACBlocks.ethaxium_brick.func_176223_P(), ACBlocks.ethaxium_brick.func_176223_P(), false);
            this.func_175811_a(worldIn, Blocks.field_150356_k.func_176223_P(), 7, 1, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150356_k.func_176223_P(), 8, 1, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150411_aY.func_176223_P(), 9, 2, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150411_aY.func_176223_P(), 9, 2, 4, structureBoundingBoxIn);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 7, 2, 4, 8, 2, 5, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), 6, 1, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150460_al.func_176223_P(), 6, 2, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150460_al.func_176223_P(), 6, 3, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150334_T.func_176223_P(), 8, 1, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 0, 2, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 0, 2, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 2, 2, 6, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 4, 2, 6, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_180407_aO.func_176223_P(), 2, 1, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150452_aw.func_176223_P(), 2, 2, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), 1, 1, 5, structureBoundingBoxIn);
            if (ACConfig.ethaxium_brick_stairs) {
                this.func_175811_a(worldIn, ACBlocks.ethaxium_brick_stairs.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH), 2, 1, 5, structureBoundingBoxIn);
                this.func_175811_a(worldIn, ACBlocks.ethaxium_brick_stairs.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.WEST), 1, 1, 4, structureBoundingBoxIn);
            }
            if (!this.hasMadeChest && structureBoundingBoxIn.func_175898_b((Vec3i)new BlockPos(this.func_74865_a(5, 5), this.func_74862_a(1), this.func_74873_b(5, 5)))) {
                this.hasMadeChest = true;
            }
            if (ACConfig.ethaxium_brick_stairs) {
                for (int i = 6; i <= 8; ++i) {
                    if (this.func_175807_a(worldIn, i, 0, -1, structureBoundingBoxIn).func_185904_a() != Material.field_151579_a || this.func_175807_a(worldIn, i, -1, -1, structureBoundingBoxIn).func_185904_a() == Material.field_151579_a) continue;
                    this.func_175811_a(worldIn, ACBlocks.ethaxium_brick_stairs.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH), i, 0, -1, structureBoundingBoxIn);
                }
            }
            for (int k = 0; k < 7; ++k) {
                for (int j = 0; j < 10; ++j) {
                    this.func_74871_b(worldIn, j, 6, k, structureBoundingBoxIn);
                    this.func_175808_b(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), j, -1, k, structureBoundingBoxIn);
                }
            }
            this.spawnRemnants(worldIn, structureBoundingBoxIn, 7, 1, 1, 1);
            return true;
        }

        @Override
        protected int func_180779_c(int p_180779_1_, int p_180779_2_) {
            Random rand = new Random();
            return rand.nextInt(5) == 0 ? 6 : 3;
        }
    }

    public static class House1
    extends Omothol {
        public House1() {
        }

        public House1(Start start, int p_i45571_2_, Random rand, StructureBoundingBox p_i45571_4_, EnumFacing facing) {
            super(start, p_i45571_2_);
            this.func_186164_a(facing);
            this.field_74887_e = p_i45571_4_;
        }

        public static House1 func_175850_a(Start start, List<StructureComponent> p_175850_1_, Random rand, int p_175850_3_, int p_175850_4_, int p_175850_5_, EnumFacing facing, int p_175850_7_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)p_175850_3_, (int)p_175850_4_, (int)p_175850_5_, (int)0, (int)0, (int)0, (int)9, (int)9, (int)6, (EnumFacing)facing);
            return House1.canVillageGoDeeper(structureboundingbox) && StructureComponent.func_74883_a(p_175850_1_, (StructureBoundingBox)structureboundingbox) == null ? new House1(start, p_175850_7_, rand, structureboundingbox, facing) : null;
        }

        public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            if (this.field_143015_k < 0) {
                this.field_143015_k = this.getAverageGroundLevel(worldIn, structureBoundingBoxIn);
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78894_e + 9 - 1, 0);
            }
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 1, 1, 7, 5, 4, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 0, 0, 8, 0, 5, ACBlocks.ethaxium_brick.func_176223_P(), ACBlocks.ethaxium_brick.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 5, 0, 8, 5, 5, ACBlocks.ethaxium_brick.func_176223_P(), ACBlocks.ethaxium_brick.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 6, 1, 8, 6, 4, ACBlocks.ethaxium_brick.func_176223_P(), ACBlocks.ethaxium_brick.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 7, 2, 8, 7, 3, ACBlocks.ethaxium_brick.func_176223_P(), ACBlocks.ethaxium_brick.func_176223_P(), false);
            if (ACConfig.ethaxium_brick_stairs) {
                for (int k = -1; k <= 2; ++k) {
                    for (int l = 0; l <= 8; ++l) {
                        this.func_175811_a(worldIn, ACBlocks.ethaxium_brick_stairs.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH), l, 6 + k, k, structureBoundingBoxIn);
                        this.func_175811_a(worldIn, ACBlocks.ethaxium_brick_stairs.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.SOUTH), l, 6 + k, 5 - k, structureBoundingBoxIn);
                    }
                }
            }
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 1, 0, 0, 1, 5, ACBlocks.ethaxium_brick.func_176223_P(), ACBlocks.ethaxium_brick.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 1, 5, 8, 1, 5, ACBlocks.ethaxium_brick.func_176223_P(), ACBlocks.ethaxium_brick.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 8, 1, 0, 8, 1, 4, ACBlocks.ethaxium_brick.func_176223_P(), ACBlocks.ethaxium_brick.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 2, 1, 0, 7, 1, 0, ACBlocks.ethaxium_brick.func_176223_P(), ACBlocks.ethaxium_brick.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 2, 0, 0, 4, 0, ACBlocks.ethaxium_brick.func_176223_P(), ACBlocks.ethaxium_brick.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 2, 5, 0, 4, 5, ACBlocks.ethaxium_brick.func_176223_P(), ACBlocks.ethaxium_brick.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 8, 2, 5, 8, 4, 5, ACBlocks.ethaxium_brick.func_176223_P(), ACBlocks.ethaxium_brick.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 8, 2, 0, 8, 4, 0, ACBlocks.ethaxium_brick.func_176223_P(), ACBlocks.ethaxium_brick.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 2, 1, 0, 4, 4, ACBlocks.ethaxium_brick.func_176223_P(), ACBlocks.ethaxium_brick.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 2, 5, 7, 4, 5, ACBlocks.ethaxium_brick.func_176223_P(), ACBlocks.ethaxium_brick.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 8, 2, 1, 8, 4, 4, ACBlocks.ethaxium_brick.func_176223_P(), ACBlocks.ethaxium_brick.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 2, 0, 7, 4, 0, ACBlocks.ethaxium_brick.func_176223_P(), ACBlocks.ethaxium_brick.func_176223_P(), false);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 4, 2, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 5, 2, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 6, 2, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 4, 3, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 5, 3, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 6, 3, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 0, 2, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 0, 2, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 0, 3, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 0, 3, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 8, 2, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 8, 2, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 8, 3, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 8, 3, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 2, 2, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 3, 2, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 5, 2, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 6, 2, 5, structureBoundingBoxIn);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 4, 1, 7, 4, 1, ACBlocks.ethaxium_brick.func_176223_P(), ACBlocks.ethaxium_brick.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 4, 4, 7, 4, 4, ACBlocks.ethaxium_brick.func_176223_P(), ACBlocks.ethaxium_brick.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 3, 4, 7, 3, 4, Blocks.field_150342_X.func_176223_P(), Blocks.field_150342_X.func_176223_P(), false);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), 7, 1, 4, structureBoundingBoxIn);
            if (ACConfig.ethaxium_brick_stairs) {
                this.func_175811_a(worldIn, ACBlocks.ethaxium_brick_stairs.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.EAST), 7, 1, 3, structureBoundingBoxIn);
                IBlockState iblockstate = ACBlocks.ethaxium_brick_stairs.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH);
                this.func_175811_a(worldIn, iblockstate, 6, 1, 4, structureBoundingBoxIn);
                this.func_175811_a(worldIn, iblockstate, 5, 1, 4, structureBoundingBoxIn);
                this.func_175811_a(worldIn, iblockstate, 4, 1, 4, structureBoundingBoxIn);
                this.func_175811_a(worldIn, iblockstate, 3, 1, 4, structureBoundingBoxIn);
            }
            this.func_175811_a(worldIn, Blocks.field_180407_aO.func_176223_P(), 6, 1, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150452_aw.func_176223_P(), 6, 2, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_180407_aO.func_176223_P(), 4, 1, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150452_aw.func_176223_P(), 4, 2, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150462_ai.func_176223_P(), 7, 1, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 1, 1, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 1, 2, 0, structureBoundingBoxIn);
            this.placeDoorCurrentPosition(worldIn, structureBoundingBoxIn, randomIn, 1, 1, 0, EnumFacing.NORTH);
            if (this.func_175807_a(worldIn, 1, 0, -1, structureBoundingBoxIn).func_185904_a() == Material.field_151579_a && this.func_175807_a(worldIn, 1, -1, -1, structureBoundingBoxIn).func_185904_a() != Material.field_151579_a && ACConfig.ethaxium_brick_stairs) {
                this.func_175811_a(worldIn, ACBlocks.ethaxium_brick_stairs.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH), 1, 0, -1, structureBoundingBoxIn);
            }
            for (int k1 = 0; k1 < 6; ++k1) {
                for (int i1 = 0; i1 < 9; ++i1) {
                    this.func_74871_b(worldIn, i1, 9, k1, structureBoundingBoxIn);
                    this.func_175808_b(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), i1, -1, k1, structureBoundingBoxIn);
                }
            }
            this.spawnRemnants(worldIn, structureBoundingBoxIn, 2, 1, 2, 1);
            return true;
        }

        @Override
        protected int func_180779_c(int p_180779_1_, int p_180779_2_) {
            return 1;
        }
    }

    public static class Hall
    extends Omothol {
        public Hall() {
        }

        public Hall(Start start, int p_i45567_2_, Random rand, StructureBoundingBox p_i45567_4_, EnumFacing facing) {
            super(start, p_i45567_2_);
            this.func_186164_a(facing);
            this.field_74887_e = p_i45567_4_;
        }

        public static Hall func_175857_a(Start start, List<StructureComponent> p_175857_1_, Random rand, int p_175857_3_, int p_175857_4_, int p_175857_5_, EnumFacing facing, int p_175857_7_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)p_175857_3_, (int)p_175857_4_, (int)p_175857_5_, (int)0, (int)0, (int)0, (int)9, (int)7, (int)11, (EnumFacing)facing);
            return Hall.canVillageGoDeeper(structureboundingbox) && StructureComponent.func_74883_a(p_175857_1_, (StructureBoundingBox)structureboundingbox) == null ? new Hall(start, p_175857_7_, rand, structureboundingbox, facing) : null;
        }

        public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            if (this.field_143015_k < 0) {
                this.field_143015_k = this.getAverageGroundLevel(worldIn, structureBoundingBoxIn);
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78894_e + 7 - 1, 0);
            }
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 1, 1, 7, 4, 4, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 2, 1, 6, 8, 4, 10, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 2, 0, 6, 8, 0, 10, Blocks.field_150346_d.func_176223_P(), Blocks.field_150346_d.func_176223_P(), false);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), 6, 0, 6, structureBoundingBoxIn);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 2, 1, 6, 2, 1, 10, ACBlocks.ethaxium_brick_fence.func_176223_P(), ACBlocks.ethaxium_brick_fence.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 8, 1, 6, 8, 1, 10, ACBlocks.ethaxium_brick_fence.func_176223_P(), ACBlocks.ethaxium_brick_fence.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 3, 1, 10, 7, 1, 10, ACBlocks.ethaxium_brick_fence.func_176223_P(), ACBlocks.ethaxium_brick_fence.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 0, 1, 7, 0, 4, ACBlocks.ethaxium_brick.func_176223_P(), ACBlocks.ethaxium_brick.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 0, 0, 0, 3, 5, ACBlocks.ethaxium_brick.func_176223_P(), ACBlocks.ethaxium_brick.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 8, 0, 0, 8, 3, 5, ACBlocks.ethaxium_brick.func_176223_P(), ACBlocks.ethaxium_brick.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 0, 0, 7, 1, 0, ACBlocks.ethaxium_brick.func_176223_P(), ACBlocks.ethaxium_brick.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 0, 5, 7, 1, 5, ACBlocks.ethaxium_brick.func_176223_P(), ACBlocks.ethaxium_brick.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 2, 0, 7, 3, 0, ACBlocks.ethaxium_brick.func_176223_P(), ACBlocks.ethaxium_brick.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 2, 5, 7, 3, 5, ACBlocks.ethaxium_brick.func_176223_P(), ACBlocks.ethaxium_brick.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 4, 1, 8, 4, 1, ACBlocks.ethaxium_brick.func_176223_P(), ACBlocks.ethaxium_brick.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 4, 4, 8, 4, 4, ACBlocks.ethaxium_brick.func_176223_P(), ACBlocks.ethaxium_brick.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 5, 2, 8, 5, 3, ACBlocks.ethaxium_brick.func_176223_P(), ACBlocks.ethaxium_brick.func_176223_P(), false);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), 0, 4, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), 0, 4, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), 8, 4, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), 8, 4, 3, structureBoundingBoxIn);
            if (ACConfig.ethaxium_brick_stairs) {
                IBlockState iblockstate = ACBlocks.ethaxium_brick_stairs.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH);
                IBlockState iblockstate1 = ACBlocks.ethaxium_brick_stairs.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.SOUTH);
                IBlockState iblockstate2 = ACBlocks.ethaxium_brick_stairs.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.WEST);
                for (int k = -1; k <= 2; ++k) {
                    for (int l = 0; l <= 8; ++l) {
                        this.func_175811_a(worldIn, iblockstate, l, 4 + k, k, structureBoundingBoxIn);
                        this.func_175811_a(worldIn, iblockstate1, l, 4 + k, 5 - k, structureBoundingBoxIn);
                    }
                }
                this.func_175811_a(worldIn, iblockstate, 2, 1, 4, structureBoundingBoxIn);
                this.func_175811_a(worldIn, iblockstate2, 1, 1, 3, structureBoundingBoxIn);
            }
            this.func_175811_a(worldIn, ACBlocks.ethaxium_pillar.func_176223_P(), 0, 2, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_pillar.func_176223_P(), 0, 2, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_pillar.func_176223_P(), 8, 2, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_pillar.func_176223_P(), 8, 2, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 0, 2, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 0, 2, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 8, 2, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 8, 2, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 2, 2, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 3, 2, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 5, 2, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 6, 2, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_180407_aO.func_176223_P(), 2, 1, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150452_aw.func_176223_P(), 2, 2, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), 1, 1, 4, structureBoundingBoxIn);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 5, 0, 1, 7, 0, 3, Blocks.field_150334_T.func_176223_P(), Blocks.field_150334_T.func_176223_P(), false);
            this.func_175811_a(worldIn, Blocks.field_150334_T.func_176223_P(), 6, 1, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150334_T.func_176223_P(), 6, 1, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 2, 1, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 2, 2, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150478_aa.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)this.func_186165_e()), 2, 3, 1, structureBoundingBoxIn);
            this.placeDoorCurrentPosition(worldIn, structureBoundingBoxIn, randomIn, 2, 1, 0, EnumFacing.NORTH);
            if (this.func_175807_a(worldIn, 2, 0, -1, structureBoundingBoxIn).func_185904_a() == Material.field_151579_a && this.func_175807_a(worldIn, 2, -1, -1, structureBoundingBoxIn).func_185904_a() != Material.field_151579_a && ACConfig.ethaxium_brick_stairs) {
                this.func_175811_a(worldIn, ACBlocks.ethaxium_brick_stairs.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH), 2, 0, -1, structureBoundingBoxIn);
            }
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 6, 1, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 6, 2, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150478_aa.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)this.func_186165_e().func_176734_d()), 6, 3, 4, structureBoundingBoxIn);
            this.placeDoorCurrentPosition(worldIn, structureBoundingBoxIn, randomIn, 6, 1, 5, EnumFacing.SOUTH);
            for (int i1 = 0; i1 < 5; ++i1) {
                for (int j1 = 0; j1 < 9; ++j1) {
                    this.func_74871_b(worldIn, j1, 7, i1, structureBoundingBoxIn);
                    this.func_175808_b(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), j1, -1, i1, structureBoundingBoxIn);
                }
            }
            this.spawnRemnants(worldIn, structureBoundingBoxIn, 4, 1, 2, 2);
            return true;
        }

        @Override
        protected int func_180779_c(int p_180779_1_, int p_180779_2_) {
            return p_180779_1_ == 0 ? 4 : super.func_180779_c(p_180779_1_, p_180779_2_);
        }
    }

    public static class Field2
    extends Omothol {
        private Block cropTypeA;
        private Block cropTypeB;

        public Field2() {
        }

        public Field2(Start start, int p_i45569_2_, Random rand, StructureBoundingBox p_i45569_4_, EnumFacing facing) {
            super(start, p_i45569_2_);
            this.func_186164_a(facing);
            this.field_74887_e = p_i45569_4_;
            this.cropTypeA = this.func_151560_a(rand);
            this.cropTypeB = this.func_151560_a(rand);
        }

        @Override
        protected void func_143012_a(NBTTagCompound tagCompound) {
            super.func_143012_a(tagCompound);
            tagCompound.func_74768_a("CA", Block.field_149771_c.func_148757_b((Object)this.cropTypeA));
            tagCompound.func_74768_a("CB", Block.field_149771_c.func_148757_b((Object)this.cropTypeB));
        }

        @Override
        protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager p_143011_2_) {
            super.func_143011_b(tagCompound, p_143011_2_);
            this.cropTypeA = Block.func_149729_e((int)tagCompound.func_74762_e("CA"));
            this.cropTypeB = Block.func_149729_e((int)tagCompound.func_74762_e("CB"));
        }

        private Block func_151560_a(Random rand) {
            switch (rand.nextInt(5)) {
                case 0: {
                    return Blocks.field_150459_bM;
                }
                case 1: {
                    return Blocks.field_150469_bN;
                }
            }
            return Blocks.field_150464_aj;
        }

        public static Field2 func_175852_a(Start start, List<StructureComponent> p_175852_1_, Random rand, int p_175852_3_, int p_175852_4_, int p_175852_5_, EnumFacing facing, int p_175852_7_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)p_175852_3_, (int)p_175852_4_, (int)p_175852_5_, (int)0, (int)0, (int)0, (int)7, (int)4, (int)9, (EnumFacing)facing);
            return Field2.canVillageGoDeeper(structureboundingbox) && StructureComponent.func_74883_a(p_175852_1_, (StructureBoundingBox)structureboundingbox) == null ? new Field2(start, p_175852_7_, rand, structureboundingbox, facing) : null;
        }

        public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            if (this.field_143015_k < 0) {
                this.field_143015_k = this.getAverageGroundLevel(worldIn, structureBoundingBoxIn);
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78894_e + 4 - 1, 0);
            }
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 1, 0, 6, 4, 8, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 0, 1, 2, 0, 7, Blocks.field_150458_ak.func_176223_P(), Blocks.field_150458_ak.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 4, 0, 1, 5, 0, 7, Blocks.field_150458_ak.func_176223_P(), Blocks.field_150458_ak.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 0, 0, 0, 0, 8, ACBlocks.ethaxium_pillar.func_176223_P(), ACBlocks.ethaxium_pillar.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 6, 0, 0, 6, 0, 8, ACBlocks.ethaxium_pillar.func_176223_P(), ACBlocks.ethaxium_pillar.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 0, 0, 5, 0, 0, ACBlocks.ethaxium_pillar.func_176223_P(), ACBlocks.ethaxium_pillar.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 0, 8, 5, 0, 8, ACBlocks.ethaxium_pillar.func_176223_P(), ACBlocks.ethaxium_pillar.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 3, 0, 1, 3, 0, 7, Blocks.field_150355_j.func_176223_P(), Blocks.field_150355_j.func_176223_P(), false);
            for (int i = 1; i <= 7; ++i) {
                this.func_175811_a(worldIn, this.cropTypeA.func_176203_a(MathHelper.func_76136_a((Random)randomIn, (int)2, (int)7)), 1, 1, i, structureBoundingBoxIn);
                this.func_175811_a(worldIn, this.cropTypeA.func_176203_a(MathHelper.func_76136_a((Random)randomIn, (int)2, (int)7)), 2, 1, i, structureBoundingBoxIn);
                this.func_175811_a(worldIn, this.cropTypeB.func_176203_a(MathHelper.func_76136_a((Random)randomIn, (int)2, (int)7)), 4, 1, i, structureBoundingBoxIn);
                this.func_175811_a(worldIn, this.cropTypeB.func_176203_a(MathHelper.func_76136_a((Random)randomIn, (int)2, (int)7)), 5, 1, i, structureBoundingBoxIn);
            }
            for (int k = 0; k < 9; ++k) {
                for (int j = 0; j < 7; ++j) {
                    this.func_74871_b(worldIn, j, 4, k, structureBoundingBoxIn);
                    this.func_175808_b(worldIn, Blocks.field_150346_d.func_176223_P(), j, -1, k, structureBoundingBoxIn);
                }
            }
            return true;
        }
    }

    public static class Field1
    extends Omothol {
        private Block cropTypeA;
        private Block cropTypeB;
        private Block cropTypeC;
        private Block cropTypeD;

        public Field1() {
        }

        public Field1(Start start, int p_i45570_2_, Random rand, StructureBoundingBox p_i45570_4_, EnumFacing facing) {
            super(start, p_i45570_2_);
            this.func_186164_a(facing);
            this.field_74887_e = p_i45570_4_;
            this.cropTypeA = this.func_151559_a(rand);
            this.cropTypeB = this.func_151559_a(rand);
            this.cropTypeC = this.func_151559_a(rand);
            this.cropTypeD = this.func_151559_a(rand);
        }

        @Override
        protected void func_143012_a(NBTTagCompound tagCompound) {
            super.func_143012_a(tagCompound);
            tagCompound.func_74768_a("CA", Block.field_149771_c.func_148757_b((Object)this.cropTypeA));
            tagCompound.func_74768_a("CB", Block.field_149771_c.func_148757_b((Object)this.cropTypeB));
            tagCompound.func_74768_a("CC", Block.field_149771_c.func_148757_b((Object)this.cropTypeC));
            tagCompound.func_74768_a("CD", Block.field_149771_c.func_148757_b((Object)this.cropTypeD));
        }

        @Override
        protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager p_143011_2_) {
            super.func_143011_b(tagCompound, p_143011_2_);
            this.cropTypeA = Block.func_149729_e((int)tagCompound.func_74762_e("CA"));
            this.cropTypeB = Block.func_149729_e((int)tagCompound.func_74762_e("CB"));
            this.cropTypeC = Block.func_149729_e((int)tagCompound.func_74762_e("CC"));
            this.cropTypeD = Block.func_149729_e((int)tagCompound.func_74762_e("CD"));
        }

        private Block func_151559_a(Random rand) {
            switch (rand.nextInt(5)) {
                case 0: {
                    return Blocks.field_150459_bM;
                }
                case 1: {
                    return Blocks.field_150469_bN;
                }
            }
            return Blocks.field_150464_aj;
        }

        public static Field1 func_175851_a(Start start, List<StructureComponent> p_175851_1_, Random rand, int p_175851_3_, int p_175851_4_, int p_175851_5_, EnumFacing facing, int p_175851_7_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)p_175851_3_, (int)p_175851_4_, (int)p_175851_5_, (int)0, (int)0, (int)0, (int)13, (int)4, (int)9, (EnumFacing)facing);
            return Field1.canVillageGoDeeper(structureboundingbox) && StructureComponent.func_74883_a(p_175851_1_, (StructureBoundingBox)structureboundingbox) == null ? new Field1(start, p_175851_7_, rand, structureboundingbox, facing) : null;
        }

        public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            if (this.field_143015_k < 0) {
                this.field_143015_k = this.getAverageGroundLevel(worldIn, structureBoundingBoxIn);
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78894_e + 4 - 1, 0);
            }
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 1, 0, 12, 4, 8, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 0, 1, 2, 0, 7, Blocks.field_150458_ak.func_176223_P(), Blocks.field_150458_ak.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 4, 0, 1, 5, 0, 7, Blocks.field_150458_ak.func_176223_P(), Blocks.field_150458_ak.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 7, 0, 1, 8, 0, 7, Blocks.field_150458_ak.func_176223_P(), Blocks.field_150458_ak.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 10, 0, 1, 11, 0, 7, Blocks.field_150458_ak.func_176223_P(), Blocks.field_150458_ak.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 0, 0, 0, 0, 8, ACBlocks.ethaxium_pillar.func_176223_P(), ACBlocks.ethaxium_pillar.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 6, 0, 0, 6, 0, 8, ACBlocks.ethaxium_pillar.func_176223_P(), ACBlocks.ethaxium_pillar.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 12, 0, 0, 12, 0, 8, ACBlocks.ethaxium_pillar.func_176223_P(), ACBlocks.ethaxium_pillar.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 0, 0, 11, 0, 0, ACBlocks.ethaxium_pillar.func_176223_P(), ACBlocks.ethaxium_pillar.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 0, 8, 11, 0, 8, ACBlocks.ethaxium_pillar.func_176223_P(), ACBlocks.ethaxium_pillar.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 3, 0, 1, 3, 0, 7, Blocks.field_150355_j.func_176223_P(), Blocks.field_150355_j.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 9, 0, 1, 9, 0, 7, Blocks.field_150355_j.func_176223_P(), Blocks.field_150355_j.func_176223_P(), false);
            for (int i = 1; i <= 7; ++i) {
                this.func_175811_a(worldIn, this.cropTypeA.func_176203_a(MathHelper.func_76136_a((Random)randomIn, (int)2, (int)7)), 1, 1, i, structureBoundingBoxIn);
                this.func_175811_a(worldIn, this.cropTypeA.func_176203_a(MathHelper.func_76136_a((Random)randomIn, (int)2, (int)7)), 2, 1, i, structureBoundingBoxIn);
                this.func_175811_a(worldIn, this.cropTypeB.func_176203_a(MathHelper.func_76136_a((Random)randomIn, (int)2, (int)7)), 4, 1, i, structureBoundingBoxIn);
                this.func_175811_a(worldIn, this.cropTypeB.func_176203_a(MathHelper.func_76136_a((Random)randomIn, (int)2, (int)7)), 5, 1, i, structureBoundingBoxIn);
                this.func_175811_a(worldIn, this.cropTypeC.func_176203_a(MathHelper.func_76136_a((Random)randomIn, (int)2, (int)7)), 7, 1, i, structureBoundingBoxIn);
                this.func_175811_a(worldIn, this.cropTypeC.func_176203_a(MathHelper.func_76136_a((Random)randomIn, (int)2, (int)7)), 8, 1, i, structureBoundingBoxIn);
                this.func_175811_a(worldIn, this.cropTypeD.func_176203_a(MathHelper.func_76136_a((Random)randomIn, (int)2, (int)7)), 10, 1, i, structureBoundingBoxIn);
                this.func_175811_a(worldIn, this.cropTypeD.func_176203_a(MathHelper.func_76136_a((Random)randomIn, (int)2, (int)7)), 11, 1, i, structureBoundingBoxIn);
            }
            for (int k = 0; k < 9; ++k) {
                for (int j = 0; j < 13; ++j) {
                    this.func_74871_b(worldIn, j, 4, k, structureBoundingBoxIn);
                    this.func_175808_b(worldIn, Blocks.field_150346_d.func_176223_P(), j, -1, k, structureBoundingBoxIn);
                }
            }
            return true;
        }
    }

    public static class Church
    extends Omothol {
        public Church() {
        }

        public Church(Start start, int p_i45564_2_, Random rand, StructureBoundingBox p_i45564_4_, EnumFacing facing) {
            super(start, p_i45564_2_);
            this.func_186164_a(facing);
            this.field_74887_e = p_i45564_4_;
        }

        public static Church func_175854_a(Start start, List<StructureComponent> p_175854_1_, Random rand, int p_175854_3_, int p_175854_4_, int p_175854_5_, EnumFacing facing, int p_175854_7_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)p_175854_3_, (int)p_175854_4_, (int)p_175854_5_, (int)0, (int)0, (int)0, (int)5, (int)12, (int)9, (EnumFacing)facing);
            return Church.canVillageGoDeeper(structureboundingbox) && StructureComponent.func_74883_a(p_175854_1_, (StructureBoundingBox)structureboundingbox) == null ? new Church(start, p_175854_7_, rand, structureboundingbox, facing) : null;
        }

        public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            if (this.field_143015_k < 0) {
                this.field_143015_k = this.getAverageGroundLevel(worldIn, structureBoundingBoxIn);
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78894_e + 12 - 1, 0);
            }
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 1, 1, 3, 3, 7, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 5, 1, 3, 9, 3, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 0, 0, 3, 0, 8, ACBlocks.ethaxium_brick.func_176223_P(), ACBlocks.ethaxium_brick.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 1, 0, 3, 10, 0, ACBlocks.ethaxium_brick.func_176223_P(), ACBlocks.ethaxium_brick.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 1, 1, 0, 10, 3, ACBlocks.ethaxium_brick.func_176223_P(), ACBlocks.ethaxium_brick.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 4, 1, 1, 4, 10, 3, ACBlocks.ethaxium_brick.func_176223_P(), ACBlocks.ethaxium_brick.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 0, 4, 0, 4, 7, ACBlocks.ethaxium_brick.func_176223_P(), ACBlocks.ethaxium_brick.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 4, 0, 4, 4, 4, 7, ACBlocks.ethaxium_brick.func_176223_P(), ACBlocks.ethaxium_brick.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 1, 8, 3, 4, 8, ACBlocks.ethaxium_brick.func_176223_P(), ACBlocks.ethaxium_brick.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 5, 4, 3, 10, 4, ACBlocks.ethaxium_brick.func_176223_P(), ACBlocks.ethaxium_brick.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 5, 5, 3, 5, 7, ACBlocks.ethaxium_brick.func_176223_P(), ACBlocks.ethaxium_brick.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 9, 0, 4, 9, 4, ACBlocks.ethaxium_brick.func_176223_P(), ACBlocks.ethaxium_brick.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 4, 0, 4, 4, 4, ACBlocks.ethaxium_brick.func_176223_P(), ACBlocks.ethaxium_brick.func_176223_P(), false);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), 0, 11, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), 4, 11, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), 2, 11, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), 2, 11, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), 1, 1, 6, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), 1, 1, 7, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), 2, 1, 7, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), 3, 1, 6, structureBoundingBoxIn);
            this.func_175811_a(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), 3, 1, 7, structureBoundingBoxIn);
            if (ACConfig.ethaxium_brick_stairs) {
                IBlockState iblockstate = ACBlocks.ethaxium_brick_stairs.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH);
                IBlockState iblockstate1 = ACBlocks.ethaxium_brick_stairs.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.WEST);
                IBlockState iblockstate2 = ACBlocks.ethaxium_brick_stairs.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.EAST);
                this.func_175811_a(worldIn, iblockstate, 1, 1, 5, structureBoundingBoxIn);
                this.func_175811_a(worldIn, iblockstate, 2, 1, 6, structureBoundingBoxIn);
                this.func_175811_a(worldIn, iblockstate, 3, 1, 5, structureBoundingBoxIn);
                this.func_175811_a(worldIn, iblockstate1, 1, 2, 7, structureBoundingBoxIn);
                this.func_175811_a(worldIn, iblockstate2, 3, 2, 7, structureBoundingBoxIn);
            }
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 0, 2, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 0, 3, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 4, 2, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 4, 3, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 0, 6, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 0, 7, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 4, 6, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 4, 7, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 2, 6, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 2, 7, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 2, 6, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 2, 7, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 0, 3, 6, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 4, 3, 6, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 2, 3, 8, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150478_aa.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)this.func_186165_e().func_176734_d()), 2, 4, 7, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150478_aa.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)this.func_186165_e().func_176746_e()), 1, 4, 6, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150478_aa.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)this.func_186165_e().func_176735_f()), 3, 4, 6, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150478_aa.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)this.func_186165_e()), 2, 4, 5, structureBoundingBoxIn);
            IBlockState iblockstate3 = Blocks.field_150468_ap.func_176223_P().func_177226_a((IProperty)BlockLadder.field_176382_a, (Comparable)EnumFacing.WEST);
            for (int j = 1; j <= 9; ++j) {
                this.func_175811_a(worldIn, iblockstate3, 3, j, 3, structureBoundingBoxIn);
            }
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 2, 1, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 2, 2, 0, structureBoundingBoxIn);
            this.placeDoorCurrentPosition(worldIn, structureBoundingBoxIn, randomIn, 2, 1, 0, EnumFacing.NORTH);
            if (this.func_175807_a(worldIn, 2, 0, -1, structureBoundingBoxIn).func_185904_a() == Material.field_151579_a && this.func_175807_a(worldIn, 2, -1, -1, structureBoundingBoxIn).func_185904_a() != Material.field_151579_a && ACConfig.ethaxium_brick_stairs) {
                this.func_175811_a(worldIn, ACBlocks.ethaxium_brick_stairs.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH), 2, 0, -1, structureBoundingBoxIn);
            }
            for (int l = 0; l < 9; ++l) {
                for (int k = 0; k < 5; ++k) {
                    this.func_74871_b(worldIn, k, 12, l, structureBoundingBoxIn);
                    this.func_175808_b(worldIn, ACBlocks.ethaxium_brick.func_176223_P(), k, -1, l, structureBoundingBoxIn);
                }
            }
            this.spawnRemnants(worldIn, structureBoundingBoxIn, 2, 1, 2, 1);
            return true;
        }

        @Override
        protected int func_180779_c(int p_180779_1_, int p_180779_2_) {
            return 2;
        }
    }
}

