/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.common.ritual;

import com.shinoow.abyssalcraft.api.biome.ACBiomes;
import com.shinoow.abyssalcraft.api.block.ACBlocks;
import com.shinoow.abyssalcraft.api.ritual.NecronomiconRitual;
import com.shinoow.abyssalcraft.common.blocks.BlockACBrick;
import com.shinoow.abyssalcraft.common.blocks.BlockRitualAltar;
import com.shinoow.abyssalcraft.common.util.BiomeUtil;
import com.shinoow.abyssalcraft.init.BlockHandler;
import com.shinoow.abyssalcraft.lib.ACConfig;
import com.shinoow.abyssalcraft.lib.util.SpecialTextUtil;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockStone;
import net.minecraft.block.BlockStoneBrick;
import net.minecraft.block.BlockStoneSlab;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class NecronomiconCorruptionRitual
extends NecronomiconRitual {
    public NecronomiconCorruptionRitual() {
        super("corruption", 4, 0, 10000.0f, true, new Object[]{new ItemStack(ACBlocks.statue, 1, Short.MAX_VALUE), new ItemStack(ACBlocks.stone, 1, 0), new ItemStack(ACBlocks.statue, 1, Short.MAX_VALUE), new ItemStack(ACBlocks.stone, 1, 0), new ItemStack(ACBlocks.statue, 1, Short.MAX_VALUE), new ItemStack(ACBlocks.stone, 1, 0), new ItemStack(ACBlocks.statue, 1, Short.MAX_VALUE), new ItemStack(ACBlocks.stone, 1, 0)});
    }

    @Override
    public boolean canCompleteRitual(World world, BlockPos pos, EntityPlayer player) {
        for (int x = pos.func_177958_n() - 24; x < pos.func_177958_n() + 25; ++x) {
            for (int z = pos.func_177952_p() - 24; z < pos.func_177952_p() + 25; ++z) {
                BlockPos pos1 = new BlockPos(x, 0, z);
                Biome b = world.func_180494_b(pos1);
                if (b != Biomes.field_76772_c && b != Biomes.field_76770_e && b != Biomes.field_76767_f && b != Biomes.field_76775_o && b != Biomes.field_185441_Q && b != Biomes.field_185443_S && b != Biomes.field_185444_T && b != Biomes.field_76785_t) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void completeRitualClient(World world, BlockPos pos, EntityPlayer player) {
        SpecialTextUtil.JzaharText("Behold, as the darkness consumes the Overworld! Bit by bit, this world will crumble.");
    }

    @Override
    protected void completeRitualServer(World world, BlockPos pos, EntityPlayer player) {
        boolean b1 = world.field_73012_v.nextBoolean();
        for (int x = pos.func_177958_n() - 64; x < pos.func_177958_n() + 65; ++x) {
            for (int z = pos.func_177952_p() - 64; z < pos.func_177952_p() + 65; ++z) {
                BlockPos pos1 = new BlockPos(x, 0, z);
                if (!this.isApplicable(world, pos1)) continue;
                Biome b = this.getDarklandsBiome(world.func_180494_b(pos1), b1);
                for (int y = 0; y < 256; ++y) {
                    if (world.func_175623_d(pos1.func_177981_b(y))) continue;
                    IBlockState state = world.func_180495_p(pos1.func_177981_b(y));
                    if (state.func_177230_c() == Blocks.field_150348_b && state.func_177229_b((IProperty)BlockStone.field_176247_a) != BlockStone.EnumType.STONE) {
                        world.func_180501_a(pos1.func_177981_b(y), ACBlocks.stone.func_176223_P(), 2);
                        continue;
                    }
                    if (state.func_177230_c() == Blocks.field_150362_t) {
                        world.func_180501_a(pos1.func_177981_b(y), ACBlocks.darklands_oak_leaves.func_176223_P().func_177226_a((IProperty)BlockLeaves.field_176236_b, state.func_177229_b((IProperty)BlockLeaves.field_176236_b)).func_177226_a((IProperty)BlockLeaves.field_176237_a, state.func_177229_b((IProperty)BlockLeaves.field_176237_a)), 2);
                        continue;
                    }
                    if (state.func_177230_c() == Blocks.field_150364_r) {
                        world.func_180501_a(pos1.func_177981_b(y), ACBlocks.darklands_oak_wood.func_176223_P().func_177226_a((IProperty)BlockLog.field_176299_a, state.func_177229_b((IProperty)BlockLog.field_176299_a)), 2);
                        continue;
                    }
                    if (state.func_177230_c() == Blocks.field_150347_e) {
                        world.func_180501_a(pos1.func_177981_b(y), ACBlocks.cobblestone.func_176223_P(), 2);
                        continue;
                    }
                    if (state.func_177230_c() == Blocks.field_150417_aV) {
                        switch ((BlockStoneBrick.EnumType)state.func_177229_b((IProperty)BlockStoneBrick.field_176249_a)) {
                            case CHISELED: {
                                world.func_180501_a(pos1.func_177981_b(y), ACBlocks.darkstone_brick.func_176223_P().func_177226_a((IProperty)BlockACBrick.TYPE, (Comparable)((Object)BlockACBrick.EnumBrickType.CHISELED)), 2);
                                break;
                            }
                            case CRACKED: {
                                world.func_180501_a(pos1.func_177981_b(y), ACBlocks.darkstone_brick.func_176223_P().func_177226_a((IProperty)BlockACBrick.TYPE, (Comparable)((Object)BlockACBrick.EnumBrickType.CRACKED)), 2);
                                break;
                            }
                            default: {
                                world.func_180501_a(pos1.func_177981_b(y), ACBlocks.darkstone_brick.func_176223_P(), 2);
                                break;
                            }
                        }
                        continue;
                    }
                    if (state.func_177230_c() == Blocks.field_150463_bK && ACConfig.darkstone_cobblestone_wall) {
                        world.func_180501_a(pos1.func_177981_b(y), ACBlocks.darkstone_cobblestone_wall.func_176223_P(), 2);
                        continue;
                    }
                    if (state == ACBlocks.ritual_altar.func_176223_P()) {
                        world.func_180501_a(pos1.func_177981_b(y), ACBlocks.ritual_altar.func_176223_P().func_177226_a((IProperty)BlockRitualAltar.MATERIAL, (Comparable)((Object)BlockRitualAltar.EnumRitualMatType.DARKSTONE_COBBLESTONE)), 2);
                        continue;
                    }
                    if (state == ACBlocks.ritual_pedestal.func_176223_P()) {
                        world.func_180501_a(pos1.func_177981_b(y), ACBlocks.ritual_pedestal.func_176223_P().func_177226_a((IProperty)BlockRitualAltar.MATERIAL, (Comparable)((Object)BlockRitualAltar.EnumRitualMatType.DARKSTONE_COBBLESTONE)), 2);
                        continue;
                    }
                    if (state.func_177230_c() == Blocks.field_150333_U && state.func_177229_b((IProperty)BlockStoneSlab.field_176556_M) == BlockStoneSlab.EnumType.SMOOTHBRICK && ACConfig.darkstone_brick_slab) {
                        world.func_180501_a(pos1.func_177981_b(y), ACBlocks.darkstone_brick_slab.func_176223_P().func_177226_a((IProperty)BlockSlab.field_176554_a, state.func_177229_b((IProperty)BlockSlab.field_176554_a)), 2);
                        continue;
                    }
                    if (state.func_177230_c() == Blocks.field_150333_U && state.func_177229_b((IProperty)BlockStoneSlab.field_176556_M) == BlockStoneSlab.EnumType.COBBLESTONE && ACConfig.darkstone_cobblestone_slab) {
                        world.func_180501_a(pos1.func_177981_b(y), ACBlocks.darkstone_cobblestone_slab.func_176223_P().func_177226_a((IProperty)BlockSlab.field_176554_a, state.func_177229_b((IProperty)BlockSlab.field_176554_a)), 2);
                        continue;
                    }
                    if (state.func_177230_c() == Blocks.field_150333_U && state.func_177229_b((IProperty)BlockStoneSlab.field_176556_M) == BlockStoneSlab.EnumType.STONE && ACConfig.darkstone_slab) {
                        world.func_180501_a(pos1.func_177981_b(y), ACBlocks.darkstone_slab.func_176223_P().func_177226_a((IProperty)BlockSlab.field_176554_a, state.func_177229_b((IProperty)BlockSlab.field_176554_a)), 2);
                        continue;
                    }
                    if (state.func_177230_c() == Blocks.field_150334_T && state.func_177229_b((IProperty)BlockStoneSlab.field_176556_M) == BlockStoneSlab.EnumType.STONE && ACConfig.darkstone_slab) {
                        world.func_180501_a(pos1.func_177981_b(y), BlockHandler.Darkstoneslab2.func_176223_P(), 2);
                        continue;
                    }
                    if (state.func_177230_c() == Blocks.field_150390_bg && ACConfig.darkstone_brick_stairs) {
                        world.func_180501_a(pos1.func_177981_b(y), ACBlocks.darkstone_brick_stairs.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, state.func_177229_b((IProperty)BlockStairs.field_176309_a)).func_177226_a((IProperty)BlockStairs.field_176308_b, state.func_177229_b((IProperty)BlockStairs.field_176308_b)), 2);
                        continue;
                    }
                    if (state.func_177230_c() == Blocks.field_150446_ar && ACConfig.darkstone_cobblestone_stairs) {
                        world.func_180501_a(pos1.func_177981_b(y), ACBlocks.darkstone_cobblestone_stairs.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, state.func_177229_b((IProperty)BlockStairs.field_176309_a)).func_177226_a((IProperty)BlockStairs.field_176308_b, state.func_177229_b((IProperty)BlockStairs.field_176308_b)), 2);
                        continue;
                    }
                    if (state.func_177230_c() == Blocks.field_150344_f) {
                        world.func_180501_a(pos1.func_177981_b(y), ACBlocks.darklands_oak_planks.func_176223_P(), 2);
                        continue;
                    }
                    if (state.func_177230_c() == Blocks.field_150476_ad && ACConfig.darklands_oak_stairs) {
                        world.func_180501_a(pos1.func_177981_b(y), ACBlocks.darklands_oak_stairs.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, state.func_177229_b((IProperty)BlockStairs.field_176309_a)).func_177226_a((IProperty)BlockStairs.field_176308_b, state.func_177229_b((IProperty)BlockStairs.field_176308_b)), 2);
                        continue;
                    }
                    if (state.func_177230_c() == Blocks.field_150376_bx && ACConfig.darklands_oak_slab) {
                        world.func_180501_a(pos1.func_177981_b(y), ACBlocks.darklands_oak_slab.func_176223_P().func_177226_a((IProperty)BlockSlab.field_176554_a, state.func_177229_b((IProperty)BlockSlab.field_176554_a)), 2);
                        continue;
                    }
                    if (state.func_177230_c() != Blocks.field_180407_aO) continue;
                    world.func_180501_a(pos1.func_177981_b(y), ACBlocks.darklands_oak_fence.func_176223_P(), 2);
                }
                BiomeUtil.updateBiome(world, pos1, b, true);
            }
        }
    }

    private boolean isApplicable(World world, BlockPos pos) {
        Biome b = world.func_180494_b(pos);
        return b == Biomes.field_76772_c || b == Biomes.field_76770_e || b == Biomes.field_76767_f || b == Biomes.field_76775_o || b == Biomes.field_185441_Q || b == Biomes.field_185443_S || b == Biomes.field_185444_T || b == Biomes.field_76785_t;
    }

    private Biome getDarklandsBiome(Biome b, boolean b1) {
        if (b == Biomes.field_76772_c || b == Biomes.field_185441_Q) {
            return b1 ? ACBiomes.darklands_plains : ACBiomes.darklands;
        }
        if (b == Biomes.field_76767_f || b == Biomes.field_185444_T || b == Biomes.field_76785_t) {
            return ACBiomes.darklands_forest;
        }
        if (b == Biomes.field_76775_o || b == Biomes.field_185443_S && b1) {
            return ACBiomes.darklands_mountains;
        }
        if (b == Biomes.field_76770_e || b == Biomes.field_185443_S) {
            return ACBiomes.darklands_hills;
        }
        return ACBiomes.darklands;
    }
}

