/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.common.handlers;

import com.shinoow.abyssalcraft.api.AbyssalCraftAPI;
import com.shinoow.abyssalcraft.api.entity.EntityUtil;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.IFuelHandler;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import org.apache.logging.log4j.Level;

public class IMCHandler {
    public static void handleIMC(FMLInterModComms.IMCEvent event) {
        ArrayList<String> senders = new ArrayList<String>();
        for (FMLInterModComms.IMCMessage imcMessage : event.getMessages()) {
            ItemStack helmet;
            NBTTagCompound tag;
            Object output;
            Object output2;
            Object output1;
            Object input;
            NBTTagCompound stuff;
            if (imcMessage.key.equals("shoggothFood")) {
                try {
                    EntityUtil.addShoggothFood(Class.forName(imcMessage.getStringValue()));
                    IMCHandler.info("Received Shoggoth Food addition %s from mod %s", imcMessage.getStringValue(), imcMessage.getSender());
                    if (senders.contains(imcMessage.getSender())) continue;
                    senders.add(imcMessage.getSender());
                }
                catch (ClassNotFoundException e) {
                    IMCHandler.warning("Could not find class %s", imcMessage.getStringValue());
                }
                continue;
            }
            if (imcMessage.key.equals("registerTransmutatorFuel")) {
                try {
                    AbyssalCraftAPI.registerFuelHandler((IFuelHandler)Class.forName(imcMessage.getStringValue()).newInstance(), AbyssalCraftAPI.FuelType.TRANSMUTATOR);
                    IMCHandler.info("Recieved Transmutator fuel handler %s from mod %s", imcMessage.getStringValue(), imcMessage.getSender());
                    if (senders.contains(imcMessage.getSender())) continue;
                    senders.add(imcMessage.getSender());
                }
                catch (InstantiationException e) {
                    IMCHandler.warning("Could not create a instance of class %s (not a IFuelHandler?)", imcMessage.getStringValue());
                }
                catch (IllegalAccessException e) {
                    IMCHandler.warning("Unable to access class %s", imcMessage.getStringValue());
                }
                catch (ClassNotFoundException e) {
                    IMCHandler.warning("Could not find class %s", imcMessage.getStringValue());
                }
                continue;
            }
            if (imcMessage.key.equals("registerCrystallizerFuel")) {
                try {
                    AbyssalCraftAPI.registerFuelHandler((IFuelHandler)Class.forName(imcMessage.getStringValue()).newInstance(), AbyssalCraftAPI.FuelType.CRYSTALLIZER);
                    IMCHandler.info("Recieved Crystallizer fuel handler %s from mod %s", imcMessage.getStringValue(), imcMessage.getSender());
                    if (senders.contains(imcMessage.getSender())) continue;
                    senders.add(imcMessage.getSender());
                }
                catch (InstantiationException e) {
                    IMCHandler.warning("Could not create a instance of class %s (not a IFuelHandler?)", imcMessage.getStringValue());
                }
                catch (IllegalAccessException e) {
                    IMCHandler.warning("Unable to access class %s", imcMessage.getStringValue());
                }
                catch (ClassNotFoundException e) {
                    IMCHandler.warning("Could not find class %s", imcMessage.getStringValue());
                }
                continue;
            }
            if (imcMessage.key.equals("addCrystal")) {
                boolean failed = false;
                if (!imcMessage.isItemStackMessage()) {
                    failed = true;
                } else {
                    ItemStack crystal = imcMessage.getItemStackValue();
                    if (crystal == null) {
                        failed = true;
                    }
                    if (!failed) {
                        AbyssalCraftAPI.addCrystal(crystal);
                    }
                }
                if (failed) {
                    IMCHandler.warning("Received invalid Crystal addition from mod %s", imcMessage.getSender());
                    continue;
                }
                IMCHandler.info("Received Crystal addition from mod %s", imcMessage.getSender());
                continue;
            }
            if (imcMessage.key.equals("addCrystallization")) {
                boolean failed = false;
                if (!imcMessage.isNBTMessage()) {
                    failed = true;
                } else {
                    if (!senders.contains(imcMessage.getSender())) {
                        senders.add(imcMessage.getSender());
                    }
                    if (!((stuff = imcMessage.getNBTValue()).func_74764_b("input") && stuff.func_74764_b("output1") && stuff.func_74764_b("output2") && stuff.func_74764_b("xp"))) {
                        failed = true;
                    }
                    input = new ItemStack(stuff.func_74775_l("input"));
                    output1 = new ItemStack(stuff.func_74775_l("output1"));
                    output2 = new ItemStack(stuff.func_74775_l("output2"));
                    if (input == null || output1 == null || output2 == null) {
                        failed = true;
                    }
                    if (!failed) {
                        AbyssalCraftAPI.addCrystallization(input, output1, output2, stuff.func_74760_g("xp"));
                    }
                }
                if (failed) {
                    IMCHandler.warning("Received invalid Crystallizer recipe from mod %s!", imcMessage.getSender());
                    continue;
                }
                IMCHandler.info("Received Crystallizer recipe from mod %s", imcMessage.getSender());
                continue;
            }
            if (imcMessage.key.equals("addSingleCrystallization")) {
                boolean failed = false;
                if (!imcMessage.isNBTMessage()) {
                    failed = true;
                } else {
                    if (!senders.contains(imcMessage.getSender())) {
                        senders.add(imcMessage.getSender());
                    }
                    if (!((stuff = imcMessage.getNBTValue()).func_74764_b("input") && stuff.func_74764_b("output") && stuff.func_74764_b("xp"))) {
                        failed = true;
                    }
                    input = new ItemStack(stuff.func_74775_l("input"));
                    output = new ItemStack(stuff.func_74775_l("output"));
                    if (input == null || output == null) {
                        failed = true;
                    }
                    if (!failed) {
                        AbyssalCraftAPI.addSingleCrystallization(input, output, stuff.func_74760_g("xp"));
                    }
                }
                if (failed) {
                    IMCHandler.warning("Received invalid Single Crystallizer recipe from mod %s!", imcMessage.getSender());
                    continue;
                }
                IMCHandler.info("Received Single Crystallizer recipe from mod %s", imcMessage.getSender());
                continue;
            }
            if (imcMessage.key.equals("addOredictCrystallization")) {
                boolean failed = false;
                if (!imcMessage.isNBTMessage()) {
                    failed = true;
                } else {
                    if (!senders.contains(imcMessage.getSender())) {
                        senders.add(imcMessage.getSender());
                    }
                    if (!((stuff = imcMessage.getNBTValue()).func_74764_b("input") && stuff.func_74764_b("output1") && stuff.func_74764_b("output2") && stuff.func_74764_b("xp"))) {
                        failed = true;
                    }
                    input = stuff.func_74779_i("input");
                    output1 = stuff.func_74779_i("output1");
                    output2 = stuff.func_74779_i("output2");
                    if (input == null || output1 == null || output2 == null) {
                        failed = true;
                    }
                    if (!failed) {
                        if (stuff.func_74764_b("quantity1") && stuff.func_74764_b("quantity2")) {
                            AbyssalCraftAPI.addCrystallization((String)input, (String)output1, stuff.func_74762_e("quantity1"), (String)output2, stuff.func_74762_e("quantity2"), stuff.func_74760_g("xp"));
                        } else {
                            AbyssalCraftAPI.addCrystallization((String)input, (String)output1, (String)output2, stuff.func_74760_g("xp"));
                        }
                    }
                }
                if (failed) {
                    IMCHandler.warning("Received invalid OreDictionary Crystallizer recipe from mod %s!", imcMessage.getSender());
                    continue;
                }
                IMCHandler.info("Received OreDictionary Crystallizer recipe from mod %s", imcMessage.getSender());
                continue;
            }
            if (imcMessage.key.equals("addSingleOredictCrystallization")) {
                boolean failed = false;
                if (!imcMessage.isNBTMessage()) {
                    failed = true;
                } else {
                    if (!senders.contains(imcMessage.getSender())) {
                        senders.add(imcMessage.getSender());
                    }
                    if (!((stuff = imcMessage.getNBTValue()).func_74764_b("input") && stuff.func_74764_b("output") && stuff.func_74764_b("xp"))) {
                        failed = true;
                    }
                    input = stuff.func_74779_i("input");
                    output = stuff.func_74779_i("output");
                    if (input == null || output == null) {
                        failed = true;
                    }
                    if (!failed) {
                        if (stuff.func_74764_b("quantity")) {
                            AbyssalCraftAPI.addSingleCrystallization((String)input, (String)output, stuff.func_74762_e("quantity"), stuff.func_74760_g("xp"));
                        } else {
                            AbyssalCraftAPI.addSingleCrystallization((String)input, (String)output, stuff.func_74760_g("xp"));
                        }
                    }
                }
                if (failed) {
                    IMCHandler.warning("Received invalid Single OreDictionary Crystallizer recipe from mod %s!", imcMessage.getSender());
                    continue;
                }
                IMCHandler.info("Received Single OreDictionary Crystallizer recipe from mod %s", imcMessage.getSender());
                continue;
            }
            if (imcMessage.key.equals("addTransmutation")) {
                boolean failed = false;
                if (!imcMessage.isNBTMessage()) {
                    failed = true;
                } else {
                    if (!senders.contains(imcMessage.getSender())) {
                        senders.add(imcMessage.getSender());
                    }
                    if (!((stuff = imcMessage.getNBTValue()).func_74764_b("input") && stuff.func_74764_b("output") && stuff.func_74764_b("xp"))) {
                        failed = true;
                    }
                    input = new ItemStack(stuff.func_74775_l("input"));
                    output = new ItemStack(stuff.func_74775_l("output"));
                    if (input == null || output == null) {
                        failed = true;
                    }
                    if (!failed) {
                        AbyssalCraftAPI.addTransmutation(input, output, stuff.func_74760_g("xp"));
                    }
                }
                if (failed) {
                    IMCHandler.warning("Received invalid Transmutator recipe from mod %s!", imcMessage.getSender());
                    continue;
                }
                IMCHandler.info("Received Transmutator recipe from mod %s", imcMessage.getSender());
                continue;
            }
            if (imcMessage.key.equals("addOredictTransmutation")) {
                boolean failed = false;
                if (!imcMessage.isNBTMessage()) {
                    failed = true;
                } else {
                    if (!senders.contains(imcMessage.getSender())) {
                        senders.add(imcMessage.getSender());
                    }
                    if (!((stuff = imcMessage.getNBTValue()).func_74764_b("input") && stuff.func_74764_b("output") && stuff.func_74764_b("xp"))) {
                        failed = true;
                    }
                    input = stuff.func_74779_i("input");
                    output = stuff.func_74779_i("output");
                    if (input == null || output == null) {
                        failed = true;
                    }
                    if (!failed) {
                        if (stuff.func_74764_b("quantity")) {
                            AbyssalCraftAPI.addTransmutation((String)input, (String)output, stuff.func_74762_e("quantity"), stuff.func_74760_g("xp"));
                        } else {
                            AbyssalCraftAPI.addTransmutation((String)input, (String)output, stuff.func_74760_g("xp"));
                        }
                    }
                }
                if (failed) {
                    IMCHandler.warning("Received invalid OreDictionary Transmutator recipe from mod %s!", imcMessage.getSender());
                    continue;
                }
                IMCHandler.info("Received OreDictionary Transmutator recipe from mod %s", imcMessage.getSender());
                continue;
            }
            if (imcMessage.key.equals("addMaterialization")) {
                boolean failed = false;
                if (!imcMessage.isNBTMessage()) {
                    failed = true;
                } else {
                    NBTTagCompound stuff2;
                    if (!senders.contains(imcMessage.getSender())) {
                        senders.add(imcMessage.getSender());
                    }
                    if (!(stuff2 = imcMessage.getNBTValue()).func_74764_b("input1") || !stuff2.func_74764_b("output")) {
                        failed = true;
                    }
                    ItemStack input1 = new ItemStack(stuff2.func_74775_l("input1"));
                    ItemStack input2 = new ItemStack(stuff2.func_74775_l("input2"));
                    ItemStack input3 = new ItemStack(stuff2.func_74775_l("input3"));
                    ItemStack input4 = new ItemStack(stuff2.func_74775_l("input4"));
                    ItemStack input5 = new ItemStack(stuff2.func_74775_l("input5"));
                    ItemStack output3 = new ItemStack(stuff2.func_74775_l("output"));
                    if (input1 == null || output3 == null) {
                        failed = true;
                    }
                    ItemStack[] items = new ItemStack[]{input1, input2, input3, input4, input5};
                    if (!failed) {
                        AbyssalCraftAPI.addMaterialization(items, output3);
                    }
                }
                if (failed) {
                    IMCHandler.warning("Received invalid Materializer recipe from mod %s!", imcMessage.getSender());
                    continue;
                }
                IMCHandler.info("Received Materializer recipe from mod %s", imcMessage.getSender());
                continue;
            }
            if (imcMessage.key.equals("addGhoulArmor")) {
                boolean failed = false;
                if (!imcMessage.isNBTMessage()) {
                    failed = true;
                } else {
                    if (!senders.contains(imcMessage.getSender())) {
                        senders.add(imcMessage.getSender());
                    }
                    tag = imcMessage.getNBTValue();
                    helmet = new ItemStack(tag.func_74775_l("helmet"));
                    ItemStack chestplate = new ItemStack(tag.func_74775_l("chestplate"));
                    ItemStack leggings = new ItemStack(tag.func_74775_l("leggings"));
                    ItemStack boots = new ItemStack(tag.func_74775_l("boots"));
                    if (helmet != null && chestplate != null && leggings != null && boots != null) {
                        if (tag.func_74764_b("res1") && tag.func_74764_b("res2")) {
                            AbyssalCraftAPI.addGhoulArmorTextures(helmet.func_77973_b(), chestplate.func_77973_b(), leggings.func_77973_b(), boots.func_77973_b(), tag.func_74779_i("res1"), tag.func_74779_i("res2"));
                        } else {
                            failed = true;
                        }
                    } else {
                        failed = true;
                    }
                }
                if (failed) {
                    IMCHandler.warning("Received invalid Ghoul Armor Texture Registration from mod %s!", imcMessage.getSender());
                    continue;
                }
                IMCHandler.info("Received Ghoul Armor Texture Registration from mod %s", imcMessage.getSender());
                continue;
            }
            if (imcMessage.key.equals("addGhoulHelmet")) {
                boolean failed = false;
                if (!imcMessage.isNBTMessage()) {
                    failed = true;
                } else {
                    if (!senders.contains(imcMessage.getSender())) {
                        senders.add(imcMessage.getSender());
                    }
                    if ((helmet = new ItemStack((tag = imcMessage.getNBTValue()).func_74775_l("helmet"))) != null && tag.func_74764_b("res")) {
                        AbyssalCraftAPI.addGhoulHelmetTexture(helmet.func_77973_b(), tag.func_74779_i("res"));
                    } else {
                        failed = true;
                    }
                }
                if (failed) {
                    IMCHandler.warning("Received invalid Ghoul Helmet Texture Registration from mod %s!", imcMessage.getSender());
                    continue;
                }
                IMCHandler.info("Received Ghoul Helmet Texture Registration from mod %s", imcMessage.getSender());
                continue;
            }
            if (imcMessage.key.equals("addGhoulChestplate")) {
                boolean failed = false;
                if (!imcMessage.isNBTMessage()) {
                    failed = true;
                } else {
                    ItemStack chestplate;
                    if (!senders.contains(imcMessage.getSender())) {
                        senders.add(imcMessage.getSender());
                    }
                    if ((chestplate = new ItemStack((tag = imcMessage.getNBTValue()).func_74775_l("chestplate"))) != null && tag.func_74764_b("res")) {
                        AbyssalCraftAPI.addGhoulChestplateTexture(chestplate.func_77973_b(), tag.func_74779_i("res"));
                    } else {
                        failed = true;
                    }
                }
                if (failed) {
                    IMCHandler.warning("Received invalid Ghoul Chestplate Texture Registration from mod %s!", imcMessage.getSender());
                    continue;
                }
                IMCHandler.info("Received Ghoul Chestplate Texture Registration from mod %s", imcMessage.getSender());
                continue;
            }
            if (imcMessage.key.equals("addGhoulLeggings")) {
                boolean failed = false;
                if (!imcMessage.isNBTMessage()) {
                    failed = true;
                } else {
                    ItemStack leggings;
                    if (!senders.contains(imcMessage.getSender())) {
                        senders.add(imcMessage.getSender());
                    }
                    if ((leggings = new ItemStack((tag = imcMessage.getNBTValue()).func_74775_l("leggings"))) != null && tag.func_74764_b("res")) {
                        AbyssalCraftAPI.addGhoulLeggingsTexture(leggings.func_77973_b(), tag.func_74779_i("res"));
                    } else {
                        failed = true;
                    }
                }
                if (failed) {
                    IMCHandler.warning("Received invalid Ghoul Leggings Texture Registration from mod %s!", imcMessage.getSender());
                    continue;
                }
                IMCHandler.info("Received Ghoul Leggings Texture Registration from mod %s", imcMessage.getSender());
                continue;
            }
            if (imcMessage.key.equals("addGhoulBoots")) {
                boolean failed = false;
                if (!imcMessage.isNBTMessage()) {
                    failed = true;
                } else {
                    ItemStack boots;
                    if (!senders.contains(imcMessage.getSender())) {
                        senders.add(imcMessage.getSender());
                    }
                    if ((boots = new ItemStack((tag = imcMessage.getNBTValue()).func_74775_l("boots"))) != null && tag.func_74764_b("res")) {
                        AbyssalCraftAPI.addGhoulBootsTexture(boots.func_77973_b(), tag.func_74779_i("res"));
                    } else {
                        failed = true;
                    }
                }
                if (failed) {
                    IMCHandler.warning("Received invalid Ghoul Boots Texture Registration from mod %s!", imcMessage.getSender());
                    continue;
                }
                IMCHandler.info("Received Ghoul Boots Texture Registration from mod %s", imcMessage.getSender());
                continue;
            }
            IMCHandler.warning("Received an IMC Message with unknown key (%s) from mod %s!", imcMessage.key, imcMessage.getSender());
        }
        if (!senders.isEmpty()) {
            IMCHandler.info("Recieved messages from the following mods: %s", senders);
        }
    }

    private static void info(String format, Object ... data) {
        FMLLog.log((String)"AbyssalCraft|IMC", (Level)Level.INFO, (String)format, (Object[])data);
    }

    private static void warning(String format, Object ... data) {
        FMLLog.log((String)"AbyssalCraft|IMC", (Level)Level.WARN, (String)format, (Object[])data);
    }
}

