/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.common.entity;

import com.github.alexthe666.iceandfire.entity.IBlacklistedFromStatues;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.shinoow.abyssalcraft.api.AbyssalCraftAPI;
import com.shinoow.abyssalcraft.api.biome.ACBiomes;
import com.shinoow.abyssalcraft.api.biome.IDreadlandsBiome;
import com.shinoow.abyssalcraft.api.entity.EntityUtil;
import com.shinoow.abyssalcraft.api.entity.IDreadEntity;
import com.shinoow.abyssalcraft.api.item.ACItems;
import com.shinoow.abyssalcraft.common.entity.EntityChagarothFist;
import com.shinoow.abyssalcraft.common.entity.EntityChagarothSpawn;
import com.shinoow.abyssalcraft.common.entity.EntityDreadSlug;
import com.shinoow.abyssalcraft.common.entity.EntityDreadSpawn;
import com.shinoow.abyssalcraft.common.entity.EntityDreadedCharge;
import com.shinoow.abyssalcraft.common.entity.EntityDreadguard;
import com.shinoow.abyssalcraft.common.entity.EntityGreaterDreadSpawn;
import com.shinoow.abyssalcraft.common.entity.ai.EntityAIChagarothAttackMelee;
import com.shinoow.abyssalcraft.common.util.BiomeUtil;
import com.shinoow.abyssalcraft.lib.ACConfig;
import com.shinoow.abyssalcraft.lib.ACLoot;
import com.shinoow.abyssalcraft.lib.ACSounds;
import com.shinoow.abyssalcraft.lib.util.SpecialTextUtil;
import java.util.Calendar;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Optional.Interface(iface="com.github.alexthe666.iceandfire.entity.IBlacklistedFromStatues", modid="iceandfire")
public class EntityChagaroth
extends EntityMob
implements IDreadEntity,
IBlacklistedFromStatues {
    private static final UUID attackDamageBoostUUID = UUID.fromString("648D7064-6A60-4F59-8ABE-C2C23A6DD7A9");
    private static final AttributeModifier attackDamageBoost = new AttributeModifier(attackDamageBoostUUID, "Halloween Attack Damage Boost", 8.0, 0);
    public int deathTicks;
    private final BossInfoServer bossInfo = (BossInfoServer)new BossInfoServer(this.func_145748_c_(), BossInfo.Color.BLUE, BossInfo.Overlay.PROGRESS).func_186741_a(true);
    private static final DataParameter<Integer> FIRST_HEAD_TARGET = EntityDataManager.func_187226_a(EntityChagaroth.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> SECOND_HEAD_TARGET = EntityDataManager.func_187226_a(EntityChagaroth.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> THIRD_HEAD_TARGET = EntityDataManager.func_187226_a(EntityChagaroth.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer>[] HEAD_TARGETS = new DataParameter[]{FIRST_HEAD_TARGET, SECOND_HEAD_TARGET, THIRD_HEAD_TARGET};
    private static final DataParameter<Integer> BARF_TIMER = EntityDataManager.func_187226_a(EntityChagaroth.class, (DataSerializer)DataSerializers.field_187192_b);
    private final float[] xRotationHeads = new float[2];
    private final float[] yRotationHeads = new float[2];
    private final float[] xRotOHeads = new float[2];
    private final float[] yRotOHeads = new float[2];
    private final int[] nextHeadUpdate = new int[2];
    private final int[] idleHeadUpdates = new int[2];

    public EntityChagaroth(World par1World) {
        super(par1World);
        this.func_70105_a(2.0f, 4.8f);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIChagarothAttackMelee((EntityCreature)this, 0.0, true));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 16.0f));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 0, true, false, entity -> !(entity instanceof IDreadEntity)));
        this.field_70158_ak = true;
        this.field_70178_ae = true;
    }

    public String func_70005_c_() {
        return TextFormatting.DARK_RED + super.func_70005_c_();
    }

    public AxisAlignedBB func_70046_E() {
        return this.func_174813_aQ();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FIRST_HEAD_TARGET, (Object)0);
        this.field_70180_af.func_187214_a(SECOND_HEAD_TARGET, (Object)0);
        this.field_70180_af.func_187214_a(THIRD_HEAD_TARGET, (Object)0);
        this.field_70180_af.func_187214_a(BARF_TIMER, (Object)0);
    }

    public int getWatchedTargetId(int head) {
        return (Integer)this.field_70180_af.func_187225_a(HEAD_TARGETS[head]);
    }

    public void updateWatchedTargetId(int targetOffset, int newId) {
        this.field_70180_af.func_187227_b(HEAD_TARGETS[targetOffset], (Object)newId);
    }

    public int getBarfTimer() {
        return (Integer)this.field_70180_af.func_187225_a(BARF_TIMER);
    }

    public void setBarfTimer(int time) {
        this.field_70180_af.func_187227_b(BARF_TIMER, (Object)time);
    }

    public void decrementBarfTimer() {
        this.setBarfTimer(this.getBarfTimer() - 1);
    }

    public boolean isMouthOpen() {
        return this.getBarfTimer() > 0;
    }

    public boolean func_70652_k(Entity par1Entity) {
        boolean flag = super.func_70652_k(par1Entity);
        if (flag && par1Entity instanceof EntityLivingBase && !EntityUtil.isEntityDread((EntityLivingBase)par1Entity)) {
            ((EntityLivingBase)par1Entity).func_70690_d(new PotionEffect(AbyssalCraftAPI.dread_plague, 100));
        }
        if (ACConfig.hardcoreMode && par1Entity instanceof EntityPlayer) {
            par1Entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this).func_76348_h().func_151518_m(), 4.5f * (float)(ACConfig.damageAmpl > 1.0 ? ACConfig.damageAmpl : 1.0));
        }
        return flag;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(ACConfig.hardcoreMode ? 2000.0 : 1000.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(ACConfig.hardcoreMode ? 30.0 : 15.0);
    }

    public boolean func_70648_aU() {
        return true;
    }

    protected SoundEvent func_184639_G() {
        return ACSounds.dreadguard_ambient;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return ACSounds.dreadguard_hurt;
    }

    protected SoundEvent func_184615_bR() {
        return ACSounds.dreadguard_death;
    }

    protected ResourceLocation func_184647_J() {
        return ACLoot.ENTITY_CHAGAROTH;
    }

    protected float func_70599_aP() {
        return 5.0f;
    }

    public int func_70658_aO() {
        return 10;
    }

    protected void func_70623_bb() {
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        if ((double)this.func_110143_aJ() > (double)this.func_110138_aP() * 0.75 && this.bossInfo.func_186736_g() != BossInfo.Color.BLUE) {
            this.bossInfo.func_186745_a(BossInfo.Color.BLUE);
        }
        if ((double)this.func_110143_aJ() < (double)this.func_110138_aP() * 0.75 && this.func_110143_aJ() > this.func_110138_aP() / 2.0f && this.bossInfo.func_186736_g() != BossInfo.Color.GREEN) {
            this.bossInfo.func_186745_a(BossInfo.Color.GREEN);
        }
        if (this.func_110143_aJ() < this.func_110138_aP() / 2.0f && this.func_110143_aJ() > this.func_110138_aP() / 4.0f && this.bossInfo.func_186736_g() != BossInfo.Color.YELLOW) {
            this.bossInfo.func_186745_a(BossInfo.Color.YELLOW);
        }
        if (this.func_110143_aJ() < this.func_110138_aP() / 4.0f && this.func_110143_aJ() > 0.0f && this.bossInfo.func_186736_g() != BossInfo.Color.RED) {
            this.bossInfo.func_186745_a(BossInfo.Color.RED);
        }
        block0: for (int i = 1; i < 3; ++i) {
            if (this.field_70173_aa < this.nextHeadUpdate[i - 1]) continue;
            this.nextHeadUpdate[i - 1] = this.field_70173_aa + 10 + this.field_70146_Z.nextInt(10);
            int k1 = this.getWatchedTargetId(i);
            if (k1 > 0) {
                Entity entity2 = this.field_70170_p.func_73045_a(k1);
                if (entity2 != null && entity2.func_70089_S() && this.func_70068_e(entity2) <= 2304.0 && this.func_70685_l(entity2)) {
                    if (entity2 instanceof EntityPlayer && ((EntityPlayer)entity2).field_71075_bZ.field_75102_a) {
                        this.updateWatchedTargetId(i, 0);
                        continue;
                    }
                    this.launchWitherSkullToEntity(i + 1, (EntityLivingBase)entity2);
                    this.idleHeadUpdates[i - 1] = 0;
                    continue;
                }
                this.updateWatchedTargetId(i, 0);
                continue;
            }
            List list = this.field_70170_p.func_175647_a(EntityLivingBase.class, this.func_174813_aQ().func_186662_g(48.0), Predicates.and((Predicate)EntitySelectors.field_180132_d, entity -> !EntityUtil.isEntityDread(entity)));
            for (int j2 = 0; j2 < 10 && !list.isEmpty(); ++j2) {
                EntityLivingBase entitylivingbase = (EntityLivingBase)list.get(this.field_70146_Z.nextInt(list.size()));
                if (entitylivingbase != this && entitylivingbase.func_70089_S() && this.func_70685_l((Entity)entitylivingbase)) {
                    if (entitylivingbase instanceof EntityPlayer) {
                        if (((EntityPlayer)entitylivingbase).field_71075_bZ.field_75102_a) continue block0;
                        this.updateWatchedTargetId(i, entitylivingbase.func_145782_y());
                        continue block0;
                    }
                    this.updateWatchedTargetId(i, entitylivingbase.func_145782_y());
                    continue block0;
                }
                list.remove(entitylivingbase);
            }
        }
        if (this.func_70638_az() != null) {
            this.updateWatchedTargetId(0, this.func_70638_az().func_145782_y());
        } else {
            this.updateWatchedTargetId(0, 0);
        }
    }

    private void launchWitherSkullToEntity(int p_82216_1_, EntityLivingBase p_82216_2_) {
        this.launchWitherSkullToCoords(p_82216_1_, p_82216_2_.field_70165_t, p_82216_2_.field_70163_u + 0.5, p_82216_2_.field_70161_v, true);
    }

    private void launchWitherSkullToCoords(int p_82209_1_, double x, double y, double z, boolean invulnerable) {
        double d0 = this.getHeadX(p_82209_1_);
        double d1 = this.getHeadY(p_82209_1_);
        double d2 = this.getHeadZ(p_82209_1_);
        double d3 = x - d0;
        double d4 = y - d1;
        double d5 = z - d2;
        float f1 = MathHelper.func_76133_a((double)(d3 * d3 + d5 * d5)) * 0.2f;
        float f2 = MathHelper.func_76133_a((double)(d3 * d3 + d4 * d4 + d5 * d5));
        EntityDreadSlug entitydreadslug = new EntityDreadSlug(this.field_70170_p, (EntityLivingBase)this);
        entitydreadslug.field_70163_u = d1;
        entitydreadslug.field_70165_t = d0;
        entitydreadslug.field_70161_v = d2;
        entitydreadslug.func_70186_c(d3, d4 + (double)f1, d5, 1.75f, 1.0f);
        if (!this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72838_d((Entity)entitydreadslug);
        }
        entitydreadslug.field_70159_w = d3 / (double)f2 * 0.8 * 0.8 + entitydreadslug.field_70159_w;
        entitydreadslug.field_70181_x = d4 / (double)f2 * 0.8 * 0.8 + entitydreadslug.field_70181_x;
        entitydreadslug.field_70179_y = d5 / (double)f2 * 0.8 * 0.8 + entitydreadslug.field_70179_y;
        switch (this.field_70146_Z.nextInt(5)) {
            case 0: {
                EntityDreadSlug entitydreadslug1 = new EntityDreadSlug(this.field_70170_p, (EntityLivingBase)this);
                entitydreadslug1.field_70163_u = d1;
                entitydreadslug1.field_70165_t = d0;
                entitydreadslug1.field_70161_v = d2;
                entitydreadslug1.func_70186_c(d3, d4 + (double)f1, d5, 1.75f, 1.0f);
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_72838_d((Entity)entitydreadslug1);
                }
                entitydreadslug1.field_70159_w = d3 / (double)f2 * 0.8 * 0.8 + entitydreadslug1.field_70159_w;
                entitydreadslug1.field_70181_x = d4 / (double)f2 * 0.8 * 0.8 + entitydreadslug1.field_70181_x;
                entitydreadslug1.field_70179_y = d5 / (double)f2 * 0.8 * 0.8 + entitydreadslug1.field_70179_y;
                this.nextHeadUpdate[p_82209_1_ - 2] = this.field_70173_aa + 10;
                break;
            }
            case 1: {
                EntityDreadSlug entitydreadslug11 = new EntityDreadSlug(this.field_70170_p, (EntityLivingBase)this);
                entitydreadslug11.field_70163_u = d1;
                entitydreadslug11.field_70165_t = d0;
                entitydreadslug11.field_70161_v = d2;
                EntityDreadSpawn mob = new EntityDreadSpawn(this.field_70170_p);
                mob.func_82149_j((Entity)entitydreadslug11);
                entitydreadslug11.func_70186_c(d3, d4 + (double)f1 + this.field_70146_Z.nextDouble() * 150.0, d5, 1.3f, 1.0f);
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_72838_d((Entity)entitydreadslug11);
                }
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_72838_d((Entity)mob);
                }
                mob.func_184220_m((Entity)entitydreadslug11);
                mob.func_180482_a(this.field_70170_p.func_175649_E(this.func_180425_c()), null);
                this.nextHeadUpdate[p_82209_1_ - 2] = this.field_70173_aa + 20;
                break;
            }
            case 2: {
                EntityDreadSlug entitydreadslug111 = new EntityDreadSlug(this.field_70170_p, (EntityLivingBase)this);
                entitydreadslug111.field_70163_u = d1;
                entitydreadslug111.field_70165_t = d0;
                entitydreadslug111.field_70161_v = d2;
                EntityChagarothSpawn spawn = new EntityChagarothSpawn(this.field_70170_p);
                spawn.func_82149_j((Entity)entitydreadslug111);
                entitydreadslug111.func_70186_c(d3, d4 + (double)f1 + this.field_70146_Z.nextDouble() * 150.0, d5, 1.3f, 1.0f);
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_72838_d((Entity)entitydreadslug111);
                }
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_72838_d((Entity)spawn);
                }
                spawn.func_184220_m((Entity)entitydreadslug111);
                spawn.func_180482_a(this.field_70170_p.func_175649_E(this.func_180425_c()), null);
                this.nextHeadUpdate[p_82209_1_ - 2] = this.field_70173_aa + 20;
                break;
            }
            case 3: {
                EntityDreadSlug entitydreadslug1111 = new EntityDreadSlug(this.field_70170_p, (EntityLivingBase)this);
                entitydreadslug1111.field_70163_u = d1;
                entitydreadslug1111.field_70165_t = d0;
                entitydreadslug1111.field_70161_v = d2;
                EntityChagarothFist fist = new EntityChagarothFist(this.field_70170_p);
                fist.func_82149_j((Entity)entitydreadslug1111);
                entitydreadslug1111.func_70186_c(d3, d4 + (double)f1 + this.field_70146_Z.nextDouble() * 150.0, d5, 1.3f, 1.0f);
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_72838_d((Entity)entitydreadslug1111);
                }
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_72838_d((Entity)fist);
                }
                fist.func_184220_m((Entity)entitydreadslug1111);
                fist.func_180482_a(this.field_70170_p.func_175649_E(this.func_180425_c()), null);
                this.nextHeadUpdate[p_82209_1_ - 2] = this.field_70173_aa + 20;
                break;
            }
            case 4: {
                this.field_70170_p.func_180498_a((EntityPlayer)null, 1016, new BlockPos((Entity)this), 0);
                d4 = y + 0.5 - d1;
                EntityDreadedCharge entitydragonfireball = new EntityDreadedCharge(this.field_70170_p, (EntityLivingBase)this, d3, d4, d5);
                entitydragonfireball.field_70165_t = d0;
                entitydragonfireball.field_70163_u = d1;
                entitydragonfireball.field_70161_v = d2;
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_72838_d((Entity)entitydragonfireball);
                }
                this.nextHeadUpdate[p_82209_1_ - 2] = this.field_70173_aa + 100;
            }
        }
    }

    private double getHeadX(int p_82214_1_) {
        if (p_82214_1_ <= 0) {
            return this.field_70165_t;
        }
        float f = (this.field_70761_aq + (float)(180 * (p_82214_1_ - 1))) * ((float)Math.PI / 180);
        float f1 = MathHelper.func_76134_b((float)f);
        return this.field_70165_t + (double)f1 * 1.4;
    }

    private double getHeadY(int p_82208_1_) {
        return this.field_70163_u + (double)this.func_70047_e() * 0.8;
    }

    private double getHeadZ(int p_82213_1_) {
        if (p_82213_1_ <= 0) {
            return this.field_70161_v;
        }
        float f = (this.field_70761_aq + (float)(180 * (p_82213_1_ - 1))) * ((float)Math.PI / 180);
        float f1 = MathHelper.func_76126_a((float)f);
        return this.field_70161_v + (double)f1 * 1.4;
    }

    private float rotlerp(float p_82204_1_, float p_82204_2_, float p_82204_3_) {
        float f = MathHelper.func_76142_g((float)(p_82204_2_ - p_82204_1_));
        if (f > p_82204_3_) {
            f = p_82204_3_;
        }
        if (f < -p_82204_3_) {
            f = -p_82204_3_;
        }
        return p_82204_1_ + f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getHeadYRotation(int p_82207_1_) {
        return this.yRotationHeads[p_82207_1_];
    }

    @SideOnly(value=Side.CLIENT)
    public float getHeadXRotation(int p_82210_1_) {
        return this.xRotationHeads[p_82210_1_];
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    public void func_70636_d() {
        this.func_70105_a(2.25f, 4.5f);
        if (this.field_70173_aa % 40 == 0 && !this.field_70170_p.field_72995_K) {
            for (int x = this.func_180425_c().func_177958_n() - 3; x <= this.func_180425_c().func_177958_n() + 3; ++x) {
                for (int z = this.func_180425_c().func_177952_p() - 3; z <= this.func_180425_c().func_177952_p() + 3; ++z) {
                    if (this.field_70170_p.func_180494_b(new BlockPos(x, 0, z)) instanceof IDreadlandsBiome || this.field_70170_p.func_180494_b(new BlockPos(x, 0, z)) == ACBiomes.purged) continue;
                    BiomeUtil.updateBiome(this.field_70170_p, new BlockPos(x, 0, z), ACBiomes.dreadlands);
                }
            }
        }
        this.func_70031_b(false);
        this.field_70159_w = 0.0;
        this.field_70179_y = 0.0;
        if (this.field_70181_x > 0.0) {
            this.field_70181_x = 0.0;
        }
        this.field_70160_al = false;
        this.field_70122_E = true;
        for (int i = 0; i < 2; ++i) {
            this.yRotOHeads[i] = this.yRotationHeads[i];
            this.xRotOHeads[i] = this.xRotationHeads[i];
        }
        for (int j = 0; j < 2; ++j) {
            int k = this.getWatchedTargetId(j + 1);
            Entity entity1 = null;
            if (k > 0) {
                entity1 = this.field_70170_p.func_73045_a(k);
            }
            if (entity1 != null) {
                double d11 = this.getHeadX(j + 1);
                double d12 = this.getHeadY(j + 1);
                double d13 = this.getHeadZ(j + 1);
                double d6 = entity1.field_70165_t - d11;
                double d7 = entity1.field_70163_u + (double)entity1.func_70047_e() - d12;
                double d8 = entity1.field_70161_v - d13;
                double d9 = MathHelper.func_76133_a((double)(d6 * d6 + d8 * d8));
                float f = (float)(MathHelper.func_181159_b((double)d8, (double)d6) * 57.29577951308232) - 90.0f;
                float f1 = (float)(-(MathHelper.func_181159_b((double)d7, (double)d9) * 57.29577951308232));
                this.xRotationHeads[j] = this.rotlerp(this.xRotationHeads[j], f1, 40.0f);
                this.yRotationHeads[j] = this.rotlerp(this.yRotationHeads[j], f, 10.0f);
                continue;
            }
            this.xRotationHeads[j] = this.rotlerp(this.xRotationHeads[j], this.field_70125_A, 40.0f);
            this.yRotationHeads[j] = this.rotlerp(this.yRotationHeads[j], this.field_70759_as, 10.0f);
        }
        int timer = this.getBarfTimer();
        if (this.func_70638_az() != null && this.func_70068_e((Entity)this.func_70638_az()) <= 256.0 && timer <= -200) {
            this.setBarfTimer(150);
        }
        if (timer > 0) {
            Entity target;
            this.field_70170_p.func_72960_a((Entity)this, (byte)23);
            if (this.field_70173_aa % 5 == 0 && timer > 30) {
                this.field_70170_p.func_184133_a(null, new BlockPos(this.field_70165_t + 0.5, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v + 0.5), ACSounds.dreadguard_barf, this.func_184176_by(), 0.7f + this.func_70681_au().nextFloat(), this.func_70681_au().nextFloat() * 0.6f + 0.2f);
                this.field_70170_p.func_184133_a(null, new BlockPos(this.field_70165_t + 0.5, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v + 0.5), ACSounds.dreadguard_barf, this.func_184176_by(), 0.7f + this.func_70681_au().nextFloat(), this.func_70681_au().nextFloat() * 0.5f + 0.2f);
                this.field_70170_p.func_184133_a(null, new BlockPos(this.field_70165_t + 0.5, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v + 0.5), ACSounds.dreadguard_barf, this.func_184176_by(), 0.7f + this.func_70681_au().nextFloat(), this.func_70681_au().nextFloat() * 0.4f + 0.2f);
            }
            if ((target = this.getHeadLookTarget()) != null) {
                for (EntityLivingBase entity : this.field_70170_p.func_175647_a(EntityLivingBase.class, target.func_174813_aQ().func_72314_b(2.0, 2.0, 2.0), EntitySelectors.field_94557_a)) {
                    if (this.field_70146_Z.nextInt(3) != 0 || !entity.func_70097_a(AbyssalCraftAPI.dread, (float)(7.5 - (double)this.func_70032_d((Entity)entity)) * 2.0f)) continue;
                    entity.func_70690_d(new PotionEffect(AbyssalCraftAPI.dread_plague, 200, 1));
                }
                if (target.func_70097_a(AbyssalCraftAPI.dread, (float)(7.5 - (double)this.func_70032_d(target)) * 2.0f) && target instanceof EntityLivingBase) {
                    ((EntityLivingBase)target).func_70690_d(new PotionEffect(AbyssalCraftAPI.dread_plague, 200, 1));
                }
            }
        }
        this.decrementBarfTimer();
        if (!this.field_70170_p.field_72995_K && this.func_70089_S()) {
            if (this.field_70173_aa % 600 == 0) {
                if (this.field_70146_Z.nextBoolean() && this.field_70170_p.func_72872_a(EntityDreadSpawn.class, this.func_174813_aQ().func_186662_g(32.0)).size() < 20) {
                    EntityDreadSpawn mob = new EntityDreadSpawn(this.field_70170_p);
                    mob.func_82149_j((Entity)this);
                    this.field_70170_p.func_72838_d((Entity)mob);
                    mob.func_180482_a(this.field_70170_p.func_175649_E(this.func_180425_c()), null);
                } else if (this.field_70170_p.func_72872_a(EntityChagarothSpawn.class, this.func_174813_aQ().func_186662_g(32.0)).size() < 20) {
                    EntityChagarothSpawn spawn = new EntityChagarothSpawn(this.field_70170_p);
                    spawn.func_82149_j((Entity)this);
                    this.field_70170_p.func_72838_d((Entity)spawn);
                    spawn.func_180482_a(this.field_70170_p.func_175649_E(this.func_180425_c()), null);
                }
            }
            if (this.field_70173_aa % 1200 == 0) {
                EntityChagarothFist fist = new EntityChagarothFist(this.field_70170_p);
                fist.func_82149_j((Entity)this);
                this.field_70170_p.func_72838_d((Entity)fist);
                fist.func_180482_a(this.field_70170_p.func_175649_E(this.func_180425_c()), null);
            }
            if (this.field_70173_aa % 2400 == 0) {
                EntityDreadguard dreadGuard = new EntityDreadguard(this.field_70170_p);
                dreadGuard.func_82149_j((Entity)this);
                dreadGuard.field_70159_w += 1.0;
                this.field_70170_p.func_72838_d((Entity)dreadGuard);
                dreadGuard.func_180482_a(this.field_70170_p.func_175649_E(this.func_180425_c()), null);
            }
            if (this.field_70173_aa % 4800 == 0 && this.field_70170_p.func_72872_a(EntityGreaterDreadSpawn.class, this.func_174813_aQ().func_186662_g(32.0)).size() < 10) {
                EntityGreaterDreadSpawn dreadGuard = new EntityGreaterDreadSpawn(this.field_70170_p);
                dreadGuard.func_82149_j((Entity)this);
                dreadGuard.field_70159_w += 1.0;
                this.field_70170_p.func_72838_d((Entity)dreadGuard);
                dreadGuard.func_180482_a(this.field_70170_p.func_175649_E(this.func_180425_c()), null);
            }
        }
        super.func_70636_d();
    }

    private Entity getHeadLookTarget() {
        Entity pointedEntity = null;
        double range = 8.0 + this.field_70146_Z.nextDouble() * 20.0;
        Vec3d srcVec = new Vec3d(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v);
        Vec3d lookVec = this.func_70676_i(1.0f);
        RayTraceResult raytrace = this.field_70170_p.func_72933_a(srcVec, srcVec.func_72441_c(lookVec.field_72450_a * range, lookVec.field_72448_b * range, lookVec.field_72449_c * range));
        BlockPos hitpos = raytrace != null ? raytrace.func_178782_a() : null;
        double rx = hitpos == null ? range : Math.min(range, Math.abs(this.field_70165_t - (double)hitpos.func_177958_n()));
        double ry = hitpos == null ? range : Math.min(range, Math.abs(this.field_70163_u - (double)hitpos.func_177956_o()));
        double rz = hitpos == null ? range : Math.min(range, Math.abs(this.field_70161_v - (double)hitpos.func_177952_p()));
        Vec3d destVec = srcVec.func_72441_c(lookVec.field_72450_a * range, lookVec.field_72448_b * range, lookVec.field_72449_c * range);
        float var9 = 8.0f;
        List possibleList = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72317_d(lookVec.field_72450_a * rx, lookVec.field_72448_b * ry, lookVec.field_72449_c * rz).func_72314_b((double)var9, (double)var9, (double)var9));
        double hitDist = 0.0;
        for (Entity possibleEntity : possibleList) {
            double possibleDist;
            if (possibleEntity == this || !(possibleEntity instanceof EntityLivingBase) || EntityUtil.isEntityDread((EntityLivingBase)possibleEntity)) continue;
            float borderSize = possibleEntity.func_70111_Y();
            AxisAlignedBB collisionBB = possibleEntity.func_174813_aQ().func_72314_b((double)borderSize, (double)borderSize, (double)borderSize);
            RayTraceResult interceptPos = collisionBB.func_72327_a(srcVec, destVec);
            if (collisionBB.func_72318_a(srcVec)) {
                if (!(0.0 < hitDist) && hitDist != 0.0) continue;
                pointedEntity = possibleEntity;
                hitDist = 0.0;
                continue;
            }
            if (interceptPos == null || !((possibleDist = srcVec.func_72438_d(interceptPos.field_72307_f)) < hitDist) && hitDist != 0.0) continue;
            pointedEntity = possibleEntity;
            hitDist = possibleDist;
        }
        return pointedEntity;
    }

    protected void addMouthParticles() {
        if (this.field_70170_p.field_72995_K) {
            Vec3d vector = this.func_70040_Z();
            double px = this.field_70165_t + vector.field_72450_a * 1.5;
            double py = this.field_70163_u + (double)(this.field_70131_O * 0.75f);
            double pz = this.field_70161_v + vector.field_72449_c * 1.5;
            for (int i = 0; i < 75; ++i) {
                double dx = vector.field_72450_a;
                double dy = vector.field_72448_b;
                double dz = vector.field_72449_c;
                double spread = 15.0 + this.func_70681_au().nextDouble() * 5.0;
                double velocity = 0.5 + this.func_70681_au().nextDouble();
                dx += this.func_70681_au().nextGaussian() * (double)0.0075f * spread;
                dy += this.func_70681_au().nextGaussian() * (double)0.0075f;
                dz += this.func_70681_au().nextGaussian() * (double)0.0075f * spread;
                this.field_70170_p.func_175688_a(EnumParticleTypes.ITEM_CRACK, px + this.func_70681_au().nextDouble() - 0.5, py + this.func_70681_au().nextDouble() - 0.5, pz + this.func_70681_au().nextDouble() - 0.5, dx *= velocity, dy *= velocity, dz *= velocity, new int[]{Item.func_150891_b((Item)ACItems.dreaded_shard_of_abyssalnite)});
                this.field_70170_p.func_175688_a(EnumParticleTypes.ITEM_CRACK, px + this.func_70681_au().nextDouble() - 0.5, py + this.func_70681_au().nextDouble() - 0.5, pz + this.func_70681_au().nextDouble() - 0.5, dx, dy, dz, new int[]{Item.func_150891_b((Item)ACItems.dread_fragment)});
            }
        } else {
            this.field_70170_p.func_72960_a((Entity)this, (byte)23);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 23) {
            this.addMouthParticles();
        } else {
            super.func_70103_a(id);
        }
    }

    public void func_70108_f(Entity entityIn) {
        double d1;
        double d0;
        double d2;
        if (!this.func_184223_x(entityIn) && !entityIn.field_70145_X && !this.field_70145_X && (d2 = MathHelper.func_76132_a((double)(d0 = entityIn.field_70165_t - this.field_70165_t), (double)(d1 = entityIn.field_70161_v - this.field_70161_v))) >= 0.01) {
            d2 = MathHelper.func_76133_a((double)d2);
            d0 /= d2;
            d1 /= d2;
            double d3 = 1.0 / d2;
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            d0 *= d3;
            d1 *= d3;
            entityIn.func_70024_g(d0 *= 0.2, 0.0, d1 *= 0.2);
            this.func_70024_g(d0 *= 0.1, 0.0, d1 *= 0.1);
        }
    }

    public EnumPushReaction func_184192_z() {
        return EnumPushReaction.IGNORE;
    }

    public void func_70014_b(NBTTagCompound par1NBTTagCompound) {
        super.func_70014_b(par1NBTTagCompound);
        if (this.deathTicks > 0) {
            par1NBTTagCompound.func_74768_a("DeathTicks", this.deathTicks);
        }
        par1NBTTagCompound.func_74768_a("BarfTimer", this.getBarfTimer());
    }

    public void func_70037_a(NBTTagCompound par1NBTTagCompound) {
        super.func_70037_a(par1NBTTagCompound);
        this.deathTicks = par1NBTTagCompound.func_74762_e("DeathTicks");
        this.setBarfTimer(par1NBTTagCompound.func_74762_e("BarfTimer"));
    }

    public void func_70645_a(DamageSource par1DamageSource) {
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        super.func_70645_a(par1DamageSource);
    }

    public boolean func_184222_aU() {
        return false;
    }

    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        if (par2 > 30.0f) {
            par2 = 10 + this.field_70170_p.field_73012_v.nextInt(10);
        }
        return super.func_70097_a(par1DamageSource, par2);
    }

    protected void func_70609_aI() {
        ++this.deathTicks;
        if (this.deathTicks <= 200) {
            float f = (this.field_70146_Z.nextFloat() - 0.5f) * 8.0f;
            float f1 = (this.field_70146_Z.nextFloat() - 0.5f) * 4.0f;
            float f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 8.0f;
            if (ACConfig.particleEntity) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, this.field_70165_t + (double)f, this.field_70163_u + 2.0 + (double)f1, this.field_70161_v + (double)f2, 0.0, 0.0, 0.0, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.LAVA, this.field_70165_t + (double)f, this.field_70163_u + 2.0 + (double)f1, this.field_70161_v + (double)f2, 0.0, 0.0, 0.0, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, this.field_70165_t + (double)f, this.field_70163_u + 2.0 + (double)f1, this.field_70161_v + (double)f2, 0.0, 0.0, 0.0, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t + (double)f, this.field_70163_u + 2.0 + (double)f1, this.field_70161_v + (double)f2, 0.0, 0.0, 0.0, new int[0]);
                if (this.deathTicks >= 190 && this.deathTicks <= 200) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_HUGE, this.field_70165_t + (double)f, this.field_70163_u + 2.0 + (double)f1, this.field_70161_v + (double)f2, 0.0, 0.0, 0.0, new int[0]);
                }
            }
        }
        if (!this.field_70170_p.field_72995_K && this.deathTicks > 150 && this.deathTicks % 5 == 0) {
            int j;
            for (int i = 500; i > 0; i -= j) {
                j = EntityXPOrb.func_70527_a((int)i);
                this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, j));
                if (this.deathTicks != 100 && this.deathTicks != 120 && this.deathTicks != 140 && this.deathTicks != 160 && this.deathTicks != 180) continue;
                this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, this.field_70165_t + (double)this.posneg(3), this.field_70163_u + (double)this.field_70146_Z.nextInt(3), this.field_70161_v + (double)this.posneg(3), new ItemStack(ACItems.dread_fragment, 4)));
                this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, this.field_70165_t + (double)this.posneg(3), this.field_70163_u + (double)this.field_70146_Z.nextInt(3), this.field_70161_v + (double)this.posneg(3), new ItemStack(ACItems.dreaded_chunk_of_abyssalnite, 2)));
                this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, this.field_70165_t + (double)this.posneg(3), this.field_70163_u + (double)this.field_70146_Z.nextInt(3), this.field_70161_v + (double)this.posneg(3), new ItemStack(ACItems.dreaded_shard_of_abyssalnite)));
                this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, this.field_70165_t + (double)this.posneg(3), this.field_70163_u + (double)this.field_70146_Z.nextInt(3), this.field_70161_v + (double)this.posneg(3), new ItemStack(ACItems.dreadium_ingot)));
            }
        }
        if (ACConfig.showBossDialogs) {
            if (this.deathTicks == 20 && !this.field_70170_p.field_72995_K) {
                SpecialTextUtil.ChagarothGroup(this.field_70170_p, I18n.func_74838_a((String)"message.chagaroth.death.1"));
            }
            if (this.deathTicks == 80 && !this.field_70170_p.field_72995_K) {
                SpecialTextUtil.ChagarothGroup(this.field_70170_p, I18n.func_74838_a((String)"message.chagaroth.death.2"));
            }
            if (this.deathTicks == 140 && !this.field_70170_p.field_72995_K) {
                SpecialTextUtil.ChagarothGroup(this.field_70170_p, I18n.func_74838_a((String)"message.chagaroth.death.3"));
            }
            if (this.deathTicks == 200 && !this.field_70170_p.field_72995_K) {
                SpecialTextUtil.ChagarothGroup(this.field_70170_p, I18n.func_74838_a((String)"message.chagaroth.death.4"));
            }
        }
        if (this.deathTicks == 200 && !this.field_70170_p.field_72995_K) {
            this.func_70106_y();
            this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack(ACItems.dread_plagued_gateway_key)));
        }
    }

    private int posneg(int num) {
        return this.field_70146_Z.nextBoolean() ? this.field_70146_Z.nextInt(num) : -1 * this.field_70146_Z.nextInt(num);
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData par1EntityLivingData) {
        par1EntityLivingData = super.func_180482_a(difficulty, par1EntityLivingData);
        IAttributeInstance attribute = this.func_110148_a(SharedMonsterAttributes.field_111264_e);
        Calendar calendar = this.field_70170_p.func_83015_S();
        attribute.func_111124_b(attackDamageBoost);
        if (calendar.get(2) + 1 == 10 && calendar.get(5) == 31) {
            attribute.func_111121_a(attackDamageBoost);
        }
        return par1EntityLivingData;
    }

    public boolean canBeTurnedToStone() {
        return false;
    }
}

