/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.common.caps;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.shinoow.abyssalcraft.common.caps.INecromancyCapability;
import com.shinoow.abyssalcraft.common.caps.NecromancyCapabilityProvider;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Tuple;

public class NecromancyCapability
implements INecromancyCapability {
    List<Tuple<String, NBTTagCompound>> data = Lists.newArrayList();
    Map<String, Integer> sizes = Maps.newHashMap();

    public static INecromancyCapability getCap(EntityPlayer player) {
        return (INecromancyCapability)player.getCapability(NecromancyCapabilityProvider.NECROMANCY_CAP, null);
    }

    @Override
    public NBTTagCompound getDataForName(String name) {
        for (Tuple<String, NBTTagCompound> t : this.data) {
            if (!((String)t.func_76341_a()).equals(name)) continue;
            return (NBTTagCompound)t.func_76340_b();
        }
        return null;
    }

    @Override
    public int getSizeForName(String name) {
        return this.sizes.get(name) != null ? this.sizes.get(name) : 0;
    }

    @Override
    public void storeData(String name, NBTTagCompound data, int size) {
        if (this.getDataForName(name) == null) {
            if (this.data.size() == 5) {
                this.sizes.remove(this.data.get(0).func_76341_a());
                this.data.remove(0);
            }
            this.data.add((Tuple<String, NBTTagCompound>)new Tuple((Object)name, (Object)data));
        } else {
            for (Tuple<String, NBTTagCompound> tuple : this.data) {
                if (!((String)tuple.func_76341_a()).equals(name)) continue;
                Tuple tuple2 = new Tuple((Object)name, (Object)data);
                break;
            }
        }
        this.sizes.put(name, size);
    }

    @Override
    public void clearEntry(String name) {
        for (Tuple<String, NBTTagCompound> t : this.data) {
            if (!((String)t.func_76341_a()).equals(name)) continue;
            this.data.remove(t);
            break;
        }
        this.sizes.remove(name);
    }

    @Override
    public List<Tuple<String, NBTTagCompound>> getData() {
        return this.data;
    }

    @Override
    public Map<String, Integer> getSizeData() {
        return this.sizes;
    }

    @Override
    public void copy(INecromancyCapability cap) {
        this.data = cap.getData();
        this.sizes = cap.getSizeData();
    }
}

