/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.common.blocks.tile;

import com.shinoow.abyssalcraft.common.blocks.BlockStateTransformer;
import com.shinoow.abyssalcraft.common.items.ItemStoneTablet;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class TileEntityStateTransformer
extends TileEntity
implements ITickable,
ISidedInventory {
    public int processingTime;
    private NonNullList<ItemStack> containerItemStacks = NonNullList.func_191197_a((int)50, (Object)ItemStack.field_190927_a);
    public int mode;
    private int[][] slots = new int[][]{{0}, {1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49}, {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49}};
    boolean flag1;
    IItemHandler handlerTop = new SidedInvWrapper((ISidedInventory)this, EnumFacing.UP);
    IItemHandler handlerBottom = new SidedInvWrapper((ISidedInventory)this, EnumFacing.DOWN);
    IItemHandler handlerSide = new SidedInvWrapper((ISidedInventory)this, EnumFacing.WEST);

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        ItemStackHelper.func_191283_b((NBTTagCompound)nbttagcompound, this.containerItemStacks);
        this.processingTime = nbttagcompound.func_74762_e("ProcessingTime");
        this.mode = nbttagcompound.func_74762_e("Mode");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        ItemStackHelper.func_191282_a((NBTTagCompound)nbttagcompound, this.containerItemStacks);
        nbttagcompound.func_74768_a("ProcessingTime", this.processingTime);
        nbttagcompound.func_74768_a("Mode", this.mode);
        return nbttagcompound;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public String func_70005_c_() {
        return "container.abyssalcraft.statetransformer";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70302_i_() {
        return this.containerItemStacks.size();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.containerItemStacks) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.containerItemStacks.get(index);
    }

    public ItemStack func_70298_a(int var1, int var2) {
        if (var1 == 0) {
            this.flag1 = true;
        }
        return ItemStackHelper.func_188382_a(this.containerItemStacks, (int)var1, (int)var2);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.containerItemStacks, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.containerItemStacks.set(index, (Object)stack);
        if (!stack.func_190926_b() && stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (index == 0) {
            this.flag1 = true;
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) != this ? false : player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index == 0) {
            return stack.func_77973_b() instanceof ItemStoneTablet;
        }
        return !(stack.func_77973_b() instanceof ItemStoneTablet);
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public void func_73660_a() {
        boolean flag = false;
        if (!this.field_145850_b.field_72995_K) {
            if (this.canDoThing()) {
                ++this.processingTime;
                if (this.processingTime == 200) {
                    this.processingTime = 0;
                    this.processItem();
                    flag = true;
                }
            } else {
                this.processingTime = 0;
            }
        }
        if (flag) {
            this.func_70296_d();
        }
        if (this.flag1) {
            if (!this.field_145850_b.field_72995_K) {
                boolean b;
                IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
                boolean bl = b = !((ItemStack)this.containerItemStacks.get(0)).func_190926_b();
                if ((Boolean)state.func_177229_b((IProperty)BlockStateTransformer.TABLET) != b) {
                    TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c);
                    this.field_145850_b.func_175656_a(this.field_174879_c, state.func_177226_a((IProperty)BlockStateTransformer.TABLET, (Comparable)Boolean.valueOf(b)));
                    if (te != null) {
                        te.func_145829_t();
                        this.field_145850_b.func_175690_a(this.field_174879_c, te);
                    }
                }
            }
            this.flag1 = false;
        }
    }

    private void processItem() {
        ItemStack stack = (ItemStack)this.containerItemStacks.get(0);
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (this.mode == 0) {
            NBTTagList items = new NBTTagList();
            float pe = 0.0f;
            for (int i = 1; i < this.func_70302_i_(); ++i) {
                if (this.func_70301_a(i).func_190926_b()) continue;
                NBTTagCompound item = new NBTTagCompound();
                item.func_74768_a("Slot", i);
                this.func_70301_a(i).func_77955_b(item);
                items.func_74742_a((NBTBase)item);
                ItemStack is = this.func_70301_a(i);
                pe += (float)(is.func_190916_E() * (64 / is.func_77976_d()));
                this.func_70304_b(i);
            }
            stack.func_77978_p().func_74782_a("ItemInventory", (NBTBase)items);
            stack.func_77978_p().func_74776_a("PotEnergy", pe);
        } else if (this.mode == 1) {
            NBTTagList items = stack.func_77978_p().func_150295_c("ItemInventory", 10);
            for (int i = 0; i < items.func_74745_c(); ++i) {
                NBTTagCompound item = items.func_150305_b(i);
                byte slot = item.func_74771_c("Slot");
                if (slot < 0 || slot >= this.func_70302_i_()) continue;
                this.func_70299_a(slot, new ItemStack(item));
            }
            stack.func_77978_p().func_82580_o("ItemInventory");
            stack.func_77978_p().func_82580_o("PotEnergy");
        }
    }

    private boolean canDoThing() {
        ItemStack stack = (ItemStack)this.containerItemStacks.get(0);
        if (stack.func_190926_b()) {
            return false;
        }
        if (this.mode == 0) {
            boolean b = false;
            for (int i = 1; i < this.containerItemStacks.size(); ++i) {
                if (((ItemStack)this.containerItemStacks.get(i)).func_190926_b()) continue;
                b = true;
            }
            if (b) {
                return !stack.func_77942_o() || stack.func_77978_p().func_82582_d();
            }
        } else if (this.mode == 1) {
            boolean b = true;
            for (int i = 1; i < this.containerItemStacks.size(); ++i) {
                if (((ItemStack)this.containerItemStacks.get(i)).func_190926_b()) continue;
                b = false;
            }
            return b && ((ItemStoneTablet)stack.func_77973_b()).hasInventory(stack);
        }
        return false;
    }

    public int[] func_180463_a(EnumFacing side) {
        switch (this.mode) {
            case 0: {
                return side == EnumFacing.UP ? this.slots[2] : this.slots[0];
            }
            case 1: {
                return side == EnumFacing.UP ? this.slots[0] : (side == EnumFacing.DOWN ? this.slots[2] : new int[]{});
            }
        }
        return new int[0];
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        if (this.processingTime > 0) {
            return false;
        }
        switch (this.mode) {
            case 0: {
                return index > 0 && direction == EnumFacing.UP || index == 0 && direction != EnumFacing.UP && direction != EnumFacing.DOWN && itemStackIn.func_77973_b() instanceof ItemStoneTablet && !((ItemStoneTablet)itemStackIn.func_77973_b()).hasInventory(itemStackIn);
            }
            case 1: {
                return index == 0 && itemStackIn.func_77973_b() instanceof ItemStoneTablet && ((ItemStoneTablet)itemStackIn.func_77973_b()).hasInventory(itemStackIn) && direction != EnumFacing.DOWN;
            }
        }
        return false;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        if (this.processingTime > 0) {
            return false;
        }
        switch (this.mode) {
            case 0: {
                return index == 0 && stack.func_77973_b() instanceof ItemStoneTablet && ((ItemStoneTablet)stack.func_77973_b()).hasInventory(stack) && direction == EnumFacing.DOWN;
            }
            case 1: {
                return direction == EnumFacing.DOWN && index == 0 ? stack.func_77973_b() instanceof ItemStoneTablet && !((ItemStoneTablet)stack.func_77973_b()).hasInventory(stack) : true;
            }
        }
        return false;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == EnumFacing.DOWN) {
                return (T)this.handlerBottom;
            }
            if (facing == EnumFacing.UP) {
                return (T)this.handlerTop;
            }
            return (T)this.handlerSide;
        }
        return (T)super.getCapability(capability, facing);
    }
}

