/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.common.blocks;

import com.google.common.base.Predicate;
import com.shinoow.abyssalcraft.AbyssalCraft;
import com.shinoow.abyssalcraft.api.block.ACBlocks;
import com.shinoow.abyssalcraft.common.blocks.tile.TileEntityTransmutator;
import com.shinoow.abyssalcraft.lib.ACConfig;
import com.shinoow.abyssalcraft.lib.ACTabs;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.internal.FMLNetworkHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockTransmutator
extends BlockContainer {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    private final Random rand = new Random();
    private final boolean isLit;
    private static boolean keepInventory;

    public BlockTransmutator(boolean par1) {
        super(Material.field_151576_e);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.func_149672_a(SoundType.field_185851_d);
        this.isLit = par1;
        if (!this.isLit) {
            this.func_149647_a(ACTabs.tabDecoration);
        }
    }

    public Item func_180660_a(IBlockState state, Random par1Random, int par3) {
        return Item.func_150898_a((Block)ACBlocks.transmutator_idle);
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        this.setDefaultFacing(worldIn, pos, state);
    }

    private void setDefaultFacing(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            IBlockState block = worldIn.func_180495_p(pos.func_177978_c());
            IBlockState block1 = worldIn.func_180495_p(pos.func_177968_d());
            IBlockState block2 = worldIn.func_180495_p(pos.func_177976_e());
            IBlockState block3 = worldIn.func_180495_p(pos.func_177974_f());
            EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            if (enumfacing == EnumFacing.NORTH && block.func_185913_b() && !block1.func_185913_b()) {
                enumfacing = EnumFacing.SOUTH;
            } else if (enumfacing == EnumFacing.SOUTH && block1.func_185913_b() && !block.func_185913_b()) {
                enumfacing = EnumFacing.NORTH;
            } else if (enumfacing == EnumFacing.WEST && block2.func_185913_b() && !block3.func_185913_b()) {
                enumfacing = EnumFacing.EAST;
            } else if (enumfacing == EnumFacing.EAST && block3.func_185913_b() && !block2.func_185913_b()) {
                enumfacing = EnumFacing.WEST;
            }
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)enumfacing), 2);
        }
    }

    public boolean func_180639_a(World par1World, BlockPos pos, IBlockState state, EntityPlayer par5EntityPlayer, EnumHand hand, EnumFacing side, float par7, float par8, float par9) {
        if (!par1World.field_72995_K) {
            FMLNetworkHandler.openGui((EntityPlayer)par5EntityPlayer, (Object)AbyssalCraft.instance, (int)31, (World)par1World, (int)pos.func_177958_n(), (int)pos.func_177956_o(), (int)pos.func_177952_p());
        }
        return true;
    }

    public static void updateTransmutatorBlockState(boolean par0, World par1World, BlockPos pos) {
        IBlockState state = par1World.func_180495_p(pos);
        TileEntity tileentity = par1World.func_175625_s(pos);
        keepInventory = true;
        if (par0) {
            par1World.func_180501_a(pos, ACBlocks.transmutator_active.func_176223_P().func_177226_a((IProperty)FACING, state.func_177229_b((IProperty)FACING)), 3);
        } else {
            par1World.func_180501_a(pos, ACBlocks.transmutator_idle.func_176223_P().func_177226_a((IProperty)FACING, state.func_177229_b((IProperty)FACING)), 3);
        }
        keepInventory = false;
        if (tileentity != null) {
            tileentity.func_145829_t();
            par1World.func_175690_a(pos, tileentity);
        }
    }

    public TileEntity func_149915_a(World par1World, int par2) {
        return new TileEntityTransmutator();
    }

    public void func_180633_a(World par1World, BlockPos pos, IBlockState state, EntityLivingBase par5EntityLivingBase, ItemStack par6ItemStack) {
        par1World.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)par5EntityLivingBase.func_174811_aO().func_176734_d()), 2);
        if (par6ItemStack.func_82837_s()) {
            ((TileEntityTransmutator)par1World.func_175625_s(pos)).func_145951_a(par6ItemStack.func_82833_r());
        }
    }

    public void func_180663_b(World par1World, BlockPos pos, IBlockState state) {
        TileEntityTransmutator tileentitytransmutator;
        if (!keepInventory && (tileentitytransmutator = (TileEntityTransmutator)par1World.func_175625_s(pos)) != null) {
            InventoryHelper.func_180175_a((World)par1World, (BlockPos)pos, (IInventory)tileentitytransmutator);
            par1World.func_175666_e(pos, (Block)this);
        }
        super.func_180663_b(par1World, pos, state);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (this.isLit && ACConfig.particleBlock) {
            EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            double d0 = (double)pos.func_177958_n() + 0.5;
            double d1 = (double)pos.func_177956_o() + rand.nextDouble() * 6.0 / 16.0;
            double d2 = (double)pos.func_177952_p() + 0.5;
            double d3 = 0.52;
            double d4 = rand.nextDouble() * 0.6 - 0.3;
            switch (enumfacing) {
                case WEST: {
                    world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 - d3, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                    AbyssalCraft.proxy.spawnParticle("CorBlood", world, d0 - d3, d1, d2 + d4, 0.0, 0.0, 0.0);
                    break;
                }
                case EAST: {
                    world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + d3, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                    AbyssalCraft.proxy.spawnParticle("CorBlood", world, d0 + d3, d1, d2 + d4, 0.0, 0.0, 0.0);
                    break;
                }
                case NORTH: {
                    world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + d4, d1, d2 - d3, 0.0, 0.0, 0.0, new int[0]);
                    AbyssalCraft.proxy.spawnParticle("CorBlood", world, d0 + d4, d1, d2 - d3, 0.0, 0.0, 0.0);
                    break;
                }
                case SOUTH: {
                    world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + d4, d1, d2 + d3, 0.0, 0.0, 0.0, new int[0]);
                    AbyssalCraft.proxy.spawnParticle("CorBlood", world, d0 + d4, d1, d2 + d3, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World par1World, BlockPos pos) {
        return Container.func_178144_a((TileEntity)par1World.func_175625_s(pos));
    }

    @SideOnly(value=Side.CLIENT)
    public ItemStack func_185473_a(World par1World, BlockPos pos, IBlockState state) {
        return new ItemStack(ACBlocks.transmutator_idle);
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{FACING}).build();
    }
}

