/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.common.blocks;

import com.shinoow.abyssalcraft.api.block.ACBlocks;
import com.shinoow.abyssalcraft.common.blocks.BlockACBasic;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.projectile.EntityWitherSkull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class BlockACBrick
extends BlockACBasic {
    public static final PropertyEnum TYPE = PropertyEnum.func_177709_a((String)"type", EnumBrickType.class);

    public BlockACBrick(int harvestlevel, float hardness, float resistance) {
        super(Material.field_151576_e, "pickaxe", harvestlevel, hardness, resistance, SoundType.field_185851_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)TYPE, (Comparable)((Object)EnumBrickType.NORMAL)));
    }

    public BlockACBrick(float hardness, float resistance) {
        super(Material.field_151576_e, hardness, resistance, SoundType.field_185851_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)TYPE, (Comparable)((Object)EnumBrickType.NORMAL)));
    }

    public BlockACBrick(int harvestlevel, float hardness, float resistance, MapColor mapColor) {
        super(Material.field_151576_e, "pickaxe", harvestlevel, hardness, resistance, SoundType.field_185851_d, mapColor);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)TYPE, (Comparable)((Object)EnumBrickType.NORMAL)));
    }

    public BlockACBrick(float hardness, float resistance, MapColor mapColor) {
        super(Material.field_151576_e, hardness, resistance, SoundType.field_185851_d, mapColor);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)TYPE, (Comparable)((Object)EnumBrickType.NORMAL)));
    }

    public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        if (entity instanceof EntityDragon || entity instanceof EntityWither || entity instanceof EntityWitherSkull) {
            return state.func_177230_c() != ACBlocks.ethaxium_brick && state.func_177230_c() != ACBlocks.dark_ethaxium_brick;
        }
        return super.canEntityDestroy(state, world, pos, entity);
    }

    public int func_180651_a(IBlockState state) {
        return ((EnumBrickType)((Object)state.func_177229_b((IProperty)TYPE))).getMeta();
    }

    public void func_149666_a(CreativeTabs par2CreativeTabs, NonNullList<ItemStack> par3List) {
        for (int i = 0; i < EnumBrickType.values().length; ++i) {
            par3List.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)TYPE, (Comparable)((Object)EnumBrickType.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumBrickType)((Object)state.func_177229_b((IProperty)TYPE))).getMeta();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{TYPE}).build();
    }

    public static enum EnumBrickType implements IStringSerializable
    {
        NORMAL(0, "normal"),
        CHISELED(1, "chiseled"),
        CRACKED(2, "cracked");

        private static final EnumBrickType[] META_LOOKUP;
        private int meta;
        private String name;

        private EnumBrickType(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public static EnumBrickType byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        public String func_176610_l() {
            return this.name;
        }

        public int getMeta() {
            return this.meta;
        }

        public String toString() {
            return this.func_176610_l();
        }

        static {
            META_LOOKUP = new EnumBrickType[EnumBrickType.values().length];
            EnumBrickType[] enumBrickTypeArray = EnumBrickType.values();
            int n = enumBrickTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumBrickType type;
                EnumBrickType.META_LOOKUP[type.getMeta()] = type = enumBrickTypeArray[i];
            }
        }
    }
}

