/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.api.recipe;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class TransmutatorRecipes {
    private static final TransmutatorRecipes transmutationBase = new TransmutatorRecipes();
    private final Map<ItemStack, ItemStack> transmutationList = new HashMap<ItemStack, ItemStack>();
    private final Map<ItemStack, Float> experienceList = new HashMap<ItemStack, Float>();

    public static TransmutatorRecipes instance() {
        return transmutationBase;
    }

    private TransmutatorRecipes() {
        this.transmute(Items.field_151045_i, new ItemStack(Items.field_151044_h, 64), 0.2f);
        this.transmute(Items.field_151131_as, new ItemStack(Blocks.field_150432_aD, 8), 0.0f);
        this.transmute(Blocks.field_150325_L, new ItemStack(Items.field_151007_F, 4), 0.0f);
        this.transmute(Blocks.field_150351_n, new ItemStack(Items.field_151145_ak, 2), 0.0f);
        this.transmute(Blocks.field_150371_ca, new ItemStack(Items.field_151128_bU, 4), 0.0f);
        this.transmute(Blocks.field_150385_bj, new ItemStack(Items.field_151130_bT, 4), 0.0f);
        this.transmute(Items.field_151130_bT, new ItemStack(Blocks.field_150424_aL), 0.0f);
        this.transmute(Items.field_151015_O, new ItemStack(Items.field_151014_N), 0.0f);
        this.transmute(Items.field_151014_N, new ItemStack(Items.field_151015_O), 0.0f);
    }

    public void transmute(Block input, ItemStack output, float xp) {
        this.transmute(Item.func_150898_a((Block)input), output, xp);
    }

    public void transmute(Item input, ItemStack output, float xp) {
        this.transmute(new ItemStack(input, 1, Short.MAX_VALUE), output, xp);
    }

    public void transmute(ItemStack input, ItemStack output, float xp) {
        this.transmutationList.put(input, output);
        this.experienceList.put(output, Float.valueOf(xp));
    }

    public ItemStack getTransmutationResult(ItemStack par1ItemStack) {
        for (Map.Entry<ItemStack, ItemStack> entry : this.transmutationList.entrySet()) {
            if (!this.areStacksEqual(par1ItemStack, entry.getKey())) continue;
            return entry.getValue();
        }
        return ItemStack.field_190927_a;
    }

    private boolean areStacksEqual(ItemStack par1ItemStack, ItemStack par2ItemStack) {
        return par2ItemStack.func_77973_b() == par1ItemStack.func_77973_b() && (par2ItemStack.func_77952_i() == Short.MAX_VALUE || par2ItemStack.func_77952_i() == par1ItemStack.func_77952_i());
    }

    public Map<ItemStack, ItemStack> getTransmutationList() {
        return this.transmutationList;
    }

    public float getExperience(ItemStack par1ItemStack) {
        float ret = par1ItemStack.func_77973_b().getSmeltingExperience(par1ItemStack);
        if (ret != -1.0f) {
            return ret;
        }
        for (Map.Entry<ItemStack, Float> entry : this.experienceList.entrySet()) {
            if (!this.areStacksEqual(par1ItemStack, entry.getKey())) continue;
            return entry.getValue().floatValue();
        }
        return 0.0f;
    }
}

