/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.api.necronomicon.condition;

import com.google.common.collect.Maps;
import com.shinoow.abyssalcraft.api.necronomicon.condition.IConditionProcessor;
import java.util.Map;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.logging.log4j.Level;

public class ConditionProcessorRegistry {
    private final Map<Integer, IConditionProcessor> processors = Maps.newHashMap();
    private static final ConditionProcessorRegistry INSTANCE = new ConditionProcessorRegistry();

    public static ConditionProcessorRegistry instance() {
        return INSTANCE;
    }

    public void registerProcessor(int type, IConditionProcessor processor) {
        if (type > -1) {
            if (!this.processors.containsKey(type)) {
                this.processors.put(type, processor);
            } else {
                FMLLog.log((String)"ConditionProcessorRegistry", (Level)Level.ERROR, (String)"Processor already registed for type %d", (Object[])new Object[]{type});
            }
        } else {
            FMLLog.log((String)"ConditionProcessorRegistry", (Level)Level.ERROR, (String)"Invalid type: %d", (Object[])new Object[]{type});
        }
    }

    public IConditionProcessor getProcessor(int type) {
        return this.processors.containsKey(type) ? this.processors.get(type) : (condition, cap, player) -> false;
    }
}

