/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.api.necronomicon;

import com.shinoow.abyssalcraft.api.APIUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class CraftingStack {
    private ItemStack output;
    private Object[] recipe = new Object[9];

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CraftingStack(Object output, Object ... recipe) {
        if (output == null) throw new NullPointerException("Output can't be null!");
        if (recipe == null) throw new NullPointerException("This array can't be empty!");
        if (recipe.length != 9) {
            throw new ArrayIndexOutOfBoundsException("The array must contain preciesly 9 elements, not " + recipe.length + "!");
        }
        this.output = APIUtils.convertToStack(output);
        this.recipe = recipe;
    }

    public CraftingStack(Object output) {
        if (output != null) {
            int size = 0;
            Object[] stuff = new Object[9];
            this.output = APIUtils.convertToStack(output);
            for (IRecipe recipe : ForgeRegistries.RECIPES) {
                int i;
                if (recipe.func_77571_b() == null || !recipe.func_77571_b().func_77969_a(this.output)) continue;
                if (recipe instanceof ShapedRecipes) {
                    for (i = 0; i < recipe.func_192400_c().size(); ++i) {
                        stuff[i] = ((ShapedRecipes)recipe).func_192400_c().get(i);
                    }
                    size = ((ShapedRecipes)recipe).field_77577_c * ((ShapedRecipes)recipe).field_77576_b;
                }
                if (recipe instanceof ShapelessRecipes) {
                    for (i = 0; i < recipe.func_192400_c().size(); ++i) {
                        stuff[i] = ((ShapelessRecipes)recipe).field_77579_b.get(i);
                    }
                }
                if (recipe instanceof ShapedOreRecipe) {
                    for (i = 0; i < recipe.func_192400_c().size(); ++i) {
                        stuff[i] = ((ShapedOreRecipe)recipe).func_192400_c().get(i);
                    }
                    size = ((ShapedOreRecipe)recipe).getHeight() * ((ShapedOreRecipe)recipe).getWidth();
                }
                if (recipe instanceof ShapelessOreRecipe) {
                    for (i = 0; i < recipe.func_192400_c().size(); ++i) {
                        stuff[i] = ((ShapelessOreRecipe)recipe).func_192400_c().get(i);
                    }
                }
                if (size == 4) {
                    Object[] copy = (Object[])stuff.clone();
                    stuff = new Object[9];
                    for (int i2 = 0; i2 < 2; ++i2) {
                        stuff[i2] = copy[i2];
                        stuff[i2 + 3] = copy[i2 + 2];
                    }
                }
                this.output.func_190920_e(recipe.func_77571_b().func_190916_E());
            }
            this.recipe = stuff;
        }
    }

    public ItemStack getOutput() {
        return this.output;
    }

    @Deprecated
    public ItemStack[] getCraftingRecipe() {
        return new ItemStack[0];
    }

    @Deprecated
    public ItemStack[] getFirstArray() {
        return new ItemStack[0];
    }

    @Deprecated
    public ItemStack[] getSecondArray() {
        return new ItemStack[0];
    }

    @Deprecated
    public ItemStack[] getThirdArray() {
        return new ItemStack[0];
    }

    public Object[] getRecipe() {
        return this.recipe;
    }

    @Deprecated
    public static CraftingStack[] arrayFrom(CraftingStack ... stacks) {
        return stacks;
    }

    public String toString() {
        return "CraftingStack{Output: " + this.output.toString() + ", Recipe: " + this.recipe.toString() + "}";
    }
}

