/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.api.energy;

import com.google.common.collect.Lists;
import com.shinoow.abyssalcraft.api.AbyssalCraftAPI;
import com.shinoow.abyssalcraft.api.energy.EnergyEnum;
import com.shinoow.abyssalcraft.api.energy.IEnergyAmplifier;
import com.shinoow.abyssalcraft.api.energy.IEnergyCollector;
import com.shinoow.abyssalcraft.api.energy.IEnergyContainer;
import com.shinoow.abyssalcraft.api.energy.IEnergyContainerItem;
import com.shinoow.abyssalcraft.api.energy.IEnergyManipulator;
import com.shinoow.abyssalcraft.api.energy.IEnergyTransporter;
import com.shinoow.abyssalcraft.api.energy.IEnergyTransporterItem;
import com.shinoow.abyssalcraft.api.energy.structure.IStructureBase;
import com.shinoow.abyssalcraft.api.energy.structure.IStructureComponent;
import com.shinoow.abyssalcraft.api.entity.EntityUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class PEUtils {
    public static void transferPEToNearbyPlayers(World world, BlockPos pos, IEnergyManipulator manipulator, int range) {
        List players = world.func_72872_a(EntityPlayer.class, new AxisAlignedBB(pos, pos.func_177982_a(1, 1, 1)).func_72314_b((double)range, (double)range, (double)range));
        for (EntityPlayer player : players) {
            if (!EntityUtil.hasNecronomicon(player)) continue;
            ItemStack item = player.func_184586_b(EnumHand.MAIN_HAND);
            ItemStack item1 = player.func_184586_b(EnumHand.OFF_HAND);
            if (!PEUtils.canStackAcceptPE(item) && !PEUtils.canStackAcceptPE(item1) || !manipulator.canTransferPE()) continue;
            PEUtils.transferPEToStack(item, manipulator);
            PEUtils.transferPEToStack(item1, manipulator);
            AbyssalCraftAPI.getInternalMethodHandler().spawnPEStream(pos, (Entity)player, world.field_73011_w.getDimension());
        }
    }

    private static boolean canStackAcceptPE(ItemStack stack) {
        if (stack.func_77973_b() instanceof IEnergyTransporterItem) {
            return ((IEnergyTransporterItem)stack.func_77973_b()).canAcceptPEExternally(stack);
        }
        return false;
    }

    public static void transferPEToNearbyDroppedItems(World world, BlockPos pos, IEnergyManipulator manipulator, int range) {
        List items = world.func_72872_a(EntityItem.class, new AxisAlignedBB(pos, pos.func_177982_a(1, 1, 1)).func_72314_b((double)range, (double)range, (double)range));
        for (EntityItem item : items) {
            if (!(item.func_92059_d().func_77973_b() instanceof IEnergyTransporterItem) || world.field_73012_v.nextInt(120 - (int)(20.0f * manipulator.getAmplifier(EnergyEnum.AmplifierType.DURATION))) != 0 || !PEUtils.canStackAcceptPE(item.func_92059_d()) || !manipulator.canTransferPE()) continue;
            PEUtils.transferPEToStack(item.func_92059_d(), manipulator);
            AbyssalCraftAPI.getInternalMethodHandler().spawnPEStream(pos, (Entity)item, world.field_73011_w.getDimension());
        }
    }

    private static void transferPEToStack(ItemStack stack, IEnergyManipulator manipulator) {
        if (stack.func_77973_b() instanceof IEnergyTransporterItem && ((IEnergyTransporterItem)stack.func_77973_b()).canAcceptPEExternally(stack)) {
            ((IEnergyTransporterItem)stack.func_77973_b()).addEnergy(stack, manipulator.getEnergyQuanta());
            manipulator.addTolerance(manipulator.isActive() ? 4 : 2);
        }
    }

    public static void transferPEToCollectors(World world, BlockPos pos, IEnergyManipulator manipulator, int boost) {
        int xp = pos.func_177958_n();
        int yp = pos.func_177956_o();
        int zp = pos.func_177952_p();
        ArrayList collectors = Lists.newArrayList();
        for (int x = -1 * (3 + boost); x <= 3 + boost; ++x) {
            for (int y = 0; y <= PEUtils.getRangeAmplifiers(world, pos, manipulator); ++y) {
                for (int z = -1 * (3 + boost); z <= 3 + boost; ++z) {
                    if (x >= -2 && x <= 2 && z >= -2 && z <= 2 || !PEUtils.isCollector(world.func_175625_s(new BlockPos(xp + x, yp - y, zp + z))) || collectors.size() >= 20) continue;
                    collectors.add(world.func_175625_s(new BlockPos(xp + x, yp - y, zp + z)));
                }
            }
        }
        for (TileEntity tile : collectors) {
            if (!PEUtils.checkForAdjacentCollectors(world, tile.func_174877_v()) || world.field_73012_v.nextInt(120 - (int)(20.0f * manipulator.getAmplifier(EnergyEnum.AmplifierType.DURATION))) != 0 || !((IEnergyCollector)tile).canAcceptPE() || !manipulator.canTransferPE()) continue;
            ((IEnergyCollector)tile).addEnergy(manipulator.getEnergyQuanta());
            manipulator.addTolerance(manipulator.isActive() ? 2 : 1);
            AbyssalCraftAPI.getInternalMethodHandler().spawnPEStream(pos, tile.func_174877_v(), world.field_73011_w.getDimension());
        }
    }

    public static void clearManipulatorData(IEnergyManipulator manipulator) {
        if (manipulator.getActiveAmplifier() != null || manipulator.getActiveDeity() != null) {
            NBTTagCompound tag = new NBTTagCompound();
            ((TileEntity)manipulator).func_189515_b(tag);
            tag.func_74778_a("ActiveDeity", "");
            tag.func_74778_a("ActiveAmplifier", "");
            manipulator.setActiveDeity(null);
            manipulator.setActiveAmplifier(null);
            ((TileEntity)manipulator).func_145839_a(tag);
        }
    }

    public static void readManipulatorNBT(IEnergyManipulator manipulator, NBTTagCompound compound) {
        if (compound.func_74764_b("ActiveDeity") && !compound.func_74779_i("ActiveDeity").equals("")) {
            manipulator.setActiveDeity(EnergyEnum.DeityType.valueOf(compound.func_74779_i("ActiveDeity")));
        }
        if (compound.func_74764_b("ActiveAmplifier") && !compound.func_74779_i("ActiveAmplifier").equals("")) {
            manipulator.setActiveAmplifier(EnergyEnum.AmplifierType.valueOf(compound.func_74779_i("ActiveAmplifier")));
        }
    }

    public static void writeManipulatorNBT(IEnergyManipulator manipulator, NBTTagCompound compound) {
        if (manipulator.getActiveDeity() != null) {
            compound.func_74778_a("ActiveDeity", manipulator.getActiveDeity().name());
        } else {
            compound.func_74778_a("ActiveDeity", "");
        }
        if (manipulator.getActiveAmplifier() != null) {
            compound.func_74778_a("ActiveAmplifier", manipulator.getActiveAmplifier().name());
        } else {
            compound.func_74778_a("ActiveAmplifier", "");
        }
    }

    public static int getRangeAmplifiers(World world, BlockPos pos, IEnergyManipulator manipulator) {
        Block block1 = world.func_180495_p(new BlockPos(pos.func_177958_n(), pos.func_177956_o() - 1, pos.func_177952_p())).func_177230_c();
        Block block2 = world.func_180495_p(new BlockPos(pos.func_177958_n(), pos.func_177956_o() - 2, pos.func_177952_p())).func_177230_c();
        int num = 0;
        if (block1 != null && block1 instanceof IEnergyAmplifier && ((IEnergyAmplifier)block1).getAmplifierType() == EnergyEnum.AmplifierType.RANGE) {
            num = 1;
        }
        if (block1 != null && block1 instanceof IEnergyAmplifier && ((IEnergyAmplifier)block1).getAmplifierType() == EnergyEnum.AmplifierType.RANGE && block2 != null && block2 instanceof IEnergyAmplifier && ((IEnergyAmplifier)block2).getAmplifierType() == EnergyEnum.AmplifierType.RANGE) {
            num = 2;
        }
        if (manipulator instanceof IStructureComponent) {
            num = (int)((float)num + PEUtils.getStructureAmplifier(world, (IStructureComponent)((Object)manipulator), EnergyEnum.AmplifierType.RANGE));
        }
        return num;
    }

    public static float getStructureAmplifier(World world, IStructureComponent component, EnergyEnum.AmplifierType type) {
        float amplifier = 0.0f;
        if (component.isInMultiblock() && component.getBasePosition() != null) {
            if (world.func_175625_s(component.getBasePosition()) instanceof IStructureBase) {
                amplifier = ((IStructureBase)world.func_175625_s(component.getBasePosition())).getAmplifier(type);
            }
        } else {
            component.setInMultiblock(false);
            component.setBasePosition(null);
        }
        return amplifier;
    }

    public static boolean isCollector(TileEntity tile) {
        if (tile != null) {
            return tile instanceof IEnergyCollector;
        }
        return false;
    }

    public static boolean isManipulator(TileEntity tile) {
        if (tile != null) {
            return tile instanceof IEnergyManipulator;
        }
        return false;
    }

    public static boolean isContainer(TileEntity tile) {
        if (tile != null) {
            return tile instanceof IEnergyContainer;
        }
        return false;
    }

    public static boolean checkForAdjacentCollectors(World world, BlockPos pos) {
        for (EnumFacing face : EnumFacing.values()) {
            if (!PEUtils.isCollector(world.func_175625_s(pos.func_177972_a(face)))) continue;
            return false;
        }
        return true;
    }

    public static boolean checkForAdjacentManipulators(World world, BlockPos pos) {
        for (EnumFacing face : EnumFacing.values()) {
            if (!PEUtils.isManipulator(world.func_175625_s(pos.func_177972_a(face)))) continue;
            return false;
        }
        if (PEUtils.isManipulator(world.func_175625_s(pos.func_177981_b(2)))) {
            return false;
        }
        return !PEUtils.isManipulator(world.func_175625_s(pos.func_177979_c(2)));
    }

    public static boolean canTransfer(World world, BlockPos pos, EnumFacing face, int dist) {
        for (int i = 1; i < dist + 1; ++i) {
            if (world.func_180495_p(pos.func_177967_a(face, i)).func_177230_c().func_149686_d(world.func_180495_p(pos.func_177967_a(face, i))) && !world.func_175623_d(pos.func_177967_a(face, i))) {
                return false;
            }
            if (!PEUtils.isContainer(world.func_175625_s(pos.func_177967_a(face, i)))) continue;
            return ((IEnergyContainer)world.func_175625_s(pos.func_177967_a(face, i))).canAcceptPE();
        }
        return false;
    }

    public static IEnergyCollector getCollector(World world, BlockPos pos, EnumFacing face, int dist) {
        for (int i = 1; i < dist + 1; ++i) {
            if (!PEUtils.isCollector(world.func_175625_s(pos.func_177967_a(face, i)))) continue;
            return (IEnergyCollector)world.func_175625_s(pos.func_177967_a(face, i));
        }
        return null;
    }

    public static IEnergyContainer getContainer(World world, BlockPos pos, EnumFacing face, int dist) {
        for (int i = 1; i < dist + 1; ++i) {
            if (!PEUtils.isContainer(world.func_175625_s(pos.func_177967_a(face, i)))) continue;
            return (IEnergyContainer)world.func_175625_s(pos.func_177967_a(face, i));
        }
        return null;
    }

    public static void collectNearbyPE(IEnergyTransporter relay, World world, BlockPos pos, EnumFacing face, float amount) {
        IEnergyContainer container;
        if (relay.canAcceptPE() && (container = PEUtils.getContainer(world, pos, face, 1)) != null && container.canTransferPE()) {
            relay.addEnergy(container.consumeEnergy(amount));
        }
    }

    public static float getContainedEnergy(ItemStack stack) {
        float energy;
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (stack.func_77978_p().func_74764_b("PotEnergy")) {
            energy = stack.func_77978_p().func_74760_g("PotEnergy");
        } else {
            energy = 0.0f;
            stack.func_77978_p().func_74776_a("PotEnergy", energy);
        }
        return energy;
    }

    public static void addEnergy(IEnergyContainerItem container, ItemStack stack, float energy) {
        float contained = container.getContainedEnergy(stack);
        if (contained + energy >= (float)container.getMaxEnergy(stack)) {
            stack.func_77978_p().func_74776_a("PotEnergy", (float)container.getMaxEnergy(stack));
        } else {
            stack.func_77978_p().func_74776_a("PotEnergy", contained += energy);
        }
    }

    public static float consumeEnergy(ItemStack stack, float energy) {
        float contained = PEUtils.getContainedEnergy(stack);
        if (energy < contained) {
            stack.func_77978_p().func_74776_a("PotEnergy", contained -= energy);
            return energy;
        }
        stack.func_77978_p().func_74776_a("PotEnergy", 0.0f);
        return contained;
    }
}

