/*
 * Decompiled with CFR 0.152.
 */
package mods.waterstrainer.gui;

import java.util.Arrays;
import mods.waterstrainer.inventory.ContainerStrainer;
import mods.waterstrainer.registry.ItemRegistry;
import mods.waterstrainer.tileentity.TileEntityStrainer;
import mods.waterstrainer.util.APIUtils;
import mods.waterstrainer.util.Patcher;
import mods.waterstrainer.util.WaterStrainerUtils;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiStrainer
extends GuiContainer {
    private static final ResourceLocation guiTexture = new ResourceLocation("waterstrainer", "textures/gui/strainer_base.png");
    private final TileEntityStrainer tile;
    private final InventoryPlayer playerInventory;

    public GuiStrainer(InventoryPlayer playerInventory, TileEntityStrainer tileEntity) {
        super((Container)new ContainerStrainer(playerInventory, tileEntity));
        this.playerInventory = playerInventory;
        this.tile = tileEntity;
        this.field_147000_g = 226;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
        Slot slot = this.getSlotUnderMouse();
        if (slot != null) {
            int slotIndex = slot.field_75222_d;
            if (slot.func_75216_d()) {
                return;
            }
            if (slotIndex == 0) {
                this.drawHoveringText(Arrays.asList("Strainer Slot"), mouseX, mouseY, this.field_146289_q);
            } else if (slotIndex == 28) {
                this.drawHoveringText(Arrays.asList("Bait Slot"), mouseX, mouseY, this.field_146289_q);
            } else if (slotIndex == 29) {
                this.drawHoveringText(Arrays.asList("Bait Pot Slot"), mouseX, mouseY, this.field_146289_q);
            }
        }
        int guiX = (this.field_146294_l - this.field_146999_f) / 2;
        int guiY = (this.field_146295_m - this.field_147000_g) / 2;
        EnumBaitStatus status = this.getBaitStatus();
        if (this.isMouseHovering(mouseX, mouseY, guiX + 57, guiY + 42, 12, 12)) {
            if (status == EnumBaitStatus.REDUNDANT) {
                this.drawHoveringText(Arrays.asList(TextFormatting.RED + "Bait redundant", "This strainer does", "not need any bait!"), mouseX, mouseY, this.field_146289_q);
            } else if (status == EnumBaitStatus.REQUIRED) {
                this.drawHoveringText(Arrays.asList(TextFormatting.RED + "Bait required", "This strainer requires bait!"), mouseX, mouseY, this.field_146289_q);
            }
        } else if (this.isMouseHovering(mouseX, mouseY, guiX + 155, guiY + 5, 16, 16) && !APIUtils.isJEILoaded()) {
            this.drawHoveringText(Arrays.asList(WaterStrainerUtils.ctext("#RED#Show Recipes"), WaterStrainerUtils.ctext("This function is only available if you"), WaterStrainerUtils.ctext("have #BLUE#Just Enough Items (JEI)#RESET# installed.")), mouseX, mouseY, this.field_146289_q);
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        String s = I18n.func_135052_a((String)this.tile.func_70005_c_(), (Object[])new Object[0]);
        this.field_146289_q.func_78276_b(s, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(s) / 2, 6, 0x404040);
        this.field_146289_q.func_78276_b(this.playerInventory.func_145748_c_().func_150260_c(), 8, this.field_147000_g - 96 + 2, 0x404040);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(guiTexture);
        int k = (this.field_146294_l - this.field_146999_f) / 2;
        int l = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(k, l, 0, 0, this.field_146999_f, this.field_147000_g);
        if (Patcher.isStackEmpty(this.tile.func_70301_a(0))) {
            this.func_73729_b(k + 80, l + 21, 176, 0, 16, 16);
        }
        if (Patcher.isStackEmpty(this.tile.func_70301_a(28))) {
            this.func_73729_b(k + 70, l + 41, 176, 32, 16, 16);
        }
        if (Patcher.isStackEmpty(this.tile.func_70301_a(29))) {
            this.func_73729_b(k + 90, l + 41, 176, 16, 16, 16);
        }
        if (this.getBaitStatus() != EnumBaitStatus.NONE) {
            this.func_73729_b(k + 55, l + 43, 192, 0, 12, 12);
        }
    }

    public boolean isMouseHovering(int mouse_x, int mouse_y, int x, int y, int xsize, int ysize) {
        return mouse_x >= x && mouse_x < x + xsize && mouse_y >= y && mouse_y < y + ysize;
    }

    protected EnumBaitStatus getBaitStatus() {
        ItemStack strainer = this.tile.func_70301_a(0);
        ItemStack bait = this.tile.func_70301_a(28);
        if (!Patcher.isStackEmpty(strainer)) {
            if (strainer.func_77973_b() != ItemRegistry.strainer_fisherman) {
                if (!Patcher.isStackEmpty(bait)) {
                    return EnumBaitStatus.REDUNDANT;
                }
            } else if (Patcher.isStackEmpty(bait) || !Patcher.isStackEmpty(bait) && bait.func_77973_b() == ItemRegistry.bait_pot && bait.func_77952_i() == bait.func_77958_k()) {
                return EnumBaitStatus.REQUIRED;
            }
        }
        return EnumBaitStatus.NONE;
    }

    protected static enum EnumBaitStatus {
        NONE,
        REDUNDANT,
        REQUIRED;

    }
}

