/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.crafting;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import xreliquary.util.LogHelper;

public class AlkahestryLoader {
    private static final String CONFIG_FOLDER = "config/xreliquary/alkahestry_overrides";
    private static Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Method LOAD_CONSTANTS = ReflectionHelper.findMethod(JsonContext.class, (String)"loadConstants", null, (Class[])new Class[]{JsonObject[].class});
    private static Set<String> foldersLoaded = Sets.newHashSet();

    private static void loadConstants(JsonContext ctx, JsonObject[] jsons) {
        try {
            LOAD_CONSTANTS.invoke((Object)ctx, new Object[]{jsons});
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static void loadRecipes() {
        AlkahestryLoader.createConfigFolder();
        AlkahestryLoader.loadAlkahestry(new File(CONFIG_FOLDER), "", false);
        AlkahestryLoader.loadAlkahestry(Loader.instance().activeModContainer().getSource(), "assets/xreliquary/alkahestry", true);
    }

    private static void createConfigFolder() {
        new File(CONFIG_FOLDER).mkdirs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadAlkahestry(File source, String base, boolean folderMustExist) {
        Path root;
        FileSystem fs;
        block8: {
            fs = null;
            try {
                root = null;
                if (source.isFile()) {
                    try {
                        fs = FileSystems.newFileSystem(source.toPath(), null);
                        root = fs.getPath("/" + base, new String[0]);
                    }
                    catch (IOException e) {
                        LogHelper.error("Error loading FileSystem from jar: ", e);
                    }
                } else if (source.isDirectory()) {
                    root = source.toPath().resolve(base);
                }
                if (root != null && Files.exists(root, new LinkOption[0])) break block8;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fs);
                throw throwable;
            }
            IOUtils.closeQuietly((Closeable)fs);
            return;
        }
        JsonContext ctx = AlkahestryLoader.loadJsonContext(root);
        AlkahestryLoader.loadRecipeFolder(root, "crafting", ctx, folderMustExist);
        AlkahestryLoader.loadRecipeFolder(root, "charging", ctx, folderMustExist);
        AlkahestryLoader.loadRecipeFolder(root, "drain", ctx, folderMustExist);
        IOUtils.closeQuietly((Closeable)fs);
    }

    private static void loadRecipeFolder(Path root, String folderName, JsonContext ctx, boolean folderMustExist) {
        Iterator itr;
        block7: {
            if (foldersLoaded.contains(folderName)) {
                return;
            }
            itr = null;
            Path folderRoot = root.resolve(folderName);
            if (!Files.exists(folderRoot, new LinkOption[0])) {
                if (folderMustExist) {
                    LogHelper.error("Unable to find folder {} which is required", folderRoot.toString());
                }
                return;
            }
            try {
                itr = Files.walk(folderRoot, new FileVisitOption[0]).iterator();
            }
            catch (IOException e) {
                if (!folderMustExist) break block7;
                LogHelper.error("Error iterating filesystem for: {}", "xreliquary", e);
            }
        }
        boolean recipeAdded = false;
        while (itr != null && itr.hasNext()) {
            recipeAdded |= AlkahestryLoader.loadRecipe(root, (Path)itr.next(), ctx);
        }
        if (recipeAdded) {
            foldersLoaded.add(folderName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean loadRecipe(Path root, Path file, JsonContext ctx) {
        String relative = root.relativize(file).toString();
        if (!"json".equals(FilenameUtils.getExtension((String)file.toString())) || relative.startsWith("_")) {
            return false;
        }
        String name = FilenameUtils.removeExtension((String)relative).replaceAll("\\\\", "/");
        ResourceLocation key = new ResourceLocation(ctx.getModId(), name);
        BufferedReader reader = null;
        try {
            reader = Files.newBufferedReader(file);
            JsonObject json = (JsonObject)JsonUtils.func_193839_a((Gson)GSON, (Reader)reader, JsonObject.class);
            if (json.has("conditions") && !CraftingHelper.processConditions((JsonArray)JsonUtils.func_151214_t((JsonObject)json, (String)"conditions"), (JsonContext)ctx)) {
                boolean bl = false;
                return bl;
            }
            IRecipe recipe = CraftingHelper.getRecipe((JsonObject)json, (JsonContext)ctx);
            ForgeRegistries.RECIPES.register((IForgeRegistryEntry)recipe.setRegistryName(key));
        }
        catch (JsonParseException e) {
            LogHelper.error("Parsing error loading recipe {}", new Object[]{key, e});
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            LogHelper.error("Couldn't read recipe {} from {}", key, file, e);
            boolean bl = false;
            return bl;
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JsonContext loadJsonContext(Path root) {
        JsonContext ctx = new JsonContext("xreliquary");
        Path fPath = root.resolve("_constants.json");
        if (fPath != null && Files.exists(fPath, new LinkOption[0])) {
            BufferedReader reader = null;
            try {
                reader = Files.newBufferedReader(fPath);
                JsonObject[] json = (JsonObject[])JsonUtils.func_193839_a((Gson)GSON, (Reader)reader, JsonObject[].class);
                AlkahestryLoader.loadConstants(ctx, json);
            }
            catch (IOException e) {
                LogHelper.error("Error loading _constants.json: ", e);
            }
            finally {
                IOUtils.closeQuietly((Reader)reader);
            }
        }
        return ctx;
    }
}

