/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.blocks.tile;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import xreliquary.blocks.tile.TileEntityPedestal;

public class PedestalFluidHandler
implements IFluidHandler {
    private static final IFluidTankProperties[] EMPTY_TANK_PROPERTIES = new IFluidTankProperties[0];
    TileEntityPedestal pedestal;

    public PedestalFluidHandler(TileEntityPedestal pedestal) {
        this.pedestal = pedestal;
    }

    public IFluidTankProperties[] getTankProperties() {
        List<ItemStack> fluidContainers = this.pedestal.getFluidContainers();
        if (fluidContainers.size() == 0) {
            return EMPTY_TANK_PROPERTIES;
        }
        ArrayList props = new ArrayList();
        for (ItemStack container : fluidContainers) {
            IFluidTankProperties[] containerProps = this.getContainerTankProperties(container);
            Collections.addAll(props, containerProps);
        }
        return props.toArray(new IFluidTankProperties[0]);
    }

    public int fill(FluidStack resource, boolean doFill) {
        int totalFilled = 0;
        FluidStack resourceCopy = resource.copy();
        for (ItemStack container : this.pedestal.getFluidContainers()) {
            resourceCopy.amount = resource.amount - (totalFilled += this.getFluidCapFromContainer(container).fill(resourceCopy, doFill));
            if (totalFilled < resource.amount) continue;
            break;
        }
        return totalFilled;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        ItemStack container;
        FluidStack drainedStack;
        int totalDrained = 0;
        Iterator<ItemStack> iterator = this.pedestal.getFluidContainers().iterator();
        while (iterator.hasNext() && ((drainedStack = this.getFluidCapFromContainer(container = iterator.next()).drain(resource.amount - totalDrained, doDrain)) == null || (totalDrained += drainedStack.amount) < resource.amount)) {
        }
        return new FluidStack(resource.getFluid(), totalDrained);
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        List<ItemStack> fluidContainers = this.pedestal.getFluidContainers();
        if (fluidContainers.size() == 0) {
            return null;
        }
        ItemStack container = fluidContainers.get(0);
        Fluid fluid = this.getFirstContainerFluid(container);
        if (fluid == null) {
            return null;
        }
        return this.drain(new FluidStack(fluid, maxDrain), doDrain);
    }

    private IFluidHandler getFluidCapFromContainer(ItemStack container) {
        if (!container.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null) && !container.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
            return null;
        }
        IFluidHandler fluidHandler = (IFluidHandler)container.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
        if (fluidHandler == null) {
            fluidHandler = (IFluidHandler)container.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        }
        return fluidHandler;
    }

    private IFluidTankProperties[] getContainerTankProperties(ItemStack container) {
        IFluidHandler handler = this.getFluidCapFromContainer(container);
        if (handler == null) {
            return null;
        }
        return handler.getTankProperties();
    }

    private Fluid getFirstContainerFluid(ItemStack container) {
        IFluidHandler handler = this.getFluidCapFromContainer(container);
        if (handler == null) {
            return null;
        }
        IFluidTankProperties[] tankProperties = handler.getTankProperties();
        if (tankProperties == null || tankProperties.length == 0) {
            return null;
        }
        return tankProperties[0].getContents() == null ? null : tankProperties[0].getContents().getFluid();
    }
}

