/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbutilities;

import com.feed_the_beast.ftblib.events.RegisterRankConfigEvent;
import com.feed_the_beast.ftblib.events.RegisterRankConfigHandlerEvent;
import com.feed_the_beast.ftblib.lib.config.ConfigEnum;
import com.feed_the_beast.ftblib.lib.config.ConfigInt;
import com.feed_the_beast.ftblib.lib.config.ConfigString;
import com.feed_the_beast.ftblib.lib.config.ConfigTimer;
import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.config.IRankConfigHandler;
import com.feed_the_beast.ftblib.lib.math.Ticks;
import com.feed_the_beast.ftblib.lib.util.misc.Node;
import com.feed_the_beast.ftblib.lib.util.text_components.TextComponentParser;
import com.feed_the_beast.ftbutilities.FTBUtilitiesCommon;
import com.feed_the_beast.ftbutilities.FTBUtilitiesConfig;
import com.feed_the_beast.ftbutilities.data.Leaderboard;
import com.feed_the_beast.ftbutilities.events.CustomPermissionPrefixesRegistryEvent;
import com.feed_the_beast.ftbutilities.ranks.FTBUtilitiesPermissionHandler;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAnvil;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockWorkbench;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBucket;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;

@Mod.EventBusSubscriber(modid="ftbutilities")
public class FTBUtilitiesPermissions {
    public static final String DISPLAY_ADMIN_INFO = "ftbutilities.display.admin_info";
    public static final Node BADGE = Node.get((String)"ftbutilities.badge");
    public static final String HOMES_CROSS_DIM = "ftbutilities.homes.cross_dim";
    public static final Node HOMES_MAX = Node.get((String)"ftbutilities.homes.max");
    public static final Node HOMES_COOLDOWN = Node.get((String)"ftbutilities.homes.cooldown");
    public static final Node HOMES_WARMUP = Node.get((String)"ftbutilities.homes.warmup");
    public static final String HOMES_LIST_OTHER = "ftbutilities.other_player.homes.list";
    public static final String HOMES_TELEPORT_OTHER = "ftbutilities.other_player.homes.teleport";
    public static final Node WARPS_COOLDOWN = Node.get((String)"ftbutilities.warps.cooldown");
    public static final Node WARPS_WARMUP = Node.get((String)"ftbutilities.warps.warmup");
    public static final String HOMES_BACK = "ftbutilities.back.home";
    public static final String WARPS_BACK = "ftbutilities.back.warp";
    public static final String SPAWN_BACK = "ftbutilities.back.spawn";
    public static final String TPA_BACK = "ftbutilities.back.tpa";
    public static final String RTP_BACK = "ftbutilities.back.rtp";
    public static final String RESPAWN_BACK = "ftbutilities.back.respawn";
    public static final String BACK_BACK = "ftbutilities.back.back";
    public static final String CLAIMS_OTHER_SEE_INFO = "ftbutilities.other_player.claims.see_info";
    public static final String CLAIMS_OTHER_CLAIM = "ftbutilities.other_player.claims.claim";
    public static final String CLAIMS_OTHER_UNCLAIM = "ftbutilities.other_player.claims.unclaim";
    public static final String CLAIMS_OTHER_LOAD = "ftbutilities.other_player.claims.load";
    public static final String CLAIMS_OTHER_UNLOAD = "ftbutilities.other_player.claims.unload";
    public static final Node CLAIMS_MAX_CHUNKS = Node.get((String)"ftbutilities.claims.max_chunks");
    public static final Node CLAIMS_BLOCK_EDIT_PREFIX = Node.get((String)"ftbutilities.claims.block.edit");
    public static final Node CLAIMS_BLOCK_INTERACT_PREFIX = Node.get((String)"ftbutilities.claims.block.interact");
    public static final Node CLAIMS_ITEM_PREFIX = Node.get((String)"ftbutilities.claims.item");
    public static final String CLAIMS_BYPASS_LIMITS = "ftbutilities.claims.bypass_limits";
    public static final String CLAIMS_ATTACK_ANIMALS = "ftbutilities.claims.attack_animals";
    public static final HashSet<Block> CLAIMS_BLOCK_EDIT_WHITELIST = new HashSet();
    public static final HashSet<Block> CLAIMS_BLOCK_INTERACT_WHITELIST = new HashSet();
    public static final HashSet<Item> CLAIMS_ITEM_BLACKLIST = new HashSet();
    public static final Node CHUNKLOADER_MAX_CHUNKS = Node.get((String)"ftbutilities.chunkloader.max_chunks");
    public static final String CHUNKLOADER_LOAD_OFFLINE = "ftbutilities.chunkloader.load_offline";
    public static final String CHAT_SPEAK = "ftbutilities.chat.speak";
    public static final String CHAT_NICKNAME_SET = "ftbutilities.chat.nickname.set";
    public static final String CHAT_NICKNAME_COLORS = "ftbutilities.chat.nickname.colors";
    public static final Node CHAT_NAME_FORMAT = Node.get((String)"ftbutilities.chat.name_format");
    public static final Node CHAT_TEXT_COLOR = Node.get((String)"ftbutilities.chat.text.color");
    public static final Node CHAT_TEXT_BOLD = Node.get((String)"ftbutilities.chat.text.bold");
    public static final Node CHAT_TEXT_ITALIC = Node.get((String)"ftbutilities.chat.text.italic");
    public static final Node CHAT_TEXT_UNDERLINED = Node.get((String)"ftbutilities.chat.text.underlined");
    public static final Node CHAT_TEXT_STRIKETHROUGH = Node.get((String)"ftbutilities.chat.text.strikethrough");
    public static final Node CHAT_TEXT_OBFUSCATED = Node.get((String)"ftbutilities.chat.text.obfuscated");
    public static final String INFINITE_BACK_USAGE = "ftbutilities.back.infinite";
    public static final String CRASH_REPORTS_VIEW = "admin_panel.ftbutilities.crash_reports.view";
    public static final String CRASH_REPORTS_DELETE = "admin_panel.ftbutilities.crash_reports.delete";
    private static final String LEADERBOARD_PREFIX = "ftbutilities.leaderboard.";
    public static final String EDIT_WORLD_GAMERULES = "admin_panel.ftbutilities.edit_world.gamerules";
    public static final String RANKS_VIEW = "admin_panel.ftbutilities.ranks.view";
    public static final Node TPA_COOLDOWN = Node.get((String)"ftbutilities.tpa.cooldown");
    public static final Node SPAWN_COOLDOWN = Node.get((String)"ftbutilities.spawn.cooldown");
    public static final Node BACK_COOLDOWN = Node.get((String)"ftbutilities.back.cooldown");
    public static final Node RTP_COOLDOWN = Node.get((String)"ftbutilities.rtp.cooldown");
    public static final Node TPA_WARMUP = Node.get((String)"ftbutilities.tpa.warmup");
    public static final Node SPAWN_WARMUP = Node.get((String)"ftbutilities.spawn.warmup");
    public static final Node BACK_WARMUP = Node.get((String)"ftbutilities.back.warmup");
    public static final Node RTP_WARMUP = Node.get((String)"ftbutilities.rtp.warmup");
    public static final String TPA_CROSS_DIM = "ftbutilities.tpa.cross_dim";
    public static final Node AFK_TIMER = Node.get((String)"ftbutilities.afk.timer");
    public static final String HEAL_OTHER = "ftbutilities.other_player.heal";

    @SubscribeEvent
    public static void registerRankConfigHandler(RegisterRankConfigHandlerEvent event) {
        if (FTBUtilitiesConfig.ranks.enabled) {
            event.setHandler((IRankConfigHandler)FTBUtilitiesPermissionHandler.INSTANCE);
        }
    }

    public static void registerPermissions() {
        String name;
        PermissionAPI.registerNode((String)CHAT_SPEAK, (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)"Controls if player is muted or not");
        PermissionAPI.registerNode((String)CHAT_NICKNAME_SET, (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"Allow to change nickname");
        PermissionAPI.registerNode((String)CHAT_NICKNAME_COLORS, (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"Allow to use formatting codes in nickname, requires ftbutilities.chat.nickname.set");
        PermissionAPI.registerNode((String)DISPLAY_ADMIN_INFO, (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"Display 'Admin' in Server Info");
        PermissionAPI.registerNode((String)HOMES_CROSS_DIM, (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)"Can use /home to teleport to/from another dimension");
        PermissionAPI.registerNode((String)HOMES_LIST_OTHER, (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"Allow to list other people homes");
        PermissionAPI.registerNode((String)HOMES_TELEPORT_OTHER, (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"Allow to teleport to other people homes");
        PermissionAPI.registerNode((String)CLAIMS_OTHER_SEE_INFO, (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"Allow player to see info of other team chunks");
        PermissionAPI.registerNode((String)CLAIMS_OTHER_CLAIM, (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"Allow player to claim other team chunks");
        PermissionAPI.registerNode((String)CLAIMS_OTHER_UNCLAIM, (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"Allow player to unclaim other team chunks");
        PermissionAPI.registerNode((String)CLAIMS_OTHER_LOAD, (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"Allow player to load other team chunks");
        PermissionAPI.registerNode((String)CLAIMS_OTHER_UNLOAD, (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"Allow player to unload other team chunks");
        PermissionAPI.registerNode((String)CLAIMS_BYPASS_LIMITS, (DefaultPermissionLevel)DefaultPermissionLevel.NONE, (String)"Allow to bypass claiming and loading limits");
        PermissionAPI.registerNode((String)CLAIMS_ATTACK_ANIMALS, (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"Allow to attack animals in claimed chunks");
        PermissionAPI.registerNode((String)CHUNKLOADER_LOAD_OFFLINE, (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)"Keep loaded chunks working when player goes offline");
        PermissionAPI.registerNode((String)INFINITE_BACK_USAGE, (DefaultPermissionLevel)DefaultPermissionLevel.NONE, (String)"Allow to use 'back' command infinite times");
        PermissionAPI.registerNode((String)CRASH_REPORTS_VIEW, (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"Allow to view crash reports via Admin Panel");
        PermissionAPI.registerNode((String)CRASH_REPORTS_DELETE, (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"Allow to delete crash reports, requires admin_panel.ftbutilities.crash_reports.view");
        PermissionAPI.registerNode((String)EDIT_WORLD_GAMERULES, (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"Allow to edit gamerules via Admin Panel");
        PermissionAPI.registerNode((String)TPA_CROSS_DIM, (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)"Can use /tpa to teleport to/from another dimension");
        PermissionAPI.registerNode((String)HEAL_OTHER, (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"Allow to heal other players");
        PermissionAPI.registerNode((String)HOMES_BACK, (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"Allow player back to last time where /home is used");
        PermissionAPI.registerNode((String)WARPS_BACK, (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"Allow player back to last time where /warp is used");
        PermissionAPI.registerNode((String)BACK_BACK, (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"Allow player back to last time where /back is used");
        PermissionAPI.registerNode((String)SPAWN_BACK, (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"Allow player back to last time where /spawn is used");
        PermissionAPI.registerNode((String)TPA_BACK, (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"Allow player back to last time where /tpa is used");
        PermissionAPI.registerNode((String)RTP_BACK, (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"Allow player back to last time where /rtp is used");
        PermissionAPI.registerNode((String)RESPAWN_BACK, (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)"Allow player back to last death point");
        for (Block block : Block.field_149771_c) {
            name = FTBUtilitiesPermissions.formatId((IForgeRegistryEntry)block);
            if (name.endsWith(".grave") || name.endsWith(".gravestone")) {
                CLAIMS_BLOCK_EDIT_WHITELIST.add(block);
            }
            if (!(block instanceof BlockDoor) && !(block instanceof BlockWorkbench) && !(block instanceof BlockAnvil)) continue;
            CLAIMS_BLOCK_INTERACT_WHITELIST.add(block);
        }
        for (Item item : Item.field_150901_e) {
            if (!(item instanceof ItemBucket)) continue;
            CLAIMS_ITEM_BLACKLIST.add(item);
        }
        CLAIMS_ITEM_BLACKLIST.add(Items.field_185158_cP);
        for (Block block : Block.field_149771_c) {
            name = FTBUtilitiesPermissions.formatId((IForgeRegistryEntry)block);
            PermissionAPI.registerNode((String)CLAIMS_BLOCK_EDIT_PREFIX.append(name).toString(), (DefaultPermissionLevel)(CLAIMS_BLOCK_EDIT_WHITELIST.contains(block) ? DefaultPermissionLevel.ALL : DefaultPermissionLevel.OP), (String)"");
            PermissionAPI.registerNode((String)CLAIMS_BLOCK_INTERACT_PREFIX.append(name).toString(), (DefaultPermissionLevel)(CLAIMS_BLOCK_INTERACT_WHITELIST.contains(block) ? DefaultPermissionLevel.ALL : DefaultPermissionLevel.OP), (String)"");
        }
        for (Item item : Item.field_150901_e) {
            PermissionAPI.registerNode((String)CLAIMS_ITEM_PREFIX.append(FTBUtilitiesPermissions.formatId((IForgeRegistryEntry)item)).toString(), (DefaultPermissionLevel)(CLAIMS_ITEM_BLACKLIST.contains(item) ? DefaultPermissionLevel.OP : DefaultPermissionLevel.ALL), (String)"");
        }
        for (Leaderboard leaderboard : FTBUtilitiesCommon.LEADERBOARDS.values()) {
            PermissionAPI.registerNode((String)FTBUtilitiesPermissions.getLeaderboardNode(leaderboard), (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)"");
        }
    }

    @SubscribeEvent
    public static void registerConfigs(RegisterRankConfigEvent event) {
        event.register(CHAT_NAME_FORMAT, (ConfigValue)new ConfigString("<{name}>"), (ConfigValue)new ConfigString("<&2{name}&r>"));
        event.register(CHAT_TEXT_COLOR, (ConfigValue)new ConfigEnum(TextComponentParser.TEXT_FORMATTING_COLORS_NAME_MAP));
        event.register(BADGE, (ConfigValue)new ConfigString(""));
        event.register(HOMES_MAX, (ConfigValue)new ConfigInt(1, 0, 30000), (ConfigValue)new ConfigInt(100));
        event.register(HOMES_COOLDOWN, (ConfigValue)new ConfigTimer(Ticks.MINUTE.x(5L)), (ConfigValue)new ConfigTimer(Ticks.NO_TICKS));
        event.register(WARPS_COOLDOWN, (ConfigValue)new ConfigTimer(Ticks.MINUTE), (ConfigValue)new ConfigTimer(Ticks.NO_TICKS));
        event.register(TPA_COOLDOWN, (ConfigValue)new ConfigTimer(Ticks.MINUTE.x(3L)), (ConfigValue)new ConfigTimer(Ticks.NO_TICKS));
        event.register(SPAWN_COOLDOWN, (ConfigValue)new ConfigTimer(Ticks.MINUTE), (ConfigValue)new ConfigTimer(Ticks.NO_TICKS));
        event.register(BACK_COOLDOWN, (ConfigValue)new ConfigTimer(Ticks.MINUTE.x(3L)), (ConfigValue)new ConfigTimer(Ticks.NO_TICKS));
        event.register(RTP_COOLDOWN, (ConfigValue)new ConfigTimer(Ticks.MINUTE.x(10L)), (ConfigValue)new ConfigTimer(Ticks.NO_TICKS));
        event.register(HOMES_WARMUP, (ConfigValue)new ConfigTimer(Ticks.SECOND.x(5L), Ticks.MINUTE), (ConfigValue)new ConfigTimer(Ticks.NO_TICKS));
        event.register(WARPS_WARMUP, (ConfigValue)new ConfigTimer(Ticks.SECOND.x(5L), Ticks.MINUTE), (ConfigValue)new ConfigTimer(Ticks.NO_TICKS));
        event.register(TPA_WARMUP, (ConfigValue)new ConfigTimer(Ticks.SECOND.x(5L), Ticks.MINUTE), (ConfigValue)new ConfigTimer(Ticks.NO_TICKS));
        event.register(SPAWN_WARMUP, (ConfigValue)new ConfigTimer(Ticks.SECOND.x(5L), Ticks.MINUTE), (ConfigValue)new ConfigTimer(Ticks.NO_TICKS));
        event.register(BACK_WARMUP, (ConfigValue)new ConfigTimer(Ticks.SECOND.x(5L), Ticks.MINUTE), (ConfigValue)new ConfigTimer(Ticks.NO_TICKS));
        event.register(RTP_WARMUP, (ConfigValue)new ConfigTimer(Ticks.SECOND.x(5L), Ticks.MINUTE), (ConfigValue)new ConfigTimer(Ticks.NO_TICKS));
        event.register(CLAIMS_MAX_CHUNKS, (ConfigValue)new ConfigInt(100, 0, 30000), (ConfigValue)new ConfigInt(1000));
        event.register(CHUNKLOADER_MAX_CHUNKS, (ConfigValue)new ConfigInt(50, 0, 30000), (ConfigValue)new ConfigInt(64));
        event.register(AFK_TIMER, (ConfigValue)new ConfigTimer(Ticks.NO_TICKS));
    }

    @SubscribeEvent
    public static void registerCustomPermissionPrefixes(CustomPermissionPrefixesRegistryEvent event) {
        event.register(Node.COMMAND, DefaultPermissionLevel.OP, "Permission for commands, if FTBUtilities command overriding is enabled. If not, this node will be inactive");
        event.register(CLAIMS_BLOCK_EDIT_PREFIX, DefaultPermissionLevel.OP, "Permission for blocks that players can break and place within claimed chunks");
        event.register(CLAIMS_BLOCK_INTERACT_PREFIX, DefaultPermissionLevel.OP, "Permission for blocks that players can right-click within claimed chunks");
        event.register(CLAIMS_ITEM_PREFIX, DefaultPermissionLevel.ALL, "Permission for items that players can right-click in air within claimed chunks");
        event.register(Node.get((String)LEADERBOARD_PREFIX), DefaultPermissionLevel.ALL, "Permission for leaderboards that players can view");
    }

    public static String formatId(@Nullable IForgeRegistryEntry item) {
        return item == null || item.getRegistryName() == null ? "minecraft.air" : item.getRegistryName().toString().toLowerCase().replace(':', '.');
    }

    public static boolean hasBlockEditingPermission(EntityPlayer player, Block block) {
        return PermissionAPI.hasPermission((EntityPlayer)player, (String)CLAIMS_BLOCK_EDIT_PREFIX.append(FTBUtilitiesPermissions.formatId((IForgeRegistryEntry)block)).toString());
    }

    public static boolean hasBlockInteractionPermission(EntityPlayer player, Block block) {
        return PermissionAPI.hasPermission((EntityPlayer)player, (String)CLAIMS_BLOCK_INTERACT_PREFIX.append(FTBUtilitiesPermissions.formatId((IForgeRegistryEntry)block)).toString());
    }

    public static boolean hasItemUsePermission(EntityPlayer player, Item block) {
        return PermissionAPI.hasPermission((EntityPlayer)player, (String)CLAIMS_ITEM_PREFIX.append(FTBUtilitiesPermissions.formatId((IForgeRegistryEntry)block)).toString());
    }

    public static String getLeaderboardNode(Leaderboard leaderboard) {
        return LEADERBOARD_PREFIX + leaderboard.id.func_110624_b() + "." + leaderboard.id.func_110623_a();
    }
}

