/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.blocks.processor;

import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import mcjty.lib.base.ModBase;
import mcjty.lib.client.RenderHelper;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.WindowManager;
import mcjty.lib.gui.events.SelectionEvent;
import mcjty.lib.gui.events.TextSpecialKeyEvent;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.layout.HorizontalLayout;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.LayoutHint;
import mcjty.lib.gui.layout.PositionalLayout;
import mcjty.lib.gui.layout.VerticalLayout;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.AbstractWidget;
import mcjty.lib.gui.widgets.BlockRender;
import mcjty.lib.gui.widgets.Button;
import mcjty.lib.gui.widgets.ChoiceLabel;
import mcjty.lib.gui.widgets.EnergyBar;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Slider;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.gui.widgets.ToggleButton;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.WidgetList;
import mcjty.lib.tileentity.GenericEnergyStorageTileEntity;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.rftoolscontrol.RFToolsControl;
import mcjty.rftoolscontrol.api.parameters.Parameter;
import mcjty.rftoolscontrol.api.parameters.ParameterType;
import mcjty.rftoolscontrol.blocks.processor.CardInfo;
import mcjty.rftoolscontrol.blocks.processor.ProcessorContainer;
import mcjty.rftoolscontrol.blocks.processor.ProcessorTileEntity;
import mcjty.rftoolscontrol.gui.GuiTools;
import mcjty.rftoolscontrol.logic.editors.ParameterEditor;
import mcjty.rftoolscontrol.logic.editors.ParameterEditors;
import mcjty.rftoolscontrol.logic.registry.ParameterTypeTools;
import mcjty.rftoolscontrol.network.PacketGetFluids;
import mcjty.rftoolscontrol.network.PacketGetLog;
import mcjty.rftoolscontrol.network.PacketGetVariables;
import mcjty.rftoolscontrol.network.PacketVariableToServer;
import mcjty.rftoolscontrol.network.RFToolsCtrlMessages;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiProcessor
extends GenericGuiContainer<ProcessorTileEntity> {
    public static final int SIDEWIDTH = 80;
    public static final int WIDTH = 256;
    public static final int HEIGHT = 236;
    private static final ResourceLocation mainBackground = new ResourceLocation("rftoolscontrol", "textures/gui/processor.png");
    private static final ResourceLocation sideBackground = new ResourceLocation("rftoolscontrol", "textures/gui/sidegui.png");
    private static final ResourceLocation icons = new ResourceLocation("rftoolscontrol", "textures/gui/icons.png");
    private Window sideWindow;
    private EnergyBar energyBar;
    private ToggleButton[] setupButtons = new ToggleButton[6];
    private WidgetList log;
    private WidgetList variableList;
    private WidgetList fluidList;
    private TextField command;
    private ToggleButton exclusive;
    private ChoiceLabel hudMode;
    private static List<String> commandHistory = new ArrayList<String>();
    private static int commandHistoryIndex = -1;
    private int[] fluidListMapping = new int[24];
    private static List<PacketGetFluids.FluidEntry> fromServer_fluids = new ArrayList<PacketGetFluids.FluidEntry>();
    private static List<Parameter> fromServer_vars = new ArrayList<Parameter>();
    private int listDirty = 0;

    public static void storeFluidsForClient(List<PacketGetFluids.FluidEntry> messages) {
        fromServer_fluids = new ArrayList<PacketGetFluids.FluidEntry>(messages);
    }

    public static void storeVarsForClient(List<Parameter> messages) {
        fromServer_vars = new ArrayList<Parameter>(messages);
    }

    public GuiProcessor(ProcessorTileEntity tileEntity, ProcessorContainer container) {
        super((ModBase)RFToolsControl.instance, RFToolsCtrlMessages.INSTANCE, (GenericTileEntity)tileEntity, (Container)container, RFToolsControl.GUI_MANUAL_CONTROL, "processor");
        this.field_146999_f = 256;
        this.field_147000_g = 236;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        Panel toplevel = (Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new PositionalLayout()).setBackground(mainBackground);
        toplevel.setBounds(new Rectangle(this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g));
        long maxEnergyStored = ((ProcessorTileEntity)this.tileEntity).getCapacity();
        this.energyBar = ((EnergyBar)new EnergyBar(this.field_146297_k, (Gui)this).setVertical().setMaxValue(maxEnergyStored).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(122, 4, 70, 10))).setShowText(false).setHorizontal();
        this.energyBar.setValue(GenericEnergyStorageTileEntity.getCurrentRF());
        toplevel.addChild((Widget)this.energyBar);
        this.exclusive = (ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton(this.field_146297_k, (Gui)this).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(122, 16, 40, 15))).setCheckMarker(true).setText("Excl.")).setTooltips(new String[]{TextFormatting.YELLOW + "Exclusive mode", "If pressed then programs on", "card X can only run on core X"});
        this.exclusive.setPressed(((ProcessorTileEntity)this.tileEntity).isExclusive());
        this.exclusive.addButtonEvent(parent -> {
            ((ProcessorTileEntity)this.tileEntity).setExclusive(this.exclusive.isPressed());
            this.sendServerCommand(RFToolsCtrlMessages.INSTANCE, "setExclusive", TypedMap.builder().put(ProcessorTileEntity.PARAM_EXCLUSIVE, (Object)this.exclusive.isPressed()).build());
        });
        toplevel.addChild((Widget)this.exclusive);
        this.hudMode = ((ChoiceLabel)new ChoiceLabel(this.field_146297_k, (Gui)this).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(163, 16, 28, 15))).addChoices(new String[]{"Off", "Log", "Db", "Gfx"}).setChoiceTooltip("Off", new String[]{"No overhead log"}).setChoiceTooltip("Log", new String[]{"Show the normal log"}).setChoiceTooltip("Db", new String[]{"Show a debug display"}).setChoiceTooltip("Gfx", new String[]{"Graphics display"});
        switch (((ProcessorTileEntity)this.tileEntity).getShowHud()) {
            case 0: {
                this.hudMode.setChoice("Off");
                break;
            }
            case 1: {
                this.hudMode.setChoice("Log");
                break;
            }
            case 2: {
                this.hudMode.setChoice("Db");
                break;
            }
            case 3: {
                this.hudMode.setChoice("Gfx");
            }
        }
        this.hudMode.addChoiceEvent((parent, newChoice) -> {
            String choice = this.hudMode.getCurrentChoice();
            int m = 0;
            m = "Off".equals(choice) ? 0 : ("Log".equals(choice) ? 1 : ("Db".equals(choice) ? 2 : 3));
            this.sendServerCommand(RFToolsCtrlMessages.INSTANCE, "setHudMode", TypedMap.builder().put(ProcessorTileEntity.PARAM_HUDMODE, (Object)m).build());
        });
        toplevel.addChild((Widget)this.hudMode);
        this.setupLogWindow(toplevel);
        for (int i = 0; i < 6; ++i) {
            this.setupButtons[i] = (ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton(this.field_146297_k, (Gui)this).addButtonEvent(this::setupMode).setTooltips(new String[]{TextFormatting.YELLOW + "Resource allocation", "Setup item and variable", "allocation for this card"})).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(11 + i * 18, 6, 15, 7))).setUserObject((Object)"allowed");
            toplevel.addChild((Widget)this.setupButtons[i]);
        }
        this.window = new Window((GuiScreen)this, (AbstractContainerWidget)toplevel);
        Panel listPanel = this.setupVariableListPanel();
        Panel sidePanel = (Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new PositionalLayout()).setBackground(sideBackground)).addChild((Widget)listPanel);
        sidePanel.setBounds(new Rectangle(this.field_147003_i - 80, this.field_147009_r, 80, this.field_147000_g));
        this.sideWindow = new Window((GuiScreen)this, (AbstractContainerWidget)sidePanel);
    }

    private void setupLogWindow(Panel toplevel) {
        this.log = ((WidgetList)((WidgetList)((WidgetList)((WidgetList)new WidgetList(this.field_146297_k, (Gui)this).setName("log")).setFilledBackground(-16777216)).setFilledRectThickness(1)).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(9, 35, 173, 98))).setRowheight(14).setInvisibleSelection(true).setDrawHorizontalLines(false);
        Slider slider = (Slider)new Slider(this.field_146297_k, (Gui)this).setVertical().setScrollableName("log").setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(183, 35, 9, 98));
        this.command = ((TextField)new TextField(this.field_146297_k, (Gui)this).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(9, 134, 183, 15))).addTextEnterEvent((e, text) -> this.executeCommand(text)).addSpecialKeyEvent(new TextSpecialKeyEvent(){

            public void arrowUp(Widget widget) {
                GuiProcessor.this.dumpHistory();
                if (commandHistoryIndex == -1) {
                    commandHistoryIndex = commandHistory.size() - 1;
                } else {
                    commandHistoryIndex--;
                    if (commandHistoryIndex < 0) {
                        commandHistoryIndex = 0;
                    }
                }
                if (commandHistoryIndex >= 0 && commandHistoryIndex < commandHistory.size()) {
                    GuiProcessor.this.command.setText((String)commandHistory.get(commandHistoryIndex));
                }
                GuiProcessor.this.dumpHistory();
            }

            public void arrowDown(Widget widget) {
                GuiProcessor.this.dumpHistory();
                if (commandHistoryIndex != -1) {
                    commandHistoryIndex++;
                    if (commandHistoryIndex >= commandHistory.size()) {
                        commandHistoryIndex = -1;
                        GuiProcessor.this.command.setText("");
                    } else {
                        GuiProcessor.this.command.setText((String)commandHistory.get(commandHistoryIndex));
                    }
                }
                GuiProcessor.this.dumpHistory();
            }

            public void tab(Widget widget) {
            }
        });
        ((Panel)((Panel)toplevel.addChild((Widget)this.log)).addChild((Widget)slider)).addChild((Widget)this.command);
    }

    private void executeCommand(String text) {
        this.dumpHistory();
        this.sendServerCommand(RFToolsCtrlMessages.INSTANCE, "execute", TypedMap.builder().put(ProcessorTileEntity.PARAM_CMD, (Object)text).build());
        if (!(commandHistoryIndex >= 0 && commandHistoryIndex < commandHistory.size() && text.equals(commandHistory.get(commandHistoryIndex)) || text.isEmpty())) {
            if (commandHistory.isEmpty() || !text.equals(commandHistory.get(commandHistory.size() - 1))) {
                commandHistory.add(text);
            }
            while (commandHistory.size() > 50) {
                commandHistory.remove(0);
            }
            commandHistoryIndex = -1;
        }
        this.command.setText("");
        this.window.setTextFocus((Widget)this.command);
    }

    private void dumpHistory() {
    }

    private void requestLists() {
        RFToolsCtrlMessages.INSTANCE.sendToServer((IMessage)new PacketGetLog(((ProcessorTileEntity)this.tileEntity).func_174877_v()));
        RFToolsCtrlMessages.INSTANCE.sendToServer((IMessage)new PacketGetVariables(((ProcessorTileEntity)this.tileEntity).func_174877_v()));
        RFToolsCtrlMessages.INSTANCE.sendToServer((IMessage)new PacketGetFluids(((ProcessorTileEntity)this.tileEntity).func_174877_v()));
    }

    private void requestListsIfNeeded() {
        --this.listDirty;
        if (this.listDirty <= 0) {
            this.requestLists();
            this.listDirty = 10;
        }
    }

    private void populateLog() {
        boolean atend = this.log.getFirstSelected() + this.log.getCountSelected() >= this.log.getChildCount();
        this.log.removeChildren();
        for (String message : ((ProcessorTileEntity)this.tileEntity).getClientLog()) {
            this.log.addChild((Widget)((Label)((Label)new Label(this.field_146297_k, (Gui)this).setColor(-16742400)).setText(message)).setHorizontalAlignment(HorizontalAlignment.ALIGN_LEFT));
        }
        if (atend) {
            this.log.setFirstSelected(this.log.getChildCount());
        }
    }

    private void setupMode(Widget<?> parent) {
        ToggleButton tb = (ToggleButton)parent;
        if (tb.isPressed()) {
            for (ToggleButton button : this.setupButtons) {
                if (button == tb) continue;
                button.setPressed(false);
            }
        }
        this.updateVariableList();
    }

    private int getSetupMode() {
        for (int i = 0; i < this.setupButtons.length; ++i) {
            if (!this.setupButtons[i].isPressed()) continue;
            return i;
        }
        return -1;
    }

    protected void func_73864_a(int x, int y, int button) throws IOException {
        int setupMode = this.getSetupMode();
        if (setupMode == -1) {
            super.func_73864_a(x, y, button);
        } else {
            Widget w;
            Optional widget = this.getWindowManager().findWidgetAtPosition(x, y);
            if (widget.isPresent() && "allowed".equals((w = (Widget)widget.get()).getUserObject())) {
                super.func_73864_a(x, y, button);
                return;
            }
            int leftx = this.window.getToplevel().getBounds().x;
            int topy = this.window.getToplevel().getBounds().y;
            x -= leftx;
            y -= topy;
            CardInfo cardInfo = ((ProcessorTileEntity)this.tileEntity).getCardInfo(setupMode);
            int itemAlloc = cardInfo.getItemAllocation();
            int varAlloc = cardInfo.getVarAllocation();
            int fluidAlloc = cardInfo.getFluidAllocation();
            for (int i = 0; i < 24; ++i) {
                Slot slot = this.field_147002_h.func_75139_a(22 + i);
                if (x < slot.field_75223_e || x > slot.field_75223_e + 17 || y < slot.field_75221_f || y > slot.field_75221_f + 17) continue;
                boolean allocated = (itemAlloc >> i & 1) != 0;
                boolean bl = allocated = !allocated;
                itemAlloc = allocated ? (itemAlloc |= 1 << i) : (itemAlloc &= ~(1 << i));
                cardInfo.setItemAllocation(itemAlloc);
                this.sendServerCommand(RFToolsCtrlMessages.INSTANCE, "allocate", TypedMap.builder().put(ProcessorTileEntity.PARAM_CARD, (Object)setupMode).put(ProcessorTileEntity.PARAM_ITEMS, (Object)itemAlloc).put(ProcessorTileEntity.PARAM_VARS, (Object)varAlloc).put(ProcessorTileEntity.PARAM_FLUID, (Object)fluidAlloc).build());
                break;
            }
        }
    }

    protected void registerWindows(WindowManager mgr) {
        super.registerWindows(mgr);
        mgr.addWindow(this.sideWindow);
        mgr.getIconManager().setClickHoldToDrag(true);
    }

    private Panel setupVariableListPanel() {
        this.fluidList = (WidgetList)((WidgetList)((WidgetList)new WidgetList(this.field_146297_k, (Gui)this).setName("fluids")).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(0, 0, 62, 65))).setPropagateEventsToChildren(true).setInvisibleSelection(true).setDrawHorizontalLines(false).setUserObject((Object)"allowed");
        this.fluidList.addSelectionEvent(new SelectionEvent(){

            public void select(Widget parent, int i) {
                int setupMode = GuiProcessor.this.getSetupMode();
                if (setupMode != -1) {
                    int idx;
                    CardInfo cardInfo = ((ProcessorTileEntity)GuiProcessor.this.tileEntity).getCardInfo(setupMode);
                    int varAlloc = cardInfo.getVarAllocation();
                    int itemAlloc = cardInfo.getItemAllocation();
                    int fluidAlloc = cardInfo.getFluidAllocation();
                    boolean allocated = (fluidAlloc >> (idx = GuiProcessor.this.fluidListMapping[i]) & 1) != 0;
                    boolean bl = allocated = !allocated;
                    fluidAlloc = allocated ? (fluidAlloc |= 1 << idx) : (fluidAlloc &= ~(1 << idx));
                    cardInfo.setFluidAllocation(fluidAlloc);
                    GuiProcessor.this.sendServerCommand(RFToolsCtrlMessages.INSTANCE, "allocate", TypedMap.builder().put(ProcessorTileEntity.PARAM_CARD, (Object)setupMode).put(ProcessorTileEntity.PARAM_ITEMS, (Object)itemAlloc).put(ProcessorTileEntity.PARAM_VARS, (Object)varAlloc).put(ProcessorTileEntity.PARAM_FLUID, (Object)fluidAlloc).build());
                    GuiProcessor.this.updateFluidList();
                    GuiProcessor.this.fluidList.setSelected(-1);
                }
            }

            public void doubleClick(Widget parent, int index) {
            }
        });
        Slider fluidSlider = (Slider)((Slider)new Slider(this.field_146297_k, (Gui)this).setVertical().setScrollableName("fluids").setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(62, 0, 9, 65))).setUserObject((Object)"allowed");
        this.updateFluidList();
        this.variableList = (WidgetList)((WidgetList)((WidgetList)new WidgetList(this.field_146297_k, (Gui)this).setName("variables")).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(0, 67, 62, 161))).setPropagateEventsToChildren(true).setInvisibleSelection(true).setDrawHorizontalLines(false).setUserObject((Object)"allowed");
        this.variableList.addSelectionEvent(new SelectionEvent(){

            public void select(Widget parent, int i) {
                int setupMode = GuiProcessor.this.getSetupMode();
                if (setupMode != -1) {
                    CardInfo cardInfo = ((ProcessorTileEntity)GuiProcessor.this.tileEntity).getCardInfo(setupMode);
                    int varAlloc = cardInfo.getVarAllocation();
                    int itemAlloc = cardInfo.getItemAllocation();
                    int fluidAlloc = cardInfo.getFluidAllocation();
                    boolean allocated = (varAlloc >> i & 1) != 0;
                    boolean bl = allocated = !allocated;
                    varAlloc = allocated ? (varAlloc |= 1 << i) : (varAlloc &= ~(1 << i));
                    cardInfo.setVarAllocation(varAlloc);
                    GuiProcessor.this.sendServerCommand(RFToolsCtrlMessages.INSTANCE, "allocate", TypedMap.builder().put(ProcessorTileEntity.PARAM_CARD, (Object)setupMode).put(ProcessorTileEntity.PARAM_ITEMS, (Object)itemAlloc).put(ProcessorTileEntity.PARAM_VARS, (Object)varAlloc).put(ProcessorTileEntity.PARAM_FLUID, (Object)fluidAlloc).build());
                    GuiProcessor.this.updateVariableList();
                    GuiProcessor.this.variableList.setSelected(-1);
                }
            }

            public void doubleClick(Widget parent, int index) {
            }
        });
        Slider varSlider = (Slider)((Slider)new Slider(this.field_146297_k, (Gui)this).setVertical().setScrollableName("variables").setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(62, 67, 9, 161))).setUserObject((Object)"allowed");
        this.updateVariableList();
        return (Panel)((Panel)((Panel)((Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new PositionalLayout()).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(5, 5, 72, 220))).addChild((Widget)this.variableList)).addChild((Widget)varSlider)).addChild((Widget)this.fluidList)).addChild((Widget)fluidSlider)).setUserObject((Object)"allowed");
    }

    private void openValueEditor(int varIdx) {
        if (fromServer_vars == null || varIdx > fromServer_vars.size()) {
            return;
        }
        if (fromServer_vars.get(varIdx) == null) {
            GuiTools.showMessage(this.field_146297_k, (Gui)this, this.getWindowManager(), 50, 50, "Variable is not defined!");
            return;
        }
        Parameter parameter = fromServer_vars.get(varIdx);
        if (parameter == null) {
            GuiTools.showMessage(this.field_146297_k, (Gui)this, this.getWindowManager(), 50, 50, "Variable is not defined!");
            return;
        }
        ParameterType type = parameter.getParameterType();
        ParameterEditor editor = ParameterEditors.getEditor(type);
        if (editor == null) {
            return;
        }
        Panel editPanel = (Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new PositionalLayout()).setFilledRectThickness(1);
        editor.build(this.field_146297_k, (Gui)this, editPanel, o -> {
            NBTTagCompound tag = new NBTTagCompound();
            ParameterTypeTools.writeToNBT(tag, type, o);
            RFToolsCtrlMessages.INSTANCE.sendToServer((IMessage)new PacketVariableToServer(((ProcessorTileEntity)this.tileEntity).func_174877_v(), varIdx, tag));
        });
        editor.writeValue(parameter.getParameterValue());
        editor.constantOnly();
        Panel panel = (Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new VerticalLayout()).setFilledBackground(-10066330, -5592406)).setFilledRectThickness(1);
        panel.setBounds(new Rectangle(50, 50, 200, 60 + editor.getHeight()));
        Window modalWindow = this.getWindowManager().createModalWindow((AbstractContainerWidget)panel);
        panel.addChild((Widget)new Label(this.field_146297_k, (Gui)this).setText("Var " + varIdx + ":"));
        panel.addChild((Widget)editPanel);
        panel.addChild((Widget)((Button)new Button(this.field_146297_k, (Gui)this).setChannel("close")).setText("Close"));
        modalWindow.event("close", (source, params) -> this.getWindowManager().closeWindow(modalWindow));
    }

    private void updateFluidList() {
        this.fluidList.removeChildren();
        for (int i = 0; i < this.fluidListMapping.length; ++i) {
            this.fluidListMapping[i] = -1;
        }
        int setupMode = this.getSetupMode();
        int fluidAlloc = 0;
        if (setupMode != -1) {
            CardInfo cardInfo = ((ProcessorTileEntity)this.tileEntity).getCardInfo(setupMode);
            fluidAlloc = cardInfo.getFluidAllocation();
        }
        this.fluidList.setPropagateEventsToChildren(setupMode == -1);
        int index = 0;
        for (int i = 0; i < fromServer_fluids.size(); ++i) {
            AbstractWidget label;
            PacketGetFluids.FluidEntry entry = fromServer_fluids.get(i);
            if (!entry.isAllocated()) continue;
            this.fluidListMapping[this.fluidList.getChildCount()] = i;
            EnumFacing side = EnumFacing.values()[i / 4];
            String l = side.func_176610_l().substring(0, 1).toUpperCase() + i % 4;
            Panel panel = (Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new HorizontalLayout()).setDesiredWidth(40);
            if (setupMode != -1) {
                boolean allocated;
                boolean bl = allocated = (fluidAlloc >> i & 1) != 0;
                int fill = allocated ? 0x7700FF00 : (((ProcessorTileEntity)this.tileEntity).isFluidAllocated(-1, i) ? 0x77660000 : 0x77444444);
                panel.setFilledBackground(fill);
                if (allocated) {
                    label = ((Label)((Label)((Label)new Label(this.field_146297_k, (Gui)this).setColor(-1)).setText(String.valueOf(index))).setDesiredWidth(26)).setUserObject((Object)"allowed");
                    ++index;
                } else {
                    label = ((Label)((Label)new Label(this.field_146297_k, (Gui)this).setText("/")).setDesiredWidth(26)).setUserObject((Object)"allowed");
                }
            } else {
                label = ((Label)((Label)new Label(this.field_146297_k, (Gui)this).setText(l)).setDesiredWidth(26)).setUserObject((Object)"allowed");
            }
            label.setUserObject((Object)"allowed");
            panel.addChild((Widget)label);
            FluidStack fluidStack = entry.getFluidStack();
            if (fluidStack != null) {
                BlockRender fluid = new BlockRender(this.field_146297_k, (Gui)this).setRenderItem((Object)fluidStack);
                fluid.setTooltips(new String[]{TextFormatting.GREEN + "Fluid: " + TextFormatting.WHITE + fluidStack.getLocalizedName(), TextFormatting.GREEN + "Amount: " + TextFormatting.WHITE + fluidStack.amount + "mb"});
                fluid.setUserObject((Object)"allowed");
                panel.addChild((Widget)fluid);
            }
            panel.setUserObject((Object)"allowed");
            this.fluidList.addChild((Widget)panel);
        }
    }

    private void updateVariableList() {
        this.variableList.removeChildren();
        int setupMode = this.getSetupMode();
        int varAlloc = 0;
        if (setupMode != -1) {
            CardInfo cardInfo = ((ProcessorTileEntity)this.tileEntity).getCardInfo(setupMode);
            varAlloc = cardInfo.getVarAllocation();
        }
        this.variableList.setPropagateEventsToChildren(setupMode == -1);
        int index = 0;
        int i = 0;
        while (i < ((ProcessorTileEntity)this.tileEntity).getMaxvars()) {
            Panel panel = (Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new HorizontalLayout()).setDesiredWidth(40);
            if (setupMode != -1) {
                boolean allocated;
                boolean bl = allocated = (varAlloc >> i & 1) != 0;
                int fill = allocated ? 0x7700FF00 : (((ProcessorTileEntity)this.tileEntity).isVarAllocated(-1, i) ? 0x77660000 : 0x77444444);
                panel.setFilledBackground(fill);
                if (allocated) {
                    panel.addChild((Widget)((Label)((Label)((Label)new Label(this.field_146297_k, (Gui)this).setColor(-1)).setText(String.valueOf(index))).setDesiredWidth(26)).setUserObject((Object)"allowed"));
                    ++index;
                } else {
                    panel.addChild((Widget)((Label)((Label)new Label(this.field_146297_k, (Gui)this).setText("/")).setDesiredWidth(26)).setUserObject((Object)"allowed"));
                }
            } else {
                panel.addChild((Widget)((Label)((Label)new Label(this.field_146297_k, (Gui)this).setText(String.valueOf(i))).setDesiredWidth(26)).setUserObject((Object)"allowed"));
            }
            int finalI = i++;
            panel.addChild((Widget)((Button)new Button(this.field_146297_k, (Gui)this).addButtonEvent(w -> this.openValueEditor(finalI)).setText("...")).setUserObject((Object)"allowed"));
            panel.setUserObject((Object)"allowed");
            this.variableList.addChild((Widget)panel);
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        if (this.variableList.getChildCount() != ((ProcessorTileEntity)this.tileEntity).getMaxvars()) {
            this.updateVariableList();
        }
        this.updateFluidList();
        this.requestListsIfNeeded();
        this.populateLog();
        this.drawWindow();
        long currentRF = GenericEnergyStorageTileEntity.getCurrentRF();
        this.energyBar.setValue(currentRF);
        ((ProcessorTileEntity)this.tileEntity).requestRfFromServer("rftoolscontrol");
        this.drawAllocatedSlots();
    }

    private void drawAllocatedSlots() {
        int setupMode = this.getSetupMode();
        if (setupMode == -1) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)this.field_147003_i, (float)this.field_147009_r, (float)0.0f);
        CardInfo cardInfo = ((ProcessorTileEntity)this.tileEntity).getCardInfo(setupMode);
        int itemAlloc = cardInfo.getItemAllocation();
        int index = 0;
        for (int i = 0; i < 24; ++i) {
            int border;
            Slot slot = this.field_147002_h.func_75139_a(22 + i);
            boolean allocated = (itemAlloc >> i & 1) != 0;
            int n = border = allocated ? -1 : -1431655766;
            int fill = allocated ? 0x7700FF00 : (((ProcessorTileEntity)this.tileEntity).isItemAllocated(-1, i) ? 0x77660000 : 0x77444444);
            RenderHelper.drawFlatBox((int)slot.field_75223_e, (int)slot.field_75221_f, (int)(slot.field_75223_e + 17), (int)(slot.field_75221_f + 17), (int)border, (int)fill);
            if (!allocated) continue;
            this.func_73731_b(this.field_146289_q, "" + index, slot.field_75223_e + 4, slot.field_75221_f + 4, -1);
            ++index;
        }
        GlStateManager.func_179121_F();
    }
}

